/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.InternalCacheEvent;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.locks.NonReentrantReadWriteLock;
import com.gemstone.gemfire.internal.cache.partitioned.Bucket;
import com.gemstone.gemfire.internal.cache.partitioned.BucketListener;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdListResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.message.MemberExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionSingleKeyExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public final class IdentityValueManager {
    private static final ConcurrentHashMap<Object, AtomicLong> autoIncMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Object, Object[]> generatedValues = new ConcurrentHashMap();
    private final NonReentrantReadWriteLock generatedValuesLock = new NonReentrantReadWriteLock();
    private static final IdentityValueManager instance = new IdentityValueManager();

    private IdentityValueManager() {
    }

    public static IdentityValueManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAfterRetrievedValue(Object table, long start, long increment, DistributedMember idGeneratingNode) {
        this.generatedValuesLock.attemptWriteLock(-1L);
        try {
            Object[] id = this.generatedValues.get(table);
            if (id != null) {
                AtomicLong currValue = (AtomicLong)id[0];
                id[1] = idGeneratingNode;
                long l = currValue.get() + increment;
                return l;
            }
            this.generatedValues.put(table, new Object[]{new AtomicLong(start), idGeneratingNode});
            long l = start;
            return l;
        }
        finally {
            this.generatedValuesLock.releaseWriteLock();
        }
    }

    public void clearRetrievedValue(Object table) {
        this.generatedValuesLock.attemptWriteLock(-1L);
        try {
            this.generatedValues.remove(table);
        }
        finally {
            this.generatedValuesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setGeneratedValue(Object table, long value, long increment, DistributedMember idGeneratorNode) {
        this.generatedValuesLock.attemptReadLock(-1L);
        try {
            Object[] id = this.generatedValues.get(table);
            if (id == null) {
                id = this.generatedValues.putIfAbsent(table, new Object[]{new AtomicLong(value), null});
            }
            if (id != null) {
                Object markedGeneratorNode = id[1];
                if (markedGeneratorNode == null || markedGeneratorNode.equals(idGeneratorNode)) {
                    AtomicLong currAL = (AtomicLong)id[0];
                    while (true) {
                        long currValue = currAL.get();
                        if (increment > 0L && value > currValue || increment < 0L && value < currValue) {
                            if (!currAL.compareAndSet(currValue, value)) continue;
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = true;
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.generatedValuesLock.releaseReadLock();
        }
    }

    public static final class GetRetrievedIdentityValues
    extends MemberExecutorMessage<Object> {
        private Object table;
        private long start;
        private long increment;

        public GetRetrievedIdentityValues() {
            super(true);
        }

        private GetRetrievedIdentityValues(ResultCollector<Object, Object> rc, Object table, long start, long increment) {
            super(rc, null, false, true);
            this.table = table;
            this.start = start;
            this.increment = increment;
        }

        public static long retrieve(Object table, long start, long increment, long currentIdentity) throws StandardException, SQLException {
            GetRetrievedIdentityValues msg = new GetRetrievedIdentityValues(new GfxdListResultCollector(), table, start, increment);
            ArrayList allResults = (ArrayList)msg.executeFunction();
            long result = currentIdentity;
            if (increment > 0L) {
                for (Object o : allResults) {
                    long v = (Long)o;
                    if ((increment <= 0L || v <= result) && (increment >= 0L || v >= result)) continue;
                    result = v;
                }
            }
            return result;
        }

        private GetRetrievedIdentityValues(GetRetrievedIdentityValues other) {
            super(other);
            this.table = other.table;
            this.start = other.start;
            this.increment = other.increment;
        }

        @Override
        protected void execute() throws SQLException {
            long result;
            if (this.increment != 0L) {
                result = IdentityValueManager.getInstance().getAfterRetrievedValue(this.table, this.start, this.increment, (DistributedMember)this.getSenderForReply());
                if (GemFireXDUtils.TraceExecution | GemFireXDUtils.TraceFunctionException) {
                    SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("IDENTITY: GetRetrievedIdentityValues: after identity generator start/failure, got retrieved value = " + result + " for table " + this.table));
                }
            } else {
                IdentityValueManager.getInstance().clearRetrievedValue(this.table);
                result = 0L;
                if (GemFireXDUtils.TraceExecution) {
                    SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("IDENTITY: GetRetrievedIdentityValues: cleared any cached retrieved value for table " + this.table));
                }
            }
            this.lastResult(result, false, false, false);
        }

        @Override
        public Set<DistributedMember> getMembers() {
            return GetRetrievedIdentityValues.getAllGfxdServers();
        }

        @Override
        public boolean optimizeForWrite() {
            return false;
        }

        @Override
        public boolean isHA() {
            return true;
        }

        @Override
        public boolean canStartRemoteTransaction() {
            return false;
        }

        @Override
        protected boolean requiresTXFlushBeforeExecution() {
            return false;
        }

        @Override
        protected boolean requiresTXFlushAfterExecution() {
            return false;
        }

        @Override
        public void postExecutionCallback() {
        }

        @Override
        protected GetRetrievedIdentityValues clone() {
            return new GetRetrievedIdentityValues(this);
        }

        @Override
        public byte getGfxdID() {
            return 47;
        }

        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            InternalDataSerializer.writeObject((Object)this.table, (DataOutput)out);
            InternalDataSerializer.writeSignedVL((long)this.start, (DataOutput)out);
            InternalDataSerializer.writeSignedVL((long)this.increment, (DataOutput)out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.table = InternalDataSerializer.readObject((DataInput)in);
            this.start = InternalDataSerializer.readSignedVL((DataInput)in);
            this.increment = InternalDataSerializer.readSignedVL((DataInput)in);
        }

        @Override
        protected void appendFields(StringBuilder sb) {
            super.appendFields(sb);
            sb.append(";table=").append(this.table).append(";start=").append(this.start).append(";increment=").append(this.increment);
        }
    }

    public static final class GetIdentityValueMessage
    extends RegionSingleKeyExecutorMessage {
        private long startBy;
        private long increment;
        private transient boolean forceFunctionExecutor;

        public GetIdentityValueMessage() {
            super(true);
        }

        public GetIdentityValueMessage(LocalRegion region, Object key, long start, long inc, LanguageConnectionContext lcc) {
            super(region, key, null, null, false, null, GetIdentityValueMessage.getTimeStatsSettings(lcc));
            this.startBy = start;
            this.increment = inc;
        }

        protected GetIdentityValueMessage(GetIdentityValueMessage other) {
            super(other);
            this.startBy = other.startBy;
            this.increment = other.increment;
        }

        public static void installBucketListener(PartitionedRegion identityRegion) {
            identityRegion.setBucketListener((BucketListener)new BListener());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void execute() throws Exception {
            long maxIdentity;
            block16: {
                block15: {
                    if (this.increment == 0L) break block15;
                    AtomicLong ident = (AtomicLong)autoIncMap.get(this.key);
                    if (ident != null) {
                        maxIdentity = ident.addAndGet(this.increment);
                        break block16;
                    } else {
                        if (!this.forceFunctionExecutor && this.dm != null) {
                            this.forceFunctionExecutor = true;
                            this.schedule(this.dm);
                            return;
                        }
                        ConcurrentHashMap concurrentHashMap = autoIncMap;
                        synchronized (concurrentHashMap) {
                            ident = (AtomicLong)autoIncMap.get(this.key);
                            if (ident == null) {
                                PartitionedRegion pr;
                                GemFireContainer container = this.getContainer((String)this.key);
                                ExtraTableInfo tabInfo = container.getExtraTableInfo();
                                maxIdentity = this.startBy;
                                long retrievedIdentity = GetRetrievedIdentityValues.retrieve(this.key, this.startBy, this.increment, this.startBy);
                                LocalRegion r = container.getRegion();
                                boolean hasRows = r.getDataPolicy().withPartitioning() ? (pr = (PartitionedRegion)r).getRegionAdvisor().getCreatedBucketsCount() > 0 : true;
                                if (hasRows) {
                                    String columnName = tabInfo.getAutoGeneratedColumn(tabInfo.getAutoGeneratedColumns()[0]).getColumnName();
                                    try (EmbedConnection conn = GemFireXDUtils.createNewInternalConnection(false);){
                                        ResultSet rs;
                                        Statement stmt = conn.createStatement();
                                        String query = null;
                                        query = this.increment > 0L ? "select max(" + columnName + ") from " + container.getQualifiedTableName() : "select min(" + columnName + ") from " + container.getQualifiedTableName();
                                        if (container.getRegion().isHDFSReadWriteRegion()) {
                                            query = query + " -- GEMFIREXD-PROPERTIES queryHDFS=true \n";
                                        }
                                        if ((rs = stmt.executeQuery(query)).next()) {
                                            maxIdentity = rs.getLong(1);
                                            maxIdentity = rs.wasNull() ? this.startBy : (maxIdentity += this.increment);
                                        }
                                        rs.close();
                                        stmt.close();
                                    }
                                    if (this.increment > 0L && retrievedIdentity > maxIdentity || this.increment < 0L && retrievedIdentity < maxIdentity) {
                                        maxIdentity = retrievedIdentity;
                                    }
                                    SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("IDENTITY: got new start value " + maxIdentity + " for column " + columnName + " in table " + container.getQualifiedTableName()));
                                }
                                ident = new AtomicLong(maxIdentity);
                                autoIncMap.put(this.key, ident);
                            } else {
                                maxIdentity = ident.addAndGet(this.increment);
                            }
                        }
                    }
                    break block16;
                }
                autoIncMap.remove(this.key);
                GetRetrievedIdentityValues.retrieve(this.key, 0L, 0L, 0L);
                maxIdentity = 0L;
            }
            this.lastResult(maxIdentity, false, false, false);
        }

        private GemFireContainer getContainer(String key) {
            GemFireContainer container = GemFireContainer.getContainerFromIdentityKey(key);
            if (container != null && container.getExtraTableInfo() != null) {
                return container;
            }
            throw new RegionDestroyedException(LocalizedStrings.PartitionMessage_0_COULD_NOT_FIND_PARTITIONED_REGION_WITH_ID_1.toLocalizedString(new Object[]{Misc.getGemFireCache().getMyId(), this.prId}), key);
        }

        @Override
        public boolean canStartRemoteTransaction() {
            return false;
        }

        @Override
        public int getMessageProcessorType() {
            if (this.forceFunctionExecutor) {
                return super.getMessageProcessorType();
            }
            return 74;
        }

        @Override
        protected RegionSingleKeyExecutorMessage clone() {
            return new GetIdentityValueMessage(this);
        }

        @Override
        public void reset() {
            super.reset();
            this.getContainer((String)this.key);
        }

        @Override
        public boolean isHA() {
            return true;
        }

        @Override
        public boolean optimizeForWrite() {
            return true;
        }

        @Override
        public byte getGfxdID() {
            return 46;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            long beginTime = XPLAINUtil.recordTiming(this.ser_deser_time == 0L ? (this.ser_deser_time = -1L) : -2L);
            super.toData(out);
            InternalDataSerializer.writeSignedVL((long)this.startBy, (DataOutput)out);
            InternalDataSerializer.writeSignedVL((long)this.increment, (DataOutput)out);
            if (beginTime != 0L) {
                this.ser_deser_time = XPLAINUtil.recordTiming(beginTime);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.ser_deser_time = this.timeStatsEnabled ? (long)(this.ser_deser_time == 0L ? -1 : -2) : 0L;
            super.fromData(in);
            this.startBy = InternalDataSerializer.readSignedVL((DataInput)in);
            this.increment = InternalDataSerializer.readSignedVL((DataInput)in);
            if (this.timeStatsEnabled && this.ser_deser_time == -1L) {
                this.ser_deser_time = XPLAINUtil.recordStdTiming(this.getTimestamp());
            }
        }

        @Override
        protected String getID() {
            return "GetIdentityValueMessage";
        }

        @Override
        protected void appendFields(StringBuilder sb) {
            super.appendFields(sb);
            sb.append(";startBy=").append(this.startBy).append(";increment=").append(this.increment);
        }

        private static final class BListener
        implements BucketListener {
            private BListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void primaryMoved(Bucket bucket) {
                int bucketId = bucket.getId();
                PartitionedRegion pr = bucket.getPartitionedRegion();
                ConcurrentHashMap concurrentHashMap = autoIncMap;
                synchronized (concurrentHashMap) {
                    for (Object key : autoIncMap.keySet()) {
                        if (bucketId != PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, key)) continue;
                        autoIncMap.remove(key);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void regionClosed(InternalCacheEvent event) {
                ConcurrentHashMap concurrentHashMap = autoIncMap;
                synchronized (concurrentHashMap) {
                    autoIncMap.clear();
                }
            }
        }
    }
}

