/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.conn;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.MemoryEvent;
import com.gemstone.gemfire.internal.cache.control.MemoryThresholdListener;
import com.gemstone.gemfire.internal.cache.control.MemoryThresholds;
import com.gemstone.gemfire.internal.cache.control.ResourceListener;
import com.gemstone.gemfire.internal.concurrent.ConcurrentHashSet;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.ShutdownException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public final class GfxdHeapThresholdListener
implements MemoryThresholdListener {
    public static final int queryCancellationTimeInterval = Integer.getInteger(GfxdConstants.QUERY_CANCELLATION_TIME_INTERVAL, 100);
    private final GfxdQueryCanceller queryCanceller;
    private final Thread queryCancellerThread;
    private final LogWriterI18n logger;
    private final GemFireStore.StoreStatistics stats;
    private final ConcurrentHashSet<DistributedMember> heapCriticalMembers;
    private final ConcurrentHashSet<DistributedMember> heapEvictionMembers;
    private static final String THREAD_NAME = "gemfirexd.QueryCanceller";

    private GfxdHeapThresholdListener(GemFireCacheImpl cache) {
        Thread t;
        this.logger = cache.getLoggerI18n();
        this.stats = Misc.getMemStoreBooting().getStoreStatistics();
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            t = entry.getKey();
            if (!THREAD_NAME.equals(t.getName())) continue;
            StringBuilder sb = new StringBuilder("Existing QueryCanceller thread: ");
            StackTraceElement[] lines = entry.getValue();
            sb.append(" name=").append(t.getName()).append(" id=").append(t.getId()).append(" priority=").append(t.getPriority()).append(" state=").append((Object)t.getState()).append(" isdaemon=").append(t.isDaemon()).append('\n');
            for (int i = 0; i < lines.length; ++i) {
                sb.append('\t').append(lines[i]).append('\n');
            }
            GemFireXDUtils.throwAssert(sb.toString());
        }
        this.queryCanceller = new GfxdQueryCanceller();
        t = new Thread((Runnable)this.queryCanceller, THREAD_NAME);
        t.setDaemon(true);
        t.setPriority(9);
        t.start();
        this.queryCancellerThread = t;
        this.heapCriticalMembers = new ConcurrentHashSet(16, 0.75f, 2);
        this.heapEvictionMembers = new ConcurrentHashSet(16, 0.75f, 2);
        this.logger.info(LocalizedStrings.DEBUG, (Object)("GfxdHeapThreshold: Query Cancellation Thread Started with query cancellation interval " + queryCancellationTimeInterval + "ms"));
    }

    public void onEvent(MemoryEvent event) {
        MemoryThresholds.MemoryState memoryState = event.getState();
        DistributedMember member = event.getMember();
        if (!event.isLocal()) {
            if (memoryState.isCritical()) {
                this.heapCriticalMembers.add((Object)member);
            } else {
                this.heapCriticalMembers.remove((Object)member);
            }
            if (memoryState.isEviction()) {
                this.heapEvictionMembers.add((Object)member);
            } else {
                this.heapEvictionMembers.remove((Object)member);
            }
            return;
        }
        if (GemFireXDUtils.TraceHeapThresh) {
            SanityManager.DEBUG_PRINT((String)"TraceHeapThreshold", (String)("GfxdHeapThreshold: received memory event " + event));
        }
        if (memoryState.isCritical()) {
            this.queryCanceller.criticalUp();
        } else {
            this.queryCanceller.criticalDown();
        }
        if (memoryState.isEviction()) {
            this.queryCanceller.evictionUp();
        } else {
            this.queryCanceller.evictionDown();
        }
        if (memoryState.isEvictionDisabled()) {
            this.queryCanceller.evictionDisabled();
        }
    }

    public final boolean isEvictionUp(DistributedMember member) {
        return this.heapEvictionMembers.contains((Object)member);
    }

    public final boolean isCriticalUp(DistributedMember member) {
        return this.heapCriticalMembers.contains((Object)member);
    }

    public static boolean isCancellableQuery(Activation act) {
        ExecPreparedStatement ps = act.getPreparedStatement();
        if (ps == null) {
            return false;
        }
        ConstantAction ca = ps.getConstantAction();
        if (ca != null) {
            if (!ca.isCancellable()) {
                if (GemFireXDUtils.TraceHeapThresh) {
                    SanityManager.DEBUG_PRINT((String)"TraceHeapThreshold", (String)("GfxdHeapThresholdListener.isCancellableQuery: Skipping ConstantAction statement " + ps.getUserQueryString(act.getLanguageConnectionContext()) + " for cancellation"));
                }
                return false;
            }
        } else {
            int statementType = ps.getStatementType();
            switch (statementType) {
                case 4: {
                    if (GemFireXDUtils.TraceHeapThresh) {
                        SanityManager.DEBUG_PRINT((String)"TraceHeapThreshold", (String)("GfxdHeapThresholdListener.isCancellableQuery: Skipping data reduction statement " + ps.getUserQueryString(act.getLanguageConnectionContext()) + " for cancellation"));
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public static GfxdHeapThresholdListener createInstance(GemFireCacheImpl cache) {
        GfxdHeapThresholdListener listener = new GfxdHeapThresholdListener(cache);
        cache.getResourceManager().addResourceListener(InternalResourceManager.ResourceType.HEAP_MEMORY, (ResourceListener)listener);
        if (GemFireXDUtils.TraceHeapThresh) {
            SanityManager.DEBUG_PRINT((String)"TraceHeapThreshold", (String)("GfxdHeapThreshold: queryCancellationTimeInterval = " + queryCancellationTimeInterval));
        }
        return listener;
    }

    public void stop() {
        this.logger.info(LocalizedStrings.DEBUG, (Object)"GfxdHeapThreshold: Stopping Query Cancellation Thread");
        this.queryCanceller.stop();
        try {
            this.queryCancellerThread.join();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            Misc.checkIfCacheClosing(ie);
        }
    }

    public final boolean isCritical() {
        return this.queryCanceller._critical;
    }

    public final boolean isEviction() {
        return this.queryCanceller._eviction;
    }

    public final boolean isEvictionDisabled() {
        return this.queryCanceller._evictionDisabled;
    }

    private final class GfxdQueryCanceller
    implements Runnable {
        private volatile boolean _isStopped = false;
        private volatile boolean _critical = false;
        private volatile boolean _eviction = false;
        private boolean _evictionDisabled = false;
        private Activation activationToCancel = null;

        private GfxdQueryCanceller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this._isStopped) {
                    boolean isFirstAfterWait = false;
                    GfxdQueryCanceller gfxdQueryCanceller = this;
                    synchronized (gfxdQueryCanceller) {
                        while (!this._critical && !this._isStopped) {
                            GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
                            if (observer != null) {
                                observer.criticalDownMemoryEvent(GfxdHeapThresholdListener.this);
                            }
                            if (GemFireXDUtils.TraceHeapThresh) {
                                SanityManager.DEBUG_PRINT((String)"TraceHeapThreshold", (String)"GfxdHeapThreshold: Sleeping as CRITICAL_DOWN event is received");
                            }
                            this.activationToCancel = null;
                            isFirstAfterWait = true;
                            this.wait();
                        }
                    }
                    GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
                    if (observer != null) {
                        observer.criticalUpMemoryEvent(GfxdHeapThresholdListener.this);
                    }
                    if (isFirstAfterWait && GfxdHeapThresholdListener.this.logger.infoEnabled()) {
                        GfxdHeapThresholdListener.this.logger.info(LocalizedStrings.DEBUG, (Object)"GfxdHeapThreshold: Processing CRITICAL_UP event");
                        isFirstAfterWait = false;
                    }
                    this.cancelTopMemoryConsumingQuery();
                }
            }
            catch (InterruptedException e) {
                if (!this._isStopped && GfxdHeapThresholdListener.this.logger.infoEnabled()) {
                    GfxdHeapThresholdListener.this.logger.info(LocalizedStrings.DEBUG, (Object)"GfxdHeapThreshold: Query Cancellation Thread Interrupted ", (Throwable)e);
                }
            }
            catch (ShutdownException ignore) {
                if (GfxdHeapThresholdListener.this.logger.infoEnabled()) {
                    GfxdHeapThresholdListener.this.logger.info(LocalizedStrings.DEBUG, (Object)"GfxdHeapThreshold: Fabric server shutting down. Closing this thread. ");
                }
            }
            finally {
                if (GfxdHeapThresholdListener.this.logger.infoEnabled()) {
                    GfxdHeapThresholdListener.this.logger.info(LocalizedStrings.DEBUG, (Object)"GfxdHeapThreshold: Query Cancellation Thread Stopped ");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelTopMemoryConsumingQuery() throws InterruptedException {
            long beginCancellation = NanoTimer.getTime();
            ContextService singleton = ContextService.getFactory();
            assert (singleton != null);
            Iterator contextIter = null;
            ContextService contextService = singleton;
            synchronized (contextService) {
                if (!this._critical) {
                    return;
                }
                ConcurrentHashSet<ContextManager> hset = singleton.getAllContexts();
                if (GemFireXDUtils.TraceHeapThresh) {
                    SanityManager.DEBUG_PRINT((String)"TraceHeapThreshold", (String)("GfxdHeapThreshold: Acquiring ContextService iterator of size " + hset.size()));
                }
                contextIter = hset.iterator();
            }
            assert (contextIter != null) : "GfxdHeapThreshold: Context Service should have been null";
            long maxEstimatedMemoryUsed = 0L;
            LanguageConnectionContext lcc = null;
            while (contextIter.hasNext() && this._critical) {
                ContextManager cm = (ContextManager)contextIter.next();
                lcc = (LanguageConnectionContext)cm.getContext("LanguageConnectionContext");
                if (lcc == null) {
                    if (!GemFireXDUtils.TraceHeapThresh) continue;
                    SanityManager.DEBUG_PRINT((String)"TraceHeapThreshold", (String)"GfxdHeapThreshold: LCC is null");
                    continue;
                }
                ArrayList<Activation> acts = lcc.getAllActivations();
                Activation act = null;
                if (GemFireXDUtils.TraceHeapThresh) {
                    SanityManager.DEBUG_PRINT((String)"TraceHeapThreshold", (String)("GfxdHeapThreshold: Got " + acts.size() + " Activations for LCC " + lcc));
                }
                for (int index = acts.size() - 1; index >= 0; --index) {
                    if (index >= acts.size()) continue;
                    act = acts.get(index);
                    if (act == null) {
                        if (!GemFireXDUtils.TraceHeapThresh) continue;
                        SanityManager.DEBUG_PRINT((String)"TraceHeapThreshold", (String)("GfxdHeapThreshold: Skipping " + index + " activation for lcc " + lcc));
                        continue;
                    }
                    ExecPreparedStatement ps = act.getPreparedStatement();
                    if (ps == null) {
                        if (!GemFireXDUtils.TraceHeapThresh) continue;
                        SanityManager.DEBUG_PRINT((String)"TraceHeapThreshold", (String)("GfxdHeapThreshold: Skipping " + index + " activation as PS is NULL for lcc " + lcc));
                        continue;
                    }
                    if (!GfxdHeapThresholdListener.isCancellableQuery(act)) continue;
                    if (act.isQueryCancelled()) {
                        if (!GemFireXDUtils.TraceHeapThresh) continue;
                        SanityManager.DEBUG_PRINT((String)"TraceHeapThreshold", (String)("GfxdHeapThreshold: Skipping " + index + " activation as its already cancelled for lcc " + lcc));
                        continue;
                    }
                    try {
                        long estimatedMemoryUsed = act.estimateMemoryUsage();
                        if (estimatedMemoryUsed <= maxEstimatedMemoryUsed) continue;
                        maxEstimatedMemoryUsed = estimatedMemoryUsed;
                        this.activationToCancel = act;
                        continue;
                    }
                    catch (StandardException e) {
                        if (!GemFireXDUtils.TraceHeapThresh) continue;
                        SanityManager.DEBUG_PRINT((String)"TraceHeapThreshold", (String)("GfxdHeapThreshold: Skipping " + index + " activation because of exception " + e + " for lcc " + lcc));
                        continue;
                    }
                    catch (Throwable t) {
                        Error err;
                        if (t instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t))) {
                            SystemFailure.initiateFailure((Error)err);
                            throw err;
                        }
                        SystemFailure.checkFailure();
                        if (!GfxdHeapThresholdListener.this.logger.warningEnabled()) continue;
                        GfxdHeapThresholdListener.this.logger.warning(LocalizedStrings.DEBUG, (Object)("GfxdHeapThreshold: Ignoring " + index + " activation because of runtime exception " + t + " for lcc " + lcc), t);
                    }
                }
            }
            if (this._critical && this.activationToCancel != null) {
                this.activationToCancel.cancelOnLowMemory();
                this.activationToCancel = null;
                GfxdHeapThresholdListener.this.stats.collectQueryCancelledStats(NanoTimer.getTime() - beginCancellation);
                Thread.yield();
            }
            Thread.sleep(queryCancellationTimeInterval);
        }

        synchronized void stop() {
            this._critical = false;
            this._isStopped = true;
            this.notify();
            GfxdHeapThresholdListener.this.queryCancellerThread.interrupt();
        }

        synchronized void criticalUp() {
            this._critical = true;
            this.notify();
        }

        synchronized void criticalDown() {
            this._critical = false;
        }

        synchronized void evictionUp() {
            if (!this._eviction) {
                this._eviction = true;
            }
        }

        synchronized void evictionDown() {
            if (this._eviction) {
                this._eviction = false;
            }
        }

        synchronized void evictionDisabled() {
            this._evictionDisabled = true;
        }
    }
}

