/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.raw.log;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.EventID;
import com.pivotal.gemfirexd.internal.engine.GfxdOpConflationHandler;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Loggable;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.Logger;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.TransactionId;
import java.io.IOException;
import java.util.ArrayList;

public class MemLogger
implements Logger {
    private RawTransaction xact;
    private ArrayList<MemOperation> undoList;
    private ArrayList<MemOperation> doList;
    private GfxdOpConflationHandler<MemOperation> conflationHandler;

    @Override
    public void flush(LogInstant where) throws StandardException {
        throw new UnsupportedOperationException("This method is not supposed to be called!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushAll() throws StandardException {
        Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
        MemOperation operation = null;
        try {
            if (this.doList != null) {
                Throwable failure = null;
                for (int index = 0; index < this.doList.size(); ++index) {
                    operation = this.doList.get(index);
                    try {
                        operation.doMe(this.xact, null, null);
                        continue;
                    }
                    catch (Throwable t) {
                        Error err;
                        if (t instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t))) {
                            SystemFailure.initiateFailure((Error)err);
                            throw err;
                        }
                        SystemFailure.checkFailure();
                        Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(t);
                        failure = t;
                    }
                }
                if (failure != null) {
                    if (failure instanceof StandardException) {
                        throw (StandardException)failure;
                    }
                    Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(failure);
                    throw StandardException.newException("XSLA1.D", failure, (Object)operation);
                }
            }
        }
        finally {
            this.clear();
        }
    }

    @Override
    public LogInstant logAndDo(RawTransaction xact, Loggable operation) throws StandardException {
        RegionConflatable regionConflatable;
        MemOperation oldOp;
        MemOperation memOp = (MemOperation)operation;
        if (memOp.doAtCommitOrAbort()) {
            this.getDoList(xact).add(memOp);
        } else {
            try {
                memOp.doMe(xact, null, null);
            }
            catch (IOException ex) {
                throw StandardException.newException("XSLA1.D", (Throwable)ex, (Object)operation);
            }
        }
        String region = memOp.getRegionToConflate();
        Object key = memOp.getKeyToConflate();
        GfxdOpConflationHandler<MemOperation> conflateHandler = this.getConflationHandler(xact);
        if (key != null && (oldOp = conflateHandler.indexGet(regionConflatable = new RegionConflatable(region))) != null) {
            if (GemFireXDUtils.TraceConflation) {
                SanityManager.DEBUG_PRINT((String)"TraceConflation", (String)(this.toString() + ": skipping undo for operation [" + memOp + "] due to existing operation: " + oldOp));
            }
            return null;
        }
        ArrayList<MemOperation> list = this.getUndoList(xact);
        if (!conflateHandler.doConflate(memOp, key, memOp, null, list, true, false) || key == null) {
            list.add(memOp);
            if (region != null) {
                conflateHandler.addToConflationIndex(memOp, memOp);
            }
        } else if (GemFireXDUtils.TraceConflation) {
            SanityManager.DEBUG_PRINT((String)"TraceConflation", (String)(this.toString() + ": skipping undo due to conflation for operation [" + memOp + ']'));
        }
        return null;
    }

    @Override
    public LogInstant logAndUndo(RawTransaction xact, Compensation operation, LogInstant undoInstant, LimitObjectInput in) throws StandardException {
        throw new UnsupportedOperationException("This method is not supposed to be called!");
    }

    @Override
    public void reprepare(RawTransaction t, TransactionId undoId, LogInstant undoStopAt, LogInstant undoStartAt) throws StandardException {
        throw new UnsupportedOperationException("This method is not supposed to be called!");
    }

    @Override
    public void undo(RawTransaction tran, TransactionId undoId, LogInstant undoStopAt, LogInstant undoStartAt) throws StandardException {
        MemOperation operation = null;
        Compensation undo = null;
        if (this.undoList != null) {
            Throwable failure = null;
            for (int index = this.undoList.size() - 1; index >= 0; --index) {
                operation = this.undoList.get(index);
                try {
                    undo = operation.generateUndo(tran, null);
                    if (undo == null) continue;
                    if (GemFireXDUtils.TraceTran) {
                        SanityManager.DEBUG_PRINT((String)"TraceTran", (String)(this.toString() + " undo operation {" + undo + "} for operation: " + operation));
                    }
                    undo.doMe(tran, null, null);
                    continue;
                }
                catch (Throwable t) {
                    Error err;
                    if (t instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t))) {
                        SystemFailure.initiateFailure((Error)err);
                        throw err;
                    }
                    SystemFailure.checkFailure();
                    Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(t);
                    failure = t;
                }
            }
            if (failure != null) {
                if (failure instanceof StandardException) {
                    throw (StandardException)failure;
                }
                Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(failure);
                throw StandardException.newException("XSLA8.D", failure, (Object)tran, (Object)operation, (Object)undo);
            }
        }
    }

    private ArrayList<MemOperation> getUndoList(RawTransaction xact) {
        if (this.undoList == null) {
            this.undoList = new ArrayList();
            this.xact = xact;
        }
        return this.undoList;
    }

    public ArrayList<MemOperation> getDoList(RawTransaction xact) {
        if (this.doList == null) {
            this.doList = new ArrayList();
            this.xact = xact;
        }
        return this.doList;
    }

    private GfxdOpConflationHandler<MemOperation> getConflationHandler(RawTransaction xact) {
        if (this.conflationHandler == null) {
            this.conflationHandler = new GfxdOpConflationHandler();
            this.xact = xact;
            this.conflationHandler.setLogPrefix(this.toString());
        }
        return this.conflationHandler;
    }

    public String toString() {
        return "MemLogger for TX " + this.xact;
    }

    private void clear() {
        if (this.undoList != null) {
            this.undoList.clear();
        }
        if (this.doList != null) {
            this.doList.clear();
        }
        if (this.conflationHandler != null) {
            this.conflationHandler.close();
        }
    }

    private static final class RegionConflatable
    implements Conflatable {
        private final String regionName;

        RegionConflatable(String regionName) {
            this.regionName = regionName;
        }

        public boolean shouldBeConflated() {
            return false;
        }

        public boolean shouldBeMerged() {
            return false;
        }

        public boolean merge(Conflatable existing) {
            throw new AssertionError((Object)"not expected to be invoked");
        }

        public String getRegionToConflate() {
            return this.regionName;
        }

        public Object getKeyToConflate() {
            return null;
        }

        public Object getValueToConflate() {
            return null;
        }

        public EventID getEventId() {
            return null;
        }

        public void setLatestValue(Object value) {
        }
    }
}

