/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.procedure.cohort;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.procedure.ObjectArrayRow;
import com.pivotal.gemfirexd.internal.engine.procedure.ProcedureChunkMessage;
import com.pivotal.gemfirexd.internal.engine.procedure.cohort.ProcedureSender;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProxyResultDescription;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.GenericColumnDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.GenericResultDescription;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.procedure.OutgoingResultSet;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public final class OutgoingResultSetImpl
implements OutgoingResultSet,
ResultSet {
    private ArrayList<List<Object>> rowsList;
    private ProcedureSender sender;
    private final int resultSetNumber;
    private ResultDescription resultDescription;
    private final ProxyResultDescription proxyResultDescription;
    static final TypeId javaObjectType;
    private final Activation activation;
    Vector<ResultColumnDescriptor> columnDescriptors;
    private int numColumn;
    private int position;
    private boolean beforeFirst;
    private boolean afterLast;
    private Object[] rows;
    private int numRows;
    private int batchSize;

    public OutgoingResultSetImpl(Activation activation, int resultSetNumber, ResultDescription prd) {
        this.activation = activation;
        this.proxyResultDescription = (ProxyResultDescription)prd;
        this.sender = null;
        this.rowsList = new ArrayList();
        this.resultSetNumber = resultSetNumber;
        this.resultDescription = null;
        this.columnDescriptors = new Vector();
        this.numColumn = 0;
        this.position = -1;
        this.numRows = 0;
        this.beforeFirst = true;
        this.afterLast = false;
        this.batchSize = 100;
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    @Override
    public void addColumn(String name) {
        if (this.resultDescription != null) {
            throw new AssertionError((Object)"Meta data cannot be modified any more!");
        }
        DataTypeDescriptor dtd = new DataTypeDescriptor(javaObjectType, true);
        GenericColumnDescriptor rcd = new GenericColumnDescriptor(name, dtd);
        this.columnDescriptors.add(rcd);
    }

    private void prepareResultSetDescription() {
        if (this.resultDescription == null) {
            int num;
            if (this.columnDescriptors.size() == 0) {
                throw new IllegalStateException("Outgoing result set does not have any columns definition added");
            }
            this.numColumn = num = this.columnDescriptors.size();
            ResultColumnDescriptor[] temp = new ResultColumnDescriptor[this.numColumn];
            temp = this.columnDescriptors.toArray(temp);
            this.resultDescription = new GenericResultDescription(temp, "data aware procedure");
            this.proxyResultDescription.setResultDescription(this.resultDescription);
        }
    }

    @Override
    public void addRow(List<Object> row) {
        int length = row.size();
        if (length < 1) {
            return;
        }
        if (this.resultDescription == null) {
            if (this.columnDescriptors.size() == 0) {
                this.numColumn = length;
                this.resultDescription = OutgoingResultSetImpl.generateResultDescriptionOnRow(row);
            } else {
                int num = this.columnDescriptors.size();
                if (num != length) {
                    throw new AssertionError((Object)("The number of column is " + this.columnDescriptors.size() + " But the input row size is " + length));
                }
                this.numColumn = num;
                ResultColumnDescriptor[] temp = new ResultColumnDescriptor[this.numColumn];
                temp = this.columnDescriptors.toArray(temp);
                this.resultDescription = new GenericResultDescription(temp, "data aware procedure");
            }
            this.proxyResultDescription.setResultDescription(this.resultDescription);
        } else if (this.numColumn != length) {
            throw new AssertionError((Object)("The number of column is " + this.columnDescriptors.size() + " But the input row size is " + length));
        }
        this.rowsList.add(row);
        if (this.rowsList.size() >= this.batchSize && this.sender != null) {
            this.sendOutgoingResultSet();
            this.rowsList.clear();
        }
    }

    private void sendOutgoingResultSet() {
        ProcedureChunkMessage message = new ProcedureChunkMessage(3, this.getResultSetNumber(), this.rowsList);
        this.sender.send(message);
    }

    public static ResultDescription generateResultDescriptionOnRow(List<Object> row) {
        int length = row.size();
        ResultColumnDescriptor[] columnDescriptors = new ResultColumnDescriptor[length];
        for (int i = 1; i <= length; ++i) {
            columnDescriptors[i - 1] = new GenericColumnDescriptor("C" + i, new DataTypeDescriptor(javaObjectType, true));
        }
        GenericResultDescription rd = new GenericResultDescription(columnDescriptors, "data aware procedure");
        return rd;
    }

    @Override
    public void endResults() {
        this.prepareResultSetDescription();
        if (this.sender == null) {
            this.rows = this.rowsList.toArray();
            this.rowsList = null;
            this.numRows = this.rows == null || this.rows.length == 0 ? 0 : this.rows.length;
        } else {
            this.sendOutgoingResultSet();
        }
    }

    public void setResultSetSender(ProcedureSender sender) {
        this.sender = sender;
    }

    @Override
    public boolean checkRowPosition(int isType) throws StandardException {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public void cleanUp(boolean cleanupOnError) throws StandardException {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public void clearCurrentRow() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
    }

    @Override
    public void finish() throws StandardException {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public ExecRow getAbsoluteRow(int row) throws StandardException {
        if (this.isLegalPosition(row)) {
            return this.generateExecRow(row);
        }
        return null;
    }

    @Override
    public Activation getActivation() {
        return this.activation;
    }

    @Override
    public ResultSet getAutoGeneratedKeysResultset() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public boolean hasAutoGeneratedKeysResultSet() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public void flushBatch() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void closeBatch() throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public Timestamp getBeginExecutionTimestamp() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public String getCursorName() {
        return null;
    }

    @Override
    public Timestamp getEndExecutionTimestamp() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public long getExecuteTime() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public ExecRow getFirstRow() throws StandardException {
        if (this.isEmpty()) {
            return null;
        }
        return this.generateExecRow(0);
    }

    @Override
    public ExecRow getLastRow() throws StandardException {
        if (this.isEmpty()) {
            return null;
        }
        return this.generateExecRow(this.numRows - 1);
    }

    @Override
    public ExecRow getNextRow() throws StandardException {
        if (this.afterLast) {
            return null;
        }
        int nextPosition = this.position + 1;
        if (this.isLegalPosition(nextPosition)) {
            return this.generateExecRow(nextPosition);
        }
        if (nextPosition >= this.numRows) {
            this.setAfterLastRow();
        }
        return null;
    }

    @Override
    public ExecRow getPreviousRow() throws StandardException {
        if (this.beforeFirst) {
            return null;
        }
        int nextPosition = this.position - 11;
        if (this.isLegalPosition(nextPosition)) {
            return this.generateExecRow(nextPosition);
        }
        if (nextPosition < 0) {
            this.setBeforeFirstRow();
        }
        return null;
    }

    @Override
    public ExecRow getRelativeRow(int row) throws StandardException {
        int nextPosition = this.position + row;
        if (this.isLegalPosition(nextPosition)) {
            return this.generateExecRow(nextPosition);
        }
        if (nextPosition < 0) {
            this.setBeforeFirstRow();
            return null;
        }
        if (nextPosition >= this.numRows) {
            this.setAfterLastRow();
        }
        return null;
    }

    @Override
    public int getRowNumber() {
        return this.numRows;
    }

    @Override
    public NoPutResultSet[] getSubqueryTrackingArray(int numSubqueries) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public long getTimeSpent(int type, int timeType) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public int modifiedRowCount() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public void open() throws StandardException {
    }

    @Override
    public boolean returnsRows() {
        return true;
    }

    @Override
    public ExecRow setAfterLastRow() throws StandardException {
        this.position = this.numRows;
        this.beforeFirst = false;
        this.afterLast = true;
        return null;
    }

    @Override
    public ExecRow setBeforeFirstRow() throws StandardException {
        this.position = -1;
        this.beforeFirst = true;
        this.afterLast = false;
        return null;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int size) {
        this.batchSize = size;
    }

    private ExecRow generateExecRow(int index) {
        List row = (List)this.rows[index];
        this.position = index;
        this.afterLast = false;
        this.beforeFirst = false;
        return new ObjectArrayRow(row.toArray(), null);
    }

    private boolean isEmpty() {
        return this.numRows == 0;
    }

    private boolean isLegalPosition(int index) {
        return this.numRows != 0 && index < this.numRows && index >= 0;
    }

    public int getCurrentNumRows() {
        return this.rowsList.size();
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public UUID getExecutionPlanID() {
        return null;
    }

    @Override
    public void markLocallyExecuted() {
    }

    @Override
    public void resetStatistics() {
    }

    @Override
    public boolean isDistributedResultSet() {
        return false;
    }

    @Override
    public boolean addLockReference(GemFireTransaction tran) {
        return false;
    }

    @Override
    public boolean releaseLocks(GemFireTransaction tran) {
        return false;
    }

    @Override
    public void checkCancellationFlag() throws StandardException {
        Activation act = this.activation;
        if (act != null && act.isQueryCancelled()) {
            act.checkCancellationFlag();
        }
    }

    static {
        try {
            javaObjectType = TypeId.getUserDefinedTypeId("java.lang.Object", true);
        }
        catch (StandardException se) {
            throw new ExceptionInInitializerError(se);
        }
    }
}

