/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management.impl;

import com.gemstone.gemfire.internal.shared.SystemProperties;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.diag.MemoryAnalyticsVTI;
import com.pivotal.gemfirexd.internal.engine.management.impl.MBeanDataUpdater;
import com.pivotal.gemfirexd.internal.engine.management.impl.MBeanUpdateScheduler;
import com.pivotal.gemfirexd.internal.engine.management.impl.TableMBeanBridge;
import com.pivotal.gemfirexd.internal.engine.management.impl.Updatable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Random;
import java.util.Set;

class TableMBeanDataUpdater
extends MBeanDataUpdater<TableMBeanBridge> {
    private MemoryAnalyticsHolder memAnaHolder;
    private Random random = new Random();
    private int updateNumer = 0;

    public TableMBeanDataUpdater() {
        this.memAnaHolder = new MemoryAnalyticsHolder(new MemoryAnalyticsVTI(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runUpdate() {
        block15: {
            Updatable updatable = null;
            int updateToken = this.random.nextInt();
            try {
                if (Misc.initialDDLReplayDone() && this.updateNumer % (this.memAnaHolder.updatesToSkip == 0 ? this.updateNumer : this.memAnaHolder.updatesToSkip) == 0) {
                    MemoryAnalyticsVTI memoryAnalyticsVTI = this.memAnaHolder.memAnaVTI;
                    this.memAnaHolder.init();
                    while (memoryAnalyticsVTI.next()) {
                        updatable = null;
                        try {
                            String indexName;
                            String tableName = memoryAnalyticsVTI.getString(this.memAnaHolder.tableNameIndex);
                            updatable = (Updatable)this.updatables.get(tableName);
                            if (updatable == null) continue;
                            TableMBeanBridge tableMBeanBridge = (TableMBeanBridge)updatable.getSelf();
                            TableMBeanBridge.MemoryAnalyticsData memoryAnalytics = tableMBeanBridge.getMemoryAnalytics();
                            if (memoryAnalytics != null && (indexName = memoryAnalyticsVTI.getString(this.memAnaHolder.indexNameIndex)) == null) {
                                memoryAnalytics.updateMemoryAnalytics(Double.parseDouble(memoryAnalyticsVTI.getString(this.memAnaHolder.entrySizeIndex)), Double.parseDouble(memoryAnalyticsVTI.getString(this.memAnaHolder.keySizeIndex)), memoryAnalyticsVTI.getLong(this.memAnaHolder.numRowsIndex));
                            }
                            updatable.setUpdateToken(updateToken);
                        }
                        catch (SQLException e) {
                            this.logFine(e);
                        }
                        if (updatable == null) continue;
                        updatable.update();
                    }
                    this.memAnaHolder.lastUpdateTime = System.currentTimeMillis();
                    break block15;
                }
                Set entrySet = this.updatables.entrySet();
                for (Map.Entry entry : entrySet) {
                    updatable = (Updatable)entry.getValue();
                    if (updatable == null) continue;
                    updatable.update();
                }
            }
            catch (SQLException e) {
                this.logFine(e);
            }
            catch (Exception e) {
                this.logFine(e);
            }
            finally {
                if (this.memAnaHolder != null) {
                    this.memAnaHolder.reset();
                }
            }
        }
        if (this.updateNumer == Integer.MAX_VALUE) {
            this.updateNumer = 0;
        }
        ++this.updateNumer;
    }

    public long lastMemoryAnalyticsQueryTime() {
        if (this.memAnaHolder != null) {
            return this.memAnaHolder.lastUpdateTime;
        }
        return -1L;
    }

    @Override
    public void cleanUp() {
        if (this.memAnaHolder != null) {
            this.memAnaHolder.memAnaVTI = null;
        }
        this.memAnaHolder = null;
        super.cleanUp();
    }

    public static class MemoryAnalyticsHolder {
        public static final int DEFAULT_MEMANA_QUERY_INTERVAL_SEC = 600;
        public static final String MEMANA_QUERY_INTERVAL_PROPERTY = "tableAnalyticsUpdateIntervalSeconds";
        private MemoryAnalyticsVTI memAnaVTI;
        int tableNameIndex = -1;
        int entrySizeIndex = -1;
        int keySizeIndex = -1;
        int numRowsIndex = -1;
        int indexNameIndex = -1;
        int indexTypeIndex = -1;
        private int updatesToSkip;
        public long lastUpdateTime = -1L;

        MemoryAnalyticsHolder(MemoryAnalyticsVTI memAnaVTI) {
            this.memAnaVTI = memAnaVTI;
            int updateInterval = 600;
            try {
                updateInterval = SystemProperties.getServerInstance().getInteger(MEMANA_QUERY_INTERVAL_PROPERTY, 600);
            }
            catch (NumberFormatException e) {
                updateInterval = 600;
            }
            this.updatesToSkip = updateInterval * 1000 / MBeanUpdateScheduler.getConfiguredUpdateRate();
        }

        public void init() {
            try {
                if (this.tableNameIndex == -1) {
                    ResultSetMetaData metaData = this.memAnaVTI.getMetaData();
                    int columnCount = metaData.getColumnCount();
                    for (int i = 1; i <= columnCount; ++i) {
                        if (metaData.getColumnName(i).equals("TABLE_NAME")) {
                            this.tableNameIndex = i;
                            continue;
                        }
                        if (metaData.getColumnName(i).equals("ENTRY_SIZE")) {
                            this.entrySizeIndex = i;
                            continue;
                        }
                        if (metaData.getColumnName(i).equals("KEY_SIZE")) {
                            this.keySizeIndex = i;
                            continue;
                        }
                        if (metaData.getColumnName(i).equals("NUM_ROWS")) {
                            this.numRowsIndex = i;
                            continue;
                        }
                        if (metaData.getColumnName(i).equals("INDEX_NAME")) {
                            this.indexNameIndex = i;
                            continue;
                        }
                        if (!metaData.getColumnName(i).equals("INDEX_TYPE")) continue;
                        this.indexTypeIndex = i;
                    }
                }
            }
            catch (SQLException e) {
                Misc.getCacheLogWriterNoThrow().fine((Throwable)e);
            }
        }

        void reset() {
        }
    }
}

