/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.locks.impl;

import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.locks.QueuedSynchronizer;
import com.gemstone.gemfire.internal.cache.locks.TryLockObject;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockService;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockSet;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdReadWriteLock;
import com.pivotal.gemfirexd.internal.iapi.error.ShutdownException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class GfxdReentrantReadWriteLock
extends AtomicInteger
implements GfxdReadWriteLock {
    private static final long serialVersionUID = -1440030740550786092L;
    private final QueuedSynchronizer sync;
    private final Object lockName;
    private Object lockOwner;
    private final int waitThreshold;
    byte flags;
    byte traceLock;
    private static final String REF_PREFIX = "GfxdReentrantReadWriteLock@";
    private static final int WAIT_INFINITE = -1;
    private static final int DS_NOTFOUND = -2;
    private static final int WAIT_FOR_PENDING_WRITER = 1;
    private static final long MAXWAIT_FOR_PENDING_WRITER = GfxdLockSet.MAX_LOCKWAIT_VAL / 10;
    static final byte IS_INMAP = 1;
    static final byte ALLOW_LOCK_DOWNGRADE = 2;
    static final int SHARED_BITS = 20;
    static final int EXCLUSIVE_BITS = 12;
    static final int SHARED_MASK = 1048575;
    static final int EXCLUSIVE_ONE = 0x100000;
    static final int MAX_SHARED_COUNT = 1048575;
    static final int MAX_EXCLUSIVE_COUNT = 4095;
    static final int MAX_EXCLUSIVE_COUNT_1 = 4094;
    static final int MAX_SHARED_COUNT_1 = 1048574;

    public GfxdReentrantReadWriteLock(Object name, boolean allowLockDowngrade) {
        this(GfxdReentrantReadWriteLock.checkName(name), allowLockDowngrade, GfxdReentrantReadWriteLock.getDSTimeoutSecs());
    }

    public static GfxdReentrantReadWriteLock createTemplate(boolean allowLockDowngrade) {
        return new GfxdReentrantReadWriteLock(null, allowLockDowngrade, GfxdReentrantReadWriteLock.getDSTimeoutSecs());
    }

    private GfxdReentrantReadWriteLock(Object name, boolean allowLockDowngrade, int timeoutSecs) {
        this.lockName = name;
        this.sync = new QueuedSynchronizer();
        this.waitThreshold = timeoutSecs;
        if (GemFireXDUtils.TraceLock) {
            this.traceLock = 1;
        }
        if (allowLockDowngrade) {
            this.flags = GemFireXDUtils.set(this.flags, (byte)2);
        }
    }

    private static Object checkName(Object name) {
        Assert.assertTrue((name != null ? 1 : 0) != 0, (Object)"Unexpected null name for GfxdReentrantReadWriteLock");
        return name;
    }

    private static final int sharedCount(int c) {
        return c & 0xFFFFF;
    }

    private static final int exclusiveCount(int c) {
        return c >>> 20;
    }

    private static final boolean isShared(int c) {
        return (c & 0xFFFFF) != 0;
    }

    private static final boolean isExclusive(int c) {
        return c >>> 20 != 0;
    }

    private static int getDSTimeoutSecs() {
        InternalDistributedSystem dsys = InternalDistributedSystem.getConnectedInstance();
        if (dsys != null) {
            int timeoutSecs = dsys.getConfig().getAckWaitThreshold();
            if (timeoutSecs > 0) {
                return timeoutSecs;
            }
            return -1;
        }
        return -2;
    }

    private final boolean allowLockDowngrade() {
        return GemFireXDUtils.isSet(this.flags, (byte)2);
    }

    protected final long getMaxMillis() {
        return 9223372036854775L;
    }

    @Override
    public Object getLockName() {
        return this.lockName;
    }

    public boolean attemptReadLock(long msecs, Object owner) {
        long timeoutMillis;
        boolean traceLock = this.traceLock();
        if (traceLock) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(new StringBuilder("attemptReadLock: acquiring read lock, owner=").append(owner).append(", for lock ")).toString());
        }
        if (this.tryAcquireShared(1, owner, null) >= 0) {
            if (traceLock) {
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(new StringBuilder("attemptReadLock: successfully acquired ").append("read lock, owner=").append(owner).append(", for lock ")).toString());
            }
            return true;
        }
        if (msecs == 0L) {
            if (traceLock) {
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(new StringBuilder("attemptReadLock: FAILED acquire ").append("read lock zero timeout, owner=").append(owner).append(", for lock ")).toString());
            }
            return false;
        }
        if (msecs < 0L) {
            msecs = this.getMaxMillis();
        }
        InternalDistributedSystem dsys = Misc.getDistributedSystem();
        LogWriterI18n logger = dsys.getLogWriterI18n();
        if (this.waitThreshold > 0) {
            timeoutMillis = TimeUnit.SECONDS.toMillis(this.waitThreshold);
            if (timeoutMillis > MAXWAIT_FOR_PENDING_WRITER) {
                timeoutMillis = MAXWAIT_FOR_PENDING_WRITER;
            }
        } else {
            timeoutMillis = msecs;
        }
        if (traceLock) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(new StringBuilder("attemptReadLock: acquiring read lock with timeout ").append(timeoutMillis).append("ms, owner=").append(owner).append(", for lock ")).toString());
        }
        boolean res = false;
        long elapsedMillis = 0L;
        int waitForPendingWriter = 1;
        while (msecs > timeoutMillis) {
            if (this.sync.tryAcquireSharedNanos(waitForPendingWriter, owner, (TryLockObject)this, TimeUnit.MILLISECONDS.toNanos(timeoutMillis), null, null)) {
                res = true;
                break;
            }
            dsys.getCancelCriterion().checkCancelInProgress(null);
            msecs -= timeoutMillis;
            if (waitForPendingWriter != 0 && (elapsedMillis += timeoutMillis) >= MAXWAIT_FOR_PENDING_WRITER) {
                waitForPendingWriter = 0;
            }
            if (logger.warningEnabled()) {
                logger.warning(LocalizedStrings.LocalLock_Waiting, new Object[]{"GfxdReentrantReadWriteLock", Double.toString((double)timeoutMillis / 1000.0), "READ", this.lockName + ", owner=" + owner, this.toString(), msecs});
            }
            if (this.waitThreshold <= 0) continue;
            timeoutMillis <<= 1;
        }
        if (!res) {
            res = this.sync.tryAcquireSharedNanos(0, owner, (TryLockObject)this, TimeUnit.MILLISECONDS.toNanos(msecs), null, null);
        }
        if (traceLock) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(new StringBuilder("attemptReadLock: ").append(res ? "successfully acquired" : "unsuccessful in").append(" read lock with timeout ").append(timeoutMillis).append("ms, owner=").append(owner).append(", for lock ")).toString());
        }
        return res;
    }

    public boolean attemptWriteLock(long msecs, Object owner) {
        boolean traceLock = this.traceLock();
        if (traceLock) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(new StringBuilder("attemptWriteLock: acquiring write lock, owner=").append(owner).append(", for lock ")).toString());
        }
        if (this.tryAcquire(0, owner, null) >= 0) {
            if (traceLock) {
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(new StringBuilder("attemptWriteLock: successfully acquired ").append("write lock, owner=").append(owner).append(", for lock ")).toString());
            }
            return true;
        }
        if (msecs == 0L) {
            if (traceLock) {
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(new StringBuilder("attemptWriteLock: FAILED acquire ").append("write lock with zero timeout, owner=").append(owner).append(", for lock ")).toString());
            }
            return false;
        }
        if (msecs < 0L) {
            msecs = this.getMaxMillis();
        }
        InternalDistributedSystem dsys = Misc.getDistributedSystem();
        LogWriterI18n logger = dsys.getLogWriterI18n();
        long timeoutMillis = this.waitThreshold > 0 ? TimeUnit.SECONDS.toMillis(this.waitThreshold) : msecs;
        if (traceLock) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(new StringBuilder("attemptWriteLock: acquiring write lock with timeout ").append(timeoutMillis).append("ms, owner=").append(owner).append(", for lock ")).toString());
        }
        boolean res = false;
        while (msecs > timeoutMillis) {
            if (this.sync.tryAcquireNanos(0, owner, (TryLockObject)this, TimeUnit.MILLISECONDS.toNanos(timeoutMillis), null, null)) {
                res = true;
                break;
            }
            dsys.getCancelCriterion().checkCancelInProgress(null);
            msecs -= timeoutMillis;
            if (logger.warningEnabled()) {
                logger.warning(LocalizedStrings.LocalLock_Waiting, new Object[]{"GfxdReentrantReadWriteLock", Double.toString((double)timeoutMillis / 1000.0), "WRITE", this.lockName + ", owner=" + owner, this.toString(), msecs});
            }
            if (this.waitThreshold <= 0) continue;
            timeoutMillis <<= 1;
        }
        if (!res) {
            res = this.sync.tryAcquireNanos(0, owner, (TryLockObject)this, TimeUnit.MILLISECONDS.toNanos(msecs), null, null);
        }
        if (traceLock) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(new StringBuilder("attemptWriteLock: ").append(res ? "successfully acquired" : "unsuccessful in").append(" write lock with timeout ").append(timeoutMillis).append("ms, owner=").append(owner).append(", for lock ")).toString());
        }
        return res;
    }

    public void releaseReadLock() {
        boolean result;
        boolean traceLock = this.traceLock();
        if (traceLock) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(new StringBuilder("releaseReadLock: releasing ").append("read lock for ")).toString());
        }
        if (result = this.tryReleaseShared(0, null, null)) {
            this.sync.signalSharedWaiters();
        }
        if (traceLock) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(new StringBuilder("releaseReadLock: read lock release ").append(result ? "successful" : "unsuccessful").append(" for lock ")).toString());
        }
    }

    public void releaseWriteLock(Object owner) {
        boolean result;
        boolean traceLock = this.traceLock();
        if (traceLock) {
            StringBuilder sb = new StringBuilder("releaseWriteLock: releasing write lock with owner=").append(owner).append(", for ");
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(sb).toString());
        }
        if (result = this.tryRelease(0, owner, null)) {
            this.sync.signalWaiters();
        }
        if (traceLock) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(new StringBuilder("releaseWriteLock: write lock release with owner=").append(owner).append(result ? ", successful" : ", unsuccessful").append(" for lock ")).toString());
        }
    }

    @Override
    public GfxdLockService.ReadLockState hasReadLock() {
        return GfxdLockService.ReadLockState.UNKNOWN;
    }

    @Override
    public final boolean hasWriteLock(Object owner) {
        return GfxdReentrantReadWriteLock.isExclusive(this.getState()) && ArrayUtils.objectEquals((Object)owner, (Object)this.lockOwner);
    }

    @Override
    public final Object getWriteLockOwner() {
        return this.lockOwner;
    }

    @Override
    public GfxdReentrantReadWriteLock newLock(Object name) {
        int timeoutSecs = this.waitThreshold;
        if (timeoutSecs == -2) {
            timeoutSecs = GfxdReentrantReadWriteLock.getDSTimeoutSecs();
        }
        return new GfxdReentrantReadWriteLock(GfxdReentrantReadWriteLock.checkName(name), this.allowLockDowngrade(), timeoutSecs);
    }

    @Override
    public final int numReaders() {
        return GfxdReentrantReadWriteLock.sharedCount(this.getState());
    }

    public final int getState() {
        return super.get();
    }

    public final int tryAcquire(int arg, Object owner, Object context) {
        int currentWriteHolds;
        int currentState;
        do {
            StringBuilder sb;
            if ((currentState = this.getState()) == 0 && this.compareAndSet(0, 0x100000)) {
                this.lockOwner = owner;
                this.sync.setOwnerThread();
                return 1;
            }
            boolean traceLock = this.traceLock();
            currentWriteHolds = GfxdReentrantReadWriteLock.exclusiveCount(currentState);
            if (currentWriteHolds > 0) {
                if (!ArrayUtils.objectEquals((Object)this.lockOwner, (Object)owner)) {
                    if (traceLock) {
                        sb = new StringBuilder();
                        SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(sb).append(": tryAcquire: waiting for writer.").toString());
                    }
                    return -1;
                }
                if (currentWriteHolds == 4095) {
                    throw new IllegalMonitorStateException("Maximum write lock count exceeded 4095");
                }
                if (!traceLock) continue;
                sb = new StringBuilder();
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(sb).append(": tryAcquire: re-entering for write.").toString());
                continue;
            }
            if (!GfxdReentrantReadWriteLock.isShared(currentState)) continue;
            if (traceLock) {
                sb = new StringBuilder();
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(sb).append(": tryAcquire: waiting for reader(s).").toString());
            }
            return -1;
        } while (!this.compareAndSet(currentState, currentState + 0x100000));
        this.lockOwner = owner;
        this.sync.setOwnerThread();
        if (currentWriteHolds != 4094) {
            return 1;
        }
        return 0;
    }

    public final boolean tryRelease(int arg, Object owner, Object context) {
        int currentState = this.getState();
        if (owner != null && !owner.equals(this.lockOwner)) {
            IllegalMonitorStateException imse = new IllegalMonitorStateException("attempt to release exclusive lock by a non owner [" + owner + "], current owner [" + this.lockOwner + ']');
            Misc.getDistributedSystem().getCancelCriterion().checkCancelInProgress((Throwable)imse);
            throw imse;
        }
        while (true) {
            int writeHolds;
            if (currentState == 0x100000) {
                this.lockOwner = null;
                this.sync.clearOwnerThread();
                if (this.compareAndSet(0x100000, 0)) {
                    return true;
                }
            }
            if ((writeHolds = GfxdReentrantReadWriteLock.exclusiveCount(currentState)) == 0) {
                IllegalMonitorStateException imse = new IllegalMonitorStateException("write count is zero in release");
                Misc.getDistributedSystem().getCancelCriterion().checkCancelInProgress((Throwable)imse);
                throw imse;
            }
            if (writeHolds == 1) {
                this.lockOwner = null;
                this.sync.clearOwnerThread();
            }
            if (this.compareAndSet(currentState, currentState - 0x100000)) {
                if (writeHolds != 1 && this.traceLock()) {
                    StringBuilder sb = new StringBuilder();
                    SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(sb).append(": tryRelease: still remaining ").append(writeHolds - 1).append(" write holds for this thread.").toString());
                }
                return true;
            }
            currentState = this.getState();
        }
    }

    public final int tryAcquireShared(int arg, Object owner, Object context) {
        int currentReadHolds;
        int currentState;
        do {
            boolean allowLockDowngrade;
            if ((currentState = this.getState()) == 0 && this.compareAndSet(0, 1)) {
                return 1;
            }
            if (!(!GfxdReentrantReadWriteLock.isExclusive(currentState) || (allowLockDowngrade = this.allowLockDowngrade()) && ArrayUtils.objectEquals((Object)owner, (Object)this.lockOwner))) {
                if (this.traceLock()) {
                    StringBuilder sb = new StringBuilder();
                    SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(sb).append(": tryAcquireShared: waiting on writer with ").append("allowLockDowngrade=").append(allowLockDowngrade).toString());
                }
                return -1;
            }
            currentReadHolds = GfxdReentrantReadWriteLock.sharedCount(currentState);
            if (currentReadHolds == 1048575) {
                throw new IllegalMonitorStateException("Maximum read-only lock count exceeded: 1048575");
            }
            if (arg != 1 || !this.sync.apparentlyFirstQueuedIsExclusive()) continue;
            return -1;
        } while (!this.compareAndSet(currentState, currentState + 1));
        if (currentReadHolds != 1048574) {
            return 1;
        }
        return 0;
    }

    public final boolean tryReleaseShared(int arg, Object owner, Object context) {
        int readHolds;
        int currentState;
        do {
            if ((currentState = this.getState()) == 1 && this.compareAndSet(1, 0)) {
                return true;
            }
            readHolds = GfxdReentrantReadWriteLock.sharedCount(currentState);
            if (readHolds != 0) continue;
            IllegalMonitorStateException imse = new IllegalMonitorStateException("read-only lock count is zero in release");
            Misc.getDistributedSystem().getCancelCriterion().checkCancelInProgress((Throwable)imse);
            throw imse;
        } while (!this.compareAndSet(currentState, currentState - 1));
        if (readHolds != 1 && this.traceLock()) {
            StringBuilder sb = new StringBuilder();
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)this.fillSB(sb).append(": tryReleaseShared: remaining ").append(readHolds - 1).append(" read holds for this lock.").toString());
        }
        return true;
    }

    @Override
    public final boolean inMap() {
        return GemFireXDUtils.isSet(this.flags, (byte)1);
    }

    @Override
    public final void setInMap(boolean inMap) {
        this.flags = GemFireXDUtils.set(this.flags, (byte)1, inMap);
    }

    @Override
    public final boolean traceLock() {
        return this.traceLock == 1;
    }

    @Override
    public final void setTraceLock() {
        this.traceLock = 1;
    }

    @Override
    public final synchronized void dumpAllThreads(StringBuilder msg, Object lockObject, String logPrefix) {
        int state = this.getState();
        Object writer = this.lockOwner;
        Collection readWaiters = this.sync.getSharedQueuedThreads();
        Collection writeWaiters = this.sync.getExclusiveQueuedThreads();
        if (writer != null) {
            msg.append(logPrefix).append(": Lock object [").append(lockObject).append(",state=0x").append(Integer.toHexString(state)).append("] WRITE locked by ").append(writer.toString()).append(SanityManager.lineSeparator);
        }
        this.dumpReaders(msg, lockObject, state, logPrefix);
        if (writeWaiters.size() > 0) {
            msg.append(logPrefix).append(": Lock object [").append(lockObject).append(",state=0x").append(Integer.toHexString(state)).append("] has WRITE lock waiters: ").append(writeWaiters.toString()).append(SanityManager.lineSeparator);
        }
        if (readWaiters.size() > 0) {
            msg.append(logPrefix).append(": Lock object [").append(lockObject).append(",state=0x").append(Integer.toHexString(state)).append("] has READ lock waiters: ").append(readWaiters.toString()).append(SanityManager.lineSeparator);
        }
    }

    @Override
    public final synchronized Collection<Thread> getBlockedThreadsForDebugging() {
        Collection shared = this.sync.getSharedQueuedThreads();
        Collection exclusive = this.sync.getExclusiveQueuedThreads();
        ArrayList<Thread> results = new ArrayList<Thread>(shared.size() + exclusive.size());
        results.addAll(shared);
        results.addAll(exclusive);
        return results;
    }

    @Override
    public final void dumpAllReaders(final StringBuilder msg, final String logPrefix) {
        msg.append(SanityManager.lineSeparator);
        GemFireXDUtils.Visitor<LanguageConnectionContext> dumpReadLocks = new GemFireXDUtils.Visitor<LanguageConnectionContext>(){

            @Override
            public boolean visit(LanguageConnectionContext lcc) {
                try {
                    GfxdLockSet lockSet;
                    TransactionController tc = lcc.getTransactionExecute();
                    if (tc != null && (lockSet = ((GemFireTransaction)tc).getLockSpace()) != null) {
                        lockSet.dumpReadLocks(msg, logPrefix, lcc.getContextManager().getActiveThread());
                    }
                }
                catch (ShutdownException shutdownException) {
                    // empty catch block
                }
                return true;
            }
        };
        GemFireXDUtils.forAllContexts(dumpReadLocks);
    }

    protected void dumpReaders(StringBuilder msg, Object lockObject, int state, String logPrefix) {
        int numReaders = this.numReaders();
        if (numReaders > 0) {
            msg.append(logPrefix).append(": Lock object [").append(lockObject).append(",state=0x").append(Integer.toHexString(state)).append("] has been ").append(" READ locked by ").append(numReaders).append(" threads.").append(SanityManager.lineSeparator);
        }
    }

    public final boolean isReadLocked() {
        return GfxdReentrantReadWriteLock.isShared(this.getState());
    }

    public final boolean isWriteLocked() {
        return GfxdReentrantReadWriteLock.isExclusive(this.getState());
    }

    public int getWriteHoldCount(Object owner) {
        int writeHolds = GfxdReentrantReadWriteLock.exclusiveCount(this.getState());
        return writeHolds > 0 && ArrayUtils.objectEquals((Object)owner, (Object)this.lockOwner) ? writeHolds : 0;
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final boolean hasQueuedThread(Thread thread) {
        return this.sync.isQueued(thread);
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    @Override
    public final String toString() {
        return this.fillSB(new StringBuilder()).toString();
    }

    private StringBuilder toString(StringBuilder sb) {
        sb.append(REF_PREFIX).append(Integer.toHexString(this.hashCode())).append(',');
        return this.sync.toObjectString(sb).append("[name=").append(this.lockName).append(']');
    }

    @Override
    public StringBuilder fillSB(StringBuilder sb) {
        int count = this.getState();
        int readers = GfxdReentrantReadWriteLock.sharedCount(count);
        int writers = GfxdReentrantReadWriteLock.exclusiveCount(count);
        this.toString(sb).append(" [");
        if (writers > 0) {
            sb.append("writer=").append(this.lockOwner).append("(count=").append(writers).append("), ");
        }
        return sb.append("readers=").append(readers).append(']');
    }
}

