/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.jayway.jsonpath;

import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.Configuration;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.Filter;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.InvalidCriteriaException;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.Option;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.PathNotFoundException;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.Predicate;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.Utils;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.PathCompiler;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.spi.compiler.Path;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Criteria
implements Predicate {
    private static final Logger logger = LoggerFactory.getLogger(Criteria.class);
    private final Path path;
    private CriteriaType criteriaType;
    private Object expected;
    private final List<Criteria> criteriaChain;

    private Criteria(List<Criteria> criteriaChain, Path path) {
        if (!path.isDefinite()) {
            throw new InvalidCriteriaException("A criteria path must be definite. The path " + path.toString() + " is not!");
        }
        this.path = path;
        this.criteriaChain = criteriaChain;
        this.criteriaChain.add(this);
    }

    private Criteria(Path path) {
        this(new LinkedList<Criteria>(), path);
    }

    private Criteria(Path path, CriteriaType criteriaType, Object expected) {
        this(new LinkedList<Criteria>(), path);
        this.criteriaType = criteriaType;
        this.expected = expected;
    }

    @Override
    public boolean apply(Object model, Configuration configuration) {
        for (Criteria criteria : this.criteriaChain) {
            if (criteria.eval(model, configuration)) continue;
            return false;
        }
        return true;
    }

    private boolean eval(Object model, Configuration configuration) {
        if (CriteriaType.EXISTS == this.criteriaType) {
            boolean exists = (Boolean)this.expected;
            try {
                this.path.evaluate(model, configuration.options(Option.THROW_ON_MISSING_PROPERTY)).getValue();
                return exists;
            }
            catch (PathNotFoundException e) {
                return !exists;
            }
        }
        try {
            Object actual = this.path.evaluate(model, configuration).getValue();
            return this.criteriaType.eval(this.expected, actual, configuration);
        }
        catch (CompareException e) {
            return false;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    public static Criteria where(Path key) {
        return new Criteria(key);
    }

    public static Criteria where(String key) {
        return Criteria.where(PathCompiler.tokenize(key, new Filter[0]));
    }

    public Criteria and(String key) {
        return new Criteria(this.criteriaChain, PathCompiler.tokenize(key, new Filter[0]));
    }

    public Criteria is(Object o) {
        this.criteriaType = CriteriaType.EQ;
        this.expected = o;
        return this;
    }

    public Criteria eq(Object o) {
        return this.is(o);
    }

    public Criteria ne(Object o) {
        this.criteriaType = CriteriaType.NE;
        this.expected = o;
        return this;
    }

    public Criteria lt(Object o) {
        this.criteriaType = CriteriaType.LT;
        this.expected = o;
        return this;
    }

    public Criteria lte(Object o) {
        this.criteriaType = CriteriaType.LTE;
        this.expected = o;
        return this;
    }

    public Criteria gt(Object o) {
        this.criteriaType = CriteriaType.GT;
        this.expected = o;
        return this;
    }

    public Criteria gte(Object o) {
        this.criteriaType = CriteriaType.GTE;
        this.expected = o;
        return this;
    }

    public Criteria regex(Pattern pattern) {
        Utils.notNull(pattern, "pattern can not be null", new Object[0]);
        this.criteriaType = CriteriaType.REGEX;
        this.expected = pattern;
        return this;
    }

    public Criteria in(Object ... o) {
        return this.in(Arrays.asList(o));
    }

    public Criteria in(Collection<?> c) {
        Utils.notNull(c, "collection can not be null", new Object[0]);
        this.criteriaType = CriteriaType.IN;
        this.expected = c;
        return this;
    }

    public Criteria nin(Object ... o) {
        return this.nin(Arrays.asList(o));
    }

    public Criteria nin(Collection<?> c) {
        Utils.notNull(c, "collection can not be null", new Object[0]);
        this.criteriaType = CriteriaType.NIN;
        this.expected = c;
        return this;
    }

    public Criteria all(Object ... o) {
        return this.all(Arrays.asList(o));
    }

    public Criteria all(Collection<?> c) {
        Utils.notNull(c, "collection can not be null", new Object[0]);
        this.criteriaType = CriteriaType.ALL;
        this.expected = c;
        return this;
    }

    public Criteria size(int size) {
        this.criteriaType = CriteriaType.SIZE;
        this.expected = size;
        return this;
    }

    public Criteria exists(boolean b) {
        this.criteriaType = CriteriaType.EXISTS;
        this.expected = b;
        return this;
    }

    public Criteria type(Class<?> t) {
        Utils.notNull(t, "type can not be null", new Object[0]);
        this.criteriaType = CriteriaType.TYPE;
        this.expected = t;
        return this;
    }

    public Criteria notEmpty() {
        this.criteriaType = CriteriaType.NOT_EMPTY;
        this.expected = null;
        return this;
    }

    public Criteria matches(Predicate p) {
        this.criteriaType = CriteriaType.MATCHES;
        this.expected = p;
        return this;
    }

    private static int safeCompare(Object expected, Object actual, Configuration configuration) {
        if (Criteria.isNullish(expected) && !Criteria.isNullish(actual)) {
            return -1;
        }
        if (!Criteria.isNullish(expected) && Criteria.isNullish(actual)) {
            return 1;
        }
        if (Criteria.isNullish(expected) && Criteria.isNullish(actual)) {
            return 0;
        }
        if (expected instanceof String && actual instanceof String) {
            return ((String)expected).compareTo((String)actual);
        }
        if (expected instanceof Number && actual instanceof Number) {
            return new BigDecimal(expected.toString()).compareTo(new BigDecimal(actual.toString()));
        }
        if (expected instanceof String && actual instanceof Number) {
            return new BigDecimal(expected.toString()).compareTo(new BigDecimal(actual.toString()));
        }
        if (expected instanceof String && actual instanceof Boolean) {
            Boolean e = Boolean.valueOf((String)expected);
            Boolean a = (Boolean)actual;
            return e.compareTo(a);
        }
        if (expected instanceof Boolean && actual instanceof Boolean) {
            Boolean e = (Boolean)expected;
            Boolean a = (Boolean)actual;
            return e.compareTo(a);
        }
        logger.debug("Can not compare a {} with a {}", (Object)expected.getClass().getName(), (Object)actual.getClass().getName());
        throw new CompareException();
    }

    private static boolean isNullish(Object o) {
        return o == null || o instanceof String && "null".equals(o);
    }

    public static Criteria create(String path, String operator, String expected) {
        if (expected.startsWith("'") && expected.endsWith("'")) {
            expected = expected.substring(1, expected.length() - 1);
        }
        Path p = PathCompiler.tokenize(path, new Filter[0]);
        if ("$".equals(path) && (operator == null || operator.isEmpty()) && (expected == null || expected.isEmpty())) {
            return new Criteria(p, CriteriaType.NE, null);
        }
        if (operator.isEmpty()) {
            return Criteria.where(path).exists(true);
        }
        return new Criteria(p, CriteriaType.parse(operator), expected);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.path.toString()).append("|").append(this.criteriaType.name()).append("|").append(this.expected).append("|");
        return sb.toString();
    }

    private static class CompareException
    extends RuntimeException {
        private CompareException() {
        }
    }

    private static enum CriteriaType {
        EQ{

            @Override
            boolean eval(Object expected, Object actual, Configuration configuration) {
                boolean res = 0 == Criteria.safeCompare(expected, actual, configuration);
                logger.debug("[{}] {} [{}] => {}", new Object[]{actual, this.name(), expected, res});
                return res;
            }
        }
        ,
        NE{

            @Override
            boolean eval(Object expected, Object actual, Configuration configuration) {
                boolean res = 0 != Criteria.safeCompare(expected, actual, configuration);
                logger.debug("[{}] {} [{}] => {}", new Object[]{actual, this.name(), expected, res});
                return res;
            }
        }
        ,
        GT{

            @Override
            boolean eval(Object expected, Object actual, Configuration configuration) {
                if (expected == null ^ actual == null) {
                    return false;
                }
                boolean res = 0 > Criteria.safeCompare(expected, actual, configuration);
                logger.debug("[{}] {} [{}] => {}", new Object[]{actual, this.name(), expected, res});
                return res;
            }
        }
        ,
        GTE{

            @Override
            boolean eval(Object expected, Object actual, Configuration configuration) {
                if (expected == null ^ actual == null) {
                    return false;
                }
                boolean res = 0 >= Criteria.safeCompare(expected, actual, configuration);
                logger.debug("[{}] {} [{}] => {}", new Object[]{actual, this.name(), expected, res});
                return res;
            }
        }
        ,
        LT{

            @Override
            boolean eval(Object expected, Object actual, Configuration configuration) {
                if (expected == null ^ actual == null) {
                    return false;
                }
                boolean res = 0 < Criteria.safeCompare(expected, actual, configuration);
                logger.debug("[{}] {} [{}] => {}", new Object[]{actual, this.name(), expected, res});
                return res;
            }
        }
        ,
        LTE{

            @Override
            boolean eval(Object expected, Object actual, Configuration configuration) {
                if (expected == null ^ actual == null) {
                    return false;
                }
                boolean res = 0 <= Criteria.safeCompare(expected, actual, configuration);
                logger.debug("[{}] {} [{}] => {}", new Object[]{actual, this.name(), expected, res});
                return res;
            }
        }
        ,
        IN{

            @Override
            boolean eval(Object expected, Object actual, Configuration configuration) {
                boolean res = false;
                Collection exps = (Collection)expected;
                for (Object exp : exps) {
                    if (0 != Criteria.safeCompare(exp, actual, configuration)) continue;
                    res = true;
                    break;
                }
                logger.debug("[{}] {} [{}] => {}", new Object[]{actual, this.name(), Utils.join(", ", exps), res});
                return res;
            }
        }
        ,
        NIN{

            @Override
            boolean eval(Object expected, Object actual, Configuration configuration) {
                Collection nexps = (Collection)expected;
                boolean res = !nexps.contains(actual);
                logger.debug("[{}] {} [{}] => {}", new Object[]{actual, this.name(), Utils.join(", ", nexps), res});
                return res;
            }
        }
        ,
        ALL{

            @Override
            boolean eval(Object expected, Object actual, Configuration configuration) {
                boolean res = true;
                Collection exps = (Collection)expected;
                if (configuration.getProvider().isArray(actual)) {
                    for (Object exp : exps) {
                        boolean found = false;
                        for (Object check : configuration.getProvider().toIterable(actual)) {
                            if (0 != Criteria.safeCompare(exp, check, configuration)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        res = false;
                        break;
                    }
                    logger.debug("[{}] {} [{}] => {}", new Object[]{Utils.join(", ", configuration.getProvider().toIterable(actual)), this.name(), Utils.join(", ", exps), res});
                } else {
                    res = false;
                    logger.debug("[{}] {} [{}] => {}", new Object[]{"<NOT AN ARRAY>", this.name(), Utils.join(", ", exps), res});
                }
                return res;
            }
        }
        ,
        SIZE{

            @Override
            boolean eval(Object expected, Object actual, Configuration configuration) {
                boolean res;
                int size = (Integer)expected;
                if (configuration.getProvider().isArray(actual)) {
                    int length = configuration.getProvider().length(actual);
                    res = length == size;
                    logger.debug("Array with size {} {} {} => {}", new Object[]{length, this.name(), size, res});
                } else if (actual instanceof String) {
                    int length = ((String)actual).length();
                    res = length == size;
                    logger.debug("String with length {} {} {} => {}", new Object[]{length, this.name(), size, res});
                } else {
                    res = false;
                    logger.debug("{} {} {} => {}", new Object[]{actual == null ? "null" : actual.getClass().getName(), this.name(), size, res});
                }
                return res;
            }
        }
        ,
        EXISTS{

            @Override
            boolean eval(Object expected, Object actual, Configuration configuration) {
                throw new UnsupportedOperationException();
            }
        }
        ,
        TYPE{

            @Override
            boolean eval(Object expected, Object actual, Configuration configuration) {
                Class<?> actType;
                Class expType = (Class)expected;
                Class<?> clazz = actType = actual == null ? null : actual.getClass();
                if (actType != null) {
                    return expType.isAssignableFrom(actType);
                }
                return false;
            }
        }
        ,
        REGEX{

            @Override
            boolean eval(Object expected, Object actual, Configuration configuration) {
                boolean res = false;
                Pattern pattern = (Pattern)expected;
                if (actual != null && actual instanceof String) {
                    res = pattern.matcher(actual.toString()).matches();
                }
                logger.debug("[{}] {} [{}] => {}", new Object[]{actual, this.name(), expected.toString(), res});
                return res;
            }
        }
        ,
        MATCHES{

            @Override
            boolean eval(Object expected, Object actual, Configuration configuration) {
                Predicate exp = (Predicate)expected;
                return exp.apply(actual, configuration);
            }
        }
        ,
        NOT_EMPTY{

            @Override
            boolean eval(Object expected, Object actual, Configuration configuration) {
                boolean res = false;
                if (actual != null) {
                    if (configuration.getProvider().isArray(actual)) {
                        int len = configuration.getProvider().length(actual);
                        res = 0 != len;
                        logger.debug("array length = {} {} => {}", new Object[]{len, this.name(), res});
                    } else if (actual instanceof String) {
                        int len = ((String)actual).length();
                        res = 0 != len;
                        logger.debug("string length = {} {} => {}", new Object[]{len, this.name(), res});
                    }
                }
                return res;
            }
        };


        abstract boolean eval(Object var1, Object var2, Configuration var3);

        public static CriteriaType parse(String str) {
            if ("==".equals(str)) {
                return EQ;
            }
            if (">".equals(str)) {
                return GT;
            }
            if (">=".equals(str)) {
                return GTE;
            }
            if ("<".equals(str)) {
                return LT;
            }
            if ("<=".equals(str)) {
                return LTE;
            }
            if ("!=".equals(str)) {
                return NE;
            }
            throw new UnsupportedOperationException("CriteriaType " + str + " can not be parsed");
        }
    }
}

