/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.fabricservice;

import com.gemstone.gemfire.SystemFailure;
import com.pivotal.gemfirexd.FabricLocator;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceImpl;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceUtils;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Properties;

public class FabricLocatorImpl
extends FabricServiceImpl
implements FabricLocator {
    @Override
    public void start(String bindAddress, int port, Properties bootProperties) throws SQLException {
        this.start(bindAddress, port, bootProperties, false);
    }

    @Override
    public synchronized void start(String bindAddress, int port, Properties bootProperties, boolean ignoreIfStarted) throws SQLException {
        if (bootProperties == null) {
            bootProperties = new Properties();
        }
        bootProperties.setProperty("standalone-locator", "true");
        bootProperties.setProperty("host-data", "false");
        if (!bootProperties.containsKey("mcast-port")) {
            bootProperties.setProperty("mcast-port", "0");
        }
        if (bindAddress == null) {
            bindAddress = "0.0.0.0";
        } else if (!"0.0.0.0".equals(bindAddress) && bootProperties.get("bind-address") == null) {
            try {
                InetAddress addr = InetAddress.getByName(bindAddress);
                if (addr != null && !addr.isAnyLocalAddress()) {
                    bootProperties.setProperty("bind-address", bindAddress);
                }
            }
            catch (Exception addr) {
                // empty catch block
            }
        }
        if (port <= 0) {
            port = 10334;
        } else if (port <= 1025 || port >= 65535) {
            throw new IllegalArgumentException("Allowed port range is between 1025 to 65535 (excluding limits)");
        }
        bootProperties.setProperty("start-locator", bindAddress + '[' + port + "],server=true");
        if (!bootProperties.containsKey("jmx-manager")) {
            bootProperties.setProperty("jmx-manager", "true");
        }
        try {
            this.startImpl(bootProperties, ignoreIfStarted, true);
        }
        catch (Throwable t) {
            Error err;
            if (t instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t))) {
                FabricServiceUtils.clearSystemProperties(this.monitorlite, this.sysProps);
                SystemFailure.initiateFailure((Error)err);
                throw err;
            }
            SystemFailure.checkFailure();
            this.handleThrowable(t);
        }
    }
}

