/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.expression;

import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.expression.ExpressionBuilderVisitor;
import com.pivotal.gemfirexd.internal.engine.expression.GfxdExprNodeVirtualIDVisitor;
import com.pivotal.gemfirexd.internal.engine.expression.GfxdExprNodeVisitor;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedClass;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

public class ExpressionCompiler {
    private ValueNode exprNode;
    protected GeneratedClass exprGC;
    protected GeneratedMethod exprMethod;
    private final int exprId = ExpressionCompiler.getNextExpressionId();
    private final String exprType;
    private final Map<String, Integer> columnToIndexMap;
    private String[] columnsOrigOrder;
    private boolean isPrimaryKey;
    private boolean isSubsetOfPrimaryKey;
    private int[] columnPositionsInKey;
    private int[] columnPositionsInRow;
    protected String canonicalizedExpression;
    private static final AtomicInteger allExpressionId = new AtomicInteger(0);

    public ExpressionCompiler(ValueNode exprNode, Map<String, Integer> columnToIndexMap, String exprType) {
        this.exprNode = exprNode;
        this.columnToIndexMap = columnToIndexMap;
        this.exprType = exprType;
    }

    public static int getNextExpressionId() {
        return allExpressionId.getAndIncrement();
    }

    public String[] bindExpression(FromList fromList, SubqueryList subqueryList, Vector<?> aggregateVector) throws StandardException {
        this.exprNode.bindExpression(fromList, subqueryList, aggregateVector);
        GfxdExprNodeVisitor exprvistr = new GfxdExprNodeVisitor(this.columnToIndexMap);
        this.exprNode.accept(exprvistr);
        List<String> cols = exprvistr.getUsedColumns();
        this.columnsOrigOrder = cols.toArray(new String[cols.size()]);
        return this.columnsOrigOrder;
    }

    public void normalizeExpression(boolean forceBoolean) throws StandardException {
        if (this.exprNode.isParameterNode()) {
            throw StandardException.newException("42X19", "PARAMETER");
        }
        if (forceBoolean) {
            this.exprNode = this.exprNode.checkIsBoolean();
        }
        this.exprNode = SelectNode.normExpressions(this.exprNode);
        this.exprNode = this.exprNode.preprocess(1, null, null, null);
    }

    public boolean compileExpression(TableDescriptor td, LanguageConnectionContext lcc) throws StandardException {
        if (this.exprMethod == null) {
            CompilerContext cc = this.exprNode.getCompilerContext();
            int existingReliability = cc.getReliability();
            cc.setReliability(0);
            GfxdExprNodeVirtualIDVisitor visitor = new GfxdExprNodeVirtualIDVisitor(this.columnToIndexMap, null, this.exprType);
            this.exprNode.accept(visitor);
            this.canonicalizedExpression = visitor.getCanonicalizedExpression();
            ExpressionBuilderVisitor ebv = new ExpressionBuilderVisitor(lcc);
            ebv.dontSkipChildren();
            this.exprNode.accept(ebv);
            String methodName = ebv.getMethodsGenerated().get(0);
            this.exprGC = ebv.getExpressionClass();
            this.exprMethod = this.exprGC.getMethod(methodName);
            cc.setReliability(existingReliability);
            this.checkColumnsPrimaryKey(td, lcc);
            return true;
        }
        return false;
    }

    public final boolean isExpressionPrimaryKey() {
        return this.isPrimaryKey;
    }

    public final boolean isExpressionPartOfPrimaryKey() {
        return this.isSubsetOfPrimaryKey;
    }

    private void checkColumnsPrimaryKey(TableDescriptor td, LanguageConnectionContext lcc) throws StandardException {
        this.isPrimaryKey = false;
        this.isSubsetOfPrimaryKey = false;
        this.columnPositionsInKey = null;
        this.columnPositionsInRow = null;
        int numExprColumns = this.columnsOrigOrder.length;
        if (td != null) {
            Map<String, Integer> pkMap = GemFireXDUtils.getPrimaryKeyColumnNamesToIndexMap(td, lcc);
            if (pkMap != null) {
                this.isSubsetOfPrimaryKey = ExpressionCompiler.checkColumnsPartOfPrimaryKey(pkMap, this.columnsOrigOrder);
                if (this.isSubsetOfPrimaryKey) {
                    boolean bl = this.isPrimaryKey = pkMap.size() == numExprColumns;
                }
                if (this.isSubsetOfPrimaryKey) {
                    this.columnPositionsInKey = new int[numExprColumns];
                    for (int index = 0; index < this.columnsOrigOrder.length; ++index) {
                        String partCol = this.columnsOrigOrder[index];
                        int keyIndex = 0;
                        for (String indexCol : pkMap.keySet()) {
                            if (indexCol.equals(partCol)) break;
                            ++keyIndex;
                        }
                        assert (keyIndex < pkMap.size()) : "keyIndex=" + keyIndex + " pkMap=" + pkMap;
                        this.columnPositionsInKey[index] = keyIndex;
                    }
                }
            }
            this.columnPositionsInRow = new int[numExprColumns];
            this.columnToIndexMap.clear();
            HashMap<String, Integer> columnMap = GemFireXDUtils.getColumnNamesToIndexMap(td, true);
            for (int index = 0; index < numExprColumns; ++index) {
                String columnName = this.columnsOrigOrder[index];
                Integer colIndex = columnMap.get(columnName);
                if (colIndex == null) {
                    throw StandardException.newException("42X01", "The column (" + columnName + ") does not exist in the table's column list for table " + td.getQualifiedName());
                }
                this.columnToIndexMap.put(columnName, index);
                this.columnPositionsInRow[index] = colIndex;
            }
        }
    }

    public static boolean checkColumnsPartOfPrimaryKey(Map<String, Integer> pkMap, String[] columns) {
        for (String colName : columns) {
            if (pkMap.containsKey(colName)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DataValueDescriptor evaluateExpression(Object key, RowLocation rl, GemFireContainer container, LanguageConnectionContext lcc) throws StandardException {
        DataValueDescriptor dvd = null;
        DataValueDescriptor[] dvds = null;
        if (this.columnPositionsInKey != null) {
            int numCols = this.columnPositionsInKey.length;
            RegionKey gfKey = (RegionKey)key;
            if (numCols == 1) {
                dvd = gfKey.getKeyColumn(this.columnPositionsInKey[0]);
            } else {
                int index = 0;
                dvds = new DataValueDescriptor[numCols];
                for (int keyIndex : this.columnPositionsInKey) {
                    dvds[index++] = gfKey.getKeyColumn(keyIndex);
                }
            }
        } else {
            Object value = rl.getValueWithoutFaultIn(container);
            try {
                if (this.columnPositionsInRow.length == 1) {
                    dvd = RegionEntryUtils.getDVDFromValue(value, this.columnPositionsInRow[0], container);
                }
                dvds = RegionEntryUtils.getDVDArrayFromValue(value, this.columnPositionsInRow, container);
            }
            finally {
                OffHeapHelper.release((Object)value);
            }
        }
        return this.evaluateExpression(dvd, dvds, lcc);
    }

    public final DataValueDescriptor evaluateExpression(DataValueDescriptor dvd, DataValueDescriptor[] dvds, LanguageConnectionContext lcc) throws StandardException {
        BaseActivation act = lcc.getExpressionActivation(this.exprGC, this.exprId);
        act.setExpressionDVDs(dvd, dvds);
        return (DataValueDescriptor)this.exprMethod.invoke(act);
    }

    public final ValueNode getExpressionNode() {
        return this.exprNode;
    }

    public final Map<String, Integer> getColumnToIndexMap() {
        return this.columnToIndexMap;
    }

    public final GeneratedClass getGeneratedClass() {
        return this.exprGC;
    }

    public final GeneratedMethod getGeneratedMethod() {
        return this.exprMethod;
    }

    public final String getCanonicalizedExpression() {
        return this.canonicalizedExpression;
    }
}

