/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ColumnQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.TableQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ValueQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AndNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.NormalizeResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ProjectRestrictNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UpdateNode;

public class UpdateQueryInfo
extends DMLQueryInfo {
    private QueryInfo[][] updateCols = null;
    private int currentColumnIndex = 0;
    private int updateTargetTableNum = -1;

    public UpdateQueryInfo(QueryInfoContext qic) throws StandardException {
        super(qic);
        qic.setRootQueryInfo(this);
        this.queryType = GemFireXDUtils.set(this.queryType, 4);
    }

    @Override
    public void init() throws StandardException {
        if (this.updateTargetTableNum == -1 || this.tableQueryInfoList.isEmpty()) {
            return;
        }
        super.init();
        this.checkUpdateFormatSupported();
        TableQueryInfo tqi = (TableQueryInfo)this.tableQueryInfoList.get(this.updateTargetTableNum);
        if (!(!GemFireXDUtils.isSet(this.queryType, 4) || tqi.isPrimaryKeyBased() && this.isWhereClauseSatisfactory(tqi))) {
            this.queryType = GemFireXDUtils.clear(this.queryType, 4);
        }
    }

    public void checkNotNullCriteria(Activation activation) throws StandardException {
        int numUpdateCols = this.updateCols.length;
        for (int i = 0; i < numUpdateCols; ++i) {
            QueryInfo qi;
            ColumnQueryInfo cqi = (ColumnQueryInfo)this.updateCols[i][0];
            if (cqi == null || !((qi = this.updateCols[i][1]) instanceof ValueQueryInfo)) continue;
            ValueQueryInfo vqi = (ValueQueryInfo)qi;
            DataValueDescriptor dvd = vqi.evaluateToGetDataValueDescriptor(activation);
            cqi.isNotNullCriteriaSatisfied(dvd);
        }
    }

    private void checkUpdateFormatSupported() throws StandardException {
        TableQueryInfo tqi = (TableQueryInfo)this.tableQueryInfoList.get(this.updateTargetTableNum);
        boolean checkForColumnConstr = GemFireXDUtils.isSet(this.queryType, 4);
        if (checkForColumnConstr && tqi.isCheckTypeConstraintPresent()) {
            this.queryType = GemFireXDUtils.clear(this.queryType, 4);
            checkForColumnConstr = false;
        }
        for (int i = 0; i < this.updateCols.length; ++i) {
            ColumnQueryInfo cqi = (ColumnQueryInfo)this.updateCols[i][0];
            if (cqi == null) continue;
            if (cqi.isTableInfoMissing()) {
                cqi.setMissingTableInfo(tqi);
            }
            if (cqi.isUsedInPartitioning()) {
                throw StandardException.newException("0A000.S", "Update of partitioning column not supported");
            }
            if (!cqi.isPartOfPrimaryKey(tqi.getPrimaryKeyColumns())) continue;
            throw StandardException.newException("0A000.S", "Update of column which is primary key or is part of the primary key, not supported");
        }
    }

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        return node instanceof ProjectRestrictNode || node instanceof FromBaseTable || node instanceof AndNode || node instanceof ResultColumn;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof UpdateNode) {
            UpdateNode updNode = (UpdateNode)node;
            this.updateTargetTableNum = updNode.getTargetTableID();
            if (updNode.targetVTI != null) {
                updNode.targetVTI.computeQueryInfo(this.qic);
            }
            this.visit(updNode.getResultSetNode());
        } else if (node instanceof NormalizeResultSetNode) {
            this.visit(((NormalizeResultSetNode)node).getChildResult());
        } else if (node instanceof ResultColumnList) {
            this.handleResultColumnListNode((ResultColumnList)node);
        } else if (node instanceof ResultColumn) {
            this.handleResultColumnNode((ResultColumn)node);
        } else {
            super.visit(node);
        }
        return node;
    }

    @Override
    public final boolean isUpdate() {
        return true;
    }

    public void getChangedRowAndFormatableBitSet(Activation activation, Object pk, Object[] result) throws StandardException {
        int numUpdateCols = this.updateCols.length;
        DataValueDescriptor[] changedRow = new DataValueDescriptor[((TableQueryInfo)this.tableQueryInfoList.get(this.updateTargetTableNum)).getNumColumns()];
        FormatableBitSet changedColumnBitSet = new FormatableBitSet(numUpdateCols);
        for (int i = 0; i < numUpdateCols; ++i) {
            ColumnQueryInfo cqi = (ColumnQueryInfo)this.updateCols[i][0];
            if (cqi == null) continue;
            ValueQueryInfo vqi = (ValueQueryInfo)this.updateCols[i][1];
            DataValueDescriptor dvd = vqi.evaluateToGetDataValueDescriptor(activation);
            cqi.isNotNullCriteriaSatisfied(dvd);
            changedRow[cqi.getActualColumnPosition() - 1] = dvd;
            changedColumnBitSet.grow(cqi.getActualColumnPosition());
            changedColumnBitSet.set(cqi.getActualColumnPosition() - 1);
        }
        result[0] = changedRow;
        result[1] = changedColumnBitSet;
    }

    private void handleResultColumnListNode(ResultColumnList rlc) throws StandardException {
        this.updateCols = new QueryInfo[rlc.size()][2];
    }

    @Override
    int processResultColumnListFromProjectRestrictNodeAtLevel() {
        return 0;
    }

    private void handleResultColumnNode(ResultColumn rc) throws StandardException {
        ++this.currentColumnIndex;
        if (rc.updated()) {
            ColumnQueryInfo cqi = new ColumnQueryInfo(rc, this.qic);
            this.updateCols[this.currentColumnIndex - 1][0] = cqi;
            QueryInfo rhs = rc.getExpression().computeQueryInfo(this.qic);
            if (rhs == null) {
                rhs = QueryInfoConstants.DUMMY;
            }
            this.updateCols[this.currentColumnIndex - 1][1] = rhs;
            if (rhs == QueryInfoConstants.DUMMY || rhs instanceof ColumnQueryInfo) {
                this.queryType = GemFireXDUtils.clear(this.queryType, 4);
            }
        }
    }

    public LocalRegion getTargetRegion() {
        return ((TableQueryInfo)this.tableQueryInfoList.get(this.updateTargetTableNum)).getRegion();
    }

    @Override
    public boolean isTableVTI() {
        return this.qic.virtualTable() != null;
    }

    @Override
    public boolean routeQueryToAllNodes() {
        return this.qic.isVTIDistributable();
    }
}

