/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.TableQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import java.util.Set;
import java.util.SortedSet;

public class SubQueryInfo
extends SelectQueryInfo {
    private static final byte NON_CORRELATED_SUBQUERY = 0;
    private static final byte SUPPORTED_CORRELATED_SUBQUERY = 1;
    private static final byte UNSUPPORTED_CORRELATED_SUBQUERY = 2;
    private byte subqueryDataFlag = 0;
    private final String subqueryStr;
    private int prBasedIndependentScopeLevel = -1;

    public SubQueryInfo(QueryInfoContext qic, String subqueryStr, boolean hasCorrelatedCols) throws StandardException {
        super(qic);
        this.subqueryStr = subqueryStr;
        if (hasCorrelatedCols) {
            this.prBasedIndependentScopeLevel = qic.getLastPushedPRBasedIndependentScope();
            this.subqueryDataFlag = GemFireXDUtils.set(this.subqueryDataFlag, (byte)2);
            if (this.prBasedIndependentScopeLevel != -1) {
                DMLQueryInfo temp = qic.getScopeAt(this.prBasedIndependentScopeLevel).getDMLQueryInfo();
                TableQueryInfo masterTQI = temp.getDriverTableQueryInfo();
                assert (masterTQI.isPartitionedRegion());
                TableQueryInfo master = new TableQueryInfo(masterTQI, qic);
                this.tableQueryInfoList.add(0, master);
                this.updateColocationMatrixData(master);
            }
        } else if (qic.getNestingLevelOfScope() == 2) {
            throw StandardException.newException("0A000.S.20");
        }
    }

    @Override
    public void computeNodes(Set<Object> routingKeys, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
        QueryInfoConstants.NON_PRUNABLE.computeNodes(routingKeys, activation, false);
    }

    boolean isCorrelated() {
        return GemFireXDUtils.isSet(this.subqueryDataFlag, (byte)1) || GemFireXDUtils.isSet(this.subqueryDataFlag, (byte)2);
    }

    boolean isIndependent() {
        return GemFireXDUtils.isSet(this.subqueryDataFlag, (byte)0);
    }

    @Override
    public void init() throws StandardException {
        super.init();
        boolean bl = this.needGfxdSubactivation = (this.isPrimaryKeyBased() || this.getPRTableCount() > 0 && !this.isCorrelated()) && (!Misc.getDistributedSystem().isLoner() || SubQueryInfo.getTestFlagIgnoreSingleVMCriteria());
        if (this.isCorrelated()) {
            if (this.getRegion().getDataPolicy().withPartitioning() && this.prBasedIndependentScopeLevel == -1) {
                throw StandardException.newException("0A000.S.14");
            }
            this.subqueryDataFlag = GemFireXDUtils.set(this.subqueryDataFlag, (byte)1);
            if (this.prBasedIndependentScopeLevel != -1) {
                this.qic.getScopeAt(this.prBasedIndependentScopeLevel).getDMLQueryInfo().addSubQueryInfo(this);
            } else {
                this.checkServerGroupCompatibility();
            }
        } else {
            this.checkServerGroupCompatibility();
            this.qic.getRootQueryInfo().addSubQueryInfo(this);
        }
    }

    private void checkServerGroupCompatibility() throws StandardException {
        if (this.qic.getPRTableCount() == 0) {
            SortedSet<String> predecessor;
            DMLQueryInfo prev = this.qic.getLastPushedIndependentQueryInfo();
            SortedSet<String> replicatedSGs = SubQueryInfo.getServerGroups(this.getDriverTableQueryInfo());
            if (replicatedSGs != null && replicatedSGs != GemFireXDUtils.SET_MAX && GemFireXDUtils.setCompare(replicatedSGs, predecessor = SubQueryInfo.getServerGroups(prev.getDriverTableQueryInfo())) < 0) {
                throw StandardException.newException("0A000.S.9", (Object)(prev.getDriverTableQueryInfo().getFullTableName() + "[server groups:" + SharedUtils.toCSV(predecessor) + "]"), (Object)(this.getDriverTableQueryInfo().getFullTableName() + "[server groups:" + SharedUtils.toCSV(replicatedSGs) + "]"));
            }
        }
    }

    public String getSubqueryString() {
        return this.subqueryStr;
    }

    @Override
    public boolean isSubQueryInfo() {
        return true;
    }

    int getLastPushedPRBasedIndependentScopeLevel() {
        return this.prBasedIndependentScopeLevel;
    }

    public void cleanUp() {
        this.prBasedIndependentScopeLevel = -1;
    }
}

