/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ProjectRestrictNode;

public class Scope {
    private int numPRTables = 0;
    private int numTables = 0;
    private final DMLQueryInfo dmlInfo;
    private int scopeLevel;
    private ProjectRestrictNode parentPRN;

    Scope(DMLQueryInfo top, int scopeLevel) {
        this.dmlInfo = top;
        this.scopeLevel = scopeLevel;
    }

    void addToPRTableCount(int cnt) {
        this.checkValidity();
        this.numPRTables += cnt;
    }

    void addToTableCount(int cnt) {
        this.checkValidity();
        this.numTables += cnt;
    }

    int getPRTableCount() {
        this.checkValidity();
        return this.numPRTables;
    }

    int getTableCount() {
        this.checkValidity();
        return this.numTables;
    }

    void setParentPRN(ProjectRestrictNode prn) {
        this.checkValidity();
        this.parentPRN = prn;
    }

    ProjectRestrictNode getParentPRN() {
        this.checkValidity();
        return this.parentPRN;
    }

    void cleanUp() {
        this.setParentPRN(null);
    }

    DMLQueryInfo getDMLQueryInfo() {
        this.checkValidity();
        return this.dmlInfo;
    }

    public int getScopeLevel() {
        this.checkValidity();
        return this.scopeLevel;
    }

    public void unsetLevel() {
        this.checkValidity();
        this.scopeLevel = -1;
    }

    public void checkValidity() {
        if (this.scopeLevel == -1) {
            throw new IllegalStateException("A Scope object should not be referred to once popped out");
        }
    }
}

