/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeKey;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public final class RegionAndKey
extends GfxdDataSerializable
implements Serializable,
Comparable<RegionAndKey> {
    private static final long serialVersionUID = 2599723689085422219L;
    private String rname;
    private Object key;
    private boolean isReplicated;
    private boolean forSpecialUseOfSetOperators;
    private boolean leftSideTreeOfSetOperatorNode;
    public static final RegionAndKey TRUE = new RegionAndKey(true);
    public static final RegionAndKey FALSE = new RegionAndKey(false);

    public RegionAndKey() {
    }

    public RegionAndKey(String regionName, Object key, boolean rep) {
        this.rname = regionName;
        this.key = key;
        this.isReplicated = rep;
    }

    public boolean isDriver(String driverTable) {
        if (this.forSpecialUseOfSetOperators) {
            SanityManager.ASSERT((this.key == null ? 1 : 0) != 0, (String)" RegionAndKey when used for set operators, should have no key ");
            SanityManager.ASSERT((this.rname == null ? 1 : 0) != 0, (String)" RegionAndKey when used for set operators, should have no key ");
            return false;
        }
        return driverTable.equals(this.rname.substring(this.rname.lastIndexOf(46) + 1));
    }

    public boolean isReplicatedRegion() {
        return this.isReplicated;
    }

    @Override
    public byte getGfxdID() {
        return 94;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.forSpecialUseOfSetOperators = in.readBoolean();
        if (this.forSpecialUseOfSetOperators) {
            this.leftSideTreeOfSetOperatorNode = in.readBoolean();
        } else {
            this.rname = DataSerializer.readString((DataInput)in);
            this.key = DataSerializer.readObject((DataInput)in);
            if (this.rname != null && this.key instanceof KeyWithRegionContext) {
                try {
                    LocalRegion r = (LocalRegion)Misc.getRegionForTable(this.rname, true);
                    ((KeyWithRegionContext)this.key).setRegionContext(r);
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
            }
            this.isReplicated = in.readBoolean();
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeBoolean(this.forSpecialUseOfSetOperators);
        if (this.forSpecialUseOfSetOperators) {
            out.writeBoolean(this.leftSideTreeOfSetOperatorNode);
        } else {
            DataSerializer.writeString((String)this.rname, (DataOutput)out);
            DataSerializer.writeObject((Object)this.key, (DataOutput)out);
            out.writeBoolean(this.isReplicated);
        }
    }

    public boolean equals(Object obj) {
        assert (obj instanceof RegionAndKey) : "unexpected obj type: " + obj.getClass().getName();
        RegionAndKey other = (RegionAndKey)obj;
        if (this.forSpecialUseOfSetOperators || other.forSpecialUseOfSetOperators) {
            if (this.forSpecialUseOfSetOperators) {
                SanityManager.ASSERT((this.key == null ? 1 : 0) != 0, (String)" RegionAndKey when used for set operators, should have no key ");
                SanityManager.ASSERT((this.rname == null ? 1 : 0) != 0, (String)" RegionAndKey when used for set operators, should have no key ");
            }
            return this.forSpecialUseOfSetOperators == other.forSpecialUseOfSetOperators && this.leftSideTreeOfSetOperatorNode == other.leftSideTreeOfSetOperatorNode;
        }
        return this.isReplicated == other.isReplicated && this.rname.equalsIgnoreCase(other.rname) && this.key.equals(other.key);
    }

    public int hashCode() {
        if (this.forSpecialUseOfSetOperators) {
            SanityManager.ASSERT((this.key == null ? 1 : 0) != 0, (String)" RegionAndKey when used for set operators, should have no key ");
            SanityManager.ASSERT((this.rname == null ? 1 : 0) != 0, (String)" RegionAndKey when used for set operators, should have no key ");
            if (this.leftSideTreeOfSetOperatorNode) {
                return 1;
            }
            return 2;
        }
        return this.rname.hashCode() ^ this.key.hashCode();
    }

    public String toString() {
        if (this.forSpecialUseOfSetOperators) {
            SanityManager.ASSERT((this.key == null ? 1 : 0) != 0, (String)" RegionAndKey when used for set operators, should have no key ");
            SanityManager.ASSERT((this.rname == null ? 1 : 0) != 0, (String)" RegionAndKey when used for set operators, should have no key ");
            return "region for special-use-for-set-operators  have leftSideTreeOfSetOperatorNode = " + this.leftSideTreeOfSetOperatorNode;
        }
        return "region: " + this.rname + (this.isReplicated ? "(R)" : "(P)") + " and key: " + this.key;
    }

    @Override
    public int compareTo(RegionAndKey other) {
        if (this.forSpecialUseOfSetOperators || other.forSpecialUseOfSetOperators) {
            if (this.forSpecialUseOfSetOperators) {
                SanityManager.ASSERT((this.key == null ? 1 : 0) != 0, (String)" RegionAndKey when used for set operators, should have no key ");
                SanityManager.ASSERT((this.rname == null ? 1 : 0) != 0, (String)" RegionAndKey when used for set operators, should have no key ");
            }
            return this.forSpecialUseOfSetOperators == other.forSpecialUseOfSetOperators && this.leftSideTreeOfSetOperatorNode == other.leftSideTreeOfSetOperatorNode ? 1 : -1;
        }
        assert (this.key != null && other.key != null);
        if (this.isReplicated) {
            if (!other.isReplicated) {
                return -1;
            }
        } else if (other.isReplicated) {
            return 1;
        }
        if (this.rname == null) {
            if (other.rname != null) {
                return 1;
            }
            return this.key.hashCode() > other.key.hashCode() ? -1 : 1;
        }
        if (this.rname.equals(other.rname)) {
            if (this.key.equals(other.key)) {
                return 0;
            }
            return this.key.hashCode() > other.key.hashCode() ? -1 : 1;
        }
        return this.rname.hashCode() > other.rname.hashCode() ? -1 : 1;
    }

    public String getRegionName() {
        return this.rname;
    }

    public Object getKey() {
        return this.key;
    }

    public RegionAndKey getClone() {
        if (this.forSpecialUseOfSetOperators) {
            SanityManager.ASSERT((this.key == null ? 1 : 0) != 0, (String)" RegionAndKey when used for set operators, should have no key ");
            SanityManager.ASSERT((this.rname == null ? 1 : 0) != 0, (String)" RegionAndKey when used for set operators, should have no key ");
            return this.leftSideTreeOfSetOperatorNode ? TRUE : FALSE;
        }
        return new RegionAndKey(this.rname, this.key, this.isReplicated);
    }

    public long estimateMemoryUsage() throws StandardException {
        if (this.forSpecialUseOfSetOperators) {
            SanityManager.ASSERT((this.key == null ? 1 : 0) != 0, (String)" RegionAndKey when used for set operators, should have no key ");
            SanityManager.ASSERT((this.rname == null ? 1 : 0) != 0, (String)" RegionAndKey when used for set operators, should have no key ");
            return 2L;
        }
        long memory = 0L;
        if (this.key instanceof CompactCompositeKey) {
            memory += ((CompactCompositeKey)this.key).estimateMemoryUsage();
        } else if (this.key instanceof DataValueDescriptor) {
            memory += (long)((DataValueDescriptor)this.key).estimateMemoryUsage();
        } else if (this.key instanceof Long) {
            memory += 8L;
        }
        return (long)this.rname.length() + memory;
    }

    public boolean isForSpecialUseOfSetOperators() {
        return this.forSpecialUseOfSetOperators;
    }

    public boolean isLeftSideTreeOfSetOperatorNode() {
        return this.leftSideTreeOfSetOperatorNode;
    }

    private RegionAndKey(boolean isLeftSideTreeOfSetOperatorNode) {
        this.forSpecialUseOfSetOperators = true;
        this.leftSideTreeOfSetOperatorNode = isLeftSideTreeOfSetOperatorNode;
    }
}

