/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.LogWriter;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractConditionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AndJunctionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ComparisonQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.JunctionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.TableQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OrJunctionQueryInfo
extends JunctionQueryInfo {
    private final List<AbstractConditionQueryInfo> operands = new ArrayList<AbstractConditionQueryInfo>(5);

    OrJunctionQueryInfo(AbstractConditionQueryInfo op1, AbstractConditionQueryInfo op2) {
        this.setIsDynamic(op1.isWhereClauseDynamic() || op2.isWhereClauseDynamic());
        this.setIsStaticallyNotGetConvertible(true);
        this.operands.add(op1);
        this.operands.add(op2);
    }

    OrJunctionQueryInfo(int junctionType, JunctionQueryInfo jqi, AbstractConditionQueryInfo op1) {
        super(jqi);
        if (op1 != null) {
            if (!this.isWhereClauseDynamic()) {
                this.setIsDynamic(op1.isWhereClauseDynamic());
            }
            this.operands.add(op1);
        } else {
            this.setIsStaticallyNotGetConvertible(jqi.isStaticallyNotGetConvertible());
        }
    }

    OrJunctionQueryInfo(JunctionQueryInfo jqi1, JunctionQueryInfo jqi2) {
        super(jqi1, jqi2);
        assert (jqi1.getJunctionType() == 1);
        assert (jqi2.getJunctionType() == 1);
        this.colocationFailReason = jqi1.isEquiJoinColocationCriteriaFullfilled(null);
        if (this.colocationFailReason == null && (this.colocationFailReason = jqi2.isEquiJoinColocationCriteriaFullfilled(null)) == null) {
            this.colocationCriteria = jqi1.colocationCriteria;
        }
        this.setIsStaticallyNotGetConvertible(jqi1.isStaticallyNotGetConvertible() || jqi2.isStaticallyNotGetConvertible());
    }

    @Override
    JunctionQueryInfo mergeNonJunctionOperand(AbstractConditionQueryInfo operand, int operandJunctionType) throws StandardException {
        this.setIsStaticallyNotGetConvertible(true);
        if (this.getJunctionType() == operandJunctionType) {
            this.operands.add(operand);
            if (!this.isWhereClauseDynamic()) {
                this.setIsDynamic(operand.isWhereClauseDynamic());
            }
            return this;
        }
        return new AndJunctionQueryInfo(operandJunctionType, this, operand);
    }

    @Override
    Object isConvertibleToGet(int[][] pkColumns, TableQueryInfo tqi) throws StandardException {
        Object[] retType = null;
        if (!this.isStaticallyNotGetConvertible()) {
            assert (this.children != null);
            retType = new Object[this.children.length];
            assert (this.operands.isEmpty());
            for (int i = 0; i < this.children.length; ++i) {
                Object aKey = this.children[i].isConvertibleToGet(pkColumns, tqi);
                if (aKey == null) {
                    retType = null;
                    break;
                }
                retType[i] = aKey;
            }
        }
        return retType;
    }

    @Override
    Object isConvertibleToGetOnLocalIndex(int[][] ikColumns, TableQueryInfo tqi) throws StandardException {
        Object[] retType = null;
        if (!this.isStaticallyNotGetConvertible()) {
            assert (this.children != null);
            retType = new Object[this.children.length];
            assert (this.operands.isEmpty());
            for (int i = 0; i < this.children.length; ++i) {
                Object aKey = this.children[i].isConvertibleToGetOnLocalIndex(ikColumns, tqi);
                if (aKey == null) {
                    retType = null;
                    break;
                }
                retType[i] = aKey;
            }
        }
        return retType;
    }

    @Override
    List<AbstractConditionQueryInfo> getOperands() {
        return Collections.unmodifiableList(this.operands);
    }

    @Override
    int getJunctionType() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeNodes(Set<Object> routingKeys, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
        LogWriter logger = Misc.getCacheLogWriter();
        assert (routingKeys.size() == 1);
        assert (routingKeys.contains(ResolverUtils.TOK_ALL_NODES));
        boolean isPruningPossible = true;
        if (logger.fineEnabled()) {
            logger.fine("OrJunctionQueryInfo::computeNodes: Before prunning node  size = " + routingKeys.size());
            logger.fine("OrJunctionQueryInfo::computeNodes: Before prunning nodes are" + routingKeys);
        }
        try {
            ArrayList<Object> tempCollector = new ArrayList<Object>(10);
            Iterator<AbstractConditionQueryInfo> itr = this.operands.iterator();
            HashSet<Object> nodesCollector = new HashSet<Object>();
            nodesCollector.add(ResolverUtils.TOK_ALL_NODES);
            isPruningPossible = true;
            while (itr.hasNext()) {
                AbstractConditionQueryInfo acqi = itr.next();
                assert (acqi instanceof ComparisonQueryInfo);
                acqi.computeNodes(nodesCollector, activation, forSingleHopPreparePhase);
                if (nodesCollector.contains(ResolverUtils.TOK_ALL_NODES)) {
                    isPruningPossible = false;
                    break;
                }
                tempCollector.addAll(nodesCollector);
                nodesCollector.clear();
                nodesCollector.add(ResolverUtils.TOK_ALL_NODES);
            }
            if (isPruningPossible) {
                assert (nodesCollector.size() == 1);
                assert (nodesCollector.contains(ResolverUtils.TOK_ALL_NODES));
                if (this.children != null) {
                    for (int i = 0; i < this.children.length; ++i) {
                        this.children[i].computeNodes(nodesCollector, activation, forSingleHopPreparePhase);
                        if (nodesCollector.contains(ResolverUtils.TOK_ALL_NODES)) {
                            return;
                        }
                        tempCollector.addAll(nodesCollector);
                        nodesCollector.clear();
                        nodesCollector.add(ResolverUtils.TOK_ALL_NODES);
                    }
                }
                routingKeys.remove(ResolverUtils.TOK_ALL_NODES);
                routingKeys.addAll(tempCollector);
            }
        }
        finally {
            if (logger.fineEnabled()) {
                logger.fine("AndJunctionQueryInfo::computeNodes: After prunning nodes are" + routingKeys);
            }
        }
    }

    @Override
    public String isEquiJoinColocationCriteriaFullfilled(TableQueryInfo ncjTqi) {
        String retVal = null;
        for (AbstractConditionQueryInfo acqi : this.operands) {
            retVal = acqi.isEquiJoinColocationCriteriaFullfilled(ncjTqi);
            if (retVal == null) continue;
            return retVal;
        }
        if (this.children != null) {
            for (JunctionQueryInfo jqi : this.children) {
                retVal = jqi.isEquiJoinColocationCriteriaFullfilled(ncjTqi);
                if (retVal == null) continue;
                return retVal;
            }
        }
        return null;
    }
}

