/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SecondaryClauseQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.UpdateAggregatorInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.expression.ExpressionBuilderVisitor;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.compile.CollectExpressionOperandsVisitor;
import com.pivotal.gemfirexd.internal.engine.sql.compile.CollectParameterNodeVisitor;
import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedClass;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNodeList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AggregatorInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AggregatorInfoList;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import java.util.ArrayList;
import java.util.Vector;

public class GroupByQueryInfo
extends AbstractQueryInfo
implements SecondaryClauseQueryInfo {
    protected AggregatorInfoList aggInfo;
    private ColumnOrdering[] columnOrdering;
    private final boolean isInSortedOrder;
    private boolean isGroupingRequired;
    private ExecRow groupByExecRow;
    private ExecRow expectedRemoteExecRow;
    private RowFormatter rowFormatter;
    private int[] projectMapping;
    private GeneratedClass exprClass;
    private ArrayList<String> exprMethodList;
    private DataTypeDescriptor distinctAggUnderlyingType = null;

    public GroupByQueryInfo(QueryInfoContext qic, GroupByNode groupByNode, AggregatorInfoList _aggInfo, GroupByList _groupinglist, ResultColumnList resultColumns, ResultColumnList parentRCL, ValueNode havingClause, boolean isInSortedOrder) throws StandardException {
        ResultColumn rc;
        int i;
        this.aggInfo = _aggInfo;
        this.isInSortedOrder = isInSortedOrder;
        if (GemFireXDUtils.TraceGroupByQI) {
            SanityManager.DEBUG_PRINT((String)"TraceGroupByQI", (String)("GroupByQI::(): received parentRCL " + parentRCL));
        }
        LanguageConnectionContext lcc = groupByNode.getLanguageConnectionContext();
        CollectExpressionOperandsVisitor exprSubstitutor = new CollectExpressionOperandsVisitor(lcc, null, false);
        parentRCL.accept(exprSubstitutor);
        ResultColumnList expandedRCL = exprSubstitutor.getResultColumns();
        if (GemFireXDUtils.TraceGroupByQI) {
            SanityManager.DEBUG_PRINT((String)"TraceGroupByQI", (String)("GroupByQI::(): parentRCL after expression operands expanded " + expandedRCL));
        }
        int[] origColumnPositions = null;
        if (_groupinglist != null) {
            if (GemFireXDUtils.TraceGroupByQI) {
                SanityManager.DEBUG_PRINT((String)"TraceGroupByQI", (String)("GroupByQI::(): GroupingList to begin with " + _groupinglist));
            }
            int groupingCount = _groupinglist.size();
            origColumnPositions = new int[groupingCount];
            for (i = 0; i < groupingCount; ++i) {
                GroupByColumn gbc = (GroupByColumn)_groupinglist.elementAt(i);
                rc = expandedRCL.findParentResultColumn(resultColumns.getResultColumn(gbc.getColumnPosition()));
                if (rc != null) {
                    origColumnPositions[i] = gbc.getColumnPosition();
                    gbc.setColumnPosition(rc.getVirtualColumnId());
                } else {
                    origColumnPositions[i] = -1;
                }
                this.collectParamsIfAny(gbc.getColumnExpression(), qic);
            }
            if (GemFireXDUtils.TraceGroupByQI) {
                SanityManager.DEBUG_PRINT((String)"TraceGroupByQI", (String)("GroupByQI::(): GroupingList after re-aligning projected grouping columns: " + _groupinglist));
            }
        }
        if (GemFireXDUtils.TraceGroupByQI) {
            SanityManager.DEBUG_PRINT((String)"TraceGroupByQI", (String)("GroupByQI::(): AggregateList to begin with " + _aggInfo));
        }
        ResultColumn[] projectedAggregators = new ResultColumn[_aggInfo.size()];
        for (i = 0; i < _aggInfo.size(); ++i) {
            AggregatorInfo aggregate = (AggregatorInfo)_aggInfo.elementAt(i);
            rc = expandedRCL.findParentResultColumn(resultColumns.getResultColumn(aggregate.getOutputColNum() + 1));
            if (rc == null) continue;
            projectedAggregators[i] = rc;
            ResultColumn inputRC = resultColumns.getResultColumn(aggregate.getInputColNum() + 1);
            aggregate.setInputColNum(rc.getVirtualColumnId());
            aggregate.setOutputColNum(aggregate.getOutputColNum() + 1);
            this.handleDistinctAggregate(aggregate, inputRC, rc);
            this.collectParamsIfAny(inputRC != null ? inputRC.getExpression() : null, qic);
        }
        if (GemFireXDUtils.TraceGroupByQI) {
            SanityManager.DEBUG_PRINT((String)"TraceGroupByQI", (String)("GroupByQI::(): AggregateList after re-aligning projected aggregates " + _aggInfo));
        }
        ContextManager cm = lcc.getContextManager();
        if (_groupinglist != null) {
            int size = origColumnPositions.length;
            for (int i2 = 0; i2 < size; ++i2) {
                if (origColumnPositions[i2] != -1) continue;
                GroupByColumn gbc = (GroupByColumn)_groupinglist.elementAt(i2);
                ResultColumn gbRC = resultColumns.getResultColumn(gbc.getColumnPosition());
                VirtualColumnNode vc = (VirtualColumnNode)lcc.getLanguageConnectionFactory().getNodeFactory().getNode(107, groupByNode, gbRC, gbRC.getVirtualColumnId(), cm);
                ResultColumn newRC = (ResultColumn)lcc.getLanguageConnectionFactory().getNodeFactory().getNode(80, "##UnaggColumn Generated result", vc, cm);
                newRC.markGenerated();
                newRC.bindResultColumnToExpression();
                origColumnPositions[i2] = gbc.getColumnPosition();
                expandedRCL.addResultColumn(newRC);
                gbc.setColumnPosition(expandedRCL.size());
            }
        }
        if (GemFireXDUtils.TraceGroupByQI && _groupinglist != null) {
            SanityManager.DEBUG_PRINT((String)"TraceGroupByQI", (String)("GroupByQI::(): GroupingList after re-aligning generated grouping column " + _groupinglist));
        }
        int rclSelectListIndex = -1;
        if (havingClause != null) {
            if (_groupinglist == null) {
                rclSelectListIndex = exprSubstitutor.getResultColumns().size();
            }
            havingClause.accept(exprSubstitutor);
            this.collectParamsIfAny(havingClause, qic);
            if (GemFireXDUtils.TraceGroupByQI) {
                SanityManager.DEBUG_PRINT((String)"TraceGroupByQI", (String)("GroupByQI::(): Expected row after expanding having clause " + expandedRCL));
            }
        }
        Vector<UpdateAggregatorInfo> updateAgg = new Vector<UpdateAggregatorInfo>();
        int size = projectedAggregators.length;
        for (int i3 = 0; i3 < size; ++i3) {
            if (projectedAggregators[i3] != null) continue;
            AggregatorInfo aggregate = (AggregatorInfo)_aggInfo.elementAt(i3);
            ResultColumn inputRC = resultColumns.getResultColumn(aggregate.getInputColNum() + 1);
            ResultColumn rc2 = expandedRCL.findParentResultColumn(resultColumns.getResultColumn(aggregate.getOutputColNum() + 1));
            if (rc2 != null) {
                projectedAggregators[i3] = rc2;
                updateAgg.add(new UpdateAggregatorInfo(aggregate, inputRC, rc2, this));
                continue;
            }
            assert (rclSelectListIndex != -1) : " non-projected aggregate is expected only when there is no group by";
            ResultColumn newRC = (ResultColumn)lcc.getLanguageConnectionFactory().getNodeFactory().getNode(80, "##aggregate Generated result", groupByNode.getNullNode(aggregate.getResultDescription().getColumnDescriptor(1).getType()), cm);
            newRC.markGenerated();
            newRC.bindResultColumnToExpression();
            expandedRCL.insertResultColumnAt(newRC, rclSelectListIndex);
            updateAgg.add(new UpdateAggregatorInfo(aggregate, inputRC, newRC, this));
        }
        for (UpdateAggregatorInfo ua : updateAgg) {
            ua.apply();
        }
        if (_groupinglist != null) {
            this.columnOrdering = _groupinglist.getColumnOrdering();
            this.isGroupingRequired = true;
        } else {
            this.isGroupingRequired = false;
        }
        try {
            this.groupByExecRow = resultColumns.buildEmptyRow();
            this.expectedRemoteExecRow = expandedRCL.buildEmptyRow();
            this.rowFormatter = GroupByQueryInfo.getRowFormatterFromRCL(expandedRCL, lcc);
            if (GemFireXDUtils.TraceGroupByQI) {
                SanityManager.DEBUG_PRINT((String)"TraceGroupByQI", (String)("GroupByQI::(): finally expanded RCL is " + expandedRCL));
            }
        }
        catch (StandardException e) {
            throw GemFireXDRuntimeException.newRuntimeException("GroupByQueryInfo: Error generating template row", e);
        }
        this.generateExpressionClass(parentRCL, exprSubstitutor.getOtherExpressions(), qic);
        this.generateProjectMapping(parentRCL, exprSubstitutor.getNumOperands(), expandedRCL);
        parentRCL.resetVirtualColumnIds();
    }

    public GroupByQueryInfo(boolean isDummy) {
        assert (isDummy);
        this.isInSortedOrder = false;
        if (GemFireXDUtils.TraceGroupByQI) {
            SanityManager.DEBUG_PRINT((String)"TraceGroupByQI", (String)"GroupByQI::(): Created Dummy ");
        }
    }

    void handleDistinctAggregate(AggregatorInfo aggregate, ResultColumn inputRC, ResultColumn receiveRC) throws StandardException {
        if (!aggregate.isDistinct()) {
            return;
        }
        this.distinctAggUnderlyingType = inputRC.getType();
        TypeId cti = TypeId.getUserDefinedTypeId(DVDSet.class.getName(), this.distinctAggUnderlyingType, false);
        DataTypeDescriptor type = new DataTypeDescriptor(cti, false);
        receiveRC.setType(type);
        inputRC.setType(type);
    }

    private void collectParamsIfAny(ValueNode expression, QueryInfoContext qic) throws StandardException {
        if (expression == null) {
            return;
        }
        CollectParameterNodeVisitor collectParams = new CollectParameterNodeVisitor(qic);
        expression.accept(collectParams);
    }

    private void generateExpressionClass(ResultColumnList parentRCL, ValueNodeList otherExprs, QueryInfoContext qic) throws StandardException {
        ExpressionBuilderVisitor genExpression = new ExpressionBuilderVisitor(parentRCL.getLanguageConnectionContext());
        parentRCL.accept(genExpression);
        if (otherExprs != null) {
            genExpression.dontSkipChildren();
            otherExprs.accept(genExpression);
        }
        this.exprClass = genExpression.getExpressionClass();
        if (this.exprClass != null) {
            BaseActivation a = (BaseActivation)this.exprClass.newInstance(parentRCL.getLanguageConnectionContext(), false, null);
            SanityManager.ASSERT((a != null ? 1 : 0) != 0, (String)"Bad expression class generated ");
            a.close();
        }
        this.exprMethodList = genExpression.getMethodsGenerated();
    }

    private void generateProjectMapping(ResultColumnList parentRCL, ArrayList<Integer> numOperands, ResultColumnList dataNodeRCL) throws StandardException {
        this.projectMapping = new int[parentRCL.size()];
        int i = 0;
        int j = 1;
        int size = parentRCL.size();
        while (i < size) {
            this.projectMapping[i] = -1;
            if (this.exprMethodList.get(i) != null) {
                this.projectMapping[i] = -(i + 1);
                j += numOperands.get(i) - 1;
            } else {
                ResultColumn check;
                while ((check = dataNodeRCL.getResultColumn(j)) != null && check.isGenerated()) {
                    ++j;
                }
                this.projectMapping[i] = j;
            }
            ++i;
            ++j;
        }
        if (GemFireXDUtils.TraceGroupByQI) {
            StringBuilder sb = new StringBuilder();
            int idx = 0;
            for (int i2 : this.projectMapping) {
                sb.append(" [" + idx++ + "] = " + i2);
            }
            SanityManager.DEBUG_PRINT((String)"TraceGroupByQI", (String)("GroupByQI::generateProjectMapping(): " + sb));
        }
    }

    public final ExecRow getTemplateRow() {
        return this.groupByExecRow;
    }

    public final AggregatorInfoList getAggInfo() {
        return this.aggInfo;
    }

    public final boolean isInSortedOrder() {
        return this.isInSortedOrder;
    }

    @Override
    public final ColumnOrdering[] getColumnOrdering() {
        return this.columnOrdering;
    }

    @Override
    public final ExecRow getInComingProjectionExecRow() {
        return this.expectedRemoteExecRow;
    }

    @Override
    public final RowFormatter getRowFormatter() {
        return this.rowFormatter;
    }

    public final boolean doReGrouping() {
        return this.isGroupingRequired;
    }

    public DataTypeDescriptor getDistinctAggregateUnderlyingType() {
        if (GemFireXDUtils.TraceAggreg) {
            SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)("returning Distinct Aggregate underlying type from GBQI " + this.distinctAggUnderlyingType));
        }
        return this.distinctAggUnderlyingType;
    }

    @Override
    public final int[] getProjectMapping() {
        return null;
    }

    public final int[] getPostGroupingProjectMapping() {
        return this.projectMapping;
    }

    public final BaseActivation getExpressionEvaluator(LanguageConnectionContext lcc) throws StandardException {
        if (this.exprClass == null) {
            return null;
        }
        return (BaseActivation)this.exprClass.newInstance(lcc, true, null);
    }

    public final ArrayList<String> getExprMethodList() {
        return this.exprMethodList;
    }
}

