/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SecondaryClauseQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexColumnOrder;

public class DistinctQueryInfo
extends AbstractQueryInfo
implements SecondaryClauseQueryInfo {
    private ColumnOrdering[] ordering;
    private final ExecRow expectedRemoteExecRow;
    private final RowFormatter rowFormatter;
    private int[] projectMapping;

    public DistinctQueryInfo(QueryInfoContext qic, ResultColumnList rclist, ResultColumnList parentRCL, boolean hasColumnOrdering) throws StandardException {
        if (hasColumnOrdering) {
            this.deriveColumnOrdering(rclist, parentRCL);
        }
        if (parentRCL != null && rclist.size() != parentRCL.size()) {
            this.projectMapping = new int[parentRCL.size()];
            for (int i = 0; i < parentRCL.size(); ++i) {
                this.projectMapping[i] = i + 1;
            }
            rclist.mergeResultColumnList(parentRCL, false);
        }
        this.expectedRemoteExecRow = parentRCL != null ? parentRCL.buildEmptyRow() : rclist.buildEmptyRow();
        this.rowFormatter = DistinctQueryInfo.getRowFormatterFromRCL(parentRCL != null ? parentRCL : rclist, null);
    }

    private void deriveColumnOrdering(ResultColumnList rclist, ResultColumnList parentRCL) throws StandardException {
        int numCols = rclist == null ? 0 : rclist.size();
        IndexColumnOrder[] orderByColOrdering = parentRCL != null ? parentRCL.getColumnOrdering() : null;
        this.ordering = new IndexColumnOrder[numCols];
        int index = 0;
        if (orderByColOrdering != null) {
            for (int i = 0; i < orderByColOrdering.length; ++i) {
                this.ordering[i] = orderByColOrdering[i];
            }
            index = orderByColOrdering.length;
        }
        while (index < numCols) {
            ResultColumn rclistRC = rclist.getResultColumn(index + 1);
            ResultColumn rc = parentRCL != null ? parentRCL.findParentResultColumn(rclistRC) : rclistRC;
            this.ordering[index] = new IndexColumnOrder(rc != null ? rc.getVirtualColumnId() - 1 : rclistRC.getVirtualColumnId() - 1);
            ++index;
        }
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("DistinctQueryInfo column ordering size " + this.ordering.length));
        }
    }

    @Override
    public ColumnOrdering[] getColumnOrdering() {
        return this.ordering;
    }

    @Override
    public ExecRow getInComingProjectionExecRow() {
        return this.expectedRemoteExecRow;
    }

    @Override
    public final RowFormatter getRowFormatter() {
        return this.rowFormatter;
    }

    @Override
    public int[] getProjectMapping() {
        return this.projectMapping;
    }
}

