/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractConditionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.BooleanConstantQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ColumnQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.InsertQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.NcjHashMapWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SubQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.TableQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.compile.CollectParameterNodeVisitor;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AndNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BooleanConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.HalfOuterJoinNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.HashTableNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.IndexToBaseRowNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.IsNullNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JoinNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.LikeEscapeOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrListNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Predicate;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ProjectRestrictNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;

public abstract class DMLQueryInfo
extends AbstractQueryInfo
implements Visitor {
    private static boolean TEST_FLAG_IGNORE_SINGLE_VM_CRITERIA = false;
    protected int queryType = 0;
    private AbstractConditionQueryInfo whereClause;
    final ArrayList<TableQueryInfo> tableQueryInfoList = new ArrayList(4);
    final ArrayList<GemFireContainer> containerList = new ArrayList(4);
    private int currJunctionType = -1;
    private Object pk;
    private Object localIndexKey = null;
    private ConglomerateDescriptor chosenLocalIndexDescriptor = null;
    final QueryInfoContext qic;
    private int colocMatrixRows;
    private final ArrayList<TableQueryInfo> colocMatrixTables = new ArrayList();
    private int colocMatrixPRTableCount;
    final List<PredicateList> wherePredicateList = new ArrayList<PredicateList>(5);
    private int evaluateResultColumnList = 0;
    protected boolean isOuterJoin = false;
    protected final List<Region> logicalLeftTableList = new ArrayList<Region>();
    protected final List<Region> logicalRightTableList = new ArrayList<Region>();
    private final List<SubQueryInfo> subqueries = new ArrayList<SubQueryInfo>(2);
    private final List<SubqueryList> whereClauseSubqueries = new ArrayList<SubqueryList>(2);
    protected boolean isSpecialCaseOFOuterJoins;
    private int prTableCount;
    boolean needGfxdSubactivation = false;
    private TableQueryInfo driverTqi = UNINITIALIZED;
    static byte DEFAULT_DML_SECTION = 0;
    static byte WHERE_DML_SECTION = 1;
    private THashMap ncjMetaData = null;
    boolean isConsecutivePRNs = false;
    private boolean insertAsSubSelect;
    private String targetTableName;
    private int setOperatorCount = 0;
    private boolean hasUnionNode = false;
    private String nameOfIntersectOrExceptOperator = null;
    protected Set<PartitionedRegion> otherPartitionRegions;

    DMLQueryInfo(QueryInfoContext qic) throws StandardException {
        this.qic = qic;
        qic.pushScope(this);
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        FromBaseTable fbtNode = null;
        if (node instanceof AndNode) {
            this.handleAndNode((AndNode)node);
        } else if (node instanceof FromBaseTable) {
            fbtNode = (FromBaseTable)node;
            if (fbtNode.getTrulyTheBestAccessPath() != null && !fbtNode.considerSortAvoidancePath()) {
                this.setChosenLocalIndex(fbtNode);
            }
        } else if (node instanceof IndexToBaseRowNode) {
            fbtNode = ((IndexToBaseRowNode)node).getSource();
            if (fbtNode.getTrulyTheBestAccessPath() != null) {
                this.setChosenLocalIndex(fbtNode);
            }
        } else if (node instanceof ProjectRestrictNode) {
            this.handleProjectRestrictNode((ProjectRestrictNode)node);
        } else if (node instanceof TableOperatorNode) {
            TableOperatorNode tabOpNode = (TableOperatorNode)node;
            ArrayList<TableQueryInfo> origTQIList = new ArrayList<TableQueryInfo>(this.tableQueryInfoList);
            if (tabOpNode instanceof JoinNode) {
                this.handleJoinNode((JoinNode)tabOpNode);
            }
            ResultSetNode leftChild = tabOpNode.getLeftResultSet();
            ResultSetNode rightChild = tabOpNode.getRightResultSet();
            if (leftChild != null) {
                this.visit(leftChild);
            }
            if (rightChild != null) {
                this.visit(rightChild);
            }
            int tableNum = tabOpNode.getTableNumber();
            this.addDriverTableForColumns(tableNum, origTQIList);
        } else if (node instanceof SubqueryNode) {
            this.handleSubqueryNode((SubqueryNode)node);
        } else if (node instanceof HashTableNode) {
            SubqueryList subqueryList;
            PredicateList predList;
            HashTableNode hashNode = (HashTableNode)node;
            ArrayList<TableQueryInfo> origTQIList = new ArrayList<TableQueryInfo>(this.tableQueryInfoList);
            ResultSetNode child = hashNode.getChildResult();
            if (child != null) {
                this.visit(child);
            }
            if ((predList = hashNode.getJoinPredicateList()) != null && predList.size() > 0) {
                this.wherePredicateList.add(predList);
            }
            if ((predList = hashNode.getSearchPredicateList()) != null && predList.size() > 0) {
                this.wherePredicateList.add(predList);
            }
            if ((subqueryList = hashNode.getPSubqueryList()) != null && subqueryList.size() > 0) {
                this.whereClauseSubqueries.add(subqueryList);
            }
            if ((subqueryList = hashNode.getRSubqueryList()) != null && subqueryList.size() > 0) {
                this.whereClauseSubqueries.add(subqueryList);
            }
            int tableNum = hashNode.getTableNumber();
            this.addDriverTableForColumns(tableNum, origTQIList);
        }
        if (fbtNode != null) {
            this.handleFromBaseTableNode(fbtNode);
            PredicateList temp = fbtNode.storeRestrictionList;
            if (temp != null && temp.size() > 0) {
                this.wherePredicateList.add(temp);
            }
            if ((temp = fbtNode.nonStoreRestrictionList) != null && temp.size() > 0) {
                this.wherePredicateList.add(temp);
            }
        }
        return node;
    }

    @Override
    public boolean supportsDeltaMerge() {
        return false;
    }

    @Override
    public boolean initForDeltaState() {
        return false;
    }

    @Override
    public Object getAndResetDeltaState() {
        throw new InternalGemFireError("unexpected invocation");
    }

    @Override
    public Visitable mergeDeltaState(Object delta, Visitable node) {
        throw new InternalGemFireError("unexpected invocation");
    }

    int processResultColumnListFromProjectRestrictNodeAtLevel() {
        return -1;
    }

    public void init() throws StandardException {
        block5: {
            this.prTableCount = this.qic.getPRTableCount();
            Iterator<PredicateList> itr1 = this.wherePredicateList.iterator();
            this.qic.setQuerySectionUnderAnalysis(WHERE_DML_SECTION);
            while (itr1.hasNext()) {
                PredicateList predList = itr1.next();
                this.handlePredicateList(predList);
                itr1.remove();
            }
            this.qic.setQuerySectionUnderAnalysis(DEFAULT_DML_SECTION);
            if (this.tableQueryInfoList.size() == 1) {
                TableQueryInfo driverTable = this.tableQueryInfoList.get(0);
                this.setDriverTableQueryInfo(driverTable);
                this.processSubqueries();
            } else {
                boolean isNCJoinSupportedOnQN = this.isNCJoinSupportedOnQN(this.qic.getPRTableCount());
                AbstractConditionQueryInfo whereClause = this.getWhereClause();
                try {
                    TableQueryInfo driverTable = DMLQueryInfo.identifyDriverTableQueryInfo(this.tableQueryInfoList, this.qic, whereClause, this.hasUnionNode() || this.hasIntersectOrExceptNode());
                    this.setDriverTableQueryInfo(driverTable);
                    this.processSubqueries();
                }
                catch (StandardException ncException) {
                    if (isNCJoinSupportedOnQN && (!isNCJoinSupportedOnQN || this.ncjSetDriverTable(whereClause))) break block5;
                    throw StandardException.plainWrapException(ncException);
                }
            }
        }
    }

    void handleProjectRestrictNode(ProjectRestrictNode prn) throws StandardException {
        if (prn.restrictionList != null && prn.restrictionList.size() > 0) {
            this.wherePredicateList.add(prn.restrictionList);
        }
        this.collectSubqueries(prn);
        this.processProjectRestrictNode(prn);
    }

    void processProjectRestrictNode(ProjectRestrictNode prn) throws StandardException {
        ++this.evaluateResultColumnList;
        ResultSetNode child = prn.getChildResult();
        if (!this.isConsecutivePRNs) {
            this.qic.setParentPRN(prn);
        }
        this.isConsecutivePRNs = child instanceof ProjectRestrictNode;
        this.visit(child);
        --this.evaluateResultColumnList;
        if (this.evaluateResultColumnList == this.processResultColumnListFromProjectRestrictNodeAtLevel()) {
            ResultColumnList rcl = prn.getResultColumns();
            rcl.accept(this);
            if (this.isSelect()) {
                CollectParameterNodeVisitor collectParams = new CollectParameterNodeVisitor(this.qic);
                int size = rcl.size();
                for (int i = 0; i < size; ++i) {
                    ValueNode expr;
                    ResultColumn rc = rcl.getResultColumn(i + 1);
                    if (rc == null || (expr = rc.getExpression()) == null) continue;
                    expr.accept(collectParams);
                }
            }
        }
    }

    void collectSubqueries(ProjectRestrictNode prn) throws StandardException {
        if (prn.restrictSubquerys != null && prn.restrictSubquerys.size() > 0) {
            this.whereClauseSubqueries.add(prn.restrictSubquerys);
            this.queryType = GemFireXDUtils.set(this.queryType, 8192);
        }
    }

    @Override
    public void computeNodes(Set<Object> routingKeysToExecute, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
        assert (routingKeysToExecute.size() == 1);
        assert (routingKeysToExecute.contains(ResolverUtils.TOK_ALL_NODES));
        if (this.isSelect() || this.isDelete() || this.isUpdate()) {
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("DMLQueryInfo::computeNodes: Starting number of nodes = " + routingKeysToExecute.size()));
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("DMLQueryInfo::computeNodes: The starting nodes are  = " + routingKeysToExecute));
            }
            if (this.whereClause != null) {
                this.whereClause.computeNodes(routingKeysToExecute, activation, forSingleHopPreparePhase);
                if (routingKeysToExecute.contains(ResolverUtils.TOK_ALL_NODES)) {
                    if (!forSingleHopPreparePhase) {
                        assert (routingKeysToExecute.size() == 1);
                    } else {
                        routingKeysToExecute.clear();
                    }
                } else if (this.hasUnionNode() || this.hasIntersectOrExceptNode()) {
                    routingKeysToExecute.clear();
                    routingKeysToExecute.add(ResolverUtils.TOK_ALL_NODES);
                    if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                        SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"DMLQueryInfo::computeNodes: Node prunning has been rendered ineffective - Set Operators ");
                    }
                } else if (this.isNCJoinOnQN()) {
                    if (routingKeysToExecute.isEmpty()) {
                        routingKeysToExecute.add(ResolverUtils.TOK_ALL_NODES);
                        if (GemFireXDUtils.TraceNCJ) {
                            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"DMLQueryInfo::computeNodes: Node prunning has been rendered ineffective - NCJ ");
                        }
                    } else {
                        routingKeysToExecute.clear();
                        routingKeysToExecute.add(ResolverUtils.TOK_ALL_NODES);
                    }
                }
            }
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("DMLQueryInfo::computeNodes: Prunned number of nodes = " + routingKeysToExecute.size()));
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("DMLQueryInfo::computeNodes: The prunned nodes are  = " + routingKeysToExecute));
            }
        } else {
            if (!this.getRegion().getAttributes().getDataPolicy().withStorage()) {
                return;
            }
            throw new UnsupportedOperationException("computeNodes implemented only for Select/Update/Delete");
        }
    }

    @Override
    public final boolean isPrimaryKeyBased() {
        return GemFireXDUtils.isSet(this.queryType, 4);
    }

    public final boolean isGetAllOnLocalIndex() {
        return GemFireXDUtils.isSet(this.queryType, 4096);
    }

    public final boolean isNCJoinOnQN() {
        return this.ncjMetaData != null;
    }

    public THashMap getNCJMetaData() {
        return this.ncjMetaData;
    }

    @Override
    public boolean isSelectForUpdateQuery() {
        return GemFireXDUtils.isSet(this.queryType, 512);
    }

    @Override
    public boolean needKeysForSelectForUpdate() {
        return false;
    }

    @Override
    public String getTableName() {
        if (this.isTableVTI()) {
            return this.qic.virtualTable();
        }
        return this.tableQueryInfoList.get(0).getTableName();
    }

    @Override
    public String getFullTableName() {
        if (this.isTableVTI()) {
            return this.qic.virtualTable();
        }
        return this.tableQueryInfoList.get(0).getFullTableName();
    }

    @Override
    public String getSchemaName() {
        return this.tableQueryInfoList.get(0).getSchemaName();
    }

    final void handleFromBaseTableNode(FromBaseTable fbtNode) throws StandardException {
        TableQueryInfo tqi = (TableQueryInfo)fbtNode.computeQueryInfo(this.qic);
        this.updateColocationMatrixData(tqi);
        this.containerList.add((GemFireContainer)tqi.getRegion().getUserAttribute());
        this.addTableQueryInfoToList(tqi, tqi.getTableNumber());
        this.handleFromBaseTableNode(fbtNode, true);
    }

    final int numTablesInTableQueryInfoList() {
        int count = 0;
        for (TableQueryInfo o : this.tableQueryInfoList) {
            if (o == null) continue;
            ++count;
        }
        return count;
    }

    final void addTableQueryInfoToList(TableQueryInfo tqi, int tableNum) {
        if (tableNum < this.tableQueryInfoList.size()) {
            TableQueryInfo prev = this.tableQueryInfoList.set(tableNum, tqi);
            if (!this.hasUnionNode() && !this.hasIntersectOrExceptNode()) assert (prev == null);
        } else {
            for (int i = this.tableQueryInfoList.size(); i < tableNum; ++i) {
                this.tableQueryInfoList.add(null);
            }
            this.tableQueryInfoList.add(tqi);
        }
    }

    final void addDriverTableForColumns(int tableNum, ArrayList<TableQueryInfo> origTQIList) {
        if (tableNum >= 0) {
            TableQueryInfo driverTQI = null;
            Iterator<TableQueryInfo> newIter = this.tableQueryInfoList.iterator();
            Iterator<TableQueryInfo> iter = origTQIList.iterator();
            while (newIter.hasNext()) {
                TableQueryInfo tqi = null;
                TableQueryInfo newTQI = newIter.next();
                if (iter.hasNext()) {
                    tqi = iter.next();
                }
                if (tqi != null || newTQI == null) continue;
                if (newTQI.isPartitionedRegion()) {
                    driverTQI = newTQI;
                    break;
                }
                if (driverTQI != null) continue;
                driverTQI = newTQI;
            }
            if (driverTQI != null) {
                this.addTableQueryInfoToList(driverTQI, tableNum);
            }
        }
    }

    void updateColocationMatrixData(TableQueryInfo tqi) {
        int partCol = tqi.getPartitioningColumnCount();
        this.colocMatrixTables.add(tqi);
        if (partCol > 0) {
            if (this.colocMatrixRows == 0) {
                this.colocMatrixRows = partCol;
            }
            ++this.colocMatrixPRTableCount;
        }
    }

    void handleFromBaseTableNode(FromBaseTable fbtNode, boolean postParentClassHandling) throws StandardException {
    }

    void handlePredicateList(PredicateList predicateList) throws StandardException {
        predicateList.accept(this);
        for (Predicate predicate : predicateList.redundantPredicates) {
            predicate.accept(this);
        }
    }

    void handleAndNode(AndNode andNode) throws StandardException {
        IsNullNode isNullNode;
        ValueNode vn;
        boolean isLeftRR = false;
        boolean isRightPR = false;
        boolean hasPR = false;
        for (LocalRegion localRegion : this.logicalLeftTableList) {
            if (localRegion.getPartitionAttributes() != null) continue;
            isLeftRR = true;
            break;
        }
        for (LocalRegion localRegion : this.logicalRightTableList) {
            if (localRegion.getPartitionAttributes() == null) continue;
            isRightPR = true;
            break;
        }
        if (isLeftRR && isRightPR && andNode.leftOperand instanceof IsNullNode && (vn = (isNullNode = (IsNullNode)andNode.leftOperand).getOperand()) instanceof ColumnReference) {
            throw StandardException.newException("0A000.S", "Outer join with IS NULL is not supported.");
        }
        AbstractConditionQueryInfo abstractConditionQueryInfo = this.processJunctionNode(andNode, 1, true);
        this.whereClause = this.whereClause != null ? this.whereClause.mergeOperand(abstractConditionQueryInfo, 1, true) : abstractConditionQueryInfo;
    }

    private void handleJoinNode(JoinNode joinNode) throws StandardException {
        if (joinNode instanceof HalfOuterJoinNode) {
            Region rRegion;
            HalfOuterJoinNode ojNode = (HalfOuterJoinNode)joinNode;
            this.isOuterJoin = true;
            String logicalLeftTableName = ojNode.getLogicalLeftTableName();
            if (logicalLeftTableName != null) {
                Region lregion = Misc.getRegionForTableByPath(logicalLeftTableName, false);
                if (lregion != null) {
                    Region rregion;
                    if (GemFireXDUtils.TraceOuterJoin) {
                        SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("DMLQueryInfo::handleJoinNodeltable name being added to list of logical left tables is: " + logicalLeftTableName));
                    }
                    this.logicalLeftTableList.add(lregion);
                    if (ojNode.getRightHalfOuterJoinNode() != null) {
                        this.handleJoinNode(ojNode.getRightHalfOuterJoinNode());
                    }
                    String rightTableName = null;
                    rightTableName = ojNode.getLogicalRightTableName();
                    if (rightTableName != null && (rregion = Misc.getRegionForTableByPath(rightTableName, false)) != null) {
                        if (GemFireXDUtils.TraceOuterJoin) {
                            SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("DMLQueryInfo::handleJoinNodertable name being added to list of logical left tables is: " + rightTableName));
                        }
                        this.logicalLeftTableList.add(rregion);
                    }
                } else {
                    if (GemFireXDUtils.TraceOuterJoin) {
                        SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("DMLQueryInfo::handleJoinNodeall logical left table names of node: " + ojNode + " being added"));
                    }
                    ojNode.addAllLogicalLeftTableNamesToList(this.logicalLeftTableList);
                }
            } else {
                HalfOuterJoinNode rightHalfNode;
                HalfOuterJoinNode leftHalfNode = ojNode.getLeftHalfOuterJoinNode();
                if (leftHalfNode != null) {
                    leftHalfNode.addAllLogicalLeftTableNamesToList(this.logicalLeftTableList);
                }
                if ((rightHalfNode = ojNode.getRightHalfOuterJoinNode()) != null) {
                    rightHalfNode.addAllLogicalLeftTableNamesToList(this.logicalLeftTableList);
                }
            }
            String logicalRightTableName = ojNode.getLogicalRightTableName();
            if (logicalRightTableName != null && (rRegion = Misc.getRegionForTable(logicalRightTableName, false)) != null) {
                if (GemFireXDUtils.TraceOuterJoin) {
                    SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("DMLQueryInfo::handleJoinNodetable name being added to list of logical right tables is: " + logicalRightTableName));
                }
                this.logicalRightTableList.add(rRegion);
            }
        }
    }

    private void handleSubqueryNode(SubqueryNode sqn) throws StandardException {
        if (sqn.hasCorrelatedCRsFromOuterScope()) {
            this.queryType = GemFireXDUtils.set(this.queryType, 64);
        }
    }

    private AbstractConditionQueryInfo processJunctionNode(BinaryOperatorNode bon, int junctionType, boolean isTopLevel) throws StandardException {
        this.currJunctionType = junctionType;
        AbstractConditionQueryInfo lhs = this.generateQueryInfo(bon.leftOperand);
        this.currJunctionType = junctionType;
        AbstractConditionQueryInfo rhs = this.generateQueryInfo(bon.rightOperand);
        if (lhs != null) {
            lhs.seedColocationMatrixData(this.colocMatrixRows, this.colocMatrixTables, this.colocMatrixPRTableCount);
        }
        if (rhs != null) {
            rhs.seedColocationMatrixData(this.colocMatrixRows, this.colocMatrixTables, this.colocMatrixPRTableCount);
        }
        if (lhs != null) {
            return lhs.mergeOperand(rhs, junctionType, isTopLevel);
        }
        return rhs;
    }

    /*
     * Enabled aggressive block sorting
     */
    private AbstractConditionQueryInfo generateQueryInfo(QueryTreeNode node) throws StandardException {
        if (node instanceof OrListNode) {
            node = ((OrListNode)node).getOrNode(0);
        }
        if (node instanceof AndNode) {
            return this.processJunctionNode((BinaryOperatorNode)node, 1, false);
        }
        if (node instanceof OrNode) {
            return this.processJunctionNode((BinaryOperatorNode)node, 2, false);
        }
        if (node instanceof BooleanConstantNode) {
            return this.processBooleanConstantNode((BooleanConstantNode)node);
        }
        QueryInfo temp = node.computeQueryInfo(this.qic);
        if (temp instanceof ColumnQueryInfo) {
            assert (((ColumnQueryInfo)temp).columnDescriptor.getType().getTypeId().equals(TypeId.BOOLEAN_ID));
            temp = null;
            return (AbstractConditionQueryInfo)temp;
        }
        if (temp == QueryInfoConstants.DUMMY && node instanceof SubqueryNode) {
            temp = null;
            return (AbstractConditionQueryInfo)temp;
        }
        if (temp != null && !(temp instanceof AbstractConditionQueryInfo)) {
            if (temp == QueryInfoConstants.DUMMY && (node instanceof BinaryOperatorNode || node instanceof UnaryOperatorNode)) {
                temp = null;
                return (AbstractConditionQueryInfo)temp;
            }
            if (!GemFireXDUtils.isSet(this.queryType, 2048)) throw StandardException.newException("42Y94", new IllegalStateException("Handle the node to have right computeQueryInfo method. The problematic node type is " + node.getClass()));
            throw StandardException.newException("42Y12");
        }
        if (temp != null) return (AbstractConditionQueryInfo)temp;
        if (!(node instanceof LikeEscapeOperatorNode)) return (AbstractConditionQueryInfo)temp;
        this.queryType = GemFireXDUtils.set(this.queryType, 8192);
        return (AbstractConditionQueryInfo)temp;
    }

    private BooleanConstantQueryInfo processBooleanConstantNode(BooleanConstantNode bcn) {
        if (this.currJunctionType == 1 && bcn.isBooleanTrue() || this.currJunctionType == 2 && bcn.isBooleanFalse()) {
            return null;
        }
        return new BooleanConstantQueryInfo(bcn.isBooleanTrue());
    }

    boolean isWhereClauseSatisfactory(TableQueryInfo tqi) throws StandardException {
        if (DMLQueryInfo.disableGetConvertible()) {
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"DMLQueryInfo.isWhereClauseSatisfactory: GetConvertible Queries Disabled");
            }
            return false;
        }
        boolean isOk = false;
        if (this.whereClause != null) {
            if (tqi.isPrimaryKeyBased()) {
                int[][] pkColumn = tqi.getPrimaryKeyColumns();
                this.pk = this.whereClause.isConvertibleToGet(pkColumn, tqi);
                if (GemFireXDUtils.isSet(this.queryType, 8192)) {
                    this.pk = null;
                    if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                        SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"DMLQueryInfo.isWhereClauseSatisfactory: markNotGetConvertible");
                    }
                }
                boolean bl = isOk = this.pk != null;
            }
            if (!isOk) {
                LocalRegion region = tqi.getRegion();
                boolean hasLoader = ((GemFireContainer)region.getUserAttribute()).getHasLoaderAnywhere();
                String indexRegion = null;
                if (this.chosenLocalIndexDescriptor != null && tqi.isPartitionedRegion() && !hasLoader && !DMLQueryInfo.disableGetAll_LocalIndex()) {
                    IndexRowGenerator id = this.chosenLocalIndexDescriptor.getIndexDescriptor();
                    int[] baseColPos = id.baseColumnPositions();
                    int[][] idxColumns = TableQueryInfo.getIndexKeyColumns(baseColPos);
                    GemFireContainer indexContainer = Misc.getMemStore().getContainer(ContainerKey.valueOf(0L, this.chosenLocalIndexDescriptor.getConglomerateNumber()));
                    indexRegion = indexContainer.getQualifiedTableName();
                    Object idxKey = this.whereClause.isConvertibleToGetOnLocalIndex(idxColumns, tqi);
                    if (idxKey != null && !GemFireXDUtils.isSet(this.queryType, 8192)) {
                        this.localIndexKey = idxKey;
                    }
                }
                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("DMLQueryInfo.isWhereClauseSatisfactory: Evaluate GetAll on Local Index [index-name= " + (this.chosenLocalIndexDescriptor != null ? this.chosenLocalIndexDescriptor.getConglomerateName() : "null") + " ,index-key= " + (this.localIndexKey != null ? this.localIndexKey : "null") + "], region=" + region.getDisplayName() + " ,isPartitioned=" + tqi.isPartitionedRegion() + "], index-region=" + indexRegion + " ,hasLoader=" + hasLoader + " ,force-Ignore-GetAllLocalIndex=" + DMLQueryInfo.disableGetAll_LocalIndex() + " ,markNotGetConvertible=" + GemFireXDUtils.isSet(this.queryType, 8192)));
                }
            }
        }
        return isOk;
    }

    public ConglomerateDescriptor getChosenLocalIndex() {
        return this.chosenLocalIndexDescriptor;
    }

    private void setChosenLocalIndex(FromBaseTable fbtNode) {
        IndexRowGenerator id;
        ConglomerateDescriptor cd = fbtNode.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        if ((cd.isIndex() || cd.isConstraint()) && (id = cd.getIndexDescriptor()).indexType().equals("LOCALSORTEDMAP")) {
            this.chosenLocalIndexDescriptor = cd;
        }
    }

    public TableQueryInfo getTableQueryInfo(int index) {
        return index < this.tableQueryInfoList.size() ? this.tableQueryInfoList.get(index) : null;
    }

    public boolean isCustomEvictionEnabled() {
        return this.getRegion().getDataPolicy().withHDFS() && this.getRegion().getAttributes().getCustomEvictionAttributes() != null;
    }

    public final List<TableQueryInfo> getTableQueryInfoList() {
        return Collections.unmodifiableList(this.tableQueryInfoList);
    }

    public final List<GemFireContainer> getContainerList() {
        return this.containerList;
    }

    @Override
    public final boolean isQuery(int flags) {
        return (this.queryType & flags) == flags;
    }

    @Override
    public final boolean isQuery(int ... flags) {
        for (int i = 0; i < flags.length; ++i) {
            if ((this.queryType & flags[i]) != flags[i]) continue;
            return true;
        }
        return false;
    }

    final AbstractConditionQueryInfo getWhereClause() {
        return this.whereClause;
    }

    @Override
    public boolean isDynamic() {
        return this.qic.getParamerCount() > 0;
    }

    public boolean isWhereClauseDynamic() {
        return this.whereClause.isWhereClauseDynamic();
    }

    @Override
    public int getParameterCount() {
        return this.qic.getParamerCount();
    }

    @Override
    public Object getPrimaryKey() {
        return this.pk;
    }

    @Override
    public Object getLocalIndexKey() {
        return this.localIndexKey;
    }

    @Override
    public boolean isSelect() {
        return false;
    }

    @Override
    public boolean optimizeForWrite() {
        return true;
    }

    @Override
    public boolean withSecondaries() {
        return false;
    }

    @Override
    public boolean isUpdate() {
        return false;
    }

    @Override
    public boolean isDelete() {
        return false;
    }

    @Override
    public boolean isDeleteWithReferencedKeys() {
        return false;
    }

    @Override
    public boolean isInsert() {
        return false;
    }

    @Override
    public final boolean createGFEActivation() throws StandardException {
        boolean createQueryInfo = this.qic.createQueryInfo();
        boolean isUpdate = this.isUpdate();
        if (GemFireXDUtils.TraceActivation) {
            SanityManager.DEBUG_PRINT((String)"TraceActivation", (String)("GenericStatement::createGFEActivation createQueryInfo : " + createQueryInfo + " isSelect " + this.isSelect() + " isUpdate " + isUpdate));
        }
        if (!createQueryInfo) {
            return false;
        }
        if (!(this.isSelect() || isUpdate || this.isInsert() || this.isDelete())) {
            return false;
        }
        if (this.isInsert() && !((InsertQueryInfo)this).isInsertAsSubSelect()) {
            return false;
        }
        boolean isTableVTIDistributable = this.routeQueryToAllNodes();
        if (isTableVTIDistributable && isUpdate) {
            return false;
        }
        if (this.isPrimaryKeyBased()) {
            return !GemFireXDUtils.isSet(this.queryType, 32);
        }
        InternalDistributedSystem dsys = Misc.getDistributedSystem();
        if (!dsys.isLoner() && this.isGetAllOnLocalIndex()) {
            return !GemFireXDUtils.isSet(this.queryType, 32);
        }
        if (isTableVTIDistributable) {
            return true;
        }
        LocalRegion rgn = this.getRegion();
        if (rgn == null) {
            return false;
        }
        RegionAttributes ra = rgn.getAttributes();
        DataPolicy policy = ra.getDataPolicy();
        if (GemFireXDUtils.TraceActivation) {
            SanityManager.DEBUG_PRINT((String)"TraceActivation", (String)("DMLQueryInfo#createGFEActivation:: region: " + rgn.getName() + " region's DataPolicy: " + policy + " region's Scope: " + ra.getScope() + " isLoner: " + dsys.isLoner() + " mcast-port: " + dsys.getConfig().getMcastPort() + " locators: " + dsys.getConfig().getLocators()));
        }
        return !dsys.isLoner() && !ra.getScope().isLocal() && (policy.withPartitioning() || !policy.withStorage() || this.isDeleteWithReferencedKeys() || this.isSelectForUpdateQuery()) || DMLQueryInfo.getTestFlagIgnoreSingleVMCriteria() && !policy.withReplication() && !ra.getScope().isLocal();
    }

    public void addSubQueryInfo(SubQueryInfo subq) {
        this.subqueries.add(subq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processSubqueries() throws StandardException {
        for (SubqueryList list : this.whereClauseSubqueries) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                SubqueryNode sqn = (SubqueryNode)list.elementAt(i);
                boolean hasDependent = sqn.hasCorrelatedCRsFromOuterScope();
                SubQueryInfo sqi = new SubQueryInfo(this.qic, sqn.getSubqueryString(), hasDependent);
                try {
                    sqn.getResultSet().accept(sqi);
                    sqi.init();
                    continue;
                }
                finally {
                    this.qic.cleanUp();
                    this.qic.popScope();
                }
            }
        }
        if (this.subqueries.size() > 0) {
            for (SubQueryInfo sqi : this.subqueries) {
                this.needGfxdSubactivation = this.needGfxdSubactivation || sqi.needGfxdSubactivation;
            }
        }
    }

    public List<SubQueryInfo> getSubqueryInfoList() {
        return Collections.unmodifiableList(this.subqueries);
    }

    private static TableQueryInfo identifyDriverTableQueryInfo(List<TableQueryInfo> tableQueryInfoList, QueryInfoContext qic, AbstractConditionQueryInfo whereClause, boolean hasSetOperatorClause) throws StandardException {
        int prTableCount = qic.getPRTableCount();
        TableQueryInfo tqi2 = null;
        boolean isCaseOfSingleNode = false;
        TableQueryInfo driverTqi = null;
        String masterTable = null;
        SortedSet<String> serverGroups = null;
        TableQueryInfo sgMasterTable = null;
        TableQueryInfo prTqi = null;
        Iterator<TableQueryInfo> itr = null;
        for (TableQueryInfo tqi2 : tableQueryInfoList) {
            if (tqi2 == null) continue;
            if (prTqi != null && hasSetOperatorClause) break;
            if (tqi2.isPartitionedRegion()) {
                if (prTableCount > 1) {
                    boolean singleVMCase;
                    boolean bl = singleVMCase = DMLQueryInfo.isSingleVMCase() || qic.isColocationCheckDisabled();
                    if (isCaseOfSingleNode) {
                        if (!singleVMCase) {
                            throw StandardException.newException("0A000.S.11");
                        }
                    } else if (singleVMCase && masterTable == null) {
                        isCaseOfSingleNode = true;
                    } else {
                        if (masterTable == null) {
                            masterTable = tqi2.getMasterTableName();
                        }
                        if (masterTable == null || !masterTable.equalsIgnoreCase(tqi2.getMasterTableName())) {
                            if (masterTable == null) {
                                throw StandardException.newException("0A000.S.8", tqi2.getFullTableName());
                            }
                            if (!qic.isColocationCheckDisabled()) {
                                throw StandardException.newException("0A000.S.9", (Object)tqi2.getFullTableName(), (Object)Misc.getFullTableNameFromRegionPath(masterTable));
                            }
                        }
                    }
                }
                prTqi = tqi2;
                continue;
            }
            SortedSet<String> currSGs = DMLQueryInfo.getServerGroups(tqi2);
            if (serverGroups == null) {
                serverGroups = currSGs;
                sgMasterTable = tqi2;
                continue;
            }
            int cmp = GemFireXDUtils.setCompare(serverGroups, currSGs);
            if (cmp < -1) {
                throw StandardException.newException("0A000.S.9", (Object)(tqi2.getFullTableName() + "[server groups:" + SharedUtils.toCSV(currSGs) + "]"), (Object)(sgMasterTable.getFullTableName() + "[server groups:" + SharedUtils.toCSV(serverGroups) + "]"));
            }
            if (cmp != 1) continue;
            serverGroups = currSGs;
            sgMasterTable = tqi2;
        }
        if (serverGroups == null) {
            if (prTqi != null) {
                driverTqi = prTqi;
            }
        } else if (prTqi != null) {
            if (serverGroups != GemFireXDUtils.SET_MAX) {
                SortedSet<String> currSGs = null;
                for (TableQueryInfo tqi2 : tableQueryInfoList) {
                    if (tqi2 == null || !tqi2.isPartitionedRegion() || GemFireXDUtils.setCompare(serverGroups, currSGs = DMLQueryInfo.getServerGroups(tqi2)) < 0) continue;
                    driverTqi = tqi2;
                    break;
                }
                if (driverTqi == null) {
                    currSGs = DMLQueryInfo.getServerGroups(prTqi);
                    throw StandardException.newException("0A000.S.9", (Object)(prTqi.getFullTableName() + "[server groups:" + SharedUtils.toCSV(currSGs) + "]"), (Object)(sgMasterTable.getFullTableName() + "[server groups:" + SharedUtils.toCSV(serverGroups) + "]"));
                }
            } else {
                driverTqi = prTqi;
            }
        } else if (sgMasterTable != null) {
            driverTqi = sgMasterTable;
        }
        if (prTableCount > 1 && !hasSetOperatorClause && !isCaseOfSingleNode) {
            if (whereClause == null) {
                throw StandardException.newException("0A000.S.10", "cross join attempted on multiple partitioned tables");
            }
            String reason = whereClause.isEquiJoinColocationCriteriaFullfilled(null);
            if (reason != null) {
                throw StandardException.newException("0A000.S.10", reason);
            }
        }
        return driverTqi;
    }

    static SortedSet<String> getServerGroups(TableQueryInfo tqi) throws StandardException {
        SortedSet<String> sgs = null;
        if (tqi == null) {
            return null;
        }
        DistributionDescriptor dd = tqi.getTableDescriptor().getDistributionDescriptor();
        if (dd != null) {
            sgs = dd.getServerGroups();
        }
        if (sgs == null || sgs.size() == 0) {
            return GemFireXDUtils.SET_MAX;
        }
        return sgs;
    }

    boolean hasCorrelatedSubQuery() {
        boolean found = false;
        for (SubQueryInfo sqi : this.subqueries) {
            if (!sqi.isCorrelated()) continue;
            found = true;
            break;
        }
        return found;
    }

    public LocalRegion getRegion() {
        if (this.driverTqi == UNINITIALIZED) {
            throw new AssertionError((Object)"SelectQueryInfo#getRegion: init not invoked!");
        }
        return this.driverTqi != null ? this.driverTqi.getRegion() : null;
    }

    TableQueryInfo getDriverTableQueryInfo() {
        if (this.driverTqi == UNINITIALIZED) {
            throw new AssertionError((Object)"SelectQueryInfo#getDriverTableQueryInfo: init not invoked!");
        }
        return this.driverTqi;
    }

    private void setDriverTableQueryInfo(TableQueryInfo tqi) {
        this.driverTqi = tqi;
        this.setOtherPRegions();
    }

    public boolean isDriverTableInitialized() {
        return this.driverTqi != UNINITIALIZED;
    }

    public static boolean isSingleVMCase() {
        InternalDistributedSystem dsys = Misc.getDistributedSystem();
        return dsys.isLoner() && !TEST_FLAG_IGNORE_SINGLE_VM_CRITERIA;
    }

    @Override
    public List<Region> getOuterJoinRegions() {
        return this.logicalLeftTableList;
    }

    @Override
    public boolean isOuterJoin() {
        return this.isOuterJoin;
    }

    @Override
    public void setOuterJoinSpecialCase() {
        this.isSpecialCaseOFOuterJoins = true;
    }

    @Override
    public boolean isOuterJoinSpecialCase() {
        return this.isSpecialCaseOFOuterJoins;
    }

    @Override
    public void setInsertAsSubSelect(boolean b, String targetTableName) {
        this.insertAsSubSelect = true;
        this.targetTableName = targetTableName;
        this.qic.setOptimizeForWrite(true);
    }

    @Override
    public boolean isInsertAsSubSelect() {
        return this.insertAsSubSelect;
    }

    @Override
    public String getTargetTableName() {
        return this.targetTableName;
    }

    int getPRTableCount() {
        return this.prTableCount;
    }

    public boolean isRemoteGfxdSubActivationNeeded() {
        return this.needGfxdSubactivation;
    }

    public boolean isSubQueryInfo() {
        return false;
    }

    public boolean isSubQuery() {
        return GemFireXDUtils.isSet(this.queryType, 1024);
    }

    public void setIsSubQueryFlag(boolean flag) {
        this.queryType = GemFireXDUtils.set(this.queryType, 1024, flag);
    }

    public boolean isNcjLevelTwoQueryWithVarIN() {
        return GemFireXDUtils.isSet(this.queryType, 16384);
    }

    public void setNcjLevelTwoQueryWithVarIN(boolean flag) {
        this.queryType = GemFireXDUtils.set(this.queryType, 16384, flag);
    }

    public boolean isPreparedStatementQuery() {
        return this.qic.isPreparedStatementQuery();
    }

    public boolean isSubqueryFlatteningAllowed() {
        return !GemFireXDUtils.isSet(this.queryType, 256);
    }

    public void disallowSubqueryFlattening() {
        this.queryType = GemFireXDUtils.set(this.queryType, 256);
    }

    public static void setTestFlagIgnoreSingleVMCriteria(boolean on) {
        TEST_FLAG_IGNORE_SINGLE_VM_CRITERIA = on;
    }

    static boolean getTestFlagIgnoreSingleVMCriteria() {
        return TEST_FLAG_IGNORE_SINGLE_VM_CRITERIA;
    }

    public static boolean disableGetConvertible() {
        String qt = PropertyUtil.findAndGetProperty(Misc.getMemStoreBooting().getProperties(), GfxdConstants.GFXD_DISABLE_GET_CONVERTIBLE, "disable-get-convertible");
        return qt != null && Boolean.parseBoolean(qt);
    }

    public static boolean disableGetAll_LocalIndex() {
        String qt = PropertyUtil.findAndGetProperty(Misc.getMemStoreBooting().getProperties(), GfxdConstants.GFXD_DISABLE_GETALL_LOCALINDEX, "disable-getall-local-index");
        return qt != null && Boolean.parseBoolean(qt);
    }

    public static boolean enableGetAll_LocalIndex_withEmbedGfe() {
        String qt = PropertyUtil.findAndGetProperty(Misc.getMemStoreBooting().getProperties(), GfxdConstants.GFXD_ENABLE_GETALL_LOCALINDEX_EMBED_GFE, "enable-getall-local-index-embed-gfe");
        return qt != null && Boolean.parseBoolean(qt);
    }

    @Override
    public boolean isDML() {
        return true;
    }

    public void verifySetOperationSupported() throws StandardException {
        if (this.setOperatorCount > 1 && this.driverTqi.isPartitionedRegion()) {
            throw StandardException.newException("0A000.S", " Currently nested Set operators are not supported in distributed scenario ");
        }
        if (this.isOuterJoinSpecialCase()) {
            throw StandardException.newException("0A000.S", " Currently Set operators are not supported with outer joins  especially in distributed scenario ");
        }
        if (this.isSubQuery()) {
            throw StandardException.newException("0A000.S", " Currently Set operators are not supported with SubQueries ");
        }
    }

    protected void setHasUnionNode() {
        this.hasUnionNode = true;
        ++this.setOperatorCount;
    }

    @Override
    public boolean hasUnionNode() {
        return this.hasUnionNode;
    }

    protected void setHasIntersectOrExceptNode(String opName) {
        this.nameOfIntersectOrExceptOperator = opName;
        ++this.setOperatorCount;
    }

    public String getNameOfIntersectOrExceptOperator() {
        return this.nameOfIntersectOrExceptOperator;
    }

    @Override
    public boolean hasIntersectOrExceptNode() {
        return this.nameOfIntersectOrExceptOperator != null;
    }

    public Set<PartitionedRegion> getOtherRegions() {
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ && this.otherPartitionRegions != null && !this.otherPartitionRegions.isEmpty()) {
            ArrayList<String> prs = new ArrayList<String>(this.otherPartitionRegions.size());
            for (PartitionedRegion pr : this.otherPartitionRegions) {
                prs.add(pr.getFullPath());
            }
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("DMLQueryInfo::getOtherRegions: " + prs));
        }
        return this.otherPartitionRegions;
    }

    private void setOtherPRegions() {
        if (GemFireXDUtils.TraceActivation) {
            SanityManager.DEBUG_PRINT((String)"TraceActivation", (String)"DMLQueryInfo::getOtherRegions: is Empty. List of partitions being initialized");
        }
        Iterator<TableQueryInfo> itr = this.tableQueryInfoList.iterator();
        HashSet<PartitionedRegion> otherPRs = new HashSet<PartitionedRegion>(this.tableQueryInfoList.size());
        TableQueryInfo tqi = null;
        while (itr.hasNext()) {
            tqi = itr.next();
            if (tqi == null || tqi == this.driverTqi || !tqi.isPartitionedRegion()) continue;
            otherPRs.add((PartitionedRegion)tqi.getRegion());
        }
        this.otherPartitionRegions = otherPRs.size() > 0 ? Collections.unmodifiableSet(otherPRs) : null;
    }

    public int getQueryFlag() {
        return this.queryType;
    }

    @Override
    public void throwExceptionForInvalidParameterizedData(int invalidParamNumber) throws StandardException {
        byte querySection = this.qic.getQuerySectionForParameter(invalidParamNumber);
        if (querySection == WHERE_DML_SECTION) {
            throw StandardException.newException("42818");
        }
        if (this.isInsert() || this.isUpdate()) {
            throw StandardException.newException("42821");
        }
        throw StandardException.newException("42818");
    }

    protected void setHasJoinNode() {
        this.queryType = GemFireXDUtils.set(this.queryType, 2048);
    }

    protected boolean hasJoinNode() {
        return GemFireXDUtils.isSet(this.queryType, 2048);
    }

    private boolean isNCJoinSupportedOnQN(int prTableCount) {
        boolean isNCJoinSupported = false;
        if (prTableCount > 1 && this.hasJoinNode() && Boolean.parseBoolean(PropertyUtil.getSystemProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false"))) {
            isNCJoinSupported = true;
        }
        if (this.isSubQuery()) {
            isNCJoinSupported = false;
        }
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("returning DMLQueryInfo:isNCJoinSupported=" + isNCJoinSupported + ", isSubQuery=" + this.isSubQuery()));
        }
        return isNCJoinSupported;
    }

    private boolean ncjSetDriverTable(AbstractConditionQueryInfo whereClause) throws StandardException {
        boolean invalidCase = false;
        boolean isSelfJoin = false;
        int prTabCount = 0;
        ArrayList<TableQueryInfo> tqiList = new ArrayList<TableQueryInfo>(NcjHashMapWrapper.getTotalTableAllowed());
        for (TableQueryInfo tqi : this.tableQueryInfoList) {
            if (tqi == null) continue;
            if (tqi.isPartitionedRegion()) {
                ++prTabCount;
            }
            if (!isSelfJoin && tqiList.contains(tqi)) {
                isSelfJoin = true;
            }
            tqiList.add(tqi);
        }
        if (prTabCount < 2) {
            invalidCase = true;
            if (GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("DMLQueryInfo::ncjSetDriverTable. No of PR tables is less than two. Marking invalid.  ,num-pr-tabs=" + prTabCount + " ,isSelfJoin=" + isSelfJoin + " ,total-tables=" + tqiList.size() + " ,tables=" + tqiList));
            }
        }
        if (!invalidCase && tqiList.size() > NcjHashMapWrapper.getTotalTableAllowed()) {
            invalidCase = true;
            if (GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("DMLQueryInfo::ncjSetDriverTable. No of tables is more than eight. Marking invalid.  ,num-pr-tabs=" + prTabCount + " ,isSelfJoin=" + isSelfJoin + " ,total-tables=" + tqiList.size() + " ,tables=" + tqiList));
            }
        }
        if (!invalidCase) {
            ArrayList<THashSet> colocationArr = this.qic.getTableColocationPrCorrName();
            SanityManager.ASSERT((colocationArr != null ? 1 : 0) != 0);
            SanityManager.ASSERT((colocationArr.size() > 0 ? 1 : 0) != 0);
            if (colocationArr.size() > NcjHashMapWrapper.getMaxTableAllowed()) {
                invalidCase = true;
                if (GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("DMLQueryInfo::ncjSetDriverTable. Marking invalid since more than four tables require network access. num-colocation-grp=" + colocationArr.size() + " colocation-grp=" + colocationArr + " ,num-pr-tabs=" + prTabCount + " ,total-tables=" + tqiList.size() + " ,isSelfJoin=" + isSelfJoin + " ,tables=" + tqiList));
                }
            }
            if (GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("DMLQueryInfo::ncjSetDriverTable.  num-colocation-grp=" + colocationArr.size() + " colocation-grp=" + colocationArr));
            }
        }
        if (!invalidCase) {
            if (GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("DMLQueryInfo::ncjSetDriverTable. Going to get driver table. Num-pr-tabs=" + prTabCount + " ,total-tables=" + tqiList.size() + " ,isSelfJoin=" + isSelfJoin + " ,tables=" + tqiList));
            }
            this.ncjMetaData = new THashMap();
            this.ncjSetDriverAndRemoteTables(tqiList);
        }
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("DMLQueryInfo::ncjSetDriverTable. Set driverTable=" + (this.isDriverTableInitialized() ? this.getDriverTableQueryInfo().getTableName() : "null")));
        }
        return this.isDriverTableInitialized();
    }

    private boolean ncjVerifyCollocatedTables(TableQueryInfo driverTqi, TableQueryInfo tqi) {
        if (driverTqi == null || tqi == null || driverTqi == tqi) {
            return false;
        }
        boolean retVal = false;
        FromBaseTable driverFbt = driverTqi.getTableNode();
        SanityManager.ASSERT((driverFbt != null ? 1 : 0) != 0, (String)"Must needed for self-join");
        String driverName = driverFbt.ncjGetCorrelationName();
        FromBaseTable fbt = tqi.getTableNode();
        SanityManager.ASSERT((fbt != null ? 1 : 0) != 0, (String)"Must needed for self-join");
        String tabName = fbt.ncjGetCorrelationName();
        ArrayList<THashSet> colocationArr = this.qic.getTableColocationPrCorrName();
        for (THashSet hashSet : colocationArr) {
            if (!hashSet.contains((Object)driverName) || !hashSet.contains((Object)tabName)) continue;
            retVal = true;
            break;
        }
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("DMLQueryInfo::ncjVerifyCollocatedTables. driverTqi=" + driverTqi.getTableName() + " ;master=" + driverTqi.getMasterTableName() + " ,tqi=" + tqi.getTableName() + " ;master=" + tqi.getMasterTableName() + " ,Colocation passed? " + retVal));
        }
        return retVal;
    }

    private String ncjGetCorrName(TableQueryInfo tqi) {
        FromBaseTable fbt = tqi.getTableNode();
        SanityManager.ASSERT((fbt != null ? 1 : 0) != 0);
        return fbt.ncjGetCorrelationName();
    }

    private TableQueryInfo ncjSetDriverOnFirstTwoTables(TableQueryInfo firstTqi, TableQueryInfo secondTqi, int driverPrId) {
        TableQueryInfo driverTqi = null;
        if (firstTqi.isPartitionedRegion() && secondTqi.isPartitionedRegion()) {
            int prIdOne = ((PartitionedRegion)firstTqi.getRegion()).getPRId();
            int prIdTwo = ((PartitionedRegion)secondTqi.getRegion()).getPRId();
            if (prIdOne == driverPrId || prIdTwo == driverPrId) {
                boolean areColocated = this.ncjVerifyCollocatedTables(firstTqi, secondTqi);
                if (areColocated) {
                    driverTqi = prIdOne == driverPrId ? firstTqi : secondTqi;
                    NcjHashMapWrapper.addTableAtFirstPosition(this.ncjMetaData, this.ncjGetCorrName(firstTqi), false, firstTqi);
                    NcjHashMapWrapper.addTableAtSecondPosition(this.ncjMetaData, this.ncjGetCorrName(secondTqi), false, secondTqi);
                } else if (prIdOne == driverPrId) {
                    driverTqi = firstTqi;
                    NcjHashMapWrapper.addTableAtFirstPosition(this.ncjMetaData, this.ncjGetCorrName(secondTqi), true, secondTqi);
                    NcjHashMapWrapper.addTableAtSecondPosition(this.ncjMetaData, this.ncjGetCorrName(firstTqi), false, firstTqi);
                } else {
                    driverTqi = secondTqi;
                    NcjHashMapWrapper.addTableAtFirstPosition(this.ncjMetaData, this.ncjGetCorrName(firstTqi), true, firstTqi);
                    NcjHashMapWrapper.addTableAtSecondPosition(this.ncjMetaData, this.ncjGetCorrName(secondTqi), false, secondTqi);
                }
            } else {
                NcjHashMapWrapper.addTableAtFirstPosition(this.ncjMetaData, this.ncjGetCorrName(firstTqi), true, firstTqi);
                NcjHashMapWrapper.addTableAtSecondPosition(this.ncjMetaData, this.ncjGetCorrName(secondTqi), true, secondTqi);
            }
        } else if (firstTqi.isPartitionedRegion()) {
            int prIdOne = ((PartitionedRegion)firstTqi.getRegion()).getPRId();
            if (prIdOne == driverPrId) {
                driverTqi = firstTqi;
                NcjHashMapWrapper.addTableAtFirstPosition(this.ncjMetaData, this.ncjGetCorrName(firstTqi), false, firstTqi);
                NcjHashMapWrapper.addTableAtSecondPosition(this.ncjMetaData, this.ncjGetCorrName(secondTqi), false, secondTqi);
            } else {
                NcjHashMapWrapper.addTableAtFirstPosition(this.ncjMetaData, this.ncjGetCorrName(firstTqi), true, firstTqi);
                NcjHashMapWrapper.addTableAtSecondPosition(this.ncjMetaData, this.ncjGetCorrName(secondTqi), false, secondTqi);
            }
        } else if (secondTqi.isPartitionedRegion()) {
            int prIdTwo = ((PartitionedRegion)secondTqi.getRegion()).getPRId();
            if (prIdTwo == driverPrId) {
                driverTqi = secondTqi;
                NcjHashMapWrapper.addTableAtFirstPosition(this.ncjMetaData, this.ncjGetCorrName(firstTqi), false, firstTqi);
                NcjHashMapWrapper.addTableAtSecondPosition(this.ncjMetaData, this.ncjGetCorrName(secondTqi), false, secondTqi);
            } else {
                NcjHashMapWrapper.addTableAtFirstPosition(this.ncjMetaData, this.ncjGetCorrName(secondTqi), true, secondTqi);
                NcjHashMapWrapper.addTableAtSecondPosition(this.ncjMetaData, this.ncjGetCorrName(firstTqi), false, firstTqi);
            }
        } else {
            NcjHashMapWrapper.addTableAtFirstPosition(this.ncjMetaData, this.ncjGetCorrName(firstTqi), false, firstTqi);
            NcjHashMapWrapper.addTableAtSecondPosition(this.ncjMetaData, this.ncjGetCorrName(secondTqi), false, secondTqi);
        }
        return driverTqi;
    }

    private void ncjSetDriverAndRemoteTables(ArrayList<TableQueryInfo> tqiList) {
        SanityManager.ASSERT((this.ncjMetaData != null ? 1 : 0) != 0);
        TableQueryInfo driverTqi = null;
        int driverPrId = this.qic.getDriverTablePrID();
        SanityManager.ASSERT((driverPrId > 0 ? 1 : 0) != 0);
        TableQueryInfo firstTqi = tqiList.get(NcjHashMapWrapper.getFirstTablePositionIndex());
        TableQueryInfo secondTqi = tqiList.get(NcjHashMapWrapper.getSecondTablePositionIndex());
        driverTqi = this.ncjSetDriverOnFirstTwoTables(firstTqi, secondTqi, driverPrId);
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("DMLQueryInfo::ncjSetDriverAndRemoteTables. From first two tables, first=" + firstTqi + " ,second=" + secondTqi + " got Driver Table " + driverTqi));
        }
        for (TableQueryInfo tqi : this.tableQueryInfoList) {
            if (tqi == null || tqi == firstTqi || tqi == secondTqi) continue;
            FromBaseTable fbt = tqi.getTableNode();
            SanityManager.ASSERT((fbt != null ? 1 : 0) != 0);
            String corrName = fbt.ncjGetCorrelationName();
            boolean isPull = false;
            if (tqi.isPartitionedRegion()) {
                if (driverTqi == null && ((PartitionedRegion)tqi.getRegion()).getPRId() == driverPrId) {
                    driverTqi = tqi;
                } else if (this.ncjVerifyCollocatedTables(driverTqi, tqi)) {
                    if (GemFireXDUtils.TraceNCJ) {
                        SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("DMLQueryInfo::ncjSetDriverAndRemoteTables. Table " + tqi + " is colocated to driver " + driverTqi));
                    }
                } else {
                    isPull = true;
                }
            }
            NcjHashMapWrapper.addTableAtHigherPosition(this.ncjMetaData, corrName, isPull, tqi);
        }
        this.setDriverTableQueryInfo(driverTqi);
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("DMLQueryInfo::ncjSetDriverAndRemoteTables. Remote Table and column indexes=" + this.ncjMetaData + ", driver table=" + driverTqi + ", driver PRId=" + driverPrId + " ,tables=" + tqiList));
        }
    }
}

