/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Region;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalRowLocation;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractColumnQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractConditionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AndJunctionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ColocationCriteria;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ColumnQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ConstantConditionsWrapperQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ConstantQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.JunctionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.OrJunctionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ParameterizedConditionsWrapperQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RangeQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.TableQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ValueQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.shared.common.CharColumnRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.ColumnRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.DecimalColumnRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.DoubleColumnRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.IntColumnRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.LongIntColumnRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.RangeRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.RealColumnRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.SmallIntRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.VarCharColumnRoutingObjectInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ComparisonQueryInfo
extends AbstractConditionQueryInfo {
    final QueryInfo leftOperand;
    final QueryInfo rightOperand;
    final int opType;
    protected int colocationMatrixRows;
    protected ArrayList<TableQueryInfo> colocationMatrixTables = new ArrayList();
    protected int colocationMatrixPRTableCount;
    private QueryInfo runTimePruner = null;

    public ComparisonQueryInfo(QueryInfo left, QueryInfo right, int opType) throws StandardException {
        if (!(left instanceof AbstractColumnQueryInfo)) {
            QueryInfo temp = left;
            left = right;
            right = temp;
            opType = ComparisonQueryInfo.reflectOperator(opType);
        }
        this.leftOperand = left;
        if (left instanceof AbstractColumnQueryInfo) {
            this.adjustConstantType((AbstractColumnQueryInfo)((Object)left), right);
        }
        this.rightOperand = right;
        this.opType = opType;
    }

    protected void adjustConstantType(AbstractColumnQueryInfo left, QueryInfo right) throws StandardException {
        if (right instanceof ConstantQueryInfo) {
            ConstantQueryInfo rightConst = (ConstantQueryInfo)right;
            DataTypeDescriptor leftDtd = left.getType();
            DataValueDescriptor dvd = rightConst.getValue();
            if (dvd != null && dvd.getTypeFormatId() != leftDtd.getDVDTypeFormatId()) {
                DataValueDescriptor newDvd = leftDtd.getNull();
                newDvd.setValue(dvd);
                rightConst.setValue(newDvd);
            }
        }
    }

    @Override
    Object isConvertibleToGet(int pkColumn, TableQueryInfo tqi) throws StandardException {
        ColumnQueryInfo cqi;
        Object pk = null;
        if (this.opType == 1 && this.leftOperand instanceof ColumnQueryInfo && this.rightOperand instanceof ValueQueryInfo && (cqi = (ColumnQueryInfo)this.leftOperand).getActualColumnPosition() == pkColumn && cqi.getTableNumber() == tqi.getTableNumber()) {
            pk = this.rightOperand.getPrimaryKey();
        }
        return pk;
    }

    @Override
    Object isConvertibleToGet(int[][] pkColumns, TableQueryInfo tqi) throws StandardException {
        if (pkColumns.length == 1) {
            Object pk = this.isConvertibleToGet(pkColumns[0][0], tqi);
            if (pk != null && !this.isWhereClauseDynamic()) {
                pk = GemFireXDUtils.convertIntoGemfireRegionKey((DataValueDescriptor)pk, (GemFireContainer)tqi.getRegion().getUserAttribute(), false);
            }
            return pk;
        }
        return null;
    }

    @Override
    Object isConvertibleToGetOnLocalIndex(int fkColumn, TableQueryInfo tqi) throws StandardException {
        ColumnQueryInfo cqi;
        Object fk = null;
        if (this.opType == 1 && this.leftOperand instanceof ColumnQueryInfo && this.rightOperand instanceof ValueQueryInfo && (cqi = (ColumnQueryInfo)this.leftOperand).getActualColumnPosition() == fkColumn && cqi.getTableNumber() == tqi.getTableNumber()) {
            fk = this.rightOperand.getIndexKey();
        }
        return fk;
    }

    @Override
    Object isConvertibleToGetOnLocalIndex(int[][] ikColumns, TableQueryInfo tqi) throws StandardException {
        if (ikColumns.length == 1) {
            return this.isConvertibleToGetOnLocalIndex(ikColumns[0][0], tqi);
        }
        return null;
    }

    @Override
    AbstractConditionQueryInfo mergeOperand(AbstractConditionQueryInfo operand, int operandJunctionType, boolean isTopLevel) throws StandardException {
        if (operand == null) {
            return this;
        }
        return operand.mergeNonJunctionOperand(this, operandJunctionType);
    }

    @Override
    JunctionQueryInfo mergeNonJunctionOperand(AbstractConditionQueryInfo operand, int operandJunctionType) throws StandardException {
        return operandJunctionType == 1 ? new AndJunctionQueryInfo(this, operand) : new OrJunctionQueryInfo(this, operand);
    }

    @Override
    JunctionQueryInfo mergeJunctionOperand(JunctionQueryInfo junctionOperand, int operandJunctionType) throws StandardException {
        return junctionOperand.mergeNonJunctionOperand(this, operandJunctionType);
    }

    QueryInfo[] getOperands() {
        return new QueryInfo[]{this.leftOperand, this.rightOperand};
    }

    @Override
    int getRelationalOperator() {
        return this.opType;
    }

    @Override
    int getActualColumnPostionOfOperand() {
        if (this.leftOperand instanceof AbstractColumnQueryInfo && this.rightOperand instanceof ValueQueryInfo) {
            AbstractColumnQueryInfo acqi = (AbstractColumnQueryInfo)((Object)this.leftOperand);
            return acqi.getActualColumnPosition();
        }
        return -1;
    }

    @Override
    public boolean isWhereClauseDynamic() {
        return this.leftOperand != null && this.leftOperand.isDynamic() || this.rightOperand != null && this.rightOperand.isDynamic();
    }

    @Override
    QueryInfo getRuntimeNodesPruner(boolean forSingleHopPreparePhase) {
        if (this.runTimePruner == null) {
            this.runTimePruner = this.createRuntimeNodesPruner(forSingleHopPreparePhase);
        }
        return this.runTimePruner;
    }

    private QueryInfo createRuntimeNodesPruner(boolean forSingleHopPreparePhase) {
        GfxdPartitionResolver spr;
        ValueQueryInfo vqi;
        AbstractColumnQueryInfo acqi;
        QueryInfo pruner = null;
        if (this.leftOperand instanceof AbstractColumnQueryInfo) {
            acqi = (AbstractColumnQueryInfo)((Object)this.leftOperand);
            vqi = this.rightOperand instanceof ValueQueryInfo ? (ValueQueryInfo)this.rightOperand : null;
        } else {
            acqi = null;
            vqi = null;
        }
        pruner = acqi == null || vqi == null ? QueryInfoConstants.NON_PRUNABLE : ((spr = acqi.getResolverIfSingleColumnPartition()) != null ? ComparisonQueryInfo.getResolverBasedPruner(spr, vqi, acqi, this.opType) : (this.opType == 1 && !acqi.isExpression() && !forSingleHopPreparePhase ? ComparisonQueryInfo.attemptToGetGlobalIndexBasedPruner(vqi, (ColumnQueryInfo)acqi) : QueryInfoConstants.NON_PRUNABLE));
        return pruner;
    }

    private static QueryInfo attemptToGetGlobalIndexBasedPruner(final ValueQueryInfo vqi, ColumnQueryInfo cqi) {
        final LogWriter logger = Misc.getCacheLogWriter();
        List<ConglomerateDescriptor> globalIndexes = cqi.getAvailableGlobalHashIndexForColumn();
        ConglomerateDescriptor cd = null;
        Iterator<ConglomerateDescriptor> itr = globalIndexes.iterator();
        QueryInfo pruner = null;
        while (itr.hasNext()) {
            ConglomerateDescriptor temp = itr.next();
            if (temp.getIndexDescriptor().baseColumnPositions().length != 1) continue;
            cd = temp;
            break;
        }
        if (cd != null) {
            final long conglomID = cd.getConglomerateNumber();
            pruner = new AbstractQueryInfo(){

                @Override
                public void computeNodes(Set<Object> routingKeysToExecute, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
                    DataValueDescriptor keyDVD;
                    DataValueDescriptor[] dvdKeyArr;
                    TransactionController tc = activation.getTransactionController();
                    ScanController scan = tc.openScan(conglomID, false, 0, 7, 5, null, dvdKeyArr = new DataValueDescriptor[]{keyDVD = vqi.evaluateToGetDataValueDescriptor(activation)}, 1, null, dvdKeyArr, 1, null);
                    if (scan.next()) {
                        routingKeysToExecute.clear();
                        DataValueDescriptor[] fetchKey = new DataValueDescriptor[2];
                        fetchKey[0] = keyDVD;
                        while (scan.next()) {
                            GlobalRowLocation grl = new GlobalRowLocation();
                            fetchKey[1] = grl;
                            scan.fetch(new DataValueDescriptor[]{keyDVD, grl});
                            Serializable routingObject = grl.getRoutingObject();
                            if (logger.fineEnabled()) {
                                logger.fine("ComparisonQueryInfo::pruneUsingGlobalIndex: Scan of Global index found a row = " + grl);
                                logger.fine("ComparisonQueryInfo::pruneUsingGlobalIndex: Scan of Global index found routing object = " + routingObject);
                            }
                            assert (routingObject != null);
                            routingKeysToExecute.add(routingObject);
                        }
                    } else {
                        if (logger.fineEnabled()) {
                            logger.fine("ComparisonQueryInfo::pruneUsingGlobalIndex: Scan of Global index found NO row");
                        }
                        routingKeysToExecute.clear();
                    }
                    scan.close();
                }
            };
        } else {
            pruner = QueryInfoConstants.NON_PRUNABLE;
        }
        return pruner;
    }

    int isPartOfGlobalIndex(int[] baseColPos) {
        int indexPos = -1;
        int actualColPos = this.getActualColumnPostionOfOperand();
        if (actualColPos != -1) {
            int len = baseColPos.length;
            for (int pos = 0; pos < len; ++pos) {
                if (baseColPos[pos] != actualColPos) continue;
                indexPos = pos;
                break;
            }
        }
        return indexPos;
    }

    private static QueryInfo getResolverBasedPruner(final GfxdPartitionResolver spr, final ValueQueryInfo vqi, AbstractColumnQueryInfo acqi, final int opType) {
        final LogWriter logger = Misc.getCacheLogWriter();
        final boolean isExpression = acqi.isExpression();
        if (isExpression && opType != 1) {
            return QueryInfoConstants.NON_PRUNABLE;
        }
        QueryInfo pruner = null;
        switch (opType) {
            case 1: {
                pruner = new AbstractQueryInfo(){

                    @Override
                    public void computeNodes(Set<Object> routingKeysToExecute, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
                        if (!forSingleHopPreparePhase) {
                            DataValueDescriptor key = vqi.evaluateToGetDataValueDescriptor(activation);
                            if (logger.fineEnabled()) {
                                logger.fine("ComparisonQueryInfo.computeNodes: equality pruner");
                            }
                            routingKeysToExecute.clear();
                            Object routingKey = isExpression ? spr.getRoutingObjectForExpression(key) : spr.getRoutingKeyForColumn(key);
                            assert (routingKey != null);
                            routingKeysToExecute.add(routingKey);
                        } else {
                            if (isExpression) {
                                routingKeysToExecute.add(QueryInfoConstants.NON_PRUNABLE);
                                return;
                            }
                            routingKeysToExecute.clear();
                            int type = vqi.typeOfValue();
                            switch (type) {
                                case 1: 
                                case 2: {
                                    routingKeysToExecute.add(ComparisonQueryInfo.getAppropriateRoutingObjectInfo(activation, vqi, spr));
                                    break;
                                }
                                case 0: {
                                    routingKeysToExecute.add(ComparisonQueryInfo.getAppropriateRoutingObjectInfo(activation, vqi, spr));
                                }
                            }
                        }
                    }
                };
                break;
            }
            case 3: 
            case 4: {
                pruner = new AbstractQueryInfo(){

                    @Override
                    public void computeNodes(Set<Object> routingKeysToExecute, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
                        if (!forSingleHopPreparePhase) {
                            Object[] routingObjects;
                            DataValueDescriptor key = vqi.evaluateToGetDataValueDescriptor(activation);
                            if (logger.fineEnabled()) {
                                logger.fine("ComparisonQueryInfo::computeNodes: range passed for Greater condition (lower bound ). Lower bound = " + key + "Inclusive =" + (opType == 4));
                                logger.fine("ComparisonQueryInfo::computeNodes:Resolver is = " + spr);
                            }
                            if ((routingObjects = spr.getRoutingObjectsForRange(key, opType == 4, null, false)) != null) {
                                if (logger.fineEnabled()) {
                                    logger.fine("ComparisonQueryInfo::computeNodes:routing keys length=" + routingObjects.length);
                                    for (Object i : routingObjects) {
                                        logger.fine("ComparisonQueryInfo::computeNodes:routing key=" + i);
                                    }
                                }
                                routingKeysToExecute.clear();
                                for (int i = 0; i < routingObjects.length; ++i) {
                                    routingKeysToExecute.add(routingObjects[i]);
                                }
                            }
                        } else {
                            if (isExpression) {
                                routingKeysToExecute.add(QueryInfoConstants.NON_PRUNABLE);
                                return;
                            }
                            int type = vqi.typeOfValue();
                            switch (type) {
                                case 1: 
                                case 2: {
                                    routingKeysToExecute.add(new RangeRoutingObjectInfo(8, ComparisonQueryInfo.getAppropriateRoutingObjectInfo(activation, vqi, spr), opType == 4, null, false, (Object)spr));
                                    break;
                                }
                                case 0: {
                                    routingKeysToExecute.add(new RangeRoutingObjectInfo(8, ComparisonQueryInfo.getAppropriateRoutingObjectInfo(activation, vqi, spr), opType == 4, null, false, (Object)spr));
                                }
                            }
                        }
                    }
                };
                break;
            }
            case 5: 
            case 6: {
                pruner = new AbstractQueryInfo(){

                    @Override
                    public void computeNodes(Set<Object> routingKeysToExecute, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
                        if (!forSingleHopPreparePhase) {
                            Object[] routingObjects;
                            DataValueDescriptor key = vqi.evaluateToGetDataValueDescriptor(activation);
                            if (logger.fineEnabled()) {
                                logger.fine("ComparisonQueryInfo::computeNodes: range passed for Lower condition (upper bound) . Upper bound = " + key + "Inclusive =" + (opType == 6));
                                logger.fine("ComparisonQueryInfo::computeNodes:Resolver is = " + spr);
                            }
                            if ((routingObjects = spr.getRoutingObjectsForRange(null, false, key, opType == 6)) != null) {
                                if (logger.fineEnabled()) {
                                    logger.fine("ComparisonQueryInfo::computeNodes:routing keys length=" + routingObjects.length);
                                    for (Object i : routingObjects) {
                                        logger.fine("ComparisonQueryInfo::computeNodes:routing key=" + i);
                                    }
                                }
                                routingKeysToExecute.clear();
                                for (Object i : routingObjects) {
                                    routingKeysToExecute.add(i);
                                }
                            }
                        } else {
                            if (isExpression) {
                                routingKeysToExecute.add(QueryInfoConstants.NON_PRUNABLE);
                                return;
                            }
                            int type = vqi.typeOfValue();
                            switch (type) {
                                case 1: 
                                case 2: {
                                    routingKeysToExecute.add(new RangeRoutingObjectInfo(8, ComparisonQueryInfo.getAppropriateRoutingObjectInfo(activation, vqi, spr), opType == 6, null, false, (Object)spr));
                                    break;
                                }
                                case 0: {
                                    routingKeysToExecute.add(new RangeRoutingObjectInfo(8, ComparisonQueryInfo.getAppropriateRoutingObjectInfo(activation, vqi, spr), opType == 6, null, false, (Object)spr));
                                }
                            }
                        }
                    }
                };
                break;
            }
            default: {
                pruner = QueryInfoConstants.NON_PRUNABLE;
            }
        }
        return pruner;
    }

    public static ColumnRoutingObjectInfo getAppropriateRoutingObjectInfo(Activation activation, ValueQueryInfo vqi, GfxdPartitionResolver spi) throws StandardException {
        int infotype = vqi.typeOfValue();
        switch (infotype) {
            case 1: 
            case 2: {
                DataValueDescriptor dvd = vqi.evaluateToGetConstant(activation);
                Object value = dvd.getObject();
                int type = dvd.getTypeFormatId();
                switch (type) {
                    case 80: {
                        return new IntColumnRoutingObjectInfo(1, value, (Object)spi);
                    }
                    case 84: {
                        return new LongIntColumnRoutingObjectInfo(1, value, (Object)spi);
                    }
                    case 83: {
                        return new SmallIntRoutingObjectInfo(1, value, (Object)spi);
                    }
                    case 78: {
                        CharColumnRoutingObjectInfo ccroi = new CharColumnRoutingObjectInfo(1, value, (Object)spi);
                        ccroi.setMaxWidth(vqi.getMaximumWidth());
                        return ccroi;
                    }
                    case 200: {
                        return new DecimalColumnRoutingObjectInfo(1, value, (Object)spi);
                    }
                    case 81: {
                        return new RealColumnRoutingObjectInfo(1, value, (Object)spi);
                    }
                    case 79: {
                        return new DoubleColumnRoutingObjectInfo(1, value, (Object)spi);
                    }
                    case 85: {
                        VarCharColumnRoutingObjectInfo vccroi = new VarCharColumnRoutingObjectInfo(1, value, (Object)spi);
                        vccroi.setMaxWidth(vqi.getMaximumWidth());
                        return vccroi;
                    }
                }
                break;
            }
            case 0: {
                int paramNumber = vqi.evaluateToGetParameterNumber(activation);
                int paramType = vqi.getParamType(activation);
                switch (paramType) {
                    case 80: {
                        return new IntColumnRoutingObjectInfo(2, (Object)paramNumber, (Object)spi);
                    }
                    case 84: {
                        return new LongIntColumnRoutingObjectInfo(2, (Object)paramNumber, (Object)spi);
                    }
                    case 83: {
                        return new SmallIntRoutingObjectInfo(2, (Object)paramNumber, (Object)spi);
                    }
                    case 78: {
                        CharColumnRoutingObjectInfo ccroi = new CharColumnRoutingObjectInfo(2, (Object)paramNumber, (Object)spi);
                        ccroi.setMaxWidth(vqi.getMaximumWidth());
                        return ccroi;
                    }
                    case 200: {
                        return new DecimalColumnRoutingObjectInfo(2, (Object)paramNumber, (Object)spi);
                    }
                    case 81: {
                        return new RealColumnRoutingObjectInfo(2, (Object)paramNumber, (Object)spi);
                    }
                    case 79: {
                        return new DoubleColumnRoutingObjectInfo(2, (Object)paramNumber, (Object)spi);
                    }
                    case 85: {
                        VarCharColumnRoutingObjectInfo vccroi = new VarCharColumnRoutingObjectInfo(2, (Object)paramNumber, (Object)spi);
                        int maxWidth = vqi.getMaximumWidth();
                        vccroi.setMaxWidth(maxWidth);
                        return vccroi;
                    }
                }
            }
        }
        return null;
    }

    public static ColumnRoutingObjectInfo getAppropriateRoutingObjectInfo(ValueNode vn, int type, boolean isParameter, int paramNumber, Object value, GfxdPartitionResolver spi, int maximumWidth) throws StandardException {
        if (!isParameter) {
            switch (type) {
                case 80: {
                    return new IntColumnRoutingObjectInfo(1, value, (Object)spi);
                }
                case 84: {
                    return new LongIntColumnRoutingObjectInfo(1, value, (Object)spi);
                }
                case 83: {
                    return new SmallIntRoutingObjectInfo(1, value, (Object)spi);
                }
                case 78: {
                    CharColumnRoutingObjectInfo ccroi = new CharColumnRoutingObjectInfo(1, value, (Object)spi);
                    ccroi.setMaxWidth(maximumWidth);
                    return ccroi;
                }
                case 200: {
                    return new DecimalColumnRoutingObjectInfo(1, value, (Object)spi);
                }
                case 81: {
                    return new RealColumnRoutingObjectInfo(1, value, (Object)spi);
                }
                case 79: {
                    return new DoubleColumnRoutingObjectInfo(1, value, (Object)spi);
                }
                case 85: {
                    VarCharColumnRoutingObjectInfo vccroi = new VarCharColumnRoutingObjectInfo(1, value, (Object)spi);
                    vccroi.setMaxWidth(maximumWidth);
                    return vccroi;
                }
            }
            return null;
        }
        switch (type) {
            case 80: {
                return new IntColumnRoutingObjectInfo(2, (Object)paramNumber, (Object)spi);
            }
            case 84: {
                return new LongIntColumnRoutingObjectInfo(2, (Object)paramNumber, (Object)spi);
            }
            case 83: {
                return new SmallIntRoutingObjectInfo(2, (Object)paramNumber, (Object)spi);
            }
            case 78: {
                CharColumnRoutingObjectInfo ccroi = new CharColumnRoutingObjectInfo(2, (Object)paramNumber, (Object)spi);
                ccroi.setMaxWidth(maximumWidth);
                return ccroi;
            }
            case 200: {
                return new DecimalColumnRoutingObjectInfo(2, (Object)paramNumber, (Object)spi);
            }
            case 81: {
                return new RealColumnRoutingObjectInfo(2, (Object)paramNumber, (Object)spi);
            }
            case 79: {
                return new DoubleColumnRoutingObjectInfo(2, (Object)paramNumber, (Object)spi);
            }
            case 85: {
                VarCharColumnRoutingObjectInfo vccroi = new VarCharColumnRoutingObjectInfo(2, (Object)paramNumber, (Object)spi);
                vccroi.setMaxWidth(maximumWidth);
                return vccroi;
            }
        }
        return null;
    }

    private static int reflectOperator(int op) {
        switch (op) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 4: {
                return 6;
            }
            case 6: {
                return 4;
            }
            case 3: {
                return 5;
            }
        }
        return op;
    }

    @Override
    String getUniqueColumnName() {
        if (this.leftOperand instanceof AbstractColumnQueryInfo) {
            AbstractColumnQueryInfo acqi = (AbstractColumnQueryInfo)((Object)this.leftOperand);
            return ComparisonQueryInfo.generateUniqueColumnName(this.leftOperand.getSchemaName(), this.leftOperand.getTableName(), acqi.getActualColumnName());
        }
        return null;
    }

    @Override
    boolean isStaticallyNotGetConvertible() {
        return this.getActualColumnPostionOfOperand() == -1 || this.opType != 1;
    }

    @Override
    boolean isEquiJoinCondition() {
        return this.opType == 1 && this.leftOperand instanceof ColumnQueryInfo && (this.rightOperand instanceof ColumnQueryInfo || this.rightOperand instanceof ValueQueryInfo);
    }

    String getRegionName() {
        return this.leftOperand.getRegion().getFullPath();
    }

    @Override
    void seedColocationMatrixData(int rows, ArrayList<TableQueryInfo> tables, int numPRTables) {
        this.colocationMatrixPRTableCount = numPRTables;
        if (this.isEquiJoinCondition()) {
            this.colocationMatrixTables = tables;
            this.colocationMatrixRows = rows;
        }
    }

    int getColocationMatrixRowCount() {
        return this.colocationMatrixRows;
    }

    ArrayList<TableQueryInfo> getColocationMatrixTables() {
        return this.colocationMatrixTables;
    }

    int getColocationMatrixPRTableCount() {
        return this.colocationMatrixPRTableCount;
    }

    @Override
    AbstractConditionQueryInfo createOrAddToGroup(AbstractConditionQueryInfo operand, boolean createConstantConditionsWrapper, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
        if (activation == null && (this.isWhereClauseDynamic() || operand.isWhereClauseDynamic())) {
            return new ParameterizedConditionsWrapperQueryInfo(this, operand);
        }
        return ComparisonQueryInfo.createSingleOrRangeQueryInfo(this, this.opType, (ComparisonQueryInfo)operand, ((ComparisonQueryInfo)operand).opType, activation, createConstantConditionsWrapper, forSingleHopPreparePhase);
    }

    private static AbstractConditionQueryInfo createSingleOrRangeQueryInfo(ComparisonQueryInfo cond1, int op1, ComparisonQueryInfo cond2, int op2, Activation activation, boolean createConstantConditionsWrapper, boolean forSingleHopPreparePhase) throws StandardException {
        AbstractConditionQueryInfo retVal;
        if (forSingleHopPreparePhase) {
            return null;
        }
        DataValueDescriptor const1 = ((ValueQueryInfo)cond1.rightOperand).evaluateToGetDataValueDescriptor(activation);
        switch (op2) {
            case 3: 
            case 4: {
                DataValueDescriptor const2 = ((ValueQueryInfo)cond2.rightOperand).evaluateToGetDataValueDescriptor(activation);
                if (op1 == 4 || op1 == 3) {
                    retVal = ComparisonQueryInfo.isConditionSatisfied(const1, const2, op2) ? cond1 : cond2;
                    break;
                }
                boolean isRangeBound = ComparisonQueryInfo.checkForRangeBoundedNess(const1, op1, const2, op2);
                retVal = isRangeBound ? new RangeQueryInfo(const2, op2, const1, op1, ((ColumnQueryInfo)cond1.leftOperand).getActualColumnName(), (Region)((ColumnQueryInfo)cond1.leftOperand).getRegion()) : (createConstantConditionsWrapper ? new ConstantConditionsWrapperQueryInfo(cond1, cond2) : null);
                break;
            }
            case 5: 
            case 6: {
                DataValueDescriptor const2 = ((ValueQueryInfo)cond2.rightOperand).evaluateToGetDataValueDescriptor(activation);
                if (op1 == 6 || op1 == 5) {
                    retVal = ComparisonQueryInfo.isConditionSatisfied(const1, const2, op2) ? cond1 : cond2;
                    break;
                }
                boolean isRangeBound = ComparisonQueryInfo.checkForRangeBoundedNess(const2, op2, const1, op1);
                retVal = isRangeBound ? new RangeQueryInfo(const1, op1, const2, op2, ((ColumnQueryInfo)cond1.leftOperand).getActualColumnName(), (Region)((ColumnQueryInfo)cond1.leftOperand).getRegion()) : (createConstantConditionsWrapper ? new ConstantConditionsWrapperQueryInfo(cond1, cond2) : null);
                break;
            }
            case 1: 
            case 2: {
                retVal = createConstantConditionsWrapper ? new ConstantConditionsWrapperQueryInfo(cond1, cond2) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("operator type undefined");
            }
        }
        return retVal;
    }

    private static boolean checkForRangeBoundedNess(Object lessCondnKey, int lessOperator, Object greaterCondnKey, int greaterCondnOp) throws StandardException {
        return ComparisonQueryInfo.isConditionSatisfied(greaterCondnKey, lessCondnKey, lessOperator) && ComparisonQueryInfo.isConditionSatisfied(lessCondnKey, greaterCondnKey, greaterCondnOp);
    }

    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("left operand = ");
        sbuff.append(this.leftOperand.toString());
        sbuff.append("; right operand = ");
        sbuff.append(this.rightOperand.toString());
        sbuff.append("; operator = ");
        sbuff.append(this.opType);
        return sbuff.toString();
    }

    @Override
    public String isEquiJoinColocationCriteriaFullfilled(TableQueryInfo ncjTqi) {
        if (this.colocationMatrixPRTableCount > 1) {
            if (this.isEquiJoinCondition()) {
                ColocationCriteria colocationCheck = new ColocationCriteria(this.colocationMatrixRows, this.colocationMatrixTables);
                colocationCheck.updateColocationCriteria(this);
                return colocationCheck.isEquiJoinColocationCriteriaFullfilled(ncjTqi);
            }
            return "non equijoin attempted on more than one partitioned tables";
        }
        return null;
    }

    TableDescriptor getTableDescriptor() {
        assert (this.leftOperand instanceof AbstractColumnQueryInfo);
        return ((AbstractColumnQueryInfo)((Object)this.leftOperand)).getTableDescriptor();
    }

    @Override
    public boolean isTableVTI() {
        assert (this.leftOperand instanceof AbstractQueryInfo);
        return ((AbstractQueryInfo)this.leftOperand).isTableVTI();
    }

    @Override
    public boolean routeQueryToAllNodes() {
        assert (this.leftOperand instanceof AbstractQueryInfo);
        return ((AbstractQueryInfo)this.leftOperand).routeQueryToAllNodes();
    }

    public void setRunTimePrunerToNull() {
        this.runTimePruner = null;
    }
}

