/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gnu.trove.THashSet;
import com.gemstone.gnu.trove.TIntIntHashMap;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ColumnQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ComparisonQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ConstantQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ParameterQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ParameterizedConstantQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.TableQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ValueListQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ValueQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;

public final class ColocationCriteria {
    private final ArrayList<Integer> indexValueList;
    private int currentIndex;
    private final ArrayList<TableQueryInfo> tableQueryInfos;
    private final Map<Object, int[]> colocationMatrix;
    private final int initialMatrixSize;
    private final GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
    private boolean evaluatedSingleTableCase = false;
    private boolean isValidSingleTableJoin = false;

    ColocationCriteria(int numPartitioningColumns, ArrayList<TableQueryInfo> tables) {
        assert (numPartitioningColumns > 0) : "Expected number of partitioning columns to be > 0";
        assert (tables != null) : "Expected tables to be non-null";
        this.indexValueList = new ArrayList();
        this.indexValueList.add(0);
        this.currentIndex = 1;
        this.colocationMatrix = new HashMap<Object, int[]>();
        this.tableQueryInfos = tables;
        this.initialMatrixSize = numPartitioningColumns;
        int numTQIs = tables.size();
        THashSet tqis = new THashSet(numTQIs);
        tqis.add((Object)tables.get(0));
        for (int index = 1; index < numTQIs; ++index) {
            TableQueryInfo tqi = tables.get(index);
            TableQueryInfo oldTQI = (TableQueryInfo)tqis.putIfAbsent((Object)tqi);
            if (oldTQI == null) continue;
            tqi.setTableNumberforColocationCriteria(oldTQI.getTableNumberforColocationCriteria());
            tables.set(index, null);
        }
    }

    public void updateColocationCriteria(ComparisonQueryInfo cqi) {
        int newIndex;
        int rhsTablePos = -1;
        ColumnQueryInfo lhs = null;
        Serializable rhsColPos = null;
        boolean sameColumn = false;
        if (cqi.rightOperand instanceof ColumnQueryInfo) {
            ColumnQueryInfo rhs = (ColumnQueryInfo)cqi.rightOperand;
            rhsTablePos = rhs.getTableNumberforColocationCriteria();
            rhsColPos = Integer.valueOf(this.getColumnPositionForMatrix(rhs));
            ColumnDescriptor rhsCD = rhs.getColumnDescriptor();
            if (rhsCD != null && cqi.leftOperand instanceof ColumnQueryInfo) {
                lhs = (ColumnQueryInfo)cqi.leftOperand;
                int countTablesUptoOne = 0;
                for (int index = 0; index < this.tableQueryInfos.size() && countTablesUptoOne <= 1; ++index) {
                    TableQueryInfo tqi = this.tableQueryInfos.get(index);
                    if (tqi == null) continue;
                    ++countTablesUptoOne;
                }
                if (rhsCD.equals(lhs.getColumnDescriptor())) {
                    sameColumn = true;
                    if (countTablesUptoOne == 1) {
                        this.evaluatedSingleTableCase = true;
                        this.isValidSingleTableJoin = this.isValidSingleTableJoin || rhs.isUsedInPartitioning();
                    }
                    return;
                }
                if (countTablesUptoOne == 1) {
                    this.evaluatedSingleTableCase = true;
                    this.isValidSingleTableJoin = this.isValidSingleTableJoin || rhs.isUsedInPartitioning() && lhs.isUsedInPartitioning();
                }
            }
        } else if (cqi.rightOperand instanceof ConstantQueryInfo) {
            rhsTablePos = 0;
            rhsColPos = ((ConstantQueryInfo)cqi.rightOperand).getValue();
        } else if (cqi.rightOperand instanceof ValueListQueryInfo) {
            ValueQueryInfo rhs;
            ValueListQueryInfo inList = (ValueListQueryInfo)cqi.rightOperand;
            if (inList.getSize() == 1 && (rhs = inList.getOperands()[0]) instanceof ConstantQueryInfo) {
                rhsTablePos = 0;
                rhsColPos = ((ConstantQueryInfo)rhs).getValue();
            }
        } else if (cqi.rightOperand instanceof ParameterQueryInfo || cqi.rightOperand instanceof ParameterizedConstantQueryInfo) {
            rhsTablePos = 0;
            rhsColPos = cqi.rightOperand;
        }
        if (this.observer != null && !sameColumn) {
            this.observer.updatingColocationCriteria(cqi);
        }
        if (rhsColPos == null) {
            return;
        }
        if (lhs == null) {
            lhs = (ColumnQueryInfo)cqi.leftOperand;
        }
        int lhsTablePos = lhs.getTableNumberforColocationCriteria();
        Integer lhsColPos = this.getColumnPositionForMatrix(lhs);
        int[] row = this.getAndExpandColocationMatrix(lhsColPos);
        int existingIndex = row[lhsTablePos];
        if (existingIndex == 0) {
            row[lhsTablePos] = newIndex = this.currentIndex++;
            Integer newIndexObj = newIndex;
            this.indexValueList.add(newIndexObj);
        } else {
            newIndex = existingIndex;
        }
        row = this.getAndExpandColocationMatrix(rhsColPos);
        existingIndex = row[rhsTablePos];
        if (existingIndex == 0) {
            row[rhsTablePos] = newIndex;
        } else {
            Integer existingIndexObj = this.indexValueList.get(existingIndex);
            Integer oldIndexObj = this.indexValueList.set(newIndex, existingIndexObj);
            ListIterator<Integer> itr = this.indexValueList.listIterator();
            while (itr.hasNext()) {
                Integer val = itr.next();
                if (!val.equals(oldIndexObj)) continue;
                itr.set(existingIndexObj);
            }
        }
    }

    private int getColumnPositionForMatrix(ColumnQueryInfo column) {
        int colPos = column.getPartitionColumnPosition();
        if (colPos < 0) {
            colPos = column.getActualColumnPosition() + this.initialMatrixSize;
        }
        return colPos;
    }

    private int[] getAndExpandColocationMatrix(Object key) {
        int[] row = this.colocationMatrix.get(key);
        if (row == null) {
            row = new int[this.tableQueryInfos.size()];
            this.colocationMatrix.put(key, row);
        }
        return row;
    }

    String isEquiJoinColocationCriteriaFullfilled(TableQueryInfo ncjTqi_notUsed) {
        int[] refTableIndicesFrequency = null;
        TableQueryInfo refTQI = null;
        for (int tablePos = 0; tablePos < this.tableQueryInfos.size(); ++tablePos) {
            TableQueryInfo tqi = this.tableQueryInfos.get(tablePos);
            if (tqi == null || !tqi.isPartitionedRegion()) continue;
            if (this.evaluatedSingleTableCase) {
                if (!this.isValidSingleTableJoin) {
                    return "Self Join on non partioning column are not supported for table " + tqi.getFullTableName();
                }
                return null;
            }
            int[] tableIndicesFrequency = new int[this.currentIndex];
            TIntIntHashMap indexToColumnPosition = new TIntIntHashMap();
            for (int colPos = 0; colPos < this.initialMatrixSize; ++colPos) {
                int indexValue;
                int index = this.getAndExpandColocationMatrix(colPos)[tablePos];
                if (index <= 0) {
                    return "table " + tqi.getFullTableName() + " missing colocation for partitioning column " + this.getPartitioningColumn(tqi, colPos);
                }
                int n = indexValue = this.indexValueList.get(index).intValue();
                tableIndicesFrequency[n] = tableIndicesFrequency[n] + 1;
                indexToColumnPosition.put(indexValue, colPos);
            }
            if (refTableIndicesFrequency == null) {
                refTableIndicesFrequency = tableIndicesFrequency;
                refTQI = tqi;
                continue;
            }
            for (int index = 1; index < refTableIndicesFrequency.length; ++index) {
                if (tableIndicesFrequency[index] == refTableIndicesFrequency[index]) continue;
                return "table " + tqi.getFullTableName() + " different number of joins " + tableIndicesFrequency[index] + " on column " + this.getPartitioningColumn(tqi, indexToColumnPosition.get(index)) + " than expected " + refTableIndicesFrequency[index] + " as in table " + refTQI.getFullTableName();
            }
        }
        return null;
    }

    private String getPartitioningColumn(TableQueryInfo tqi, int colPos) {
        PartitionedRegion pr = (PartitionedRegion)tqi.getRegion();
        String[] partitioningColumns = ((GfxdPartitionResolver)pr.getPartitionResolver()).getColumnNames();
        return colPos < partitioningColumns.length ? partitioningColumns[colPos] : "number " + colPos + '?';
    }
}

