/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.GemFireCheckedException;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.InternalDataView;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.OffHeapReleaseUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GfxdFunctionMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.ProjectionRow;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionSingleKeyExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;

public final class GetExecutorMessage
extends RegionSingleKeyExecutorMessage {
    protected int[] projectionFixedColumns;
    protected int[] projectionVarColumns;
    protected int[] projectionLobColumns;
    protected transient int[] projectionAllColumns;
    protected byte targetFormatOffsetBytes;
    protected transient boolean hasProjection;
    protected transient RowFormatter targetFormat;
    protected transient boolean forceUseOfPRExecutor;
    private transient boolean hasLoader;
    private boolean queryHDFS;
    private boolean canStartTX;
    private boolean forUpdate;
    public static final Object INVALID_RESULT = new Object();
    protected static final short HAS_PROJECTION = 2048;
    protected static final short HAS_LOADER = 4096;
    protected static final short CAN_START_TX = 8192;
    protected static final short FOR_UPDATE = 16384;
    private static final String ID = "GetExecutorMessage";

    public GetExecutorMessage() {
        super(true);
    }

    public GetExecutorMessage(LocalRegion region, Object key, Object callbackArg, Object routingObject, RowFormatter targetFormat, int[] projectionFixedColumns, int[] projectionVarColumns, int[] projectionLobColumns, int[] projectionAllColumns, TXStateInterface tx, LanguageConnectionContext lcc, boolean forUpdate, boolean queryHDFS) {
        super(region, key, callbackArg, routingObject, tx != null && tx.getLockingPolicy().readCanStartTX(), tx, GetExecutorMessage.getTimeStatsSettings(lcc));
        int offsetBytes = targetFormat.getNumOffsetBytes();
        assert (offsetBytes > 0 && offsetBytes <= 4) : offsetBytes;
        this.targetFormat = targetFormat;
        this.projectionFixedColumns = projectionFixedColumns;
        this.projectionVarColumns = projectionVarColumns;
        this.projectionLobColumns = projectionLobColumns;
        this.projectionAllColumns = projectionAllColumns;
        this.targetFormatOffsetBytes = (byte)offsetBytes;
        this.hasProjection = projectionAllColumns != null;
        this.forUpdate = forUpdate;
        this.hasLoader = ((GemFireContainer)region.getUserAttribute()).getHasLoaderAnywhere();
        if (this.isTransactional() && !region.getScope().isLocal()) {
            this.canStartTX = this.getLockingPolicy().readCanStartTX() || this.forUpdate || this.hasLoader;
        }
        this.queryHDFS = queryHDFS;
    }

    protected GetExecutorMessage(GetExecutorMessage other) {
        super(other);
        this.targetFormat = other.targetFormat;
        this.projectionFixedColumns = other.projectionFixedColumns;
        this.projectionVarColumns = other.projectionVarColumns;
        this.projectionLobColumns = other.projectionLobColumns;
        this.projectionAllColumns = other.projectionAllColumns;
        this.targetFormatOffsetBytes = other.targetFormatOffsetBytes;
        this.hasProjection = other.hasProjection;
        this.forUpdate = other.forUpdate;
        this.hasLoader = other.hasLoader;
        this.canStartTX = other.canStartTX;
        this.queryHDFS = other.queryHDFS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object executeFunction(boolean enableStreaming, boolean isPossibleDuplicate, AbstractGemFireResultSet rs, boolean orderedReplies, boolean getResult) throws StandardException, SQLException {
        Object result;
        long start;
        CachePerfStats stats;
        block3: {
            stats = this.region.getCachePerfStats();
            start = stats.startGet();
            result = null;
            try {
                result = super.executeFunction(enableStreaming, isPossibleDuplicate, rs, orderedReplies, getResult);
                if (this.pr == null) break block3;
            }
            catch (Throwable throwable) {
                if (this.pr != null) {
                    this.pr.prStats.endGet(start);
                }
                stats.endGet(start, result == null);
                throw throwable;
            }
            this.pr.prStats.endGet(start);
        }
        stats.endGet(start, result == null);
        return result;
    }

    @Override
    protected void execute() throws GemFireCheckedException {
        boolean doLog = DistributionManager.VERBOSE | GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ;
        boolean forceUseOfPRExecutor = this.forceUseOfPRExecutor;
        this.forceUseOfPRExecutor = true;
        Object resultOneKey = GetExecutorMessage.executeOneKey(this, this.key, this.callbackArg, this.bucketId, this.pr, this.region, this.regionPath, this.isSecondaryCopy, this.hasProjection, this.targetFormat, this.projectionFixedColumns, this.projectionVarColumns, this.projectionAllColumns, this.projectionLobColumns, this.targetFormatOffsetBytes, forceUseOfPRExecutor, this.forUpdate, this.queryHDFS);
        if (resultOneKey != INVALID_RESULT) {
            if (doLog) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GetExecutorMessage: sending lastResult [" + resultOneKey + "] for region " + this.region.getFullPath() + " processorId=" + this.getProcessorId() + ", isSecondaryCopy=" + this.isSecondaryCopy));
            }
            boolean isPrimary = !this.isSecondaryCopy;
            try {
                this.lastResult(resultOneKey, isPrimary, isPrimary, true);
            }
            catch (RuntimeException re) {
                throw re;
            }
            finally {
                if (GemFireXDUtils.isOffHeapEnabled() && !this.isLocallyExecuted()) {
                    OffHeapReleaseUtil.freeOffHeapReference(resultOneKey);
                }
            }
        } else if (doLog) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GetExecutorMessage: Not sending lastResult now for region " + this.region.getFullPath() + " processorId=" + this.getProcessorId() + ", forceUseOfPRExecutor=" + forceUseOfPRExecutor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object executeOneKey(GfxdFunctionMessage<Object> gfxdFunctionMessage, Object key, Object callbackArg, int bucketId, PartitionedRegion pr, LocalRegion region, String regionPath, boolean isSecondaryCopy, boolean hasProjection, RowFormatter targetFormat, int[] projectionFixedColumns, int[] projectionVarColumns, int[] projectionAllColumns, int[] projectionLobColumns, byte targetFormatOffsetBytes, boolean forceUseOfPRExecutor, boolean forUpdate, boolean queryHDFS) throws GemFireCheckedException {
        Object result;
        Object val;
        String ID;
        TXStateInterface tx = gfxdFunctionMessage.getTXState();
        boolean doLog = DistributionManager.VERBOSE | GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ;
        boolean localExecution = gfxdFunctionMessage.isLocallyExecuted();
        String string = ID = doLog ? gfxdFunctionMessage.getShortClassName() + ".execute" : "";
        if (pr != null) {
            InternalDataView view;
            boolean doNotLockEntry;
            long startTime;
            long l = startTime = !localExecution ? pr.getPrStats().startPartitionMessageProcessing() : 0L;
            if (doLog) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(ID + " called for PR " + pr.getFullPath() + " forUpdate=" + forUpdate + " on key " + key + ", TX is " + tx + ", thread-local is " + TXManagerImpl.getCurrentTXState() + " ,queryHDFS=" + queryHDFS));
            }
            if (pr.getDataStore() == null) throw new InternalGemFireError(LocalizedStrings.GetMessage_GET_MESSAGE_SENT_TO_WRONG_MEMBER.toLocalizedString());
            if (bucketId < 0) {
                Assert.fail((Object)("unexpected bucketId=" + bucketId + " for PR " + pr));
            }
            if (forUpdate) {
                val = GetExecutorMessage.lockEntryForUpdate(region, pr, key, callbackArg, bucketId, tx, queryHDFS);
                doNotLockEntry = false;
            } else {
                view = pr.getDataView(tx);
                doNotLockEntry = !forceUseOfPRExecutor && !gfxdFunctionMessage.isDirectAck();
                val = view.getLocally(key, callbackArg, bucketId, (LocalRegion)pr, doNotLockEntry, localExecution, null, null, false, queryHDFS);
            }
            if (val == BucketRegion.RawValue.REQUIRES_ENTRY_LOCK) {
                Assert.assertTrue((boolean)doNotLockEntry);
                if (doLog) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(ID + ": Rescheduling execution due to possible cache-miss: " + gfxdFunctionMessage.toString()));
                }
                if (gfxdFunctionMessage.dm != null) {
                    gfxdFunctionMessage.schedule(gfxdFunctionMessage.dm);
                    return INVALID_RESULT;
                }
                view = pr.getDataView(tx);
                val = view.getLocally(key, callbackArg, bucketId, (LocalRegion)pr, false, localExecution, null, null, false, queryHDFS);
            }
            if (doLog) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(ID + ": sending value [" + val + "] back via ReplyMessage with processorId=" + gfxdFunctionMessage.getProcessorId()));
            }
            if (!localExecution) {
                pr.getPrStats().endPartitionMessagesProcessing(startTime);
            }
        } else {
            if (doLog) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(ID + " called for DR " + regionPath + " on key " + key + ", TX is " + tx + ", thread-local is " + TXManagerImpl.getCurrentTXState()));
            }
            if (forUpdate) {
                val = GetExecutorMessage.lockEntryForUpdate(region, null, key, callbackArg, 0, tx, queryHDFS);
            } else {
                InternalDataView view = region.getDataView(tx);
                val = view.getLocally(key, callbackArg, -1, region, false, localExecution, null, null, false, queryHDFS);
            }
            if (doLog) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(ID + ": sending value [" + val + "] for DR back via GetReplyMessage with processorId=" + gfxdFunctionMessage.getProcessorId()));
            }
        }
        boolean isPrimary = !isSecondaryCopy;
        ProjectionRow projRow = null;
        if (val instanceof BucketRegion.RawValue) {
            projRow = (ProjectionRow)val;
            val = projRow.getRawValue();
        }
        if (val != null && !Token.isInvalid((Object)val) && isPrimary) {
            boolean txCacheLoaded;
            boolean bl = txCacheLoaded = tx != null && projRow != null && projRow.isFromCacheLoader();
            if (txCacheLoaded) {
                result = projRow;
            } else if (hasProjection) {
                GemFireContainer container = (GemFireContainer)region.getUserAttribute();
                if (localExecution) {
                    try {
                        result = ProjectionRow.getCompactExecRow(val, container, targetFormat, projectionAllColumns, projectionLobColumns);
                    }
                    finally {
                        OffHeapHelper.release((Object)val);
                    }
                } else {
                    if (projRow == null) {
                        projRow = new ProjectionRow(val);
                    }
                    projRow.setProjectionInfo(container.getRowFormatter(val), projectionFixedColumns, projectionVarColumns, projectionLobColumns, targetFormatOffsetBytes);
                    result = projRow;
                }
            } else {
                result = val;
            }
        } else {
            result = isPrimary ? null : DUMMY_RESULT;
            OffHeapHelper.release((Object)val);
        }
        if (!doLog) return result;
        SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(ID + ": result [" + result + "] for region " + region.getFullPath() + ", processorId=" + gfxdFunctionMessage.getProcessorId() + ", isSecondaryCopy=" + isSecondaryCopy + ", key= " + key.toString() + ", bucketId= " + bucketId));
        return result;
    }

    private static Object lockEntryForUpdate(LocalRegion region, PartitionedRegion pr, Object key, Object callbackArg, int bucketId, TXStateInterface tx, boolean queryHDFS) {
        Object txes;
        if (tx == null) {
            throw new InternalGemFireError("SELECT FOR UPDATE invoked without a transaction");
        }
        Object dataRegion = pr != null ? pr.getDataRegionForRead(key, callbackArg, bucketId, Operation.GET) : region;
        try {
            txes = tx.lockEntry(null, key, callbackArg, region, dataRegion, true, queryHDFS, TXEntryState.getLockForUpdateOp(), 1);
        }
        catch (EntryNotFoundException enfe) {
            txes = null;
        }
        if (txes != null) {
            TXEntryState txs = (TXEntryState)txes;
            GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
            if (observer != null) {
                observer.lockingRowForTX(tx.getProxy(), (GemFireContainer)region.getUserAttribute(), txs.getUnderlyingRegionEntry(), true);
            }
            return txs.getRetainedValueInTXOrRegion();
        }
        return null;
    }

    public final boolean hasProjection() {
        return this.hasProjection;
    }

    @Override
    public final boolean isHA() {
        return true;
    }

    @Override
    public final boolean optimizeForWrite() {
        return false;
    }

    @Override
    protected boolean requiresTXFlushAfterExecution() {
        return this.hasLoader ? true : super.requiresTXFlushAfterExecution();
    }

    @Override
    protected GetExecutorMessage clone() {
        return new GetExecutorMessage(this);
    }

    @Override
    public final boolean canStartRemoteTransaction() {
        return this.canStartTX;
    }

    @Override
    public final int getMessageProcessorType() {
        if (!(this.forceUseOfPRExecutor || this.pendingTXId != null || this.hasLoader || this.canStartTX)) {
            return 74;
        }
        return 78;
    }

    @Override
    protected final short computeCompressedShort(short flags) {
        flags = super.computeCompressedShort(flags);
        if (this.hasProjection) {
            flags = (short)(flags | 0x800);
        }
        if (this.hasLoader) {
            flags = (short)(flags | 0x1000);
        }
        if (this.canStartTX) {
            flags = (short)(flags | 0x2000);
        }
        if (this.forUpdate) {
            flags = (short)(flags | 0x4000);
        }
        return flags;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        long beginTime = this.timeStatsEnabled ? XPLAINUtil.recordTiming(this.ser_deser_time == 0L ? (this.ser_deser_time = -1L) : -2L) : 0L;
        super.toData(out);
        if (this.hasProjection) {
            GetExecutorMessage.writeUIntArray(this.projectionFixedColumns, out);
            GetExecutorMessage.writeUIntArray(this.projectionVarColumns, out);
            GetExecutorMessage.writeUIntArray(this.projectionLobColumns, out);
            out.writeByte(this.targetFormatOffsetBytes);
        }
        out.writeBoolean(this.queryHDFS);
        if (beginTime != 0L) {
            this.ser_deser_time = XPLAINUtil.recordTiming(beginTime);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.ser_deser_time = this.timeStatsEnabled ? (long)(this.ser_deser_time == 0L ? -1 : -2) : 0L;
        super.fromData(in);
        short flags = this.flags;
        boolean bl = this.hasProjection = (flags & 0x800) != 0;
        if (this.hasProjection) {
            this.projectionFixedColumns = GetExecutorMessage.readIntArray(in);
            this.projectionVarColumns = GetExecutorMessage.readIntArray(in);
            this.projectionLobColumns = GetExecutorMessage.readIntArray(in);
            this.targetFormatOffsetBytes = in.readByte();
        }
        this.queryHDFS = in.readBoolean();
        this.hasLoader = (flags & 0x1000) != 0;
        this.canStartTX = (flags & 0x2000) != 0;
        boolean bl2 = this.forUpdate = (flags & 0x4000) != 0;
        if (this.timeStatsEnabled && this.ser_deser_time == -1L) {
            this.ser_deser_time = XPLAINUtil.recordStdTiming(this.getTimestamp());
        }
    }

    @Override
    public byte getGfxdID() {
        return 37;
    }

    static void writeUIntArray(int[] v, DataOutput out) throws IOException {
        if (v != null) {
            InternalDataSerializer.writeArrayLength((int)v.length, (DataOutput)out);
            for (int index = 0; index < v.length; ++index) {
                InternalDataSerializer.writeUnsignedVL((long)v[index], (DataOutput)out);
            }
        } else {
            InternalDataSerializer.writeArrayLength((int)-1, (DataOutput)out);
        }
    }

    static int[] readIntArray(DataInput in) throws IOException {
        int size = InternalDataSerializer.readArrayLength((DataInput)in);
        if (size != -1) {
            int[] v = new int[size];
            for (int index = 0; index < size; ++index) {
                v[index] = (int)InternalDataSerializer.readUnsignedVL((DataInput)in);
            }
            return v;
        }
        return null;
    }

    @Override
    protected String getID() {
        return ID;
    }

    @Override
    protected void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        if (this.hasProjection) {
            if (this.projectionFixedColumns != null) {
                sb.append(";projectionFixedColumns=").append(Arrays.toString(this.projectionFixedColumns));
            }
            if (this.projectionVarColumns != null) {
                sb.append(";projectionVarColumns=").append(Arrays.toString(this.projectionVarColumns));
            }
            if (this.projectionLobColumns != null) {
                sb.append(";projectionLobColumns=").append(Arrays.toString(this.projectionLobColumns));
            }
        }
        if (this.forUpdate) {
            sb.append(";forUpdate=true");
        }
        if (this.hasLoader) {
            sb.append(";hasLoader=true");
        }
        if (this.canStartTX) {
            sb.append(";canStartTX=true");
        }
        sb.append(";queryHDFS=").append(this.queryHDFS);
    }
}

