/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GfxdFunctionMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.MemberExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Set;

public final class StatementCloseExecutorMessage
extends MemberExecutorMessage<Object> {
    private final transient Set<DistributedMember> targetMembers;
    private long connectionId;
    private long statementId;

    public StatementCloseExecutorMessage() {
        super(true);
        this.targetMembers = null;
    }

    public StatementCloseExecutorMessage(ResultCollector<Object, Object> rc, Set<DistributedMember> members, long connectionId, long statementId) {
        super(rc, null, DistributionStats.enableClockStats, false);
        this.targetMembers = members;
        this.connectionId = connectionId;
        this.statementId = statementId;
    }

    protected StatementCloseExecutorMessage(StatementCloseExecutorMessage other) {
        super(other);
        this.targetMembers = other.targetMembers;
        this.connectionId = other.connectionId;
        this.statementId = other.statementId;
    }

    @Override
    protected void execute() throws SQLException {
        Long connId = this.connectionId;
        GfxdConnectionHolder connHolder = GfxdConnectionHolder.getHolder();
        GfxdConnectionWrapper wrapper = connHolder.getExistingWrapper(connId);
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("StatementCloseExecutorMessage: closing statement in Connection wrapper for statementId=" + this.statementId + " connectionId=" + connId + " : " + wrapper));
        }
        if (wrapper != null) {
            wrapper.closeStatement(this.statementId);
        }
        this.lastResult(Boolean.TRUE, false, false, true);
    }

    @Override
    public Set<DistributedMember> getMembers() {
        return this.targetMembers;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return false;
    }

    @Override
    protected boolean requiresTXFlushBeforeExecution() {
        return false;
    }

    @Override
    protected boolean requiresTXFlushAfterExecution() {
        return false;
    }

    @Override
    public void postExecutionCallback() {
    }

    @Override
    protected GfxdFunctionMessage<Object> clone() {
        return new StatementCloseExecutorMessage(this);
    }

    @Override
    public byte getGfxdID() {
        return 42;
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        GemFireXDUtils.writeCompressedHighLow(out, this.connectionId);
        GemFireXDUtils.writeCompressedHighLow(out, this.statementId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.connectionId = GemFireXDUtils.readCompressedHighLow(in);
        this.statementId = GemFireXDUtils.readCompressedHighLow(in);
    }
}

