/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdListResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.ResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.message.ProjectionRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import java.util.List;

public class OffHeapReleaseUtil {
    public static void freeOffHeapReference(ResultHolder holder) {
        if (holder != null) {
            holder.freeOffHeapForCachedRowsAndCloseResultSet();
        }
    }

    public static void freeOffHeapReference(Object offheapHolder) {
        if (offheapHolder != null) {
            Class<?> oclass = offheapHolder.getClass();
            if (oclass == ResultHolder.class) {
                ((ResultHolder)offheapHolder).freeOffHeapForCachedRowsAndCloseResultSet();
            } else {
                if (oclass == byte[].class || oclass == byte[][].class) {
                    return;
                }
                if (oclass == ProjectionRow.class) {
                    ProjectionRow projRow = (ProjectionRow)offheapHolder;
                    Object rawVal = projRow.getRawValue();
                    OffHeapHelper.release((Object)rawVal);
                } else if (OffHeapByteSource.isOffHeapBytesClass(oclass)) {
                    ((OffHeapByteSource)((Object)offheapHolder)).release();
                } else if (oclass == GfxdListResultCollector.ListResultCollectorValue.class) {
                    Object result = ((GfxdListResultCollector.ListResultCollectorValue)offheapHolder).resultOfSingleExecution;
                    if (result instanceof List) {
                        OffHeapReleaseUtil.freeOffHeapReference((List)result);
                    } else {
                        OffHeapReleaseUtil.freeOffHeapReference(result);
                    }
                } else if (List.class.isAssignableFrom(oclass)) {
                    OffHeapReleaseUtil.freeOffHeapReference((List)offheapHolder);
                }
            }
        }
    }

    public static void freeOffHeapReference(List<?> resultList) {
        for (Object result : resultList) {
            OffHeapReleaseUtil.freeOffHeapReference(result);
        }
    }
}

