/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.GemFireCheckedException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.AbstractOperationMessage;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gnu.trove.THashSet;
import com.gemstone.gnu.trove.TLongHashSet;
import com.pivotal.gemfirexd.internal.engine.GfxdSerializable;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLRegionQueue;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdReplyMessageProcessor;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdWaitingReplyProcessor;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public abstract class GfxdMessage
extends AbstractOperationMessage
implements GfxdSerializable {
    protected boolean possibleDuplicate;
    protected transient Timestamp construct_time;
    protected transient long ser_deser_time;
    protected long process_time;
    protected transient long member_mapping_time;
    protected transient short mapping_retry_count;
    protected transient boolean lastResultSent;

    public final int getDSFID() {
        return -20;
    }

    public abstract byte getGfxdID();

    protected GfxdMessage() {
    }

    protected GfxdMessage(TXStateInterface tx, boolean timeStatsEnabled) {
        super(tx);
        this.timeStatsEnabled = timeStatsEnabled;
        this.construct_time = this.timeStatsEnabled ? XPLAINUtil.currentTimeStamp() : null;
    }

    protected GfxdMessage(GfxdMessage other) {
        super((AbstractOperationMessage)other);
        this.construct_time = this.timeStatsEnabled ? XPLAINUtil.currentTimeStamp() : null;
        this.setPossibleDuplicate(other.isPossibleDuplicate());
    }

    protected final void beforeToData(DataOutput out) throws IOException {
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        Timestamp timestamp = this.construct_time = this.timeStatsEnabled ? XPLAINUtil.currentTimeStamp() : null;
        if ((this.flags & 8) != 0) {
            this.possibleDuplicate = true;
        }
    }

    protected short computeCompressedShort(short flags) {
        if (this.possibleDuplicate) {
            flags = (short)(flags | 8);
        }
        return flags;
    }

    protected final void setProcessorId(int id) {
        this.processorId = id;
    }

    public final boolean isPossibleDuplicate() {
        return this.possibleDuplicate;
    }

    protected final void setPossibleDuplicate(boolean posDup) {
        this.possibleDuplicate = posDup;
    }

    protected int getMessageProcessorType() {
        return 77;
    }

    public final int getProcessorType() {
        return this.processorType == 0 ? this.getMessageProcessorType() : this.processorType;
    }

    public void setProcessorType(boolean isReaderThread) {
        if (isReaderThread && this.getMessageProcessorType() != 77) {
            this.processorType = 77;
        }
    }

    public static GfxdWaitingReplyProcessor getReplyProcessor(InternalDistributedSystem system, Set<DistributedMember> members, boolean ignoreNodeDown) {
        DM dm = system.getDistributionManager();
        GfxdWaitingReplyProcessor processor = new GfxdWaitingReplyProcessor(dm, members, ignoreNodeDown, false);
        return processor;
    }

    public final void send(InternalDistributedSystem system, Set<DistributedMember> members, boolean ignoreNodeDown) throws StandardException, SQLException {
        if (members == null) {
            members = GfxdMessage.getOtherServers();
        }
        if (members.size() > 0) {
            GfxdWaitingReplyProcessor processor = GfxdMessage.getReplyProcessor(system, members, ignoreNodeDown);
            this.setRecipients(members);
            this.send(system, system.getDistributionManager(), processor, true, false);
        }
    }

    public final void send(InternalDistributedSystem system, Set<DistributedMember> members) throws StandardException, SQLException {
        this.send(system, members, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send(InternalDistributedSystem system, DM dm, GfxdReplyMessageProcessor processor, boolean ack, boolean toSelf) throws StandardException, SQLException {
        this.setProcessorId(processor.getProcessorId());
        InternalDistributedMember[] members = null;
        if (this.forAll() || (members = this.getRecipients()).length > 0) {
            Set failures;
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.getClass().getSimpleName() + "#send: sending message [" + this.toString() + "] to recipients " + this.getRecipientsString(members)));
            }
            if ((failures = dm.putOutgoing((DistributionMessage)this)) != null && !failures.isEmpty() && processor.isExpectingDirectReply()) {
                throw new GemFireXDRuntimeException((Throwable)new ForceReattemptException("Failed sending <" + this + ">"));
            }
        }
        ReplyException re = null;
        try {
            block15: {
                try {
                    this.beforeWaitForReplies(processor, toSelf);
                }
                catch (ReplyException ex) {
                    if (!ack) break block15;
                    re = ex;
                }
            }
            if (ack) {
                processor.waitForReplies();
            }
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.getClass().getSimpleName() + "#send: done for GemFireXD message [" + this.toString() + "] with toSelf=" + toSelf + " for recipients " + this.getRecipientsString(members)));
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            Misc.checkIfCacheClosing(ie);
            re = new ReplyException((Throwable)ie);
        }
        catch (ReplyException ex) {
            re = ex;
        }
        finally {
            if (re != null) {
                this.handleReplyException(this.toString(), re, processor);
            }
        }
    }

    protected final String getRecipientsString(InternalDistributedMember[] recipients) {
        return recipients != null ? Arrays.toString(recipients) : "ALL";
    }

    protected void beforeWaitForReplies(GfxdReplyMessageProcessor processor, boolean toSelf) throws ReplyException {
    }

    protected void handleFromDataExceptionCheckCancellation(Throwable t) throws CancelException {
        Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(t);
    }

    protected void handleReplyException(String exPrefix, ReplyException ex, GfxdReplyMessageProcessor processor) throws SQLException, StandardException {
        Map<DistributedMember, ReplyException> exceptions = processor.getReplyExceptions();
        if (exceptions != null) {
            for (ReplyException replyEx : exceptions.values()) {
                this.handleProcessorReplyException(exPrefix, replyEx);
            }
        }
        this.handleProcessorReplyException(exPrefix, ex);
    }

    protected final void handleUnexpectedReplyException(String exPrefix, ReplyException replyEx) throws SQLException, StandardException {
        if (GemFireXDUtils.TraceFunctionException) {
            SanityManager.DEBUG_PRINT((String)"TraceFunctionException", (String)(exPrefix + ": unexpected exception"), (Throwable)replyEx);
        }
        GemFireXDRuntimeException.throwSQLOrRuntimeException(this.toString() + ": unexpected exception", replyEx.getCause());
    }

    protected void handleProcessorReplyException(String exPrefix, ReplyException replyEx) throws SQLException, StandardException {
        Throwable t = replyEx.getCause();
        if (!GemFireXDUtils.retryToBeDone(t)) {
            this.handleUnexpectedReplyException(exPrefix, replyEx);
        }
    }

    /*
     * Exception decompiling
     */
    protected final void basicProcess(DistributionManager dm) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void endMessage() {
    }

    protected void preProcessMessage(DistributionManager dm) {
    }

    protected abstract void processMessage(DistributionManager var1) throws GemFireCheckedException;

    protected abstract void sendReply(ReplyException var1, DistributionManager var2);

    protected boolean blockExecutionForLastBatchDDLReplay() {
        return false;
    }

    protected abstract boolean waitForNodeInitialization();

    public void reset() {
        super.reset();
        this.possibleDuplicate = false;
    }

    public static Set<DistributedMember> getOtherMembers() {
        Set<DistributedMember> members = GfxdMessage.getAllGfxdMembers();
        InternalDistributedMember myId = Misc.getMyId();
        members.remove(myId);
        return members;
    }

    public static Set<DistributedMember> getDataStores() {
        return GemFireXDUtils.getGfxdAdvisor().adviseDataStores(null);
    }

    public static Set<DistributedMember> getOtherServers() {
        Set<DistributedMember> members = GfxdMessage.getAllGfxdServers();
        InternalDistributedMember myId = Misc.getMyId();
        members.remove(myId);
        return members;
    }

    public static Set<DistributedMember> getAllGfxdMembers() {
        return GemFireXDUtils.getGfxdAdvisor().adviseAllNodes(null);
    }

    public static Set<DistributedMember> getAllGfxdServers() {
        return GemFireXDUtils.getGfxdAdvisor().adviseOperationNodes(null);
    }

    public static Set<DistributedMember> getAllDSMembers() {
        THashSet members = new THashSet((Collection)Misc.getDistributedSystem().getDistributionManager().getDistributionManagerIdsIncludingAdmin());
        InternalDistributedMember myId = Misc.getMyId();
        members.add(myId);
        return members;
    }

    public static Set<DistributedMember> getAllDataStores() {
        return GemFireXDUtils.getGfxdAdvisor().adviseDataStores(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isOKToSkip(long ddlQueueId) {
        Object sync;
        GemFireStore memStore = Misc.getMemStore();
        Object object = sync = memStore.getInitialDDLReplaySync();
        synchronized (object) {
            GfxdDDLRegionQueue ddlQ;
            while (!memStore.initialDDLReplayInProgress() && !memStore.initialDDLReplayDone() && (ddlQ = memStore.getDDLQueueNoThrow()) != null && ddlQ.isInitialized()) {
                try {
                    sync.wait(500L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    Misc.checkIfCacheClosing(ie);
                }
            }
        }
        memStore.acquireDDLReplayLock(false);
        try {
            TLongHashSet processedIds;
            TLongHashSet tLongHashSet = processedIds = memStore.getProcessedDDLIDs();
            synchronized (tLongHashSet) {
                if (processedIds.contains(ddlQueueId)) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = !memStore.initialDDLReplayDone();
            return bl;
        }
        finally {
            memStore.releaseDDLReplayLock(false);
        }
    }

    public static void logWarnings(Statement stmt, String sqlText, String prefix, LogWriter logger) throws SQLException {
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            if (logger.warningEnabled()) {
                logger.warning(prefix + sqlText + " " + warning.getMessage(), null);
            }
            while ((warning = warning.getNextWarning()) != null) {
                if (!logger.warningEnabled()) continue;
                logger.warning(prefix + sqlText + " " + warning.getMessage(), null);
            }
        }
    }

    protected static GfxdConnectionWrapper getExistingWrapper(long connId) {
        return GfxdConnectionHolder.getHolder().getExistingWrapper(connId);
    }

    protected void appendFields(StringBuilder sb) {
        sb.append(";posDup=").append(this.possibleDuplicate);
    }
}

