/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.pivotal.gemfirexd.internal.engine.distributed.OffHeapReleaseUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class GfxdListResultCollector
extends ArrayList<Object>
implements ResultCollector<Object, Object> {
    private static final long serialVersionUID = -9058302896893928570L;
    private final Object ignoreToken;
    private final boolean getMemberInformation;
    protected boolean throwException = false;

    public GfxdListResultCollector() {
        this.ignoreToken = null;
        this.getMemberInformation = false;
    }

    public GfxdListResultCollector(Object ignoreToken, boolean memberInformation) {
        this.ignoreToken = ignoreToken;
        this.getMemberInformation = memberInformation;
    }

    public void addResult(DistributedMember memberID, Object resultOfSingleExecution) {
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultCollector received result from member " + memberID + ": " + (resultOfSingleExecution == null ? "null" : resultOfSingleExecution)));
        }
        if (this.ignoreToken != null && this.ignoreToken.equals(resultOfSingleExecution)) {
            return;
        }
        if (GemFireXDUtils.TraceFunctionException && resultOfSingleExecution instanceof Throwable) {
            this.throwException = true;
            SanityManager.DEBUG_PRINT((String)"TraceFunctionException", (String)("ResultCollector received unexpected throwable in addResult from member " + memberID), (Throwable)((Throwable)resultOfSingleExecution));
        }
        if (this.getMemberInformation) {
            this.add(new ListResultCollectorValue(resultOfSingleExecution, memberID));
        } else {
            this.add(resultOfSingleExecution);
        }
    }

    public ArrayList<Object> getResult() throws FunctionException {
        if (GemFireXDUtils.TraceFunctionException && this.throwException) {
            throw new AssertionError((Object)"unexpected Throwable ");
        }
        return this;
    }

    public ArrayList<Object> getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
        throw new AssertionError((Object)"getResult with timeout not expected to be invoked for GemFireXD");
    }

    public void clearResults() {
        if (GemFireXDUtils.isOffHeapEnabled()) {
            Iterator resultsIter = this.iterator();
            while (resultsIter.hasNext()) {
                Object obj = resultsIter.next();
                OffHeapReleaseUtil.freeOffHeapReference(obj);
                resultsIter.remove();
            }
        } else {
            this.clear();
        }
    }

    public void endResults() {
    }

    public static final class ListResultCollectorValue {
        public final Object resultOfSingleExecution;
        public final DistributedMember memberID;

        private ListResultCollectorValue(Object r, DistributedMember m) {
            this.resultOfSingleExecution = r;
            this.memberID = m;
        }
    }
}

