/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gnu.trove.TObjectIntHashMap;
import com.gemstone.gnu.trove.TObjectIntProcedure;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdQueryResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.ReferencedKeyCheckerMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.util.concurrent.atomic.AtomicInteger;

public final class GfxdDistributedDeleteResultCollector
extends GfxdQueryResultCollector {
    private static final long serialVersionUID = -284948494861032158L;
    private boolean hasReferencedKeys;
    private boolean waitForReferencedKeyResults;
    private volatile TObjectIntHashMap memberProcessorIds;
    private int numExpectedResults;
    private final AtomicInteger numDeletes;
    private GemFireTransaction tran;

    public GfxdDistributedDeleteResultCollector(boolean hasReferencedKeys, GemFireTransaction gtxn) {
        super(0);
        this.hasReferencedKeys = hasReferencedKeys && (gtxn == null || !gtxn.isTransactional());
        this.tran = gtxn;
        this.numDeletes = new AtomicInteger(0);
    }

    @Override
    public void setProcessor(ReplyProcessor21 processor) {
        if (GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.toString() + ": initial members: " + processor.membersToString()));
        }
        processor.startWait();
    }

    @Override
    public void setNumRecipients(int n) {
        if (this.hasReferencedKeys) {
            if (n <= 1) {
                this.waitForReferencedKeyResults = false;
                this.memberProcessorIds = null;
            } else {
                this.waitForReferencedKeyResults = true;
                this.memberProcessorIds = new TObjectIntHashMap();
            }
        } else {
            this.waitForReferencedKeyResults = false;
            this.memberProcessorIds = null;
        }
        this.numExpectedResults = n;
        if (GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.toString() + ": expected number of results = " + n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResult(DistributedMember member, Object resultOfSingleExecution) {
        if (resultOfSingleExecution instanceof Integer) {
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(this.toString() + "#addResult: adding result=" + resultOfSingleExecution + '(' + (this.memberProcessorIds != null ? "PROCESSORID" : "NUMDELETES") + ") from member: " + member));
            }
            int v = (Integer)resultOfSingleExecution;
            if (this.memberProcessorIds != null) {
                GfxdDistributedDeleteResultCollector gfxdDistributedDeleteResultCollector = this;
                synchronized (gfxdDistributedDeleteResultCollector) {
                    if (this.memberProcessorIds != null) {
                        if (this.memberProcessorIds.putIfAbsent((Object)member, v, Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                            this.signalDeletesAtEndOfReferenceKeyCheck();
                        }
                    } else {
                        this.numDeletes.addAndGet(v);
                    }
                }
            } else {
                this.numDeletes.addAndGet(v);
            }
            this.helper.addResultMember(member);
        } else {
            super.addResult(member, resultOfSingleExecution);
        }
    }

    @Override
    public Integer getResult() throws FunctionException, ReplyException {
        super.getResult();
        return this.numDeletes.get();
    }

    @Override
    protected void addExceptionFromMember(Throwable t, DistributedMember member) {
        super.addExceptionFromMember(t, member);
        if (this.memberProcessorIds != null) {
            this.memberProcessorIds.put((Object)member, -1);
            this.signalDeletesAtEndOfReferenceKeyCheck();
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(this.toString() + "#addExceptionFromMember: added -1 expected processorId due to exception " + t + " from member " + member));
            }
        } else if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(this.toString() + "#addExceptionFromMember: received exception " + t + " from member " + member + " waitForReferencedKeyResults=" + this.waitForReferencedKeyResults));
        }
    }

    @Override
    protected void clearData() {
        super.clearData();
        if (this.memberProcessorIds != null) {
            this.memberProcessorIds = new TObjectIntHashMap();
        }
        this.numExpectedResults = 0;
        this.numDeletes.set(0);
    }

    private void signalDeletesAtEndOfReferenceKeyCheck() {
        assert (Thread.holdsLock(this)) : "expected synchronized on 'this'";
        if (this.memberProcessorIds.size() >= this.numExpectedResults) {
            if (GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.toString() + ": signalling delete at end of reference check for " + this.memberProcessorIds.toString()));
            }
            final DM dm = Misc.getDistributedSystem().getDM();
            final boolean success = this.functionException == null;
            this.memberProcessorIds.forEachEntry(new TObjectIntProcedure(){

                public final boolean execute(Object m, int procId) {
                    if (procId != -1) {
                        if (GemFireXDUtils.TraceQuery) {
                            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.toString() + ": sending reference check end to " + m));
                        }
                        ReferencedKeyCheckerMessage.ReferencedKeyReplyMessage.send((InternalDistributedMember)m, procId, dm, success);
                    }
                    return true;
                }
            });
            this.memberProcessorIds = null;
        }
    }

    @Override
    public GfxdResultCollector<Object> cloneCollector() {
        return new GfxdDistributedDeleteResultCollector(this.hasReferencedKeys, this.tran);
    }
}

