/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.AbstractOperationMessage;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.ddl.DDLConflatable;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLRegion;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Set;

public final class GfxdDDLFinishMessage
extends GfxdMessage {
    private DDLConflatable ddlStatement;
    private long connId;
    private long id;
    private long sequenceId;
    private boolean doCommit;

    public static void send(InternalDistributedSystem system, Set<DistributedMember> members, DDLConflatable ddl, long connId, long ddlId, long sequenceId, boolean commitOrRollback) throws StandardException, SQLException {
        GfxdDDLFinishMessage msg = new GfxdDDLFinishMessage();
        msg.ddlStatement = ddl;
        msg.connId = connId;
        msg.id = ddlId;
        msg.sequenceId = sequenceId;
        msg.doCommit = commitOrRollback;
        msg.send(system, members);
    }

    @Override
    protected void processMessage(DistributionManager dm) {
        GfxdDDLMessage ddlMsg;
        String actionEnd;
        String actionStart;
        if (this.doCommit) {
            actionStart = " commit";
            actionEnd = " committed";
        } else {
            actionStart = " rollback";
            actionEnd = " rolled back";
        }
        if (GemFireXDUtils.TraceDDLReplay) {
            SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)(this.toString() + " Received" + actionStart));
        }
        if (this.doCommit) {
            GfxdDDLFinishMessage.doPutInDDLRegion(this.id, this.ddlStatement, this.sequenceId, "GfxdDDLFinishMessage:");
        }
        if ((ddlMsg = GfxdDDLMessage.removePendingDDLMessage(this.id)) == null || ddlMsg.args.getUniqueConnId() == -1L) {
            if (GemFireXDUtils.TraceDDLQueue) {
                SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)(this.toString() + " Returning after local put since GfxdDDLMessage was not executed on this node"));
            }
            return;
        }
        GfxdConnectionWrapper wrapper = null;
        boolean[] markUnused = new boolean[]{false};
        try {
            wrapper = GfxdDDLFinishMessage.getExistingWrapper(this.connId);
            GfxdDDLFinishMessage.doCommitOrRollback(wrapper, this.doCommit, (DM)dm, this.id, this.toString() + " Successfully" + actionEnd, markUnused);
        }
        catch (SQLException ex) {
            Throwable cause;
            String matchStr = "08006.D".substring(0, "08006.D".indexOf(46));
            if (ex.getSQLState().indexOf(matchStr) != -1) {
                return;
            }
            LogWriter logger = dm.getLoggerI18n().convertToLogWriter();
            if (logger.warningEnabled()) {
                logger.warning(this.toString() + " SQL exception in" + actionStart, (Throwable)ex);
            }
            if ((cause = StandardException.getJavaException(ex, ex.getSQLState())) == null) {
                cause = Misc.wrapSQLException(ex, ex);
            }
            throw new ReplyException("Unexpected SQLException on member " + dm.getDistributionManagerId(), cause);
        }
        finally {
            if (wrapper != null && markUnused[0]) {
                wrapper.markUnused();
            }
        }
    }

    static void doPutInDDLRegion(Long ddlId, DDLConflatable ddl, long sequenceId, String logStr) {
        block5: {
            DDLConflatable schemaDDL = ddl.getImplicitSchema();
            if (schemaDDL != null) {
                GfxdDDLFinishMessage.doPutInDDLRegion(schemaDDL.getId(), schemaDDL, ddl.getImplicitSchemaSequenceId(), logStr);
            }
            try {
                LocalRegion ddlRegion = Misc.getGemFireCache().getRegionByPathForProcessing("_DDL_STMTS_META_REGION");
                if (ddlRegion != null && !ddlRegion.getImageState().getInRecovery()) {
                    long startPut = CachePerfStats.getStatTime();
                    EntryEventImpl event = ddlRegion.newUpdateEntryEvent((Object)ddlId, (Object)new GfxdDDLRegion.RegionValue(ddl, sequenceId), null);
                    event.setOriginRemote(true);
                    ddlRegion.validatedPut(event, startPut);
                }
            }
            catch (Throwable t) {
                Error err;
                if (t instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t))) {
                    SystemFailure.initiateFailure((Error)err);
                    throw err;
                }
                SystemFailure.checkFailure();
                GemFireCacheImpl cache = Misc.getGemFireCache();
                cache.getCancelCriterion().checkCancelInProgress(t);
                LogWriter logger = cache.getLogger();
                if (!logger.warningEnabled()) break block5;
                logger.warning(logStr + " unexpected exception in local put on DDL region for " + ddl, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doCommitOrRollback(GfxdConnectionWrapper wrapper, boolean doCommit, DM dm, long ddlId, String logString, boolean[] markUnused) throws SQLException {
        if (wrapper != null) {
            EmbedConnection conn = wrapper.getConnectionForSynchronization();
            Object object = conn.getConnectionSynchronization();
            synchronized (object) {
                int syncVersion = wrapper.convertToHardReference(conn);
                LanguageConnectionContext lcc = wrapper.getLanguageConnectionContext();
                int oldFlags = lcc.getFlags();
                lcc.setPossibleDuplicate(false);
                ((GemFireTransaction)lcc.getTransactionExecute()).clearActiveTXState(true, false);
                try {
                    if (doCommit) {
                        conn.internalCommit();
                    } else {
                        try {
                            conn.internalRollback();
                        }
                        finally {
                            lcc.cleanupNestedTransactionExecute();
                        }
                    }
                    if (!Misc.isSnappyHiveMetaTable(lcc.getCurrentSchemaName())) {
                        SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)logString);
                    }
                }
                finally {
                    wrapper.disableOpLogger();
                    lcc.setFlags(oldFlags);
                    markUnused[0] = wrapper.convertToSoftReference(syncVersion);
                }
            }
        }
    }

    @Override
    protected void sendReply(ReplyException ex, DistributionManager dm) {
        ReplyMessage.send((InternalDistributedMember)this.getSender(), (int)this.processorId, (ReplyException)ex, (ReplySender)dm, (AbstractOperationMessage)this);
    }

    @Override
    protected boolean blockExecutionForLastBatchDDLReplay() {
        return true;
    }

    @Override
    protected boolean waitForNodeInitialization() {
        return false;
    }

    @Override
    public byte getGfxdID() {
        return 3;
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        InternalDataSerializer.invokeToData((DataSerializableFixedID)this.ddlStatement, (DataOutput)out);
        out.writeLong(this.connId);
        out.writeLong(this.id);
        out.writeLong(this.sequenceId);
        out.writeBoolean(this.doCommit);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.ddlStatement = new DDLConflatable();
        InternalDataSerializer.invokeFromData((DataSerializableFixedID)this.ddlStatement, (DataInput)in);
        this.connId = in.readLong();
        this.id = in.readLong();
        this.sequenceId = in.readLong();
        this.doCommit = in.readBoolean();
    }

    @Override
    protected void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append("; connectionID=").append(this.connId).append("; statementID=").append(this.id).append("; statement=").append(this.ddlStatement).append("; sequenceId=").append(this.sequenceId).append("; doCommit=").append(this.doCommit);
    }
}

