/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl;

import com.pivotal.gemfirexd.callbacks.AsyncEventHelper;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.callbacks.TableMetaData;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.JavaObjectsList;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.DVDStoreResultSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RawStoreResultSet;
import com.pivotal.gemfirexd.internal.engine.store.RawStoreResultSetWithByteSource;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.SingleColumnLongResultSet;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractEventImpl
implements Event {
    private ResultSet newRow;
    private ResultSet oldRow;
    private final Event.Type type;
    private final boolean isOriginRemote;
    private int[] updateColsIndex;
    private transient GemFireContainer container;
    private transient RowFormatter formatter;

    public AbstractEventImpl(Event.Type type, boolean isOriginRemote) {
        this.type = type;
        this.isOriginRemote = isOriginRemote;
    }

    @Override
    @Deprecated
    public List<Object> getNewRow() {
        Object newVal = this.getNewValue();
        return this.prepareValue(newVal);
    }

    @Override
    public ResultSet getNewRowsAsResultSet() {
        if (this.newRow == null) {
            if (this.type == Event.Type.BEFORE_UPDATE || this.type == Event.Type.AFTER_UPDATE) {
                GemFireContainer.SerializableDelta delta = this.getSerializableDelta();
                GemFireContainer container = this.getContainer();
                assert (container.isByteArrayStore());
                this.newRow = new DVDStoreResultSet(delta.getChangedRow(), -1, container.getCurrentRowFormatter(), delta.getChangedColumns(), null);
                return this.newRow;
            }
            Object newVal = this.getNewValue();
            if (newVal != null) {
                assert (this.getContainer().isByteArrayStore());
                assert (!(newVal instanceof OffHeapByteSource));
                if (newVal.getClass() == byte[].class) {
                    byte[] row = (byte[])newVal;
                    this.newRow = new RawStoreResultSet(row, this.getRowFormatter(row));
                    return this.newRow;
                }
                byte[][] row = (byte[][])newVal;
                this.newRow = new RawStoreResultSet(row, this.getRowFormatter(row));
                return this.newRow;
            }
            return null;
        }
        return this.newRow;
    }

    @Override
    @Deprecated
    public List<Object> getOldRow() {
        Object oldVal = this.getOldValue();
        return this.prepareValue(oldVal);
    }

    private List<Object> prepareValue(Object value) {
        if (value == null) {
            return null;
        }
        GemFireContainer container = this.getContainer();
        assert (container.isByteArrayStore());
        int size = container.getNumColumns();
        Class<?> valClass = value.getClass();
        if (valClass == byte[].class) {
            return new JavaObjectsList.BytesJavaObjectsList(size, (byte[])value, container);
        }
        if (valClass == byte[][].class) {
            return new JavaObjectsList.BytesJavaObjectsList(size, (byte[][])value, container);
        }
        if (valClass == OffHeapRow.class) {
            return new JavaObjectsList.BytesJavaObjectsList(size, ((OffHeapRow)((Object)value)).getRowBytes(), container);
        }
        if (valClass == OffHeapRowWithLobs.class) {
            return new JavaObjectsList.BytesJavaObjectsList(size, ((OffHeapRowWithLobs)((Object)value)).getRowByteArrays(), container);
        }
        return new JavaObjectsList.DVDArrayJavaObjectsList((DataValueDescriptor[])value);
    }

    @Override
    public ResultSet getOldRowAsResultSet() {
        if (this.oldRow == null) {
            Object oldVal = this.getOldValue();
            if (oldVal != null) {
                assert (this.getContainer().isByteArrayStore());
                Class<?> oldValClass = oldVal.getClass();
                if (oldValClass == byte[].class) {
                    byte[] row = (byte[])oldVal;
                    this.oldRow = new RawStoreResultSet(row, this.getRowFormatter(row));
                    return this.oldRow;
                }
                if (oldValClass == byte[][].class) {
                    byte[][] row = (byte[][])oldVal;
                    this.oldRow = new RawStoreResultSet(row, this.getRowFormatter(row));
                    return this.oldRow;
                }
                if (oldValClass == OffHeapRow.class) {
                    byte[] row = ((OffHeapRow)((Object)oldVal)).getRowBytes();
                    this.oldRow = new RawStoreResultSet(row, this.getRowFormatter(row));
                    return this.oldRow;
                }
                byte[][] row = ((OffHeapRowWithLobs)((Object)oldVal)).getRowByteArrays();
                this.oldRow = new RawStoreResultSet(row, this.getRowFormatter(row));
                return this.oldRow;
            }
            return null;
        }
        return this.oldRow;
    }

    @Override
    public TableMetaData getResultSetMetaData() {
        return this.getContainer().getCurrentRowFormatter().getMetaData();
    }

    @Override
    public int[] getModifiedColumns() {
        if (this.updateColsIndex == null && (this.type == Event.Type.AFTER_UPDATE || this.type == Event.Type.BEFORE_UPDATE)) {
            GemFireContainer.SerializableDelta delta = this.getSerializableDelta();
            FormatableBitSet fbs = delta.getChangedColumns();
            int numChangedColumns = fbs.getNumBitsSet();
            this.updateColsIndex = new int[numChangedColumns];
            int index = 0;
            int colIndex = fbs.anySetBit();
            while (colIndex >= 0) {
                this.updateColsIndex[index] = colIndex + 1;
                colIndex = fbs.anySetBit(colIndex);
                ++index;
            }
        }
        return this.updateColsIndex;
    }

    @Override
    public Event.Type getType() {
        return this.type;
    }

    @Override
    public boolean isOriginRemote() {
        return this.isOriginRemote;
    }

    @Override
    public boolean hasParameters() {
        return false;
    }

    @Override
    public String getSchemaName() {
        return this.getContainer().getSchemaName();
    }

    @Override
    public String getTableName() {
        return this.getContainer().getQualifiedTableName();
    }

    @Override
    public int getTableSchemaVersion() {
        return this.getContainer().getCurrentSchemaVersion();
    }

    @Override
    public boolean tableHasAutogeneratedColumns() {
        return this.getContainer().getExtraTableInfo().hasAutoGeneratedColumns();
    }

    public final GemFireContainer getContainer() {
        GemFireContainer container = this.container;
        if (container != null) {
            return container;
        }
        this.container = this.getGemFireContainer();
        return this.container;
    }

    protected final RowFormatter getRowFormatter(byte[] rowBytes) {
        if (this.formatter != null) {
            return this.formatter;
        }
        this.formatter = this.getContainer().getRowFormatter(rowBytes);
        return this.formatter;
    }

    protected final RowFormatter getRowFormatter(OffHeapByteSource rowBytes) {
        if (this.formatter != null) {
            return this.formatter;
        }
        this.formatter = this.getContainer().getRowFormatter(rowBytes);
        return this.formatter;
    }

    protected final RowFormatter getRowFormatter(byte[][] rowBytes) {
        if (this.formatter != null) {
            return this.formatter;
        }
        this.formatter = this.getContainer().getRowFormatter(rowBytes[0]);
        return this.formatter;
    }

    public abstract Object getNewValue();

    public abstract Object getOldValue();

    protected abstract GemFireContainer getGemFireContainer();

    public abstract GemFireContainer.SerializableDelta getSerializableDelta();

    @Override
    public Object[] getPrimaryKey() {
        Object[] retVal = null;
        Object key = this.extractKey();
        try {
            if (key instanceof RegionKey) {
                RegionKey rk = (RegionKey)key;
                int size = rk.nCols();
                retVal = new Object[size];
                rk.getKeyColumns(retVal);
            } else {
                retVal = new Object[]{key};
            }
        }
        catch (Exception e) {
            throw GemFireXDRuntimeException.newRuntimeException("exception encountered while retrieving primary key for event =" + this.toString(), e);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeysAsResultSet() {
        Object key = this.extractKey();
        Class<?> cls = key.getClass();
        if (cls == CompactCompositeRegionKey.class) {
            CompactCompositeRegionKey ccrk = (CompactCompositeRegionKey)key;
            ExtraTableInfo tableInfo = ccrk.getTableInfo();
            RowFormatter pkFormatter = tableInfo.getPrimaryKeyFormatter();
            byte[] kbytes = ccrk.getKeyBytes();
            if (kbytes != null) {
                return new RawStoreResultSet(kbytes, pkFormatter);
            }
            Object vbytes = ccrk.getValueByteSource();
            if (vbytes != null) {
                Class<?> vclass = vbytes.getClass();
                if (vclass == byte[].class) {
                    byte[] row = (byte[])vbytes;
                    return new RawStoreResultSet(row, this.getRowFormatter(row), tableInfo.getPrimaryKeyColumns(), pkFormatter.getMetaData());
                }
                if (vclass == byte[][].class) {
                    byte[][] row = (byte[][])vbytes;
                    return new RawStoreResultSet(row, this.getRowFormatter(row), tableInfo.getPrimaryKeyColumns(), pkFormatter.getMetaData());
                }
                OffHeapByteSource bs = (OffHeapByteSource)((Object)vbytes);
                try {
                    RawStoreResultSetWithByteSource rawStoreResultSetWithByteSource = new RawStoreResultSetWithByteSource(bs, this.getRowFormatter(bs), tableInfo.getPrimaryKeyColumns(), pkFormatter.getMetaData());
                    return rawStoreResultSetWithByteSource;
                }
                finally {
                    bs.release();
                }
            }
            return new RawStoreResultSet((byte[])null, this.getRowFormatter((byte[])null), tableInfo.getPrimaryKeyColumns(), pkFormatter.getMetaData());
        }
        if (cls == Long.class) {
            return new SingleColumnLongResultSet((Long)key);
        }
        throw new UnsupportedOperationException("unknown key [" + key + "] class: " + cls.getName());
    }

    @Override
    public String getDMLString() {
        String dmlString;
        block9: {
            dmlString = "";
            String tableName = this.getTableName();
            try {
                switch (this.getType()) {
                    case AFTER_INSERT: 
                    case BEFORE_INSERT: {
                        TableMetaData metadata = this.getResultSetMetaData();
                        dmlString = AsyncEventHelper.getInsertString(tableName, metadata, false);
                        break;
                    }
                    case AFTER_UPDATE: 
                    case BEFORE_UPDATE: {
                        ResultSet rows = this.getNewRowsAsResultSet();
                        ResultSetMetaData metadata = rows.getMetaData();
                        ResultSet pkResultSet = this.getPrimaryKeysAsResultSet();
                        ResultSetMetaData pkMetaData = pkResultSet.getMetaData();
                        dmlString = AsyncEventHelper.getUpdateString(tableName, pkMetaData, metadata);
                        break;
                    }
                    case AFTER_DELETE: 
                    case BEFORE_DELETE: {
                        ResultSet pkResultSet = this.getPrimaryKeysAsResultSet();
                        ResultSetMetaData pkMetaData = pkResultSet.getMetaData();
                        dmlString = AsyncEventHelper.getDeleteString(tableName, pkMetaData);
                        break;
                    }
                    case BULK_DML: {
                        dmlString = this.toString();
                        break;
                    }
                    case BULK_INSERT: {
                        dmlString = this.toString();
                        break;
                    }
                    default: {
                        dmlString = this.toString();
                        break;
                    }
                }
            }
            catch (SQLException e) {
                if (!Misc.getCacheLogWriter().infoEnabled()) break block9;
                Misc.getCacheLogWriter().info("AbstractEventImpl##getDMLString::" + e.getMessage());
            }
        }
        return dmlString;
    }

    public abstract Object extractKey();

    public String toString() {
        StringBuilder sb = new StringBuilder("old row = ");
        sb.append(this.getOldRowAsResultSet());
        sb.append("; new row = ");
        sb.append(this.getNewRowsAsResultSet());
        sb.append("; Table Name = ");
        sb.append(this.getTableName());
        return sb.toString();
    }
}

