/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.db;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;

public class IndexPersistenceStats {
    public static final String typeName = "IndexPersistenceStats";
    private static final StatisticsType type;
    protected static int indexLoadTimeId;
    protected static int nodeStartTimeId;
    protected static final String INDEX_LOAD_TIME = "IndexLoadTime";
    protected static final String NODE_START_TIME = "NodeStartTime";
    private Statistics stats;

    public void init(StatisticsFactory f) {
        this.stats = f.createAtomicStatistics(type, typeName);
    }

    public void close() {
        this.stats.close();
    }

    public void endIndexLoad(long start) {
        long ts = System.currentTimeMillis();
        long elapsed = ts - start;
        this.stats.incLong(indexLoadTimeId, elapsed);
    }

    public void endNodeUp(long start) {
        long ts = System.currentTimeMillis();
        long elapsed = ts - start;
        this.stats.incLong(nodeStartTimeId, elapsed);
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        type = f.createType(typeName, "Stats for loading from Persisted index file", new StatisticDescriptor[]{f.createLongGauge(INDEX_LOAD_TIME, "Time taken to load index from persisted files.", "milliseconds", false), f.createLongGauge(NODE_START_TIME, "Time taken to start a node.", "milliseconds", false)});
        indexLoadTimeId = type.nameToId(INDEX_LOAD_TIME);
        nodeStartTimeId = type.nameToId(NODE_START_TIME);
    }
}

