/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.db;

import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.db.Database;
import com.pivotal.gemfirexd.internal.iapi.db.DatabaseContext;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextImpl;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;

final class DatabaseContextImpl
extends ContextImpl
implements DatabaseContext {
    private final Database db;

    DatabaseContextImpl(ContextManager cm, Database db) {
        super(cm, "Database");
        this.db = db;
    }

    @Override
    public void cleanupOnError(Throwable t) {
        if (!(t instanceof StandardException)) {
            return;
        }
        StandardException se = (StandardException)t;
        if (se.getSeverity() < 40000) {
            return;
        }
        this.popMe();
        GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
        if (se.getSeverity() == 45000 && (cache == null || cache.getCancelCriterion().cancelInProgress() != null)) {
            ContextService.getFactory().notifyAllActiveThreads(this);
            Monitor.getMonitor().shutdown(this.db);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof DatabaseContext) {
            return ((DatabaseContextImpl)other).db == this.db;
        }
        return false;
    }

    public int hashCode() {
        return this.db.hashCode();
    }

    @Override
    public Database getDatabase() {
        return this.db;
    }
}

