/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import java.io.IOException;

public class AsyncQueueDropOperation
extends MemOperation {
    private final String id;

    public AsyncQueueDropOperation(String id) {
        super(null);
        this.id = id;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        GemFireCacheImpl cache = Misc.getGemFireCache();
        AsyncEventQueue asyncQueue = cache.getAsyncEventQueue(this.id);
        if (asyncQueue != null) {
            try {
                cache.removeAsyncEventQueue(asyncQueue);
                asyncQueue.destroy();
            }
            catch (Exception ex) {
                throw StandardException.newException("X0Z22.S", ex, (Object)this.id, (Object)ex.toString());
            }
        }
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        throw new UnsupportedOperationException("AsyncQueueDropOperation: undo unimplemented; require GFE queue rename support");
    }
}

