/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.index;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CustomEvictionAttributes;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.EvictionCriteria;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.execute.InternalRegionFunctionContext;
import com.gemstone.gemfire.internal.cache.partitioned.PREntriesIterator;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalHashIndexController;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalHashIndexScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalIndexCustomEvictionCriteria;
import com.pivotal.gemfirexd.internal.engine.access.index.Hash1IndexCostController;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndex;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexController;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexCostController;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexScanController;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import java.util.Properties;

public final class GlobalHashIndex
extends MemIndex {
    @Override
    protected void allocateMemory(Properties properties, int tmpFlag) throws StandardException {
        PartitionAttributesFactory pafact = new PartitionAttributesFactory();
        RegionAttributes ra = this.baseContainer.getRegionAttributes();
        PartitionAttributes pa = ra.getPartitionAttributes();
        if (pa == null) {
            throw StandardException.newException("X0Z15.S", (Object)this.baseContainer.getQualifiedTableName(), (Object)("creating global index (region attributes: " + ra + ')'));
        }
        if (properties.containsKey("caseSensitive")) {
            throw StandardException.newException("0A000.S.24", "primary/unique key constraint");
        }
        AttributesFactory afact = new AttributesFactory();
        if (ra.getDataPolicy().withHDFS()) {
            LogWriterI18n log = InternalDistributedSystem.getLoggerI18n();
            CustomEvictionAttributes cea = ra.getCustomEvictionAttributes();
            if (cea == null && ra.getDataPolicy().withPersistence() && Version.GFXD_13.compareTo(GemFireXDUtils.getCurrentDDLVersion()) < 0) {
                if (log.fineEnabled()) {
                    log.fine("Creating global index without HDFS storage for table " + this.baseContainer.getTableName());
                }
                afact.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                GemFireCacheImpl gfi = Misc.getMemStore().getGemFireCache();
                ra = gfi.setEvictionAttributesForLargeRegion(ra);
            } else {
                afact.setDataPolicy(ra.getDataPolicy());
                afact.setHDFSStoreName(ra.getHDFSStoreName());
                afact.setHDFSWriteOnly(ra.getHDFSWriteOnly());
                GlobalIndexCustomEvictionCriteria ec = new GlobalIndexCustomEvictionCriteria();
                afact.setCustomEvictionAttributes((EvictionCriteria)ec, 0L, 0L);
            }
            if (ra.getDataPolicy().withPersistence()) {
                afact.setDiskStoreName(ra.getDiskStoreName());
                afact.setDiskSynchronous(ra.isDiskSynchronous());
                EvictionAttributes evictAttrs = ra.getEvictionAttributes();
                if (evictAttrs != null && evictAttrs.getAction().isOverflowToDisk()) {
                    afact.setEvictionAttributes(evictAttrs);
                }
            }
        } else if (ra.getDataPolicy().withPersistence()) {
            afact.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
            afact.setDiskStoreName(ra.getDiskStoreName());
            afact.setDiskSynchronous(ra.isDiskSynchronous());
            EvictionAttributes evictAttrs = ra.getEvictionAttributes();
            if (evictAttrs != null && evictAttrs.getAction().isOverflowToDisk()) {
                afact.setEvictionAttributes(evictAttrs);
            }
        } else {
            afact.setDataPolicy(DataPolicy.PARTITION);
        }
        pafact.setLocalMaxMemory(pa.getLocalMaxMemory());
        pafact.setTotalNumBuckets(pa.getTotalNumBuckets());
        pafact.setRedundantCopies(pa.getRedundantCopies());
        pafact.setRecoveryDelay(pa.getRecoveryDelay());
        afact.setPartitionAttributes(pafact.create());
        afact.setConcurrencyLevel(ra.getConcurrencyLevel());
        afact.setInitialCapacity(ra.getInitialCapacity());
        afact.setConcurrencyChecksEnabled(ra.getConcurrencyChecksEnabled());
        properties.put("GEMFIRE_REGION_ATTRIBUTES", afact.create());
        properties.put("baseConglomerateId", this.baseContainer.getId());
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String getIndexTypeName() {
        return "GlobalHashIndex";
    }

    @Override
    protected MemIndexCostController newMemIndexCostController() {
        Hash1IndexCostController retval = new Hash1IndexCostController();
        return retval;
    }

    @Override
    protected MemIndexScanController newMemIndexScanController() {
        GlobalHashIndexScanController retval = new GlobalHashIndexScanController();
        return retval;
    }

    @Override
    protected MemIndexController newMemIndexController() {
        GlobalHashIndexController retval = new GlobalHashIndexController();
        return retval;
    }

    @Override
    public int getTypeFormatId() {
        throw new UnsupportedOperationException("not storable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpIndex(String marker) {
        if (marker == null) {
            marker = "Global hash index iteration";
        }
        PartitionedRegion region = (PartitionedRegion)this.container.getRegion();
        String idMark = " [ID: " + this.baseContainer.getId() + ']';
        SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)("##### For GlobalHashIndex " + this.container + idMark + " Region " + region + marker + " begin #####"));
        PREntriesIterator irl = (PREntriesIterator)region.getSharedDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, false, false, true, (LocalRegion)region);
        String lineSep = SanityManager.lineSeparator;
        StringBuilder sb = new StringBuilder().append(lineSep);
        while (irl.hasNext()) {
            RowLocation rl = (RowLocation)irl.next();
            sb.append("\tkey=");
            ArrayUtils.objectString((Object)rl.getKey(), (StringBuilder)sb);
            sb.append(", value=");
            BucketRegion br = irl.getHostedBucketRegion();
            Object v = ((RegionEntry)rl).getValueOffHeapOrDiskWithoutFaultIn((LocalRegion)br);
            try {
                ArrayUtils.objectStringNonRecursive((Object)v, (StringBuilder)sb);
            }
            finally {
                OffHeapHelper.release((Object)v);
            }
            sb.append(", bucketId=");
            sb.append(br.getId());
            sb.append(", isPrimary=");
            sb.append(br.getBucketAdvisor().isPrimary());
            sb.append(lineSep);
            if (sb.length() <= 0x400000) continue;
            SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)sb.toString());
            sb.setLength(0);
        }
        SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)sb.toString());
        SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)("##### For GlobalHashIndex " + this.container + idMark + " Region " + region + marker + " end #####"));
    }
}

