/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.index;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.locks.LockingPolicy;
import com.gemstone.gemfire.internal.concurrent.ConcurrentSkipListMap;
import com.gemstone.gemfire.internal.concurrent.FetchFromMap;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.index.OpenMemIndex;
import com.pivotal.gemfirexd.internal.engine.access.index.SortedMap2IndexScanController;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionSingleKeyExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class ContainsUniqueKeyExecutorMessage
extends RegionSingleKeyExecutorMessage
implements FetchFromMap {
    private int[] referenceKeyColumnIndexes;
    private transient Object mapKey;
    private transient int keyVersion;

    public ContainsUniqueKeyExecutorMessage() {
        super(true);
    }

    public ContainsUniqueKeyExecutorMessage(LocalRegion refregion, int[] refKeyColumnIndexes, Object indexKey, Object routingObject, TXStateInterface tx, LanguageConnectionContext lcc) {
        super(refregion, indexKey, null, routingObject, false, tx, ContainsUniqueKeyExecutorMessage.getTimeStatsSettings(lcc));
        this.referenceKeyColumnIndexes = refKeyColumnIndexes;
    }

    protected ContainsUniqueKeyExecutorMessage(ContainsUniqueKeyExecutorMessage other) {
        super(other);
        this.referenceKeyColumnIndexes = other.referenceKeyColumnIndexes;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    protected ContainsUniqueKeyExecutorMessage clone() {
        return new ContainsUniqueKeyExecutorMessage(this);
    }

    @Override
    public final boolean canStartRemoteTransaction() {
        return this.getLockingPolicy().readOnlyCanStartTX();
    }

    @Override
    public boolean isHA() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsKey(TXStateInterface tx, LocalRegion lr, int[] referenceKeyColumnIndexes, Object indexKey, Object callbackArg, FetchFromMap fetch) throws Exception {
        boolean containsKey = false;
        GfxdIndexManager idmanager = (GfxdIndexManager)lr.getIndexUpdater();
        List<GemFireContainer> localIndexContainers = idmanager.getIndexContainers();
        if (localIndexContainers != null && !localIndexContainers.isEmpty()) {
            for (GemFireContainer indexContainer : localIndexContainers) {
                Object ckey;
                CompactCompositeIndexKey mapKey;
                TXId rlTXId;
                int[] indexKeyPositions;
                if (!indexContainer.isLocalIndex() || !indexContainer.isUniqueIndex() || (indexKeyPositions = indexContainer.getBaseColumnPositions()).length != referenceKeyColumnIndexes.length || !Arrays.equals(indexKeyPositions, referenceKeyColumnIndexes)) continue;
                ConcurrentSkipListMap<Object, Object> map = indexContainer.getSkipListMap();
                RowLocation rl = (RowLocation)map.get(OpenMemIndex.newLocalKeyObject(indexKey, indexContainer), fetch, null);
                if (rl != null && (rlTXId = rl.getTXId()) != null) {
                    rl = SortedMap2IndexScanController.AbstractRowLocationIterator.isRowLocationValidForTransaction(rl, rlTXId, tx, 0x800000);
                }
                CompactCompositeIndexKey compactCompositeIndexKey = mapKey = (ckey = fetch.getCurrentKey()) != null && ckey.getClass() == CompactCompositeIndexKey.class ? (CompactCompositeIndexKey)ckey : null;
                if (rl == null) break;
                containsKey = true;
                boolean requalify = false;
                Object val = null;
                if (tx != null) {
                    LocalRegion dataRegion;
                    Object key;
                    RegionEntry re = rl.getUnderlyingRegionEntry();
                    if (tx.lockEntry(re, key = rl.getKey(), callbackArg, lr, dataRegion = lr.getDataRegionForRead(key, null, rl.getBucketID(), Operation.GET_ENTRY), false, false, TXEntryState.getReadOnlyOp(), 1) == null) {
                        containsKey = false;
                    } else if (mapKey != null) {
                        if (rl.isUpdateInProgress()) {
                            requalify = true;
                            val = rl.getValueWithoutFaultIn(idmanager.getContainer());
                        } else {
                            ((RegionEntry)rl).getValueAsToken();
                            requalify = mapKey.getVersion() != fetch.getCurrentNodeVersion();
                            if (requalify) {
                                val = rl.getValueWithoutFaultIn(idmanager.getContainer());
                            }
                        }
                    }
                } else if (mapKey != null && rl.isUpdateInProgress()) {
                    requalify = true;
                    val = rl.getValueWithoutFaultIn(idmanager.getContainer());
                }
                if (!containsKey || !requalify || val == null || val instanceof Token) break;
                try {
                    boolean result = mapKey.equalsValueBytes(val);
                    GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
                    if (observer != null) {
                        observer.afterIndexRowRequalification(result, mapKey, null, null);
                    }
                    break;
                }
                finally {
                    OffHeapHelper.release((Object)val);
                }
            }
        } else {
            throw new IllegalStateException("expected at least one index for the table using region: " + lr.getFullPath());
        }
        return containsKey;
    }

    @Override
    protected void execute() throws Exception {
        TXStateInterface tx = this.getTXState();
        boolean containsKey = ContainsUniqueKeyExecutorMessage.existsKey(tx, this.region, this.referenceKeyColumnIndexes, this.key, this.callbackArg, this);
        if (this.isSecondaryCopy) {
            this.lastResult(DUMMY_RESULT, false, false, true);
        } else {
            this.lastResult(containsKey, false, true, true);
        }
    }

    public void setMapKey(Object key, int version) {
        this.mapKey = key;
        this.keyVersion = version;
    }

    public Object getCurrentKey() {
        return this.mapKey;
    }

    public int getCurrentNodeVersion() {
        return this.keyVersion;
    }

    @Override
    public final int getMessageProcessorType() {
        return this.pendingTXId == null && this.getLockingPolicy() == LockingPolicy.NONE ? 74 : 78;
    }

    @Override
    public byte getGfxdID() {
        return 38;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        long begintime = this.timeStatsEnabled ? XPLAINUtil.recordTiming(this.ser_deser_time == 0L ? (this.ser_deser_time = -1L) : -2L) : 0L;
        super.toData(out);
        DataSerializer.writeIntArray((int[])this.referenceKeyColumnIndexes, (DataOutput)out);
        if (begintime != 0L) {
            this.ser_deser_time = XPLAINUtil.recordTiming(begintime);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.ser_deser_time = this.timeStatsEnabled ? (long)(this.ser_deser_time == 0L ? -1 : -2) : 0L;
        this.referenceKeyColumnIndexes = DataSerializer.readIntArray((DataInput)in);
        if (this.timeStatsEnabled && this.ser_deser_time == -1L) {
            this.ser_deser_time = XPLAINUtil.recordStdTiming(this.getTimestamp());
        }
    }

    @Override
    protected void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append(";refColumnIndexes=").append(Arrays.toString(this.referenceKeyColumnIndexes));
    }
}

