/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.ConglomerateFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import java.util.Properties;

public abstract class MemConglomerateFactory
implements ConglomerateFactory,
ModuleControl {
    private final String formatUUIDString;
    private UUID formatUUID;
    private final String primaryId;
    private final String secondaryId;
    private final int factoryId;

    protected MemConglomerateFactory(String formatUUIDString, String primaryId, String secondaryId, int factoryId) {
        this.formatUUIDString = formatUUIDString;
        this.primaryId = primaryId;
        this.secondaryId = secondaryId;
        this.factoryId = factoryId;
    }

    @Override
    public final Properties defaultProperties() {
        return new Properties();
    }

    @Override
    public final boolean supportsImplementation(String implementationId) {
        return implementationId.equals(this.primaryId) || this.secondaryId != null && implementationId.equals(this.secondaryId);
    }

    @Override
    public final String primaryImplementationType() {
        return this.primaryId;
    }

    @Override
    public final boolean supportsFormat(UUID formatId) {
        return formatId.equals(this.formatUUID);
    }

    @Override
    public final UUID primaryFormat() {
        return this.formatUUID;
    }

    @Override
    public final int getConglomerateFactoryId() {
        return this.factoryId;
    }

    @Override
    public final boolean canSupport(String identifier, Properties startParams) {
        String impl = startParams.getProperty("gemfirexd.access.Conglomerate.type");
        if (impl == null) {
            return false;
        }
        return this.supportsImplementation(impl);
    }

    @Override
    public final void boot(boolean create, Properties startParams) throws StandardException {
        UUIDFactory uuidFactory = Monitor.getMonitor().getUUIDFactory();
        this.formatUUID = uuidFactory.recreateUUID(this.formatUUIDString);
    }

    @Override
    public final void stop() {
    }

    @Override
    public abstract MemConglomerate createConglomerate(TransactionManager var1, int var2, long var3, DataValueDescriptor[] var5, ColumnOrdering[] var6, int[] var7, Properties var8, int var9) throws StandardException;

    @Override
    public final MemConglomerate readConglomerate(TransactionManager xact_manager, ContainerKey containerKey) throws StandardException {
        return Misc.getMemStore().findConglomerate(containerKey);
    }
}

