/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.IsolationLevel;
import com.gemstone.gemfire.cache.TransactionFlag;
import com.gemstone.gemfire.internal.cache.Checkpoint;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.partitioned.Bucket;
import com.gemstone.gemfire.internal.shared.SystemProperties;
import com.gemstone.gnu.trove.TIntArrayList;
import com.gemstone.gnu.trove.TLongObjectHashMap;
import com.gemstone.gnu.trove.TLongObjectIterator;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.BackingStoreHashTableFromScan;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransactionContext;
import com.pivotal.gemfirexd.internal.engine.access.GfxdTXStateProxy;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerateController;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerateFactory;
import com.pivotal.gemfirexd.internal.engine.access.MemScanController;
import com.pivotal.gemfirexd.internal.engine.access.operations.ContainerCreateOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.ContainerDropOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.db.FabricDatabase;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.AbstractDBSynchronizerMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdDRWLockService;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLocalLockService;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockSet;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockable;
import com.pivotal.gemfirexd.internal.engine.raw.log.MemLogger;
import com.pivotal.gemfirexd.internal.engine.raw.store.FileStreamInputOutput;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.offheap.ArrayOHAddressCache;
import com.pivotal.gemfirexd.internal.engine.store.offheap.LinkedListOHAddressCache;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OHAddressCache;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapOHAddressCache;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapResourceHolder;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.Serviceable;
import com.pivotal.gemfirexd.internal.iapi.services.io.DynamicByteArrayOutputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.io.Storable;
import com.pivotal.gemfirexd.internal.iapi.services.locks.LockFactory;
import com.pivotal.gemfirexd.internal.iapi.services.locks.LockOwner;
import com.pivotal.gemfirexd.internal.iapi.services.property.PersistentSet;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.BackingStoreHashtable;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.DatabaseInstant;
import com.pivotal.gemfirexd.internal.iapi.store.access.DynamicCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.FileResource;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowLocationRetRowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortController;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortCostController;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortObserver;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.StoreCostController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.access.XATransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Conglomerate;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.MethodFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.ScanControllerRowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.ScanManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Sort;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.SortFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.GlobalTransactionId;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Loggable;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.iapi.store.raw.StreamContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.data.DataFactory;
import com.pivotal.gemfirexd.internal.iapi.store.raw.data.RawContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogFactory;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.TransactionId;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.ConglomerateUtil;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.ArraySorter;
import com.pivotal.gemfirexd.internal.impl.store.raw.xact.GlobalXactId;
import com.pivotal.gemfirexd.internal.impl.store.raw.xact.TransactionTable;
import com.pivotal.gemfirexd.internal.impl.store.raw.xact.XactId;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public final class GemFireTransaction
extends RawTransaction
implements XATransactionController,
TransactionManager,
OffHeapResourceHolder {
    private String transName;
    private final OHAddressCache ownerlessAddressesToFree;
    private final Set<OffHeapResourceHolder> owners;
    private LanguageConnectionContext lcc;
    private final GfxdLockSet lockSet;
    private final LogFactory logFactory;
    private MemLogger logger;
    private final DataValueFactory dataValueFactory;
    private GemFireTransactionContext context;
    private final GemFireTransaction parentTran;
    private GemFireTransaction childTran;
    private GemFireTransaction childTranUpd;
    private final ArrayList<ScanManager> scanControllers;
    private final ArrayList<MemConglomerateController> conglomerateControllers;
    private ArrayList<Sort> sorts;
    private ArrayList<SortController> sortControllers;
    private TIntArrayList freeSortIds;
    private TLongObjectHashMap tempCongloms;
    private static AtomicLong nextTempConglomId = new AtomicLong(-1L);
    private static final AtomicLong currTranId = new AtomicLong(0L);
    private final long myId;
    private long ddlId;
    private TransactionId myXactId;
    private boolean skipLocks;
    private boolean skipLocksOnConnection;
    private boolean needLogging;
    protected int state;
    private static final String USER_CONTEXT_ID = "UserTransaction";
    protected static final int CLOSED = 0;
    protected static final int IDLE = 1;
    protected static final int ACTIVE = 2;
    private static final int COMMIT_SYNC = 65536;
    private static final int COMMIT_NO_SYNC = 131072;
    private final TXManagerImpl txManager;
    private TXStateInterface txState;
    private GfxdTXStateProxy txProxy;
    private IsolationLevel isolationLevel;
    private TXStateInterface txStateSuspended;
    private IsolationLevel isolationSuspended;
    private final Long connectionID;
    private TXManagerImpl.TXContext txContextFromPrepareStage;
    private boolean prepared;
    private PartitionedRegion.RecoveryLock regionRecoveryLock = null;
    private TXId nextTxID;
    private boolean implicitSnapshotTxStarted;
    private static final boolean ARRAY_OH_ADDRESS_CACHE = SystemProperties.getServerInstance().getBoolean("ArrayOHAddressCache", false);
    private static final boolean LINKED_LIST_OH_ADDRESS_CACHE = SystemProperties.getServerInstance().getBoolean("LinkedListOHAddressCache", false);
    private static final boolean OFF_HEAP_OH_ADDRESS_CACHE = !ARRAY_OH_ADDRESS_CACHE && !LINKED_LIST_OH_ADDRESS_CACHE;

    private GemFireTransaction(String name, GemFireTransaction parentTransaction, boolean skipLocks, GfxdLockSet compatibilitySpace, long connectionID, boolean isTxExecute) throws StandardException {
        this.transName = name;
        this.parentTran = parentTransaction;
        this.scanControllers = new ArrayList();
        this.conglomerateControllers = new ArrayList();
        FabricDatabase db = Misc.getMemStore().getDatabase();
        this.logFactory = db.getLogFactory();
        this.dataValueFactory = db.getDataValueFactory();
        this.connectionID = connectionID;
        this.sorts = null;
        this.freeSortIds = null;
        this.sortControllers = null;
        if (GemFireXDUtils.isOffHeapEnabled()) {
            this.ownerlessAddressesToFree = GemFireTransaction.createOHAddressCache();
            this.owners = new HashSet<OffHeapResourceHolder>();
        } else {
            this.ownerlessAddressesToFree = null;
            this.owners = null;
        }
        this.myId = currTranId.incrementAndGet();
        if (parentTransaction != null) {
            this.tempCongloms = parentTransaction.tempCongloms;
            this.skipLocks = parentTransaction.skipLocks;
            this.skipLocksOnConnection = parentTransaction.skipLocksOnConnection;
        } else {
            this.tempCongloms = null;
        }
        this.lockSet = compatibilitySpace == null ? new GfxdLockSet(parentTransaction != null ? parentTransaction.getLockSpace().getOwner() : new DistributedTXLockOwner(this.myId), Misc.getMemStore().getDDLLockService()) : compatibilitySpace;
        this.skipLocks = skipLocks;
        if (isTxExecute) {
            this.txManager = Misc.getGemFireCache().getCacheTransactionManager();
            TXStateInterface tx = TXManagerImpl.getCurrentTXState();
            this.setTXState(tx);
            this.isolationLevel = tx != null ? tx.getIsolationLevel() : IsolationLevel.NONE;
        } else {
            this.txManager = null;
            this.setTXState(null);
            this.isolationLevel = IsolationLevel.NONE;
        }
        this.isolationSuspended = IsolationLevel.NONE;
    }

    public static OHAddressCache createOHAddressCache() {
        if (OFF_HEAP_OH_ADDRESS_CACHE) {
            return new OffHeapOHAddressCache();
        }
        if (ARRAY_OH_ADDRESS_CACHE) {
            return new ArrayOHAddressCache();
        }
        if (LINKED_LIST_OH_ADDRESS_CACHE) {
            return new LinkedListOHAddressCache();
        }
        throw new IllegalStateException("expected one of the OHAddressCache constants to be set");
    }

    @Override
    public final LanguageConnectionContext getLanguageConnectionContext() {
        if (this.lcc != null) {
            return this.lcc;
        }
        this.lcc = (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
        return this.lcc;
    }

    public static LanguageConnectionContext getLanguageConnectionContext(GemFireTransaction tran) {
        if (tran != null) {
            return tran.getLanguageConnectionContext();
        }
        return Misc.getLanguageConnectionContext();
    }

    @Override
    public final void setLanguageConnectionContext(LanguageConnectionContext lcc) {
        this.lcc = lcc;
    }

    private void closeControllers(boolean closeHeldControllers) throws StandardException {
        ArrayList<Sort> sorts;
        ArrayList<SortController> sortControllers;
        int i;
        if (!this.scanControllers.isEmpty()) {
            for (i = this.scanControllers.size() - 1; i >= 0; --i) {
                ScanManager sc = this.scanControllers.get(i);
                sc.closeForEndTransaction(true);
                if (i < this.scanControllers.size()) continue;
                i = this.scanControllers.size() - 1;
            }
            if (closeHeldControllers) {
                this.scanControllers.clear();
            }
        }
        if (!this.conglomerateControllers.isEmpty()) {
            for (i = this.conglomerateControllers.size() - 1; i >= 0; --i) {
                ConglomerateController cc = this.conglomerateControllers.get(i);
                cc.closeForEndTransaction(true);
            }
            if (closeHeldControllers) {
                this.conglomerateControllers.clear();
            }
        }
        if ((sortControllers = this.sortControllers) != null) {
            if (closeHeldControllers) {
                for (int i2 = sortControllers.size() - 1; i2 >= 0; --i2) {
                    SortController sc = sortControllers.get(i2);
                    sc.completedInserts();
                }
            }
            this.sortControllers = null;
        }
        if ((sorts = this.sorts) != null) {
            if (closeHeldControllers) {
                for (int i3 = sorts.size() - 1; i3 >= 0; --i3) {
                    Sort sort = sorts.get(i3);
                    if (sort == null) continue;
                    sort.drop(this);
                }
            }
            this.sorts = null;
        }
        this.freeSortIds = null;
    }

    public final MemConglomerate findExistingConglomerate(long conglomId) throws StandardException {
        return GemFireTransaction.findExistingConglomerate(conglomId, this.lcc, this);
    }

    public static MemConglomerate findExistingConglomerate(long conglomId, LanguageConnectionContext lcc, GemFireTransaction tran) throws StandardException {
        MemConglomerate conglom = GemFireTransaction.findConglomerate(conglomId, lcc, tran);
        if (conglom != null) {
            return conglom;
        }
        GemFireStore store = Misc.getMemStore();
        GfxdDRWLockService lockService = store.getDDLLockService();
        lockService.dumpAllRWLocks("LOCK TABLE at the time of missing conglomerate [" + conglomId + "]", true, false, true);
        StringBuilder sb = new StringBuilder("Conglomerate Dump").append(SanityManager.lineSeparator);
        for (ConglomerateDescriptor cd : store.getDatabase().getDataDictionary().getAllConglomerateDescriptors()) {
            sb.append(cd.toString()).append(SanityManager.lineSeparator);
        }
        SanityManager.DEBUG_PRINT((String)"DumpConglomerates", (String)sb.toString());
        throw StandardException.newException("XSAI2.S", conglomId);
    }

    public final MemConglomerate findConglomerate(long conglomId) throws StandardException {
        return GemFireTransaction.findConglomerate(conglomId, this.lcc, this);
    }

    public static MemConglomerate findConglomerate(long conglomId, LanguageConnectionContext lcc, GemFireTransaction tran) throws StandardException {
        if (conglomId >= 0L) {
            return Misc.getMemStore().findConglomerate(ContainerKey.valueOf(0L, conglomId));
        }
        MemConglomerate tempconglom = null;
        if (tran.tempCongloms != null) {
            tempconglom = (MemConglomerate)tran.tempCongloms.get(conglomId);
        }
        if (tempconglom == null) {
            tempconglom = lcc.getConglomerateForDeclaredGlobalTempTable(conglomId);
        }
        return tempconglom;
    }

    private MemConglomerateController openConglomerate(MemConglomerate conglom, boolean hold, int open_mode, int lock_level, int isolation_level, StaticCompiledOpenConglomInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        if ((open_mode & Short.MIN_VALUE) != 0) {
            SanityManager.THROWASSERT((String)("Bad open mode to openConglomerate: 0x" + Integer.toHexString(open_mode)));
        }
        SanityManager.ASSERT((conglom != null ? 1 : 0) != 0);
        if (lock_level != 6 && lock_level != 7) {
            SanityManager.THROWASSERT((String)("Bad lock level to openConglomerate:" + lock_level));
        }
        return this.openConglomerateController(conglom, open_mode, lock_level, null);
    }

    private MemConglomerateController openConglomerateController(MemConglomerate conglomerate, int openMode, int lockLevel, LockingPolicy locking) throws StandardException {
        MemConglomerateController cc;
        int conglomType = conglomerate.getType();
        for (int index = 0; index < this.conglomerateControllers.size(); ++index) {
            cc = this.conglomerateControllers.get(index);
            if (!cc.isClosed() || conglomType != cc.getType()) continue;
            cc.init(this, conglomerate, openMode, lockLevel, locking);
            return cc;
        }
        cc = conglomerate.open(this, openMode, lockLevel, locking);
        this.conglomerateControllers.add(cc);
        return cc;
    }

    private MemScanController openScan(MemConglomerate conglom, boolean hold, int open_mode, int lock_level, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, StaticCompiledOpenConglomInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info, Activation act) throws StandardException {
        if ((open_mode & 0xFF0FCF3B) != 0) {
            SanityManager.THROWASSERT((String)("Bad open mode to openScan: 0x" + Integer.toHexString(open_mode)));
        }
        if (!(lock_level == 6 | lock_level == 7)) {
            SanityManager.THROWASSERT((String)("Bad lock level to openScan:" + lock_level));
        }
        return this.openScanController(conglom, hold, open_mode, lock_level, isolation_level, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, static_info, dynamic_info, act);
    }

    @Override
    public void addColumnToConglomerate(long conglomId, int column_id, Storable template_column, int collation_id) throws StandardException {
        MemConglomerate conglom = this.findExistingConglomerate(conglomId);
        MemConglomerateController cc = this.openConglomerateController(conglom, 4, 7, null);
        conglom.addColumn(this, column_id, template_column, collation_id);
        cc.close();
    }

    @Override
    public StaticCompiledOpenConglomInfo getStaticCompiledConglomInfo(long conglomId) throws StandardException {
        return this.findExistingConglomerate(conglomId).getStaticCompiledConglomInfo(this, conglomId);
    }

    @Override
    public DynamicCompiledOpenConglomInfo getDynamicCompiledConglomInfo(long conglomId) throws StandardException {
        return null;
    }

    private int countCreatedSorts() {
        int numSorts = 0;
        if (this.sortControllers != null) {
            for (int index = 0; index < this.sortControllers.size(); ++index) {
                SortController sc = this.sortControllers.get(index);
                if (sc == null) continue;
                ++numSorts;
            }
        }
        return numSorts;
    }

    @Override
    public int countOpens(int which_to_count) throws StandardException {
        int count = -1;
        switch (which_to_count) {
            case 1: {
                count = this.countOpenConglomerateControllers();
                break;
            }
            case 2: {
                count = this.countOpenScanManagers();
                break;
            }
            case 3: {
                count = this.countCreatedSorts();
                break;
            }
            case 4: {
                count = this.sortControllers != null ? this.sortControllers.size() : 0;
                break;
            }
            case 5: {
                count = this.countOpenConglomerateControllers() + this.countOpenScanManagers() + (this.sortControllers != null ? this.sortControllers.size() : 0) + this.countCreatedSorts();
            }
        }
        return count;
    }

    private int countOpenConglomerateControllers() {
        int count = 0;
        for (int index = 0; index < this.conglomerateControllers.size(); ++index) {
            MemConglomerateController cc = this.conglomerateControllers.get(index);
            if (cc.isClosed()) continue;
            ++count;
        }
        return count;
    }

    private int countOpenScanManagers() {
        int count = 0;
        for (int index = 0; index < this.scanControllers.size(); ++index) {
            ScanManager sm = this.scanControllers.get(index);
            if (sm.isScanClosed()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public long createConglomerate(String implementation, DataValueDescriptor[] template, ColumnOrdering[] columnOrder, int[] collationIds, Properties properties, int temporaryFlag) throws StandardException {
        GemFireContainer container;
        long conglomId;
        int segmentId;
        GemFireStore memStore = Misc.getMemStore();
        MethodFactory mfactory = memStore.findMethodFactoryByImpl(implementation);
        if (mfactory == null || !(mfactory instanceof MemConglomerateFactory)) {
            throw StandardException.newException("XSAM3.S", implementation);
        }
        MemConglomerateFactory cfactory = (MemConglomerateFactory)mfactory;
        if ((temporaryFlag & 1) == 1) {
            segmentId = -1;
            conglomId = GemFireTransaction.getNextTempConglomId();
        } else {
            segmentId = 0;
            conglomId = memStore.getNextConglomId();
        }
        if (GemFireXDUtils.TraceConglom) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("GemFireTransaction TX " + this.toString() + ": creating conglomerate with id " + conglomId));
        }
        MemConglomerate conglom = cfactory.createConglomerate(this, segmentId, conglomId, template, columnOrder, collationIds, properties, temporaryFlag);
        conglom.create(this, segmentId, conglomId, template, columnOrder, collationIds, properties, temporaryFlag);
        if (this.needLogging()) {
            ContainerCreateOperation operation = new ContainerCreateOperation(conglom, properties);
            this.logAndDo(operation);
        } else {
            ContainerCreateOperation.doMe(this, conglom, properties);
        }
        if ((temporaryFlag & 1) == 1) {
            if (this.tempCongloms == null) {
                this.tempCongloms = new TLongObjectHashMap();
            }
            this.tempCongloms.put(conglomId, (Object)conglom);
        }
        if ((container = conglom.getGemFireContainer()) != null && (GemFireXDUtils.TraceConglom || container.isApplicationTableOrGlobalIndex() && !"SYSSTAT".equalsIgnoreCase(container.getSchemaName()) && !Misc.isSnappyHiveMetaTable(container.getSchemaName()))) {
            SanityManager.DEBUG_PRINT((String)"info:TraceConglom", (String)("GemFireTransaction TX " + (GemFireXDUtils.TraceConglom ? this.toString() : Long.toString(this.myId)) + ": created conglomerate with id " + conglomId + ": " + Misc.getMemStore().getContainer(conglom.getId())));
        }
        return conglomId;
    }

    @Override
    public long createAndLoadConglomerate(String implementation, DataValueDescriptor[] template, ColumnOrdering[] columnOrder, int[] collationIds, Properties properties, int temporaryFlag, RowLocationRetRowSource rowSource, long[] rowCount) throws StandardException {
        return this.recreateAndLoadConglomerate(implementation, true, template, columnOrder, collationIds, properties, temporaryFlag, 0L, rowSource, rowCount);
    }

    @Override
    public long recreateAndLoadConglomerate(String implementation, boolean recreate_ifempty, DataValueDescriptor[] template, ColumnOrdering[] columnOrder, int[] collationIds, Properties properties, int temporaryFlag, long orig_conglomId, RowLocationRetRowSource rowSource, long[] rowCount) throws StandardException {
        if ("heap".equalsIgnoreCase(implementation)) {
            throw new UnsupportedOperationException("Not implemented for HEAPs");
        }
        long conglomId = this.createConglomerate(implementation, template, columnOrder, collationIds, properties, temporaryFlag);
        long rows_loaded = this.loadConglomerate(conglomId, true, rowSource);
        if (rowCount != null) {
            rowCount[0] = rows_loaded;
        }
        if (!recreate_ifempty && rows_loaded == 0L) {
            this.dropConglomerate(conglomId);
            conglomId = orig_conglomId;
        }
        return conglomId;
    }

    @Override
    public String debugOpened() throws StandardException {
        StringBuilder sb = new StringBuilder();
        for (ScanController scanController : this.scanControllers) {
            if (scanController.isScanClosed()) continue;
            sb.append("open scan controller: ").append(scanController).append(SanityManager.lineSeparator);
        }
        for (MemConglomerateController memConglomerateController : this.conglomerateControllers) {
            if (memConglomerateController.isClosed()) continue;
            sb.append("open conglomerate controller: ").append(memConglomerateController).append(SanityManager.lineSeparator);
        }
        if (this.sortControllers != null) {
            for (SortController sortController : this.sortControllers) {
                sb.append("open sort controller: ").append(sortController).append(SanityManager.lineSeparator);
            }
        }
        if (this.sorts != null) {
            for (Sort sort : this.sorts) {
                if (sort == null) continue;
                sb.append("sorts created by createSort() in current TX: ").append(sort).append(SanityManager.lineSeparator);
            }
        }
        if (this.tempCongloms != null) {
            TLongObjectIterator iter = this.tempCongloms.iterator();
            while (iter.hasNext()) {
                iter.advance();
                long l = iter.key();
                Object val = iter.value();
                sb.append("temp conglomerate id = ").append(l).append(": ").append(val);
            }
        }
        return sb.toString();
    }

    @Override
    public boolean conglomerateExists(long conglomId) throws StandardException {
        return this.findConglomerate(conglomId) != null;
    }

    @Override
    public void dropConglomerate(long conglomId) throws StandardException {
        MemConglomerate conglom = this.findExistingConglomerate(conglomId);
        if (GemFireXDUtils.TraceConglom) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("GemFireTransaction TX " + this.toString() + ": dropping conglomerate with id " + conglomId + ": " + Misc.getMemStore().getContainer(conglom.getId())));
        }
        conglom.drop(this);
        if (conglomId < 0L) {
            if (this.tempCongloms != null) {
                this.tempCongloms.remove(conglomId);
            }
            if (GemFireXDUtils.TraceConglom) {
                SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("GemFireTransaction TX " + this.toString() + ": dropped temporary conglomerate with id " + conglomId));
            }
        } else {
            SanityManager.DEBUG_PRINT((String)"info:TraceConglom", (String)("GemFireTransaction TX " + this.toString() + ": dropped conglomerate with id " + conglomId));
        }
    }

    @Override
    public boolean fetchMaxOnBtree(long conglomId, int open_mode, int lock_level, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] fetchRow) throws StandardException {
        MemConglomerate conglom = this.findExistingConglomerate(conglomId);
        return conglom.fetchMaxOnBTree(this, null, conglomId, open_mode, lock_level, null, isolation_level, scanColumnList, fetchRow);
    }

    @Override
    public Properties getUserCreateConglomPropList() {
        Properties ret_properties = ConglomerateUtil.createUserRawStorePropertySet(null);
        return ret_properties;
    }

    @Override
    public final boolean isIdle() {
        TXStateInterface tx = this.getTXState(this.txState);
        if (tx != null) {
            return !tx.getProxy().hasOps();
        }
        return this.state != 2;
    }

    @Override
    public final boolean isClosed() {
        return this.state == 0;
    }

    public long loadConglomerate(long conglomId, boolean createConglom, RowLocationRetRowSource rowSource) throws StandardException {
        MemConglomerate conglom = this.findExistingConglomerate(conglomId);
        return conglom.load(this, createConglom, rowSource);
    }

    @Override
    public void logAndDo(Loggable operation) throws StandardException {
        assert (operation instanceof MemOperation) : "the loggable is supposed to be a MemOperation";
        if (this.logger == null) {
            this.logger = (MemLogger)this.logFactory.getLogger();
            this.setActiveState();
        }
        if (GemFireXDUtils.TraceTran) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)(this.toString() + " logAndDo operation: " + operation));
        }
        this.logger.logAndDo(this, operation);
    }

    @Override
    public ContainerHandle openContainer(ContainerKey containerId, int mode) throws StandardException {
        return this.openContainer(containerId, null, mode);
    }

    @Override
    public ContainerHandle openContainer(ContainerKey containerId, LockingPolicy locking, int mode) throws StandardException {
        GemFireContainer container;
        if ((mode & 0xC) == 12) {
            SanityManager.THROWASSERT((String)"update and readonly mode specified");
        }
        if ((container = Misc.getMemStore().getContainer(containerId)) != null) {
            container.open(this, mode);
        }
        return container;
    }

    @Override
    public void dropContainer(ContainerKey containerId) throws StandardException {
        GemFireContainer.GFContainerLocking locking;
        GemFireStore memStore = Misc.getMemStore();
        GemFireContainer container = memStore.getContainer(containerId);
        if (container != null && !this.skipLocks(container, null) && (locking = container.getLockingPolicy()) != null) {
            locking.lockContainer(this, container, true, true);
        }
        if (this.needLogging()) {
            ContainerDropOperation operation = new ContainerDropOperation(containerId, false);
            this.logAndDo(operation);
        } else {
            ContainerDropOperation.doMe(this, containerId);
        }
    }

    @Override
    public MemConglomerateController openCompiledConglomerate(boolean hold, int open_mode, int lock_level, int isolation_level, StaticCompiledOpenConglomInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        SanityManager.ASSERT((static_info != null ? 1 : 0) != 0);
        return this.openConglomerate((MemConglomerate)static_info.getConglom(), hold, open_mode, lock_level, isolation_level, static_info, dynamic_info);
    }

    @Override
    public MemConglomerateController openConglomerate(long conglomId, boolean hold, int open_mode, int lock_level, int isolation_level) throws StandardException {
        return this.openConglomerate(this.findExistingConglomerate(conglomId), hold, open_mode, lock_level, isolation_level, null, null);
    }

    @Override
    public long findConglomid(long container_id) throws StandardException {
        return container_id;
    }

    @Override
    public long findContainerid(long conglom_id) throws StandardException {
        return conglom_id;
    }

    @Override
    public BackingStoreHashtable createBackingStoreHashtableFromScan(long conglomId, int open_mode, int lock_level, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, long max_rowcnt, int[] key_column_numbers, boolean remove_duplicates, long estimated_rowcnt, long max_inmemory_rowcnt, int initialCapacity, float loadFactor, boolean collect_runtimestats, boolean skipNullKeyColumns, boolean keepAfterCommit, Activation activation) throws StandardException {
        BackingStoreHashTableFromScan ht = new BackingStoreHashTableFromScan(this, conglomId, open_mode, lock_level, isolation_level, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, max_rowcnt, key_column_numbers, remove_duplicates, estimated_rowcnt, max_inmemory_rowcnt, initialCapacity, loadFactor, collect_runtimestats, skipNullKeyColumns, keepAfterCommit, activation);
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.scanControllerOpened(ht, this.findExistingConglomerate(conglomId));
        }
        return ht;
    }

    @Override
    public MemScanController openGroupFetchScan(long conglomId, boolean hold, int open_mode, int lock_level, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator) throws StandardException {
        return this.openScan(this.findExistingConglomerate(conglomId), hold, open_mode, lock_level, isolation_level, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, null, null, null);
    }

    private MemScanController openScanController(MemConglomerate conglom, boolean hold, int openMode, int lockLevel, int isolationLevel, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, StaticCompiledOpenConglomInfo staticInfo, DynamicCompiledOpenConglomInfo dynamicInfo, Activation act) throws StandardException {
        int conglomType = conglom.getType();
        for (int index = 0; index < this.scanControllers.size(); ++index) {
            ScanManager sm = this.scanControllers.get(index);
            if (!sm.isScanClosed() || conglomType != sm.getType()) continue;
            MemScanController sc = (MemScanController)sm;
            sc.init(this, conglom, openMode, lockLevel, null, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, act);
            return sc;
        }
        MemScanController sc = conglom.openScan(this, this, hold, openMode, lockLevel, null, isolationLevel, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, null, dynamicInfo, act);
        this.scanControllers.add(sc);
        return sc;
    }

    @Override
    public void purgeConglomerate(long conglomId) throws StandardException {
        this.findExistingConglomerate(conglomId).purgeConglomerate(this, this);
    }

    @Override
    public void compressConglomerate(long conglomId) throws StandardException {
        this.findExistingConglomerate(conglomId).compressConglomerate(this, this);
    }

    @Override
    public MemScanController defragmentConglomerate(long conglomId, boolean online, boolean hold, int open_mode, int lock_level, int isolation_level) throws StandardException {
        if ((open_mode & 0xFFFFDFBB) != 0) {
            SanityManager.THROWASSERT((String)("Bad open mode to openScan: 0x" + Integer.toHexString(open_mode)));
        }
        if (!(lock_level == 6 | lock_level == 7)) {
            SanityManager.THROWASSERT((String)("Bad lock level to openScan:" + lock_level));
        }
        MemConglomerate conglom = this.findExistingConglomerate(conglomId);
        MemScanController sc = conglom.defragmentConglomerate(this, this, hold, open_mode, lock_level, null, isolation_level);
        this.scanControllers.add(sc);
        return sc;
    }

    @Override
    public MemScanController openScan(long conglomId, boolean hold, int open_mode, int lock_level, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, Activation activation) throws StandardException {
        return this.openScan(this.findExistingConglomerate(conglomId), hold, open_mode, lock_level, isolation_level, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, null, null, activation);
    }

    @Override
    public MemScanController openCompiledScan(boolean hold, int open_mode, int lock_level, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, StaticCompiledOpenConglomInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        SanityManager.ASSERT((static_info != null ? 1 : 0) != 0);
        SanityManager.ASSERT((boolean)(static_info instanceof StaticCompiledOpenConglomInfo));
        return this.openScan((MemConglomerate)static_info.getConglom(), hold, open_mode, lock_level, isolation_level, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, static_info, dynamic_info, null);
    }

    @Override
    public MemScanController openCompiledScan(boolean hold, int open_mode, int lock_level, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, StaticCompiledOpenConglomInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info, Activation act) throws StandardException {
        return this.openScan((MemConglomerate)static_info.getConglom(), hold, open_mode, lock_level, isolation_level, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, static_info, dynamic_info, act);
    }

    @Override
    public StoreCostController openStoreCost(long conglomId) throws StandardException {
        MemConglomerate conglom = this.findExistingConglomerate(conglomId);
        return conglom.openStoreCost(this, this);
    }

    @Override
    public long createSort(Properties implParameters, DataValueDescriptor[] template, ColumnOrdering[] columnOrdering, SortObserver sortObserver, boolean alreadyInOrder, long estimatedRows, int estimatedRowSize) throws StandardException {
        int sortid;
        ArraySorter sort = ArraySorter.create(this, columnOrdering, sortObserver, alreadyInOrder, estimatedRows, estimatedRowSize, 0L);
        if (this.sorts == null) {
            this.sorts = new ArrayList(4);
            this.freeSortIds = new TIntArrayList(4);
        }
        if (this.freeSortIds.isEmpty()) {
            sortid = this.sorts.size();
            this.sorts.add(sort);
        } else {
            sortid = this.freeSortIds.remove(this.freeSortIds.size() - 1);
            this.sorts.set(sortid, sort);
        }
        return sortid;
    }

    @Override
    public long createSort(Properties implParameters, ExecRow template, ColumnOrdering[] columnOrdering, SortObserver sortObserver, boolean alreadyInOrder, long estimatedRows, int estimatedRowSize, long maxSortLimit) throws StandardException {
        int sortId;
        ArraySorter sort = ArraySorter.create(this, columnOrdering, sortObserver, alreadyInOrder, estimatedRows, estimatedRowSize, maxSortLimit);
        if (this.sorts == null) {
            this.sorts = new ArrayList(4);
            this.freeSortIds = new TIntArrayList(4);
        }
        if (this.freeSortIds.isEmpty()) {
            sortId = this.sorts.size();
            this.sorts.add(sort);
        } else {
            sortId = this.freeSortIds.remove(this.freeSortIds.size() - 1);
            this.sorts.set(sortId, sort);
        }
        return sortId;
    }

    @Override
    public void dropSort(long sortId) throws StandardException {
        Sort sort;
        int intSortId = (int)sortId;
        if (this.sorts != null && intSortId < this.sorts.size() && intSortId >= 0 && (sort = this.sorts.get(intSortId)) != null) {
            sort.drop(this);
            this.sorts.set(intSortId, null);
            this.freeSortIds.add(intSortId);
        }
    }

    @Override
    public Serializable getProperty(String key) throws StandardException {
        return Misc.getMemStoreBooting().getProperty(key);
    }

    @Override
    public Serializable getPropertyDefault(String key) throws StandardException {
        return Misc.getMemStoreBooting().getPropertyDefault(key);
    }

    @Override
    public void setProperty(String key, Serializable value, boolean dbOnlyProperty) throws StandardException {
        Misc.getMemStoreBooting().setProperty(key, value, dbOnlyProperty);
    }

    @Override
    public void setPropertyDefault(String key, Serializable value) throws StandardException {
        Misc.getMemStoreBooting().setPropertyDefault(key, value);
    }

    @Override
    public boolean propertyDefaultIsVisible(String key) throws StandardException {
        return Misc.getMemStoreBooting().propertyDefaultIsVisible(key);
    }

    @Override
    public Properties getProperties() throws StandardException {
        return Misc.getMemStoreBooting().getProperties();
    }

    @Override
    public final SortController openSort(long id) throws StandardException {
        Sort sort;
        ArrayList<Sort> sorts = this.sorts;
        if (sorts == null || id >= (long)sorts.size() || (sort = sorts.get((int)id)) == null) {
            throw StandardException.newException("XSAM4.S", id);
        }
        SortController sc = sort.open(this);
        if (this.sortControllers == null) {
            this.sortControllers = new ArrayList(4);
        }
        this.sortControllers.add(sc);
        return sc;
    }

    @Override
    public SortCostController openSortCostController(Properties implParameters) throws StandardException {
        MethodFactory mfactory;
        String implementation = null;
        if (implementation == null) {
            implementation = "sort external";
        }
        if ((mfactory = Misc.getMemStore().findMethodFactoryByImpl(implementation)) == null || !(mfactory instanceof SortFactory)) {
            throw StandardException.newException("XSAM0.S", implementation);
        }
        SortFactory sfactory = (SortFactory)mfactory;
        return sfactory.openSortCostController();
    }

    @Override
    public ScanController openSortScan(long id, boolean hold) throws StandardException {
        Sort sort;
        if (this.sorts == null || id >= (long)this.sorts.size() || (sort = this.sorts.get((int)id)) == null) {
            throw StandardException.newException("XSAM4.S", id);
        }
        ScanController sc = sort.openSortScan(this, hold);
        this.scanControllers.add((ScanManager)sc);
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.scanControllerOpened(sc, null);
        }
        return sc;
    }

    @Override
    public RowLocationRetRowSource openSortRowSource(long id) throws StandardException {
        Sort sort;
        if (this.sorts == null || id >= (long)this.sorts.size() || (sort = this.sorts.get((int)id)) == null) {
            throw StandardException.newException("XSAM4.S", id);
        }
        ScanControllerRowSource scan = sort.openSortRowSource(this);
        this.scanControllers.add((ScanManager)((Object)scan));
        return scan;
    }

    @Override
    public LogInstant commit() throws StandardException {
        if (GemFireXDUtils.TraceTranVerbose) {
            SanityManager.DEBUG_PRINT((String)"TraceTranVerbose", (String)("GemFireTransaction: commit: attempting commit of transaction: " + this.toString()));
        }
        TXStateInterface tx = this.getTopTXState();
        if (this.state != 2 && tx == null) {
            return null;
        }
        this.closeControllers(false);
        return this.commit(65536, tx, 3, null);
    }

    @Override
    public LogInstant commitNoSync(int commitflag) throws StandardException {
        if (GemFireXDUtils.TraceTranVerbose) {
            SanityManager.DEBUG_PRINT((String)"TraceTranVerbose", (String)("GemFireTransaction: commit: attempting commitNoSync of transaction: " + this.toString()));
        }
        if (this.state != 2) {
            return null;
        }
        this.closeControllers(false);
        if (GemFireXDUtils.TraceTran) {
            int checkflag = 3;
            SanityManager.ASSERT(((commitflag & checkflag) != 0 ? 1 : 0) != 0, (String)"commitNoSync must specify whether to keep or release locks");
            SanityManager.ASSERT(((commitflag & checkflag) != checkflag ? 1 : 0) != 0, (String)"cannot set both RELEASE and KEEP LOCKS flag");
            if ((commitflag & 4) != 0) {
                SanityManager.ASSERT((this.state == 1 || this.state == 2 ? 1 : 0) != 0);
            }
        }
        if (this.state == 1 && (commitflag & 4) != 0) {
            this.releaseAllLocks(true, true);
            return null;
        }
        return this.commit(0x20000 | commitflag, null, 3, null);
    }

    @Override
    public DatabaseInstant commitForSetIsolationLevel() throws StandardException {
        if (GemFireXDUtils.TraceTranVerbose) {
            SanityManager.DEBUG_PRINT((String)"TraceTranVerbose", (String)("GemFireTransaction: commit: attempting commit of transaction: " + this.toString()));
        }
        if (this.state != 2) {
            return null;
        }
        this.closeControllers(false);
        return this.commit(65536, null, 3, null);
    }

    private LogInstant commit(int commitflag, TXStateInterface tx, int commitPhase, TXManagerImpl.TXContext context) throws StandardException {
        if (GemFireXDUtils.TraceTranVerbose) {
            SanityManager.DEBUG_PRINT((String)"TraceTranVerbose", (String)("commiting TX " + this.toString()));
        }
        if (commitPhase != 2) {
            this.prepareCommit(commitflag);
        }
        this.waitForPendingRC();
        if (tx != null) {
            LanguageConnectionContext lcc = this.getLanguageConnectionContext();
            if (lcc == null || lcc.isConnectionForRemote()) {
                throw StandardException.newException("40XT1", new GemFireXDRuntimeException("unexpected commit on remote node or from function execution"));
            }
            try {
                TXStateInterface gfTx = (TXStateInterface)TXManagerImpl.snapshotTxState.get();
                if (tx != gfTx && !tx.isSnapshot() || tx.isSnapshot() && this.implicitSnapshotTxStarted) {
                    context = this.txManager.commit(tx, (Object)this.connectionID, commitPhase, context, false);
                    if (tx.isSnapshot() && this.implicitSnapshotTxStarted) {
                        this.implicitSnapshotTxStarted = false;
                        TXManagerImpl.snapshotTxState.set(null);
                    }
                }
                if (commitPhase != 1) {
                    this.postComplete(commitflag, true);
                    this.setTXState(null);
                }
                this.txContextFromPrepareStage = context;
            }
            catch (Exception ex) {
                StandardException stdEx;
                Exception copy = ex;
                if (ex instanceof GemFireException && (stdEx = Misc.processGemFireException((GemFireException)((Object)ex), ex, "commit of " + this.toString(), true)) != null) {
                    throw stdEx;
                }
                for (Throwable t = ex; t != null; t = t.getCause()) {
                    if (!(t instanceof StandardException)) continue;
                    throw StandardException.newException("X0Z06.T", t);
                }
                throw StandardException.newException("X0Z06.T", copy);
            }
        } else {
            this.postComplete(commitflag, true);
        }
        return null;
    }

    public final void suspendTransaction() {
        TXStateInterface txSuspended = this.txManager.internalSuspend();
        TXStateInterface myTX = this.txState;
        assert (myTX == TXStateProxy.TX_NOT_SET || myTX == txSuspended) : "unexpected mismatch of TX states, expected: " + myTX + ", actual: " + txSuspended;
        this.txStateSuspended = txSuspended;
        this.isolationSuspended = this.isolationLevel;
        this.setTXState(null);
        this.isolationLevel = IsolationLevel.NONE;
        if (GemFireXDUtils.TraceTran) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction: suspendTransaction: Gemfire Transaction suspended. transaction is " + this.toString()), (Throwable)(GemFireXDUtils.TraceTranVerbose ? new Throwable() : null));
        }
    }

    public final void resumeTransactionIfSuspended() {
        TXStateInterface txSuspended = this.txStateSuspended;
        if (txSuspended != null) {
            this.txManager.masqueradeAs(txSuspended);
            this.setTXState(txSuspended);
        }
        this.isolationLevel = this.isolationSuspended;
        this.txStateSuspended = null;
        this.isolationSuspended = IsolationLevel.NONE;
        if (GemFireXDUtils.TraceTran && txSuspended != null) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction: resumeTransactionState: GemFire TX resumed: " + this.toString()), (Throwable)(GemFireXDUtils.TraceTranVerbose ? new Throwable() : null));
        }
    }

    private void prepareCommit(int commitflag) throws StandardException {
        if (this.logger != null && (commitflag & 0x10000) == 65536) {
            this.logger.flushAll();
            this.disableLogging();
            this.logger = null;
        }
    }

    final void postComplete(int commitflag, boolean commitOrAbort) throws StandardException {
        try {
            if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("postComplete: flag=" + commitflag + ", commitOrAbort=" + commitOrAbort + " for TX " + this.toString()));
            }
            this.releaseRegionLock();
            if ((commitflag & 2) == 0) {
                this.releaseAllLocksOnly(true, true);
                this.setIdleState();
            } else {
                SanityManager.ASSERT((boolean)commitOrAbort, (String)"cannot keep locks around after an ABORT");
                this.setActiveState();
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    public void abort() throws StandardException {
        this.abort(true);
    }

    public void abort(boolean abortParent) throws StandardException {
        try {
            this.doAbort(abortParent);
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAbort(boolean abortParent) throws StandardException {
        if (GemFireXDUtils.TraceTranVerbose) {
            SanityManager.DEBUG_PRINT((String)"TraceTranVerbose", (String)("GemFireTransaction: abort: attempting abort of transaction " + this.toString()), (Throwable)new Throwable());
        }
        TXStateInterface tx = this.getTopTXState();
        if (this.state != 2 && tx == null) {
            return;
        }
        this.closeControllers(true);
        if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery || GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("aborting TX " + this.toString()));
        }
        if (this.logger != null) {
            this.logger.undo(this, null, null, null);
            this.logger.flushAll();
            this.disableLogging();
            this.logger = null;
        }
        this.waitForPendingRC();
        try {
            LanguageConnectionContext lcc;
            if (tx != null && (lcc = this.getLanguageConnectionContext()) != null && !lcc.isConnectionForRemote() && this.connectionID >= 0L) {
                TXStateInterface gfTx = (TXStateInterface)TXManagerImpl.snapshotTxState.get();
                if (tx.isSnapshot() && this.implicitSnapshotTxStarted || tx != gfTx && !tx.isSnapshot()) {
                    this.txManager.rollback(tx, (Object)this.connectionID, false);
                    if (tx.isSnapshot() && this.implicitSnapshotTxStarted) {
                        this.implicitSnapshotTxStarted = false;
                        TXManagerImpl.snapshotTxState.set(null);
                    }
                }
                this.setTXState(null);
            }
            if (abortParent && this.parentTran != null) {
                this.parentTran.abort(true);
            }
        }
        finally {
            this.postComplete(0, false);
        }
    }

    public void internalCleanup() throws StandardException {
        try {
            this.doInternalCleanup();
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    private void doInternalCleanup() throws StandardException {
        if (this.state != 2) {
            return;
        }
        this.closeControllers(true);
        if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery || GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("cleaning TX " + this.toString()));
        }
        if (this.logger != null) {
            this.logger.undo(this, null, null, null);
            this.logger.flushAll();
            this.disableLogging();
            this.logger = null;
        }
        this.waitForPendingRC();
        if (!this.isTransactional()) {
            this.postComplete(0, false);
        }
    }

    public final List<?> getLogAndDoListForCommit() {
        MemLogger logger = this.logger;
        if (logger != null) {
            return logger.getDoList(this);
        }
        return null;
    }

    @Override
    public ContextManager getContextManager() {
        return this.context != null ? this.context.getContextManager() : ContextService.getFactory().getCurrentContextManager();
    }

    @Override
    public void destroy() {
        try {
            switch (this.state) {
                case 0: {
                    return;
                }
                case 1: {
                    this.abort(false);
                    this.state = 0;
                    break;
                }
                default: {
                    throw StandardException.newException("40XT4");
                }
            }
            this.clean();
            if (this.context != null && !this.context.getContextManager().isEmpty()) {
                this.context.popMe();
            }
        }
        catch (StandardException standardException) {
        }
        finally {
            this.tempCongloms = null;
        }
    }

    private void reopen(ContextManager cm, String contextId, String transName, boolean skipLocks, boolean abortAll) {
        if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery || GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction: reopening TX " + this.toString()));
        }
        this.transName = transName;
        this.skipLocks = skipLocks;
        this.context.reset(contextId, abortAll);
        cm.pushContext(this.context);
        this.setActiveState();
    }

    @Override
    public boolean checkVersion(int requiredMajorVersion, int requiredMinorVersion, String feature) throws StandardException {
        return true;
    }

    @Override
    public final void closeMe(ConglomerateController cc) {
    }

    @Override
    public final void closeMe(SortController sc) {
        this.sortControllers.remove(sc);
    }

    @Override
    public final void closeMe(ScanManager scan) {
        if (!(scan instanceof MemScanController)) {
            this.scanControllers.remove(scan);
        }
    }

    @Override
    public GemFireStore getAccessManager() {
        return Misc.getMemStore();
    }

    @Override
    public TransactionManager getInternalTransaction() throws StandardException {
        ContextManager cm = this.getContextManager();
        return GemFireTransaction.startCommonTransaction(cm, null, null, USER_CONTEXT_ID, USER_CONTEXT_ID, this.skipLocks, true, this.connectionID, false);
    }

    @Override
    public TransactionController startNestedUserTransaction(boolean readOnly) throws StandardException {
        if (GemFireXDUtils.TraceTranVerbose) {
            SanityManager.DEBUG_PRINT((String)"TraceTranVerbose", (String)("GemFireTransaction: startNestedUserTransaction for " + this.toString()));
        }
        ContextManager cm = this.getContextManager();
        if (readOnly) {
            if (this.childTran == null) {
                this.childTran = GemFireTransaction.startCommonTransaction(cm, this, null, "nestedReadOnlyUserTransaction", "nestedReadOnlyUserTransaction", this.skipLocks, false, this.connectionID, false);
            } else {
                this.childTran.reopen(cm, "nestedReadOnlyUserTransaction", "nestedReadOnlyUserTransaction", this.skipLocks, false);
            }
            this.childTran.lcc = this.lcc;
            return this.childTran;
        }
        if (this.childTranUpd == null) {
            this.childTranUpd = GemFireTransaction.startCommonTransaction(cm, this, null, "nestedUpdateUserTransaction", "nestedUpdateUserTransaction", this.skipLocks, true, this.connectionID, false);
        } else {
            this.childTranUpd.reopen(cm, "nestedUpdateUserTransaction", "nestedUpdateUserTransaction", this.skipLocks, true);
        }
        this.childTranUpd.lcc = this.lcc;
        return this.childTranUpd;
    }

    @Override
    public void saveScanPositions(Conglomerate conglom, Page page) throws StandardException {
        for (int index = 0; index < this.scanControllers.size(); ++index) {
            ScanManager sm = this.scanControllers.get(index);
            sm.savePosition(conglom, page);
        }
    }

    @Override
    public final GfxdLockSet getLockSpace() {
        SanityManager.ASSERT((this.lockSet != null ? 1 : 0) != 0, (String)"cannot have a null lockSpace.");
        return this.lockSet;
    }

    @Override
    public String getTransactionIdString() {
        StringBuilder sb = new StringBuilder();
        return sb.append(this.myId).append('(').append(this.transName).append(')').append('@').append(Integer.toHexString(System.identityHashCode(this))).append(";txState=").append(this.txState).append(";supportsTX=").append(this.txManager != null).toString();
    }

    @Override
    public String getActiveStateTxIdString() {
        return this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        sb.append(this.myId).append('(').append(this.transName).append(')').append('@').append(Integer.toHexString(System.identityHashCode(this)));
        if (this.lockSet != null) {
            sb.append(";owner=").append(this.lockSet.getOwner());
        }
        sb.append(";txState=").append(this.txState).append(";supportsTX=").append(this.txManager != null).append(";needsLogging=").append(this.needLogging);
        if (lcc != null) {
            sb.append(";streaming=").append(lcc.streamingEnabled());
        }
        return sb.append(";skipLocks=").append(this.skipLocks).append(";state=").append(this.state).append(";remote=").append(lcc != null && lcc.isConnectionForRemote()).toString();
    }

    private void releaseRegionLock() {
        PartitionedRegion.RecoveryLock regionRecLock = this.regionRecoveryLock;
        if (regionRecLock != null) {
            regionRecLock.unlock();
            this.regionRecoveryLock = null;
        }
    }

    @Override
    public void releaseAllLocks(boolean force, boolean removeRef) {
        this.releaseRegionLock();
        this.waitForPendingRC();
        this.releaseAllLocksOnly(force, removeRef);
    }

    private void waitForPendingRC() {
        if (this.lcc == null || !this.lcc.isConnectionForRemote()) {
            this.getLockSpace().waitForPendingRC();
        }
    }

    private void releaseAllLocksOnly(boolean force, boolean removeRef) {
        if (!this.skipLocks || Misc.initialDDLReplayInProgress()) {
            GfxdLockSet lockSet = this.getLockSpace();
            if (GemFireXDUtils.TraceLock) {
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("GemFireTransaction: releasing all locks for TX " + this.toString()));
            }
            if (lockSet.unlockAll(force, removeRef)) {
                lockSet.freeLockResources();
            }
        }
    }

    @Override
    public void beginTransaction(IsolationLevel isolationLevel) throws StandardException {
        if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery || GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction: beginTransaction:  requested isolation " + isolationLevel));
        }
        this.beginTransaction(isolationLevel, null);
    }

    public final void beginTransaction(IsolationLevel isolationLevel, TXId txId) throws StandardException {
        if (this.txManager != null) {
            TXStateInterface tx = this.txState;
            TXStateInterface gemfireTx = (TXStateInterface)TXManagerImpl.snapshotTxState.get();
            if (tx != null && tx != TXStateProxy.TX_NOT_SET && gemfireTx != tx) {
                this.txManager.commit(tx, (Object)this.connectionID, 3, null, false);
            }
            if (isolationLevel != IsolationLevel.NONE) {
                ContextManager cm;
                EnumSet<TransactionFlag> txFlags;
                TXManagerImpl.TXContext context = TXManagerImpl.getOrCreateTXContext();
                context.clearTXState();
                LanguageConnectionContext lcc = this.getLanguageConnectionContext();
                if (lcc != null) {
                    txFlags = lcc.getTXFlags();
                    cm = lcc.getContextManager();
                } else {
                    txFlags = null;
                    cm = this.getContextManager();
                }
                boolean beginTxn = txId == null;
                TXStateProxy newTX = beginTxn ? this.txManager.beginTX(context, isolationLevel, txFlags, txId) : this.txManager.resumeTX(context, isolationLevel, txFlags, txId);
                this.setTXState((TXStateInterface)newTX);
                EmbedConnection conn = EmbedConnectionContext.getEmbedConnection(cm);
                if (conn != null) {
                    conn.setTXIdForFinalizer(newTX.getTransactionId());
                }
                if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery || GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction: beginTransaction: new TX state being assigned: " + newTX + ", to transaction: " + this.toString() + " requested isolation " + isolationLevel));
                }
            } else if (gemfireTx != null) {
                LanguageConnectionContext lcc = this.getLanguageConnectionContext();
                if (lcc != null) {
                    ContextManager cm = lcc.getContextManager();
                } else {
                    ContextManager cm = this.getContextManager();
                }
                this.setTXState(gemfireTx);
                this.getTransactionManager().masqueradeAs(gemfireTx);
                if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery || GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction: beginTransaction: gemfire TX state being assigned: " + gemfireTx + ", to transaction: " + this.toString() + " requested isolation " + gemfireTx.getIsolationLevel()));
                }
            } else {
                if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery || GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction: beginTransaction: changing isolation level to NONE with current TX " + tx + " for " + this.toString()));
                }
                if (tx != null) {
                    this.setTXState(null);
                }
            }
            this.isolationLevel = isolationLevel;
            this.setActiveState();
            assert (this.parentTran == null) : "unexpected beginTransaction on child transaction " + this.toString();
        }
    }

    public static GemFireTransaction findUserTransaction(ContextManager cm, String transName, long connectionID) throws StandardException {
        if (GemFireXDUtils.TraceTran) {
            ContextService contextFactory = ContextService.getFactory();
            SanityManager.ASSERT((cm == contextFactory.getCurrentContextManager() ? 1 : 0) != 0, (String)"passed in context mgr not the same as current context mgr");
        }
        GemFireTransactionContext tc = (GemFireTransactionContext)cm.getContext(USER_CONTEXT_ID);
        if (GemFireXDUtils.TraceTran) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction#findUserTransaction: for '" + transName + "' found context " + tc));
        }
        if (tc == null) {
            LanguageConnectionContext lcc = (LanguageConnectionContext)cm.getContext("LanguageConnectionContext");
            boolean skipLocks = lcc != null ? lcc.skipLocks() : false;
            GemFireTransaction tran = GemFireTransaction.startCommonTransaction(cm, null, null, USER_CONTEXT_ID, transName, skipLocks, true, connectionID, true);
            tran.lcc = lcc;
            return tran;
        }
        return tc.getTransaction();
    }

    private static GemFireTransaction startCommonTransaction(ContextManager cm, GemFireTransaction parentTran, GfxdLockSet compatibilitySpace, String contextId, String transName, boolean skipLocks, boolean abortAll, long connectionID, boolean isTxExecute) throws StandardException {
        boolean logTran;
        boolean bl = logTran = GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery || SanityManager.isFineEnabled || GemFireXDUtils.TraceNCJ;
        if (logTran) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)"GemFireTransaction: starting a new TX");
        }
        if (logTran) {
            ContextService contextFactory = ContextService.getFactory();
            SanityManager.ASSERT((cm == contextFactory.getCurrentContextManager() ? 1 : 0) != 0);
        }
        GemFireTransaction tran = new GemFireTransaction(transName, parentTran, skipLocks, compatibilitySpace, connectionID, isTxExecute);
        GemFireTransaction.pushTransactionContext(cm, contextId, tran, abortAll);
        tran.setActiveState();
        if (logTran) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction: created new TX " + tran.toString()));
        }
        return tran;
    }

    public void release() {
        if (this.ownerlessAddressesToFree != null) {
            this.ownerlessAddressesToFree.release();
        }
        if (this.owners != null) {
            for (OffHeapResourceHolder owner : this.owners) {
                owner.release();
            }
            this.owners.clear();
        }
    }

    private static void pushTransactionContext(ContextManager cm, String contextName, GemFireTransaction tran, boolean abortAll) throws StandardException {
        if (GemFireXDUtils.TraceTran && cm.getContext(contextName) != null) {
            throw StandardException.newException("XSTA2.S");
        }
        tran.context = new GemFireTransactionContext(cm, contextName, tran, abortAll);
        if (GemFireXDUtils.TraceTran) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction: pushed new context " + tran.context + " for transaction " + tran.toString()));
        }
    }

    @Override
    public DataValueFactory getDataValueFactory() throws StandardException {
        return this.dataValueFactory;
    }

    @Override
    public RawTransaction getRawStoreXact() throws StandardException {
        return this;
    }

    @Override
    public final GfxdLockSet getCompatibilitySpace() {
        return this.getLockSpace();
    }

    public final void setIdleState() {
        if (this.state == 1) {
            return;
        }
        this.state = 1;
        if (GemFireXDUtils.TraceTranVerbose) {
            SanityManager.DEBUG_PRINT((String)"TraceTranVerbose", (String)("set idle state TX " + this.toString()));
        }
    }

    public final void setActiveState() {
        if (this.state == 2) {
            return;
        }
        this.state = 2;
        if (GemFireXDUtils.TraceTranVerbose) {
            SanityManager.DEBUG_PRINT((String)"TraceTranVerbose", (String)("set active state TX " + this.toString()));
        }
    }

    private final void setActiveStateForTransaction() throws StandardException {
        if (this.txManager != null) {
            if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction#setActiveStateForTransaction: for " + this + " starting GFE transaction with current thread-local GFE TX " + TXManagerImpl.getCurrentTXState()));
            }
            this.beginTransaction(this.isolationLevel);
        }
    }

    public static final void setActiveStateForTransaction(LanguageConnectionContext lcc) throws SQLException {
        if (lcc != null) {
            if (lcc.isConnectionForRemote()) {
                return;
            }
            GemFireTransaction tran = (GemFireTransaction)lcc.getTransactionExecute();
            if (tran != null && (TXManagerImpl.getCurrentSnapshotTXState() != null || tran.state != 2)) {
                try {
                    tran.setActiveStateForTransaction();
                }
                catch (StandardException se) {
                    throw Util.generateCsSQLException(se);
                }
            }
        }
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public final boolean skipLocks() {
        return this.skipLocks;
    }

    @Override
    public final boolean skipLocks(Object warnForOwnerIfSkipLocksForConnection, GfxdLockable lockable) {
        LanguageConnectionContext lcc;
        if (!this.skipLocks) {
            return false;
        }
        if (this.skipLocksOnConnection && (warnForOwnerIfSkipLocksForConnection != null || (warnForOwnerIfSkipLocksForConnection = lockable) != null) && (lcc = this.getLanguageConnectionContext()) != null && lcc.getActivationCount() > 0) {
            try {
                Activation a = lcc.getLastActivation();
                SQLWarning warning = a.getWarnings();
                if (warning == null) {
                    a.addWarning(StandardException.newWarning("X0Z34", warnForOwnerIfSkipLocksForConnection));
                } else {
                    SQLWarning newWarning = this.addOrUpdateSkipLocksWarning(warning, warnForOwnerIfSkipLocksForConnection, warning);
                    if (newWarning != null) {
                        a.clearWarnings();
                        a.addWarning(newWarning);
                    } else {
                        a.addWarning(StandardException.newWarning("X0Z34", warnForOwnerIfSkipLocksForConnection));
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return true;
    }

    private SQLWarning addOrUpdateSkipLocksWarning(SQLWarning warning, Object lockObject, SQLWarning iter) {
        do {
            if (!"X0Z34".equals(warning.getSQLState())) continue;
            String newMessage = warning.getMessage() + ',' + lockObject;
            SQLWarning newWarning = null;
            while (iter != warning) {
                if (newWarning == null) {
                    newWarning = new SQLWarning(iter.getMessage(), iter.getSQLState(), iter.getErrorCode(), iter.getCause());
                } else {
                    newWarning.setNextWarning(new SQLWarning(iter.getMessage(), iter.getSQLState(), iter.getErrorCode(), iter.getCause()));
                }
                iter = iter.getNextWarning();
            }
            if (newWarning == null) {
                newWarning = new SQLWarning(newMessage, "X0Z34", 20000);
            } else {
                newWarning.setNextWarning(new SQLWarning(newMessage, "X0Z34", 20000));
            }
            iter = iter.getNextWarning();
            if (iter != null) {
                newWarning.setNextWarning(iter);
            }
            return newWarning;
        } while ((warning = warning.getNextWarning()) != null);
        return null;
    }

    @Override
    public void setSkipLocks(boolean skip) {
        this.skipLocks = skip;
    }

    @Override
    public void setSkipLocksForConnection(boolean skip) {
        this.skipLocksOnConnection = skip;
        if (skip) {
            this.skipLocks = true;
        }
    }

    @Override
    public void enableLogging() {
        if (this.state == 0) {
            throw new GemFireXDRuntimeException("GemFireTransaction#enableLogging: unexpected call with state as CLOSED [TX " + this.toString() + ']');
        }
        this.needLogging = true;
    }

    @Override
    public void disableLogging() {
        if (this.state != 0) {
            this.needLogging = false;
        }
    }

    @Override
    public boolean needLogging() {
        if (this.state == 0) {
            throw new GemFireXDRuntimeException("GemFireTransaction#needLogging: unexpected call with state as CLOSED [TX " + this.toString() + ']');
        }
        return this.needLogging;
    }

    void clean() {
        if (this.parentTran != null) {
            if (this == this.parentTran.childTran) {
                this.parentTran.childTran = null;
            } else {
                this.parentTran.childTranUpd = null;
            }
        }
    }

    public void addDBSynchronizerOperation(AbstractDBSynchronizerMessage dbm) {
        GfxdTXStateProxy txProxy;
        if (GemFireXDUtils.TraceDBSynchronizer) {
            SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("GemFireTransaction: adding DB Synchronizer operation" + dbm + ".  GFT object is =" + this));
        }
        if ((txProxy = this.txProxy) != null) {
            txProxy.addDBSynchronizerMessage(dbm);
        }
    }

    public final long getConnectionID() {
        return this.connectionID;
    }

    public final void setDDLId(long id) {
        this.ddlId = id;
    }

    public final long getDDLId() {
        return this.ddlId;
    }

    private final TXStateInterface getActiveTXState(TXStateInterface myTX) {
        TXStateInterface tx;
        IsolationLevel isolationLevel = this.isolationLevel;
        TXStateInterface gfTx = (TXStateInterface)TXManagerImpl.snapshotTxState.get();
        if (isolationLevel != IsolationLevel.NONE) {
            if (myTX != null && myTX != TXStateProxy.TX_NOT_SET) {
                return myTX;
            }
        } else if (myTX == null && gfTx == null) {
            return null;
        }
        if ((tx = this.getTXState(myTX)) != null) {
            return tx;
        }
        if (isolationLevel == IsolationLevel.NONE && gfTx == null) {
            return tx;
        }
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        if (lcc == null || lcc.isConnectionForRemote()) {
            return tx;
        }
        try {
            this.setActiveStateForTransaction();
        }
        catch (StandardException se) {
            throw new GemFireXDRuntimeException(se);
        }
        return this.getTXState(this.txState);
    }

    private boolean checkTXStateAgainstThreadLocal(TXStateInterface myTX) {
        if (myTX != TXStateProxy.TX_NOT_SET && this.txManager != null) {
            TXStateInterface currentTX = TXManagerImpl.getCurrentTXState();
            return myTX == currentTX || currentTX != null && !currentTX.isInProgress() || myTX != null && !myTX.isInProgress();
        }
        return true;
    }

    private String failTXStateMismatch(TXStateInterface myTX) {
        return "unexpected change in TXState expected: " + myTX + ", thread-local: " + TXManagerImpl.getCurrentTXState();
    }

    private void logActiveTXState() {
        SanityManager.DEBUG_PRINT((String)"TraceTranVerbose", (String)("GemFireTransaction#getActiveTXState: for " + this.toString() + " getting active GFE TXState with thread-local TX " + TXManagerImpl.getCurrentTXState()));
    }

    public final TXStateInterface getActiveTXState() {
        TXStateInterface myTX = this.txState;
        assert (this.checkTXStateAgainstThreadLocal(myTX)) : this.failTXStateMismatch(myTX);
        if (GemFireXDUtils.TraceTranVerbose) {
            this.logActiveTXState();
        }
        return this.getActiveTXState(myTX);
    }

    public final TXStateProxy getCurrentTXStateProxy() {
        if (this.getTXState(this.txState) != null) {
            return this.txProxy;
        }
        return null;
    }

    public final TXManagerImpl getTransactionManager() {
        return this.txManager;
    }

    private final TXStateInterface getTXState(TXStateInterface tx) {
        if (tx != TXStateProxy.TX_NOT_SET) {
            return tx;
        }
        tx = TXManagerImpl.getCurrentTXState();
        this.setTXState(tx);
        return tx;
    }

    public final TXStateInterface getTopTXState() {
        TXStateInterface tx = this.getTXState(this.txState);
        if (tx != null) {
            if (tx.isCoordinator()) {
                return this.txProxy;
            }
            return tx.getLocalTXState();
        }
        return null;
    }

    @Override
    public final boolean isTransactional() {
        return this.isolationLevel != IsolationLevel.NONE || this.implicitSnapshotTxStarted;
    }

    public final TXStateInterface getSuspendedTXState() {
        return this.txStateSuspended;
    }

    public final boolean checkTXOnRemoteNode() {
        TXStateInterface tx = this.txState;
        return tx == TXStateProxy.TX_NOT_SET || tx == null || tx.getProxy() == tx;
    }

    public final void setActiveTXState(TXStateInterface tx, boolean setIsolation) {
        TXStateInterface oldTX = this.txState;
        assert (!(tx == null || this.txManager == null || setIsolation && oldTX != null && oldTX != TXStateProxy.TX_NOT_SET && (this.isClosed() || oldTX.isInProgress()) && tx.getProxy() != oldTX.getProxy())) : "unexpected old " + oldTX + " when setting " + tx + " for " + this.toString();
        this.setTXState(tx);
        if (setIsolation) {
            this.isolationLevel = tx != null ? tx.getIsolationLevel() : IsolationLevel.NONE;
        }
        this.setActiveState();
    }

    private final void setTXState(TXStateInterface tx) {
        if (this.txState != tx) {
            if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery || GemFireXDUtils.TraceNCJ) {
                if (tx != null && tx != TXStateProxy.TX_NOT_SET) {
                    SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction#setTXState: for " + this.toString() + " setting cached GFE transaction to " + tx + " with thread-local TX " + TXManagerImpl.getCurrentTXState()));
                } else if (GemFireXDUtils.TraceTranVerbose) {
                    SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction#setTXState: to " + tx + " for " + this.toString()));
                }
            }
            this.txState = tx;
            if (tx != null && tx != TXStateProxy.TX_NOT_SET) {
                GfxdTXStateProxy txp = (GfxdTXStateProxy)tx.getProxy();
                if (this.txProxy != txp) {
                    txp.addGemFireTransaction(this);
                    this.txProxy = txp;
                }
            } else {
                GfxdTXStateProxy txp = this.txProxy;
                if (txp != null) {
                    txp.clearGemFireTransaction(this);
                    this.txProxy = null;
                }
            }
        }
    }

    public final void clearActiveTXState(boolean clearGFETX, boolean clearIsolationLevel) {
        if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction#clearActiveTXState: for " + this.toString() + " clearing cached GFE transaction = " + clearGFETX + " with thread-local TX " + TXManagerImpl.getCurrentTXState()));
        }
        this.setTXState(null);
        if (clearGFETX) {
            TXManagerImpl.getOrCreateTXContext().clearTXState();
        }
        if (clearIsolationLevel) {
            this.isolationLevel = IsolationLevel.NONE;
        }
        this.setActiveState();
    }

    public final void resetActiveTXState(boolean clearIsolationLevel) {
        assert (this.txManager != null) : "unexpected null TXManagerImpl";
        if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction#resetActiveTXState: for " + this.toString() + " resetting local cached transaction with thread-local TX " + TXManagerImpl.getCurrentTXState()));
        }
        this.setTXState(TXStateProxy.TX_NOT_SET);
        if (clearIsolationLevel) {
            this.isolationLevel = IsolationLevel.NONE;
        }
        this.setActiveState();
    }

    public final void resetTXState() {
        TXStateInterface tx = this.txState;
        if (tx != null && tx != TXStateProxy.TX_NOT_SET) {
            if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction#resetTXState: for " + this.myId + '(' + this.transName + ") resetting local cached transaction " + tx.getTransactionId().shortToString()));
            }
            this.setTXState(TXStateProxy.TX_NOT_SET);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void reattachTransaction(LanguageConnectionContext lcc, boolean isOperation) throws SQLException {
        block14: {
            block15: {
                GemFireTransaction tran;
                block17: {
                    TXManagerImpl.TXContext context;
                    TXStateInterface tx;
                    block16: {
                        if (lcc == null) break block14;
                        if (lcc.isConnectionForRemote()) {
                            return;
                        }
                        tran = (GemFireTransaction)lcc.getTransactionExecute();
                        if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery || GemFireXDUtils.TraceNCJ) {
                            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction#reattachTransaction: for " + tran + " attaching to GFE transaction with current thread-local GFE TX " + TXManagerImpl.getCurrentTXState()));
                        }
                        if (tran == null) break block14;
                        if (tran.txManager == null) break block15;
                        tx = tran.txState;
                        if (tx != null || tran.state == 2) break block16;
                        if (isOperation) {
                            try {
                                tran.beginTransaction(tran.isolationLevel);
                            }
                            catch (StandardException se) {
                                throw Util.generateCsSQLException(se);
                            }
                            if (tran.txState == null) {
                                TXManagerImpl.getOrCreateTXContext().clearTXState();
                            }
                            break block17;
                        } else {
                            TXStateInterface snapshotTXState = TXManagerImpl.getCurrentSnapshotTXState();
                            if (snapshotTXState != null) {
                                if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery || GemFireXDUtils.TraceNCJ) {
                                    SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction#reattachTransaction: for " + tran + " setting gfe tx to snapshot tx" + snapshotTXState));
                                }
                                return;
                            }
                            if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery || GemFireXDUtils.TraceNCJ) {
                                SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction#reattachTransaction: for " + tran + " setting gfe tx to null"));
                            }
                            TXManagerImpl.getOrCreateTXContext().clearTXState();
                            return;
                        }
                    }
                    if (tx != TXStateProxy.TX_NOT_SET && tx != (context = TXManagerImpl.getOrCreateTXContext()).getTXState()) {
                        if (tx != null) {
                            context.setTXState(tx);
                        } else {
                            context.clearTXState();
                        }
                    }
                }
                tran.setActiveState();
            }
            return;
        }
        TXManagerImpl.TXContext context = TXManagerImpl.getOrCreateTXContext();
        if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction#reattachTransaction: clearing GFE transaction with current thread-local GFE TX " + context.getTXState()));
        }
        context.clearTXState();
    }

    public static final void switchContextManager(ContextManager nextCM) {
        GemFireTransaction tran;
        LanguageConnectionContext lcc = (LanguageConnectionContext)nextCM.getContext("LanguageConnectionContext");
        if (lcc != null && (tran = (GemFireTransaction)lcc.getTransactionExecute()) != null && tran.txManager != null) {
            TXManagerImpl.TXContext context;
            TXStateInterface tx;
            if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery || GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction#switchContextManager: for " + tran + " attaching to GFE transaction with current thread-local GFE TX " + TXManagerImpl.getCurrentTXState()));
            }
            if ((tx = tran.txState) == null && tran.state != 2) {
                TXManagerImpl.getOrCreateTXContext().clearTXState();
            } else if (tx != TXStateProxy.TX_NOT_SET && tx != (context = TXManagerImpl.getOrCreateTXContext()).getTXState()) {
                if (tx != null) {
                    context.setTXState(tx);
                } else {
                    context.clearTXState();
                }
            }
        } else {
            TXManagerImpl.TXContext context = TXManagerImpl.getOrCreateTXContext();
            if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction#switchContextManager: clearing GFE transaction with current thread-local GFE TX " + context.getTXState()));
            }
            context.clearTXState();
        }
    }

    public void postTxCompletionOnDataStore(boolean rollback) {
        assert (this.txManager != null) : "unexpected null TXManagerImpl";
        if (GemFireXDUtils.TraceTran || GemFireXDUtils.TraceQuery || GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GemFireTransaction:: postTxCompletionOnDataStore for " + this.toString()));
        }
        this.txState = TXStateProxy.TX_NOT_SET;
        this.txProxy = null;
        this.txStateSuspended = null;
        try {
            this.closeControllers(rollback);
        }
        catch (StandardException se) {
            SanityManager.DEBUG_PRINT((String)"warning:TraceTran", (String)"unexpected exception in closing controllers", (Throwable)se);
        }
        this.setIdleState();
    }

    @Override
    public long addAndLoadStreamContainer(long segmentId, Properties tableProperties, RowSource rowSource, ByteBuffer rwBuffer) throws StandardException {
        SanityManager.ASSERT((segmentId == -1L ? 1 : 0) != 0, (String)"GemFireTransaction: Must be only used for temporary file creations");
        long conglomId = GemFireTransaction.getNextTempConglomId();
        if (this.tempCongloms == null) {
            this.tempCongloms = new TLongObjectHashMap();
        }
        this.tempCongloms.put(conglomId, (Object)new FileStreamInputOutput(conglomId, this, rowSource, rwBuffer));
        return conglomId;
    }

    @Override
    public StreamContainerHandle openStreamContainer(long segmentId, long containerId, boolean hold) throws StandardException {
        SanityManager.ASSERT((segmentId == -1L ? 1 : 0) != 0, (String)"GemFireTransaction: Must be only used for temporary file creations");
        assert (this.tempCongloms != null);
        FileStreamInputOutput fc = (FileStreamInputOutput)this.tempCongloms.get(containerId);
        fc.flipToRead();
        return fc;
    }

    public void setImplicitSnapshotTxStarted(boolean implicitSnapshotTxStarted) {
        this.implicitSnapshotTxStarted = implicitSnapshotTxStarted;
    }

    public boolean getImplcitSnapshotTxStarted() {
        return this.implicitSnapshotTxStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void xa_commit(boolean onePhase) throws StandardException {
        TXStateInterface tx = this.getTopTXState();
        if (tx == null || !tx.isCoordinator()) {
            return;
        }
        try {
            if (onePhase) {
                this.commit(65536, tx, 3, null);
            } else {
                TXManagerImpl.TXContext context = TXManagerImpl.currentTXContext();
                if (context != null) {
                    context.setWaitForPhase2Commit();
                }
                this.commit(65536, tx, 2, this.txContextFromPrepareStage);
            }
        }
        finally {
            this.prepared = false;
            this.txContextFromPrepareStage = null;
        }
    }

    @Override
    public int xa_prepare() throws StandardException {
        TXStateInterface tx = this.getTopTXState();
        if (tx != null && tx.isCoordinator()) {
            if (tx.getProxy().isDirty()) {
                this.commit(65536, tx, 1, null);
                this.prepared = true;
                return 2;
            }
            return 1;
        }
        return 1;
    }

    public final boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public void xa_rollback() throws StandardException {
        try {
            this.abort();
        }
        finally {
            this.txContextFromPrepareStage = null;
            this.prepared = false;
        }
    }

    @Override
    public Object createXATransactionFromLocalTransaction(int formatId, byte[] globalId, byte[] branchId) throws StandardException {
        GlobalXactId gid = new GlobalXactId(formatId, globalId, branchId);
        TransactionTable ttab = Misc.getMemStore().getTransactionTable();
        if (ttab.findTransactionContextByGlobalId(gid) != null) {
            throw StandardException.newException("XSAX1.S");
        }
        this.myXactId = new XactId(this.myId);
        this.setTransactionId(gid, this.myXactId);
        return null;
    }

    @Override
    public FileResource getFileHandler() {
        return Misc.getMemStoreBooting().getJarFileHandler();
    }

    @Override
    public boolean isPristine() {
        return this.state == 2 || this.state == 1;
    }

    public static long getNextTempConglomId() {
        return nextTempConglomId.getAndDecrement();
    }

    public void setRegionRecoveryLock(PartitionedRegion.RecoveryLock lock) {
        this.regionRecoveryLock = lock;
    }

    @Override
    public void dropStreamContainer(long segmentId, long containerId) throws StandardException {
        SanityManager.ASSERT((segmentId == -1L ? 1 : 0) != 0, (String)"GemFireTransaction: Must be only used for temporary file creations");
        FileStreamInputOutput container = (FileStreamInputOutput)this.tempCongloms.remove(containerId);
        SanityManager.ASSERT((container != null ? 1 : 0) != 0, (String)("GemFireTransaction: temporary sorted conglomerate must have been present " + containerId));
        container.close();
    }

    @Override
    public boolean optimizedForOffHeap() {
        return false;
    }

    public void setExecutionSeqInTXState(int execSeq) {
        if (this.txState != null) {
            this.txState.setExecutionSequence(execSeq);
        }
    }

    public void rollbackToPreviousState(int jdbcIsolationlevel, int savePoint, long memberId, int uniqueId) throws SQLException {
        assert (this.txManager != null) : "Cache transaction manager expected to be non null";
        assert (this.txState == null) : "a non-null txstate not expected on the new failover server";
        jdbcIsolationlevel = this.getActualIsolationLevel(jdbcIsolationlevel);
        try {
            IsolationLevel level = GemFireXDUtils.getIsolationLevel(jdbcIsolationlevel, null);
            TXId txId = TXId.valueOf((long)memberId, (int)uniqueId);
            this.beginTransaction(level, txId);
            assert (this.txProxy.getTransactionId().equals(txId));
            this.txProxy.rollback(savePoint);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    private int getActualIsolationLevel(int isolationlevel) {
        if (isolationlevel > 0) {
            return isolationlevel;
        }
        return 2;
    }

    public Checkpoint masqueradeAsTxn(TXId txid, int isolationLevel) throws SQLException {
        GfxdTXStateProxy txp;
        if (SanityManager.TraceClientHA || SanityManager.TraceSingleHop) {
            SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("GFT will masquerade as txid: " + txid + " isolation level = " + isolationLevel));
        }
        if ((txp = this.txProxy) != null && txp.getTransactionId().equals(txid)) {
            return this.txProxy.getACheckPoint();
        }
        try {
            isolationLevel = this.getActualIsolationLevel(isolationLevel);
            IsolationLevel level = GemFireXDUtils.getIsolationLevel(isolationLevel, null);
            this.beginTransaction(level, txid);
            return this.txProxy.getACheckPoint();
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    public void addAffectedRegion(Bucket b) {
        if (SanityManager.TraceClientHA || SanityManager.TraceSingleHop) {
            SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("addAffected region adding region = " + b.getName() + " in txproxy = " + (Object)((Object)this.txProxy)));
        }
        if (this.txProxy != null) {
            this.txProxy.addAffectedRegion(b);
        } else if (SanityManager.TraceClientHA || SanityManager.TraceSingleHop) {
            SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)"unexpected state txproxy not found");
        }
    }

    public TXId getNewTXId(boolean saveNewTxId) {
        if (this.txManager != null) {
            TXId txid = this.txManager.getNewTXId();
            if (saveNewTxId) {
                this.nextTxID = txid;
            }
            return txid;
        }
        return null;
    }

    @Override
    public boolean anyoneBlocked() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addPostCommitWork(Serviceable work) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNoLockWait(boolean noWait) {
    }

    @Override
    public void addUpdateTransaction(int transactionStatus) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean blockBackup(boolean wait) throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkpointInRollForwardRecovery(LogInstant cinstant, long redoLWM, long undoLWM) throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataFactory getDataFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LogInstant getFirstLogInstant() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GlobalTransactionId getGlobalId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TransactionId getId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LogInstant getLastLogInstant() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LockFactory getLockFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DynamicByteArrayOutputStream getLogBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LogFactory getLogFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean handlesPostTerminationWork() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean inAbort() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean inRollForwardRecovery() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBlockingBackup() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void logAndUndo(Compensation compensation, LogInstant undoInstant, LimitObjectInput in) throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RawContainerHandle openDroppedContainer(ContainerKey containerId, LockingPolicy locking) throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void prepareTransaction() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long addContainer(long segmentId, long containerId, int mode, Properties tableProperties, int temporaryFlag) throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reCreateContainerForRedoRecovery(long segmentId, long containerId, ByteArray containerInfo) throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void recoveryTransaction() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeUpdateTransaction() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reprepare() throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFirstLogInstant(LogInstant instant) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLastLogInstant(LogInstant instant) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTransactionId(GlobalTransactionId extid, TransactionId localid) {
    }

    @Override
    public void setTransactionId(Loggable beginXact, TransactionId shortId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RawTransaction startNestedTopTransaction() throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int statusForBeginXactLog() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int statusForEndXactLog() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addPostTerminationWork(Serviceable work) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public LockingPolicy getDefaultLockingPolicy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LockingPolicy newLockingPolicy(int mode, int isolation, boolean stricterOk) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int rollbackToSavePoint(String name, Object kindOfSavepoint) throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDefaultLockingPolicy(LockingPolicy policy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setup(PersistentSet set) throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int releaseSavePoint(String name, Object kindOfSavepoint) throws StandardException {
        return 0;
    }

    @Override
    public int rollbackToSavePoint(String name, boolean closeControllers, Object kindOfSavepoint) throws StandardException {
        return 0;
    }

    @Override
    public int setSavePoint(String name, Object kindOfSavepoint) throws StandardException {
        return 0;
    }

    public void registerOffHeapResourceHolder(OffHeapResourceHolder owner) {
        this.owners.add(owner);
    }

    @Override
    public void addByteSource(OffHeapByteSource byteSource) {
        if (byteSource != null) {
            this.ownerlessAddressesToFree.put(byteSource.getMemoryAddress());
        }
    }

    @Override
    public void registerWithGemFireTransaction(OffHeapResourceHolder owner) {
        throw new UnsupportedOperationException("This should not be invoked on GemFireTransaction");
    }

    @Override
    public void releaseByteSource(int position) {
        throw new UnsupportedOperationException("This should not be invoked on GemFireTransaction");
    }

    public static final class DistributedTXLockOwner
    extends GfxdLocalLockService.DistributedLockOwner
    implements LockOwner {
        public DistributedTXLockOwner() {
        }

        DistributedTXLockOwner(long txId) {
            super(Misc.getGemFireCache().getMyId(), txId);
        }

        @Override
        public String toString() {
            return "DistributedTXLockOwner(member=" + this.getOwnerMember() + ",XID=" + this.getOwnerThreadId() + ",ownerThread=" + this.getOwnerThreadName() + ",vmCreatorThread=" + this.getVMCreatorThread() + ')';
        }

        @Override
        public byte getGfxdID() {
            return 85;
        }

        @Override
        public boolean noWait() {
            throw new UnsupportedOperationException();
        }
    }
}

