/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.diag;

import com.pivotal.gemfirexd.internal.diag.ConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.ConnectionUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.SpaceInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.vti.VTICosting;
import com.pivotal.gemfirexd.internal.vti.VTIEnvironment;
import com.pivotal.gemfirexd.internal.vti.VTITemplate;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SpaceTable
extends VTITemplate
implements VTICosting {
    private ConglomInfo[] conglomTable;
    boolean initialized;
    int currentRow;
    private boolean wasNull;
    private String schemaName;
    private String tableName;
    private SpaceInfo spaceInfo;
    private TransactionController tc;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("CONGLOMERATENAME", 12, true, 128), EmbedResultSetMetaData.getResultColumnDescriptor("ISINDEX", 5, false), EmbedResultSetMetaData.getResultColumnDescriptor("NUMALLOCATEDPAGES", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("NUMFREEPAGES", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("NUMUNFILLEDPAGES", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("PAGESIZE", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("ESTIMSPACESAVING", -5, false)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public SpaceTable(String schemaName, String tableName) {
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public SpaceTable(String tableName) {
        this.tableName = tableName;
    }

    private void getConglomInfo(LanguageConnectionContext lcc) throws StandardException {
        SchemaDescriptor sd;
        TableDescriptor td;
        DataDictionary dd = lcc.getDataDictionary();
        if (this.schemaName == null) {
            this.schemaName = lcc.getCurrentSchemaName();
        }
        if ((td = dd.getTableDescriptor(this.tableName, sd = dd.getSchemaDescriptor(this.schemaName, this.tc, true), this.tc)) == null) {
            this.conglomTable = new ConglomInfo[0];
            return;
        }
        ConglomerateDescriptor[] cds = td.getConglomerateDescriptors();
        this.conglomTable = new ConglomInfo[cds.length];
        for (int i = 0; i < cds.length; ++i) {
            this.conglomTable[i] = new ConglomInfo(cds[i].getConglomerateNumber(), cds[i].isIndex() ? cds[i].getConglomerateName() : this.tableName, cds[i].isIndex());
        }
    }

    private void getSpaceInfo(int index) throws StandardException {
        ConglomerateController cc = this.tc.openConglomerate(this.conglomTable[index].getConglomId(), false, 0, 6, 2);
        this.spaceInfo = cc.getSpaceInfo();
        cc.close();
        cc = null;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    @Override
    public boolean next() throws SQLException {
        try {
            if (!this.initialized) {
                LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
                this.tc = lcc.getTransactionExecute();
                this.getConglomInfo(lcc);
                this.initialized = true;
                this.currentRow = -1;
            }
            if (this.conglomTable == null) {
                return false;
            }
            ++this.currentRow;
            if (this.currentRow >= this.conglomTable.length) {
                return false;
            }
            this.spaceInfo = null;
            this.getSpaceInfo(this.currentRow);
            return true;
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void close() {
        this.conglomTable = null;
        this.spaceInfo = null;
        this.tc = null;
    }

    @Override
    public String getString(int columnNumber) {
        ConglomInfo conglomInfo = this.conglomTable[this.currentRow];
        String str = conglomInfo.getConglomName();
        this.wasNull = str == null;
        return str;
    }

    @Override
    public long getLong(int columnNumber) {
        long longval;
        ConglomInfo conglomInfo = this.conglomTable[this.currentRow];
        switch (columnNumber) {
            case 3: {
                longval = this.spaceInfo.getNumAllocatedPages();
                break;
            }
            case 4: {
                longval = this.spaceInfo.getNumFreePages();
                break;
            }
            case 5: {
                longval = this.spaceInfo.getNumUnfilledPages();
                break;
            }
            case 7: {
                int psize = this.spaceInfo.getPageSize();
                longval = this.spaceInfo.getNumFreePages() * (long)psize;
                break;
            }
            default: {
                longval = -1L;
            }
        }
        this.wasNull = false;
        if (longval < 0L) {
            SanityManager.THROWASSERT((String)("SpaceTable column number " + columnNumber + " has a negative value at row " + this.currentRow));
        }
        return longval;
    }

    @Override
    public short getShort(int columnNumber) {
        ConglomInfo conglomInfo = this.conglomTable[this.currentRow];
        this.wasNull = false;
        return (short)(conglomInfo.getIsIndex() ? 1 : 0);
    }

    @Override
    public int getInt(int columnNumber) {
        return this.spaceInfo.getPageSize();
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public double getEstimatedRowCount(VTIEnvironment vtiEnvironment) {
        return 10000.0;
    }

    @Override
    public double getEstimatedCostPerInstantiation(VTIEnvironment vtiEnvironment) {
        return 100000.0;
    }

    @Override
    public boolean supportsMultipleInstantiations(VTIEnvironment vtiEnvironment) {
        return true;
    }
}

