/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.hadoop.mapreduce;

import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSRegionDirector;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.HoplogUtil;
import com.pivotal.gemfirexd.hadoop.mapreduce.Key;
import com.pivotal.gemfirexd.hadoop.mapreduce.Row;
import com.pivotal.gemfirexd.hadoop.mapreduce.RowRecordReader;
import com.pivotal.gemfirexd.internal.engine.Misc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowInputFormat
extends InputFormat<Key, Row> {
    public static final String HOME_DIR = "gfxd.input.homedir";
    public static final String INPUT_TABLE = "gfxd.input.tablename";
    public static final String START_TIME_MILLIS = "gfxd.input.starttimemillis";
    public static final String END_TIME_MILLIS = "gfxd.input.endtimemillis";
    public static final String CHECKPOINT_MODE = "gfxd.input.checkpointmode";
    public static final String PROPERTY_PREFIX = "gfxd.input.property.";
    protected Configuration conf;
    private final Logger logger = LoggerFactory.getLogger(RowInputFormat.class);

    public RecordReader<Key, Row> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        RowRecordReader reader = new RowRecordReader();
        reader.initialize(split, context);
        return reader;
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException, InterruptedException {
        this.conf = job.getConfiguration();
        Collection<FileStatus> hoplogs = this.getHoplogs(this.conf);
        return this.createSplits(hoplogs);
    }

    public Collection<FileStatus> getHoplogs(Configuration job) throws IOException {
        String name = job.get(INPUT_TABLE);
        String regionName = RowInputFormat.getRegionName(name);
        String regionFolder = HDFSRegionDirector.HdfsRegionManager.getRegionFolder((String)regionName);
        this.logger.info("InputFormat for " + name + " is reading " + regionFolder);
        if (name == null || name.trim().isEmpty()) {
            this.logger.info("Input table name is not correctly configured");
            return new ArrayList<FileStatus>();
        }
        String home = job.get(HOME_DIR, "gemfire");
        Path regionPath = new Path(home + "/" + regionFolder);
        FileSystem fs = regionPath.getFileSystem(job);
        long start = job.getLong(START_TIME_MILLIS, 0L);
        long end = job.getLong(END_TIME_MILLIS, 0L);
        boolean checkpoint = job.getBoolean(CHECKPOINT_MODE, true);
        return HoplogUtil.filterHoplogs((FileSystem)fs, (Path)regionPath, (long)start, (long)end, (boolean)checkpoint);
    }

    private static String getRegionName(String name) {
        name = RowInputFormat.getFullyQualifiedTableName(name);
        return Misc.getRegionPath(name);
    }

    public static String getFullyQualifiedTableName(String name) {
        if (!name.contains(".")) {
            name = "APP." + name;
        }
        return name;
    }

    public List<InputSplit> createSplits(Collection<FileStatus> hoplogs) throws IOException {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        if (hoplogs == null || hoplogs.isEmpty()) {
            return splits;
        }
        HoplogUtil.HoplogOptimizedSplitter splitter = new HoplogUtil.HoplogOptimizedSplitter(hoplogs);
        return splitter.getOptimizedSplits(this.conf);
    }
}

