/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.hadoop.mapreduce;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.internal.engine.hadoop.mapreduce.OutputFormatUtil;
import com.pivotal.gemfirexd.internal.engine.store.CustomRowsResultSet;
import com.pivotal.gemfirexd.internal.engine.store.entry.HDFSEventRowLocationRegionEntry;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.impl.sql.GenericColumnDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TableScanResultSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Row
implements Writable {
    private final EmbedResultSet ers;
    private ResultSet rs;
    SerializableGcdProxy[] rowGcdArray;
    DataValueDescriptor[] rowDvdArray;
    static final Logger logger = LoggerFactory.getLogger(Row.class);

    public Row() {
        this(null);
    }

    public Row(EmbedResultSet resultSet) {
        this.ers = resultSet;
    }

    public final EmbedResultSet getEmbedResultSet() {
        return this.ers;
    }

    public final ResultSet getRowAsResultSet() throws IOException {
        ResultSet rs = this.rs;
        if (rs != null) {
            return rs;
        }
        EmbedResultSet ers = this.ers;
        if (ers != null) {
            this.rs = OutputFormatUtil.getNonIterableResultSet(ers);
            return this.rs;
        }
        if (this.rowGcdArray == null) {
            throw new IllegalStateException("Invalid state: ResultSet is null");
        }
        ResultColumnDescriptor[] gcds = this.createGcdArray(this.rowGcdArray);
        try {
            CustomRowsResultSet crs = new CustomRowsResultSet(new FetchDVDRowsImpl(this.rowDvdArray), gcds);
            if (!crs.next()) {
                throw new IllegalStateException("No row data found in deserialized row");
            }
            this.rs = crs;
            return this.rs;
        }
        catch (Exception e) {
            String msg = "Failed to create result set from deserialized row.";
            logger.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public boolean isPossibleDuplicate() throws IOException {
        PersistedEventImpl event = this.getEvent();
        return event == null ? false : event.isPossibleDuplicate();
    }

    public Event.Type getEventType() throws IOException {
        EmbedResultSet ers = this.ers;
        if (ers != null) {
            return Row.getEventType(Row.getEvent(ers));
        }
        return null;
    }

    public static final Event.Type getEventType(PersistedEventImpl event) throws IOException {
        Operation op = event.getOperation();
        if (op != null) {
            Event.Type type = null;
            if (op.isCreate()) {
                type = Event.Type.AFTER_INSERT;
            } else if (op.isUpdate()) {
                type = Event.Type.AFTER_UPDATE;
            } else if (op.isDestroy()) {
                type = Event.Type.AFTER_DELETE;
            }
            return type;
        }
        return null;
    }

    public long getTimestamp() throws IOException {
        PersistedEventImpl event = this.getEvent();
        return event == null ? 0L : event.getTimstamp();
    }

    private PersistedEventImpl getEvent() throws IOException {
        EmbedResultSet ers = this.ers;
        if (ers != null) {
            return Row.getEvent(ers);
        }
        return null;
    }

    public static final PersistedEventImpl getEvent(EmbedResultSet ers) throws IOException {
        TableScanResultSet sourceSet = (TableScanResultSet)ers.getSourceResultSet();
        try {
            HDFSEventRowLocationRegionEntry row = (HDFSEventRowLocationRegionEntry)sourceSet.getRowLocation();
            return row.getEvent();
        }
        catch (StandardException e) {
            logger.error("Error reading event info from result set row.", (Throwable)e);
            throw new IOException("Error reading event info from result set row.", e);
        }
    }

    public void write(DataOutput out) throws IOException {
        SerializableGcdProxy[] gcdProxyArray = this.getGcdArray();
        out.writeInt(gcdProxyArray.length);
        for (SerializableGcdProxy gcdProxy : gcdProxyArray) {
            gcdProxy.toData(out);
        }
        Object[] dvdArray = this.getDvdArray();
        DataSerializer.writeObjectArray((Object[])dvdArray, (DataOutput)out);
    }

    public void readFields(DataInput in) throws IOException {
        this.rs = null;
        int colCount = in.readInt();
        this.rowGcdArray = new SerializableGcdProxy[colCount];
        for (int i = 0; i < colCount; ++i) {
            SerializableGcdProxy proxy = new SerializableGcdProxy();
            proxy.fromData(in);
            this.rowGcdArray[i] = proxy;
        }
        this.rowDvdArray = new DataValueDescriptor[colCount];
        try {
            this.rowDvdArray = (DataValueDescriptor[])DataSerializer.readObjectArray((DataInput)in);
        }
        catch (ClassNotFoundException e) {
            logger.error("Failed to deserialize object while reading row", (Throwable)e);
            throw new IOException("Failed to deserialize object while reading row", e);
        }
    }

    private SerializableGcdProxy[] getGcdArray() throws IOException {
        if (this.rowGcdArray != null) {
            return this.rowGcdArray;
        }
        EmbedResultSet ers = this.ers;
        if (ers == null) {
            throw new IllegalStateException("Invalid state: ResultSet is null");
        }
        try {
            ResultSetMetaData meta = ers.getMetaData();
            int count = meta.getColumnCount();
            this.rowGcdArray = new SerializableGcdProxy[count];
            for (int i = 0; i < count; ++i) {
                SerializableGcdProxy proxy;
                String name = meta.getColumnName(i + 1);
                int type = meta.getColumnType(i + 1);
                this.rowGcdArray[i] = proxy = new SerializableGcdProxy(name, type);
            }
        }
        catch (SQLException e) {
            logger.error("Meta serialization failed while writing row.", (Throwable)e);
            throw new IOException("Meta serialization failed while writing row.", e);
        }
        return this.rowGcdArray;
    }

    private DataValueDescriptor[] getDvdArray() {
        if (this.rowDvdArray != null) {
            return this.rowDvdArray;
        }
        EmbedResultSet ers = this.ers;
        if (ers == null) {
            throw new IllegalStateException("Invalid state: ResultSet is null");
        }
        ExecRow row = ers.getCurrentRow();
        this.rowDvdArray = row.getRowArray();
        return this.rowDvdArray;
    }

    private GenericColumnDescriptor[] createGcdArray(SerializableGcdProxy[] proxy) {
        GenericColumnDescriptor[] gcdArray = new GenericColumnDescriptor[proxy.length];
        for (int i = 0; i < proxy.length; ++i) {
            String name = proxy[i].columnName;
            int type = proxy[i].columnType;
            ResultColumnDescriptor cd = EmbedResultSetMetaData.getResultColumnDescriptor(name, type, true);
            gcdArray[i] = (GenericColumnDescriptor)cd;
        }
        return gcdArray;
    }

    private static class SerializableGcdProxy {
        private String columnName;
        private int columnType;

        public SerializableGcdProxy() {
        }

        public SerializableGcdProxy(String name, int type) {
            this.columnName = name;
            this.columnType = type;
        }

        public void toData(DataOutput out) throws IOException {
            out.writeInt(this.columnType);
            DataSerializer.writeString((String)this.columnName, (DataOutput)out);
        }

        public void fromData(DataInput in) throws IOException {
            this.columnType = in.readInt();
            this.columnName = DataSerializer.readString((DataInput)in);
        }
    }

    private static class FetchDVDRowsImpl
    implements CustomRowsResultSet.FetchDVDRows {
        private DataValueDescriptor[] dvds;

        public FetchDVDRowsImpl(DataValueDescriptor[] dvds) {
            this.dvds = dvds;
        }

        @Override
        public boolean getNext(DataValueDescriptor[] template) throws SQLException, StandardException {
            if (this.dvds == null) {
                return false;
            }
            for (int i = 0; i < this.dvds.length; ++i) {
                template[i] = this.dvds[i];
            }
            this.dvds = null;
            return true;
        }
    }
}

