/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.hadoop.mapred;

import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.HoplogUtil;
import com.pivotal.gemfirexd.hadoop.mapred.Key;
import com.pivotal.gemfirexd.hadoop.mapred.MapRedRowRecordReader;
import com.pivotal.gemfirexd.hadoop.mapred.Row;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowInputFormat
implements InputFormat<Key, Row> {
    public static final String HOME_DIR = "gfxd.input.homedir";
    public static final String INPUT_TABLE = "gfxd.input.tablename";
    public static final String START_TIME_MILLIS = "gfxd.input.starttimemillis";
    public static final String END_TIME_MILLIS = "gfxd.input.endtimemillis";
    public static final String CHECKPOINT_MODE = "gfxd.input.checkpointmode";
    public static final String PROPERTY_PREFIX = "gfxd.input.property.";
    protected final Logger logger = LoggerFactory.getLogger(RowInputFormat.class);
    protected Configuration conf;

    public RecordReader<Key, Row> getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf job, Reporter reporter) throws IOException {
        if (this.logger.isInfoEnabled()) {
            Path[] splitpaths;
            StringBuffer sb = new StringBuffer();
            for (Path path : splitpaths = this.getSplitPaths(split)) {
                sb.append(", ").append(path);
            }
            this.logger.info("Creating record reader for " + sb.toString());
        }
        MapRedRowRecordReader reader = this.getRecordReader();
        reader.initialize(split, (Configuration)job);
        return reader;
    }

    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        this.conf = job;
        Collection<FileStatus> hoplogs = new com.pivotal.gemfirexd.hadoop.mapreduce.RowInputFormat().getHoplogs((Configuration)job);
        org.apache.hadoop.mapred.InputSplit[] splits = this.createSplits(job, hoplogs);
        return splits;
    }

    private org.apache.hadoop.mapred.InputSplit[] createSplits(JobConf job, Collection<FileStatus> hoplogs) throws IOException {
        if (hoplogs == null || hoplogs.isEmpty()) {
            return new org.apache.hadoop.mapred.InputSplit[0];
        }
        HoplogUtil.HoplogOptimizedSplitter splitter = new HoplogUtil.HoplogOptimizedSplitter(hoplogs);
        List mr2Splits = splitter.getOptimizedSplits(this.conf);
        org.apache.hadoop.mapred.InputSplit[] splits = new org.apache.hadoop.mapred.InputSplit[mr2Splits.size()];
        int i = 0;
        for (InputSplit inputSplit : mr2Splits) {
            CombineFileSplit mr2Spit = (CombineFileSplit)inputSplit;
            org.apache.hadoop.mapred.lib.CombineFileSplit split = new org.apache.hadoop.mapred.lib.CombineFileSplit(job, mr2Spit.getPaths(), mr2Spit.getStartOffsets(), mr2Spit.getLengths(), mr2Spit.getLocations());
            splits[i] = this.getSplit(split);
            ++i;
        }
        return splits;
    }

    protected org.apache.hadoop.mapred.InputSplit getSplit(org.apache.hadoop.mapred.lib.CombineFileSplit split) {
        return split;
    }

    protected MapRedRowRecordReader getRecordReader() {
        return new MapRedRowRecordReader();
    }

    protected Path[] getSplitPaths(org.apache.hadoop.mapred.InputSplit split) {
        org.apache.hadoop.mapred.lib.CombineFileSplit combineSplit = (org.apache.hadoop.mapred.lib.CombineFileSplit)split;
        return combineSplit.getPaths();
    }
}

