/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.callbacks;

import com.pivotal.gemfirexd.callbacks.EventErrorLogger;
import javax.xml.stream.XMLStreamException;

public class ImportErrorLogger
extends EventErrorLogger {
    public boolean isRetry = false;
    public char[][] currentRows = null;
    public int currentRowIndex = -1;
    final String tableName;
    final String importFile;
    protected static final String ERR_XML_IFILE = "importfile";
    protected static final String ERR_XML_LINENUM = "linenumber";
    protected static final String ERR_XML_LINE = "linewitherror";
    protected static final String ERR_XML_TABLE = "tablename";

    public ImportErrorLogger(String errorFileName, String importFileName, String tableName) {
        super(errorFileName);
        this.tableName = tableName;
        this.importFile = importFileName;
    }

    private void writeProp(String startElement, String value, int indent) throws XMLStreamException {
        this.indentInErrorXML(indent);
        if (value != null) {
            this.errorWriter.writeStartElement(startElement);
            this.errorWriter.writeCharacters(value);
            this.errorWriter.writeEndElement();
        } else {
            this.errorWriter.writeStartElement("sql");
            this.errorWriter.writeAttribute("isnull", "true");
            this.errorWriter.writeEndElement();
        }
    }

    public void logError(String line, Integer lineNumber, String dmlString, Exception e) throws Exception {
        this.initErrorFile();
        int indentStep = 2;
        int indent = 2;
        this.errorWriter.writeStartElement("failure");
        this.writeProp("sql", dmlString, indent);
        this.writeProp(ERR_XML_TABLE, this.tableName, indent);
        this.writeProp(ERR_XML_IFILE, this.importFile, indent);
        this.writeProp(ERR_XML_LINENUM, Integer.toString(lineNumber), indent);
        this.writeProp(ERR_XML_LINE, line, indent += 2);
        this.errorWriter.writeCharacters("\n");
        this.writeExceptionInErrorXML(e, indent -= 2, 2, true);
        this.errorWriter.writeCharacters("\n");
        this.errorWriter.writeEndElement();
        this.errorWriter.writeCharacters("\n");
        this.errorWriter.flush();
        this.errorStream.flush();
    }
}

