/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd;

import com.pivotal.gemfirexd.FabricAgent;
import com.pivotal.gemfirexd.FabricLocator;
import com.pivotal.gemfirexd.FabricServer;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricAgentImpl;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricLocatorImpl;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServerImpl;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceImpl;

public abstract class FabricServiceManager {
    private static final Object instanceLock = new Object();

    private FabricServiceManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final FabricServer getFabricServerInstance() {
        FabricService instance = FabricServiceImpl.getInstance();
        if (instance != null) {
            return FabricServiceManager.checkServerInstance(instance);
        }
        Object object = instanceLock;
        synchronized (object) {
            instance = FabricServiceImpl.getInstance();
            if (instance == null) {
                FabricServerImpl server = new FabricServerImpl();
                FabricServiceImpl.setInstance(server);
                return server;
            }
            return FabricServiceManager.checkServerInstance(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final FabricLocator getFabricLocatorInstance() {
        FabricService instance = FabricServiceImpl.getInstance();
        if (instance != null) {
            return FabricServiceManager.checkLocatorInstance(instance);
        }
        Object object = instanceLock;
        synchronized (object) {
            instance = FabricServiceImpl.getInstance();
            if (instance == null) {
                FabricLocatorImpl locator = new FabricLocatorImpl();
                FabricServiceImpl.setInstance(locator);
                return locator;
            }
            return FabricServiceManager.checkLocatorInstance(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final FabricAgent getFabricAgentInstance() {
        FabricService instance = FabricServiceImpl.getInstance();
        if (instance != null) {
            return FabricServiceManager.checkAgentInstance(instance);
        }
        Object object = instanceLock;
        synchronized (object) {
            instance = FabricServiceImpl.getInstance();
            if (instance == null) {
                FabricAgentImpl agent = new FabricAgentImpl();
                FabricServiceImpl.setInstance(agent);
                return agent;
            }
            return FabricServiceManager.checkAgentInstance(instance);
        }
    }

    public static final FabricService currentFabricServiceInstance() {
        return FabricServiceImpl.getInstance();
    }

    private static FabricServer checkServerInstance(FabricService instance) {
        if (instance instanceof FabricServer) {
            return (FabricServer)instance;
        }
        throw new IllegalStateException("Found an existing instance of running locator (" + instance + "). Use getFabricLocatorInstance() to retrieve it.");
    }

    private static FabricLocator checkLocatorInstance(FabricService instance) {
        if (instance instanceof FabricLocator) {
            return (FabricLocator)instance;
        }
        throw new IllegalStateException("Found an existing instance of running server (" + instance + "). Use getFabricServerInstance() to retrieve it.");
    }

    private static FabricAgent checkAgentInstance(FabricService instance) {
        if (instance instanceof FabricAgent) {
            return (FabricAgent)instance;
        }
        throw new IllegalStateException("Found an existing instance of running locator or server (" + instance + "). Use getFabricServerInstance() to retrieve it.");
    }
}

