/*

   Derby - Class com.pivotal.gemfirexd.internal.jdbc.Driver30

   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 */

/*
 * Changes for GemFireXD distributed data platform (some marked by "GemStone changes")
 *
 * Portions Copyright (c) 2010-2015 Pivotal Software, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */

package com.pivotal.gemfirexd.internal.jdbc;




import java.sql.Connection;
import java.sql.SQLException;

import com.gemstone.gnu.trove.THashMap;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredConnection;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredConnection30;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredConnectionControl;
import com.pivotal.gemfirexd.internal.iapi.jdbc.ResourceAdapter;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.jdbc.*;

/** -- jdbc 2.0. extension -- */
import javax.sql.PooledConnection;
import javax.sql.XAConnection;

import java.util.Properties;

/**
	This class extends the local20 JDBC driver in order to determine at JBMS
	boot-up if the JVM that runs us does support JDBC 3.0. If it is the case
	then we will load the appropriate class(es) that have JDBC 3.0 new public
	methods and sql types.
 
*/

public class Driver30 extends Driver20 {

	/**
 	 * Get a new nested connection.
	 *
	 * @param conn	The EmbedConnection.
	 *
	 * @return A nested connection object.
	 *
	 */
	public Connection getNewNestedConnection(EmbedConnection conn)
	{
		if (SanityManager.DEBUG)
		{
			SanityManager.ASSERT(conn instanceof EmbedConnection30,
				"conn expected to be instanceof EmbedConnection30");
		}
		return new EmbedConnection30(conn);
	}

	/*
		Methods to be overloaded in sub-implementations such as
		a tracing driver.
  */
//      GemStone changes BEGIN
	protected EmbedConnection getNewEmbedConnection(String url, Properties info,
	    long id, boolean isRemote, long incomingId)
		 throws SQLException 
	{
		return new EmbedConnection30(this, url, info, id, incomingId, isRemote);
	}
//      GemStone changes END
	/**
	 	@exception SQLException if fails to create statement
	 */
	public java.sql.PreparedStatement
	newEmbedPreparedStatement (
			EmbedConnection conn,
			String stmt,
			boolean forMetaData,
			int resultSetType,
			int resultSetConcurrency,
			int resultSetHoldability,
			int autoGeneratedKeys,
			int[] columnIndexes,
//      GemStone changes BEGIN
                        String[] columnNames, long id, short execFlags, THashMap ncjMetaData,
                        long rootID, int stmtLevel
			)
    throws SQLException
	{
		return new EmbedPreparedStatement30(conn,
								stmt,
								forMetaData,
								resultSetType,
								resultSetConcurrency,
								resultSetHoldability,
								autoGeneratedKeys,
								columnIndexes,
								columnNames,  
                                                                id, execFlags, ncjMetaData, rootID,
                                                                       stmtLevel);
//       GemStone changes END
	}

//      GemStone changes BEGIN
	/**
	 	@exception SQLException if fails to create statement
	 */
	public java.sql.CallableStatement
	newEmbedCallableStatement(
			EmbedConnection conn,
			String stmt,
			int resultSetType,
			int resultSetConcurrency,
			int resultSetHoldability,
			long id, short execFlags)
    throws SQLException
	{
		return new EmbedCallableStatement30(conn,
								stmt,
								resultSetType,
								resultSetConcurrency,
								resultSetHoldability,id,execFlags);
	}

//      GemStone changes  END
	public BrokeredConnection newBrokeredConnection(BrokeredConnectionControl control) {

		return new BrokeredConnection30(control);
	}

    /**
     * Create and return an EmbedPooledConnection from the received instance
     * of EmbeddedDataSource.
     */
    protected PooledConnection getNewPooledConnection(
        EmbeddedDataSource eds, String user, String password,
        boolean requestPassword) throws SQLException
    {
        return new EmbedPooledConnection(
            eds, user, password, requestPassword);
    }

    /**
     * Create and return an EmbedXAConnection from the received instance
     * of EmbeddedDataSource.
     */
    protected XAConnection getNewXAConnection(
        EmbeddedDataSource eds, ResourceAdapter ra,
        String user, String password, boolean requestPassword)
        throws SQLException
    {
        return new EmbedXAConnection(
            eds, ra, user, password, requestPassword);
    }  

}
