/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.server;

import com.gemstone.gemfire.internal.cache.locks.NonReentrantLock;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import io.snappydata.thrift.OpenConnectionArgs;
import io.snappydata.thrift.SecurityMechanism;
import io.snappydata.thrift.StatementAttrs;
import io.snappydata.thrift.common.ThriftExceptionUtil;
import io.snappydata.thrift.server.ClientTracker;
import io.snappydata.thrift.server.SnappyDataServiceImpl;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

final class ConnectionHolder {
    private final EmbedConnection conn;
    private final int connId;
    private final ByteBuffer token;
    private final String clientHostName;
    private final String clientID;
    private final String clientHostId;
    private final String userName;
    private final boolean useStringForDecimal;
    private EmbedStatement reusableStatement;
    private final ArrayList<StatementHolder> activeStatements;
    private final NonReentrantLock sync;

    ConnectionHolder(EmbedConnection conn, OpenConnectionArgs args, int connId, SecureRandom rnd) throws SQLException {
        int tokenSize;
        this.conn = conn;
        this.connId = connId;
        if (args.getSecurity() == SecurityMechanism.PLAIN || args.getSecurity() == SecurityMechanism.DIFFIE_HELLMAN) {
            tokenSize = 16;
            if (args.isSetTokenSize()) {
                if (args.getTokenSize() < tokenSize) {
                    throw ThriftExceptionUtil.newSQLException((String)"08004.C.1", null, (Object[])new Object[]{"specified connection token size " + args.getTokenSize() + " smaller than minimum allowed of " + tokenSize});
                }
                tokenSize = args.getTokenSize();
            }
        } else {
            throw ThriftExceptionUtil.newSQLException((String)"08004.C.1", null, (Object[])new Object[]{"unsupported security mechanism " + args.getSecurity()});
        }
        byte[] rndBytes = new byte[tokenSize];
        rnd.nextBytes(rndBytes);
        this.token = ByteBuffer.wrap(rndBytes);
        this.clientHostName = args.getClientHostName();
        this.clientID = args.getClientID();
        this.clientHostId = ClientTracker.getClientHostId(this.clientHostName, this.clientID);
        this.userName = args.getUserName();
        this.useStringForDecimal = args.isSetUseStringForDecimal() && args.useStringForDecimal;
        this.reusableStatement = (EmbedStatement)conn.createStatement();
        this.activeStatements = new ArrayList(4);
        this.sync = new NonReentrantLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EmbedStatement createNewStatement(StatementAttrs attrs) throws SQLException {
        int resultSetType = SnappyDataServiceImpl.getResultType(attrs);
        int resultSetConcurrency = SnappyDataServiceImpl.getResultSetConcurrency(attrs);
        int resultSetHoldability = SnappyDataServiceImpl.getResultSetHoldability(attrs);
        this.sync.lock();
        try {
            EmbedStatement stmt = this.reusableStatement;
            if (stmt != null) {
                stmt.reset(resultSetType, resultSetConcurrency, resultSetHoldability);
                this.reusableStatement = null;
                EmbedStatement embedStatement = stmt;
                return embedStatement;
            }
        }
        finally {
            this.sync.unlock();
        }
        return (EmbedStatement)this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    final EmbedConnection getConnection() {
        return this.conn;
    }

    final int getConnectionId() {
        return this.connId;
    }

    final ByteBuffer getToken() {
        return this.token;
    }

    static String getTokenAsString(ByteBuffer token) {
        if (token != null) {
            return ClientSharedUtils.toHexString((ByteBuffer)token);
        }
        return "NULL";
    }

    final String getClientHostName() {
        return this.clientHostName;
    }

    final String getClientID() {
        return this.clientID;
    }

    final String getClientHostId() {
        return this.clientHostId;
    }

    final String getUserName() {
        return this.userName;
    }

    final boolean useStringForDecimal() {
        return this.useStringForDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStatementForReuse(EmbedStatement stmt) throws SQLException {
        this.sync.lock();
        try {
            this.setStatementForReuseNoLock(stmt);
        }
        finally {
            this.sync.unlock();
        }
    }

    private void setStatementForReuseNoLock(EmbedStatement stmt) throws SQLException {
        if (this.reusableStatement == null) {
            stmt.resetForReuse();
            this.reusableStatement = stmt;
        } else {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatementHolder registerStatement(Statement stmt, StatementAttrs attrs, int stmtId, String preparedSQL) {
        StatementHolder stmtHolder;
        this.sync.lock();
        try {
            stmtHolder = new StatementHolder(stmt, attrs, stmtId, preparedSQL);
            this.activeStatements.add(stmtHolder);
        }
        finally {
            this.sync.unlock();
        }
        return stmtHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatementHolder registerResultSet(Statement stmt, StatementAttrs attrs, int stmtId, ResultSet rs, int cursorId, String sql) {
        StatementHolder stmtHolder;
        this.sync.lock();
        try {
            stmtHolder = new StatementHolder(stmt, attrs, stmtId, sql);
            stmtHolder.addResultSetNoLock(rs, cursorId);
            this.activeStatements.add(stmtHolder);
        }
        finally {
            this.sync.unlock();
        }
        return stmtHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeStatement(StatementHolder stmtHolder, SnappyDataServiceImpl service) {
        int stmtId = stmtHolder.getStatementId();
        this.sync.lock();
        try {
            EmbedStatement estmt;
            this.removeActiveStatementNoLock(stmtHolder);
            stmtHolder.closeAllResultSets(service);
            Statement stmt = stmtHolder.getStatement();
            if (stmt instanceof EmbedStatement && !(estmt = (EmbedStatement)stmt).isPrepared()) {
                this.setStatementForReuseNoLock(estmt);
            } else if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.sync.unlock();
            service.statementMap.removePrimitive((long)stmtId);
        }
    }

    private void removeActiveStatementNoLock(StatementHolder stmtHolder) {
        ArrayList<StatementHolder> statements = this.activeStatements;
        int size = statements.size();
        while (--size >= 0) {
            if (statements.get(size) != stmtHolder) continue;
            statements.remove(size);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(SnappyDataServiceImpl service) {
        this.sync.lock();
        try {
            for (StatementHolder stmtHolder : this.activeStatements) {
                stmtHolder.closeAllResultSets(service);
                Statement stmt = stmtHolder.getStatement();
                if (stmt == null) continue;
                try {
                    stmt.close();
                }
                catch (SQLException sqle) {
                    service.logger.error("unexpected exception in Statement.close()", (Throwable)sqle);
                }
                finally {
                    service.statementMap.removePrimitive((long)stmtHolder.getStatementId());
                }
            }
            if (this.reusableStatement != null) {
                try {
                    this.reusableStatement.close();
                }
                catch (SQLException sqle) {
                    service.logger.error("unexpected exception in Statement.close()", (Throwable)sqle);
                }
            }
            try {
                this.conn.close();
            }
            catch (SQLException sqle) {
                this.conn.forceClose();
            }
        }
        finally {
            this.sync.unlock();
        }
    }

    final boolean sameToken(ByteBuffer otherId) {
        return ClientSharedUtils.equalBuffers((ByteBuffer)this.token, (ByteBuffer)otherId);
    }

    public final int hashCode() {
        return this.connId;
    }

    final class StatementHolder
    extends ResultSetHolder {
        private final Statement stmt;
        private final StatementAttrs stmtAttrs;
        private final int stmtId;
        private final String sql;
        private ArrayList<ResultSetHolder> moreResultSets;

        private StatementHolder(Statement stmt, StatementAttrs attrs, int stmtId, String sql) {
            super(null, 0, 0);
            this.stmt = stmt;
            this.stmtAttrs = attrs;
            this.stmtId = stmtId;
            this.sql = sql;
        }

        final ConnectionHolder getConnectionHolder() {
            return ConnectionHolder.this;
        }

        final Statement getStatement() {
            return this.stmt;
        }

        final int getStatementId() {
            return this.stmtId;
        }

        final String getSQL() {
            return this.sql;
        }

        final StatementAttrs getStatementAttrs() {
            return this.stmtAttrs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResultSetHolder addResultSet(ResultSet rs, int cursorId) {
            NonReentrantLock sync = ConnectionHolder.this.sync;
            sync.lock();
            try {
                ResultSetHolder resultSetHolder = this.addResultSetNoLock(rs, cursorId);
                return resultSetHolder;
            }
            finally {
                sync.unlock();
            }
        }

        private ResultSetHolder addResultSetNoLock(ResultSet rs, int cursorId) {
            if (this.resultSet == null) {
                this.resultSet = rs;
                this.rsCursorId = cursorId;
                this.rsOffset = 0;
                return this;
            }
            if (this.moreResultSets == null) {
                this.moreResultSets = new ArrayList(4);
            }
            ResultSetHolder holder = new ResultSetHolder(rs, cursorId, 0);
            this.moreResultSets.add(holder);
            return holder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResultSetHolder findResultSet(int cursorId) {
            block7: {
                NonReentrantLock sync = ConnectionHolder.this.sync;
                sync.lock();
                try {
                    if (this.rsCursorId == cursorId) {
                        StatementHolder statementHolder = this;
                        return statementHolder;
                    }
                    ArrayList<ResultSetHolder> moreResults = this.moreResultSets;
                    if (moreResults == null) break block7;
                    for (ResultSetHolder holder : moreResults) {
                        if (holder.rsCursorId != cursorId) continue;
                        ResultSetHolder resultSetHolder = holder;
                        return resultSetHolder;
                    }
                }
                finally {
                    sync.unlock();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResultSet removeResultSet(int cursorId) {
            block10: {
                NonReentrantLock sync = ConnectionHolder.this.sync;
                sync.lock();
                try {
                    if (this.rsCursorId == cursorId) {
                        Object holder;
                        ResultSet rs = this.resultSet;
                        ArrayList<ResultSetHolder> moreResults = this.moreResultSets;
                        if (moreResults != null) {
                            holder = moreResults.remove(moreResults.size() - 1);
                            this.resultSet = ((ResultSetHolder)holder).resultSet;
                            this.rsCursorId = ((ResultSetHolder)holder).rsCursorId;
                            this.rsOffset = ((ResultSetHolder)holder).rsOffset;
                        } else {
                            this.resultSet = null;
                            this.rsCursorId = 0;
                            this.rsOffset = 0;
                        }
                        holder = rs;
                        return holder;
                    }
                    ArrayList<ResultSetHolder> moreResults = this.moreResultSets;
                    if (moreResults == null) break block10;
                    Iterator<ResultSetHolder> itr = moreResults.iterator();
                    while (itr.hasNext()) {
                        ResultSetHolder holder = itr.next();
                        if (holder.rsCursorId != cursorId) continue;
                        itr.remove();
                        if (moreResults.isEmpty()) {
                            this.moreResultSets = null;
                        }
                        ResultSet resultSet = holder.resultSet;
                        return resultSet;
                    }
                }
                finally {
                    sync.unlock();
                }
            }
            return null;
        }

        void closeResultSet(int cursorId, SnappyDataServiceImpl service) {
            ResultSet rs = this.removeResultSet(cursorId);
            if (rs != null) {
                service.resultSetMap.removePrimitive((long)cursorId);
                try {
                    rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeAllResultSets(SnappyDataServiceImpl service) {
            ResultSet rs = this.resultSet;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {
                    service.logger.error("unexpected exception in ResultSet.close()", (Throwable)sqle);
                }
                finally {
                    service.resultSetMap.removePrimitive((long)this.rsCursorId);
                    this.resultSet = null;
                    this.rsCursorId = 0;
                    this.rsOffset = 0;
                }
                ArrayList<ResultSetHolder> moreResults = this.moreResultSets;
                if (moreResults != null) {
                    for (ResultSetHolder holder : moreResults) {
                        try {
                            holder.resultSet.close();
                        }
                        catch (SQLException sqle) {
                            service.logger.error("unexpected exception in ResultSet.close()", (Throwable)sqle);
                        }
                        finally {
                            service.resultSetMap.removePrimitive((long)holder.rsCursorId);
                        }
                    }
                    this.moreResultSets = null;
                }
            }
        }
    }

    static class ResultSetHolder {
        protected ResultSet resultSet;
        protected int rsCursorId;
        protected int rsOffset;

        ResultSetHolder(ResultSet rs, int cursorId, int offset) {
            this.resultSet = rs;
            this.rsCursorId = cursorId;
            this.rsOffset = offset;
        }
    }
}

