/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.tools.dataextractor.report.views;

import com.gemstone.gemfire.internal.cache.persistence.DiskRegionView;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberPattern;
import java.util.HashSet;
import java.util.Set;

public class RegionViewInfoPerMember
implements Comparable<RegionViewInfoPerMember> {
    String name;
    PersistentMemberID myId;
    int onlineScore;
    private Set<PersistentMemberID> onlineMembers = new HashSet<PersistentMemberID>();
    private Set<PersistentMemberID> offlineMembers = new HashSet<PersistentMemberID>();
    private Set<PersistentMemberPattern> revokedMembers = new HashSet<PersistentMemberPattern>();
    private Set<PersistentMemberID> offlineAndEqualMembers = new HashSet<PersistentMemberID>();
    private Set<PersistentMemberID> allMembers = new HashSet<PersistentMemberID>();
    private Set<PersistentMemberID> membersWhoSeeMeOnline = new HashSet<PersistentMemberID>();
    private Set<PersistentMemberID> membersWhoSeeMeOffline = new HashSet<PersistentMemberID>();

    public Set<PersistentMemberID> getAllMembers() {
        return this.allMembers;
    }

    public RegionViewInfoPerMember(DiskRegionView drv) {
        this.name = drv.getName();
        this.myId = drv.getMyPersistentID();
        this.onlineMembers.addAll(drv.getOnlineMembers());
        this.offlineMembers.addAll(drv.getOfflineMembers());
        this.revokedMembers.addAll(drv.getRevokedMembers());
        this.offlineAndEqualMembers.addAll(drv.getOfflineAndEqualMembers());
        this.allMembers.add(this.myId);
        this.allMembers.addAll(this.onlineMembers);
        this.allMembers.addAll(this.offlineMembers);
    }

    public void addMemberWhoSeesMeOnline(PersistentMemberID member) {
        this.membersWhoSeeMeOnline.add(member);
    }

    public void addMemberWhoSeesMeOffline(PersistentMemberID member) {
        this.membersWhoSeeMeOffline.add(member);
    }

    public boolean isSameGroup(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegionViewInfoPerMember other = (RegionViewInfoPerMember)obj;
        if (this.allMembers == null) {
            if (other.allMembers != null) {
                return false;
            }
        } else {
            HashSet<PersistentMemberID> otherMembers = new HashSet<PersistentMemberID>(other.allMembers);
            HashSet<PersistentMemberID> myMembers = new HashSet<PersistentMemberID>(other.allMembers);
            myMembers.retainAll(otherMembers);
            return !myMembers.isEmpty();
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allMembers == null ? 0 : this.allMembers.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegionViewInfoPerMember other = (RegionViewInfoPerMember)obj;
        if (this.allMembers == null ? other.allMembers != null : !this.allMembers.equals(other.allMembers)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String getName() {
        return this.name;
    }

    public Set<PersistentMemberID> getOnlineMembers() {
        return this.onlineMembers;
    }

    public PersistentMemberID getMyId() {
        return this.myId;
    }

    public String toString() {
        return String.format("RegionViewInfo [name=%s, myId=%s, onlineMembers=%s, offlineMembers=%s, revokedMembers=%s, offlineAndEqualMembers=%s]", this.name, this.myId, this.onlineMembers, this.offlineMembers, this.revokedMembers, this.offlineAndEqualMembers);
    }

    public Set<PersistentMemberID> getOfflineMembers() {
        return this.offlineMembers;
    }

    public Set<PersistentMemberPattern> getRevokedMembers() {
        return this.revokedMembers;
    }

    public Set<PersistentMemberID> getOfflineAndEqualMembers() {
        return this.offlineAndEqualMembers;
    }

    public void addOnlineMembers(Set<PersistentMemberID> onlineMembers) {
        this.onlineMembers.addAll(onlineMembers);
    }

    public void addOfflineMembers(Set<PersistentMemberID> offlineMembers) {
        this.offlineMembers.addAll(offlineMembers);
    }

    public void addOfflineAndEqualMembers(Set<PersistentMemberID> offlineAndEqualMembers) {
        this.offlineAndEqualMembers.addAll(offlineAndEqualMembers);
    }

    public void addRevokedMembers(Set<PersistentMemberPattern> revokedMembers) {
        this.revokedMembers.addAll(revokedMembers);
    }

    public boolean checkRevoked(PersistentMemberID pmId) {
        for (PersistentMemberPattern pmm : this.revokedMembers) {
            if (!pmm.matches(pmId)) continue;
            return true;
        }
        return false;
    }

    public void setOnlineScore(int onlineScore) {
        this.onlineScore = onlineScore;
    }

    public int getOnlineScore() {
        return this.onlineScore;
    }

    @Override
    public int compareTo(RegionViewInfoPerMember o) {
        if (this.onlineScore < o.onlineScore) {
            return -1;
        }
        if (this.onlineScore > o.onlineScore) {
            return 1;
        }
        return 0;
    }
}

