/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.log;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.DatabaseInstant;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Loggable;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ScanHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogFactory;
import com.pivotal.gemfirexd.internal.impl.store.raw.log.FlushedScan;
import com.pivotal.gemfirexd.internal.impl.store.raw.log.LogCounter;
import com.pivotal.gemfirexd.internal.impl.store.raw.log.LogRecord;
import com.pivotal.gemfirexd.internal.impl.store.raw.log.LogToFile;
import com.pivotal.gemfirexd.internal.impl.store.raw.log.StreamLogScan;
import java.io.IOException;
import java.io.InputStream;

public class FlushedScanHandle
implements ScanHandle {
    LogFactory lf;
    StreamLogScan fs;
    LogRecord lr = null;
    boolean readOptionalData = false;
    int groupsIWant;
    ArrayInputStream rawInput = new ArrayInputStream(new byte[4096]);

    FlushedScanHandle(LogToFile lf, DatabaseInstant start, int groupsIWant) throws StandardException {
        this.lf = lf;
        this.fs = new FlushedScan(lf, ((LogCounter)start).getValueAsLong());
        this.groupsIWant = groupsIWant;
    }

    @Override
    public boolean next() throws StandardException {
        this.readOptionalData = false;
        this.lr = null;
        try {
            this.lr = this.fs.getNextRecord(this.rawInput, null, this.groupsIWant);
            if (this.lr == null) {
                return false;
            }
            if ((this.groupsIWant & this.lr.group()) == 0) {
                SanityManager.THROWASSERT((String)(this.groupsIWant + "/" + this.lr.group()));
            }
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA2.D", ioe));
        }
    }

    @Override
    public int getGroup() throws StandardException {
        return this.lr.group();
    }

    @Override
    public Loggable getLoggable() throws StandardException {
        try {
            return this.lr.getLoggable();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA2.D", ioe));
        }
        catch (ClassNotFoundException cnfe) {
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA3.D", cnfe));
        }
    }

    @Override
    public InputStream getOptionalData() throws StandardException {
        SanityManager.ASSERT((!this.readOptionalData ? 1 : 0) != 0);
        if (this.lr == null) {
            return null;
        }
        try {
            int dataLength = this.rawInput.readInt();
            this.readOptionalData = true;
            this.rawInput.setLimit(dataLength);
            return this.rawInput;
        }
        catch (IOException ioe) {
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA2.D", ioe));
        }
    }

    @Override
    public DatabaseInstant getInstant() throws StandardException {
        return this.fs.getLogInstant();
    }

    @Override
    public Object getTransactionId() throws StandardException {
        try {
            return this.lr.getTransactionId();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA2.D", ioe));
        }
        catch (ClassNotFoundException cnfe) {
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA3.D", cnfe));
        }
    }

    @Override
    public void close() {
        if (this.fs != null) {
            this.fs.close();
        }
        this.fs = null;
    }
}

