/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.rules;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.sql.rules.ExecutionEngineRule;
import com.pivotal.gemfirexd.internal.impl.sql.rules.ExecutionRuleContext;

class AnyOneOfExecutionEngineRule
extends ExecutionEngineRule {
    AnyOneOfExecutionEngineRule() {
    }

    @Override
    protected ExecutionEngineRule.ExecutionEngine findExecutionEngine(DMLQueryInfo qInfo, ExecutionRuleContext context) {
        if (qInfo.isQuery(8, 16) || qInfo.isOuterJoinSpecialCase()) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)"AnyOneOfExecutionEngineRule:DISTINCT_QUERY_RULE:SPARK");
            return ExecutionEngineRule.ExecutionEngine.SPARK;
        }
        if (qInfo.hasUnionNode() || qInfo.hasIntersectOrExceptNode()) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)"AnyOneOfExecutionEngineRule:UNION_OR_INTERSECT_QUERY_RULE:SPARK");
            return ExecutionEngineRule.ExecutionEngine.SPARK;
        }
        if (qInfo.isQuery(2) && qInfo.getPrimaryKey() == null && qInfo.getLocalIndexKey() == null) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)"AnyOneOfExecutionEngineRule:GROUPBY_QUERY_RULE:SPARK");
            return ExecutionEngineRule.ExecutionEngine.SPARK;
        }
        if (qInfo.isQuery(8192)) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)"AnyOneOfExecutionEngineRule:NOT_GET_CONVERTIBLE_RULE:SPARK");
            return ExecutionEngineRule.ExecutionEngine.SPARK;
        }
        if (!qInfo.isQuery(4096)) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)"AnyOneOfExecutionEngineRule:GETALL_ON_LOCAL_INDEX_RULE:SPARK");
            return ExecutionEngineRule.ExecutionEngine.SPARK;
        }
        return ExecutionEngineRule.ExecutionEngine.NOT_DECIDED;
    }
}

