/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute.xplain;

import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.NanoTimer;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.procedure.cohort.OutgoingResultSetImpl;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINScanPropsDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINSortPropsDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AbstractPolymorphicStatisticsCollector;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BasicNoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoRowsResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TemporaryRowHolderResultSet;
import java.sql.Timestamp;
import java.util.Properties;

public final class XPLAINUtil {
    public static final String ISOLATION_READ_UNCOMMITED = "RU";
    public static final String ISOLATION_READ_COMMIT = "RC";
    public static final String ISOLATION_REPEAT_READ = "RR";
    public static final String ISOLATION_SERIALIZABLE = "SE";
    public static final String LOCK_MODE_EXCLUSIVE = "EX";
    public static final String LOCK_MODE_INSTANTENOUS_EXCLUSIVE = "IX";
    public static final String LOCK_MODE_SHARE = "SH";
    public static final String LOCK_MODE_INSTANTENOUS_SHARE = "IS";
    public static final String LOCK_GRANULARITY_TABLE = "T";
    public static final String LOCK_GRANULARITY_ROW = "R";
    public static final String OP_TABLESCAN = "TABLESCAN";
    public static final String OP_INDEXSCAN = "INDEXSCAN";
    public static final String OP_HASHSCAN = "HASHSCAN";
    public static final String OP_DISTINCTSCAN = "DISTINCTSCAN";
    public static final String OP_LASTINDEXKEYSCAN = "LASTINDEXKEYSCAN";
    public static final String OP_HASHTABLE = "HASHTABLE";
    public static final String OP_ROWIDSCAN = "ROWIDSCAN";
    public static final String OP_CONSTRAINTSCAN = "CONSTRAINTSCAN";
    public static final String OP_GLOBALINDEXSCAN = "GLOBALINDEXSCAN";
    public static final String OP_JOIN_NL = "NLJOIN";
    public static final String OP_JOIN_HASH = "HASHJOIN";
    public static final String OP_JOIN_NL_LO = "LONLJOIN";
    public static final String OP_JOIN_HASH_LO = "LOHASHJOIN";
    public static final String OP_JOIN_MERGE = "MERGEJOIN";
    public static final String OP_UNION = "UNION";
    public static final String OP_SET = "SET";
    public static final String OP_SET_INTERSECT = "INTERSECT";
    public static final String OP_SET_EXCEPT = "EXCEPT";
    public static final String OP_INSERT = "INSERT";
    public static final String OP_UPDATE = "UPDATE";
    public static final String OP_DELETE = "DELETE";
    public static final String OP_CASCADE = "CASCADE";
    public static final String OP_VTI = "VTI";
    public static final String OP_BULK = "BULK";
    public static final String OP_DISTINCT = "DISTINCT";
    public static final String OP_NORMALIZE = "NORMALIZE";
    public static final String OP_ANY = "ANY";
    public static final String OP_SCROLL = "SCROLL-INSENSITIVE";
    public static final String OP_MATERIALIZE = "MATERIALIZE";
    public static final String OP_ONCE = "ONCE";
    public static final String OP_VTI_RS = "VTI";
    public static final String OP_ROW = "ROW";
    public static final String OP_PROJECT = "PROJECTION";
    public static final String OP_FILTER = "FILTER";
    public static final String OP_AGGREGATE = "AGGREGATION";
    public static final String OP_PROJ_RESTRICT = "PROJECT-FILTER";
    public static final String OP_SORT = "SORT";
    public static final String OP_GROUP = "GROUPBY";
    public static final String OP_CURRENT_OF = "CURRENT-OF";
    public static final String OP_ROW_COUNT = "ROW-COUNT";
    public static final String OP_WINDOW = "WINDOW";
    public static final String SCAN_HEAP = "HEAP";
    public static final String SCAN_BTREE = "BTREE";
    public static final String SCAN_SORT = "SORT";
    public static final String SCAN_BITSET_ALL = "ALL";
    public static final String SELECT_STMT_TYPE = "S";
    public static final String SELECT_APPROXIMATE_STMT_TYPE = "SA";
    public static final String INSERT_STMT_TYPE = "I";
    public static final String UPDATE_STMT_TYPE = "U";
    public static final String DELETE_STMT_TYPE = "D";
    public static final String CALL_STMT_TYPE = "C";
    public static final String DDL_STMT_TYPE = "DDL";
    public static final String XPLAIN_ONLY = "O";
    public static final String XPLAIN_FULL = "F";
    public static final String SORT_EXTERNAL = "EX";
    public static final String SORT_INTERNAL = "IN";
    public static final String YES_CODE = "Y";
    public static final String NO_CODE = "N";
    public static final String OP_GET = "REGION-GET";
    public static final String OP_PUT = "REGION-PUT";
    public static final String OP_GETTALL = "REGION-GETALL";
    public static final String OP_LI_GETTALL = "LOCAL-INDEX-GETALL";
    public static final String OP_PUTALL = "REGION-PUTALL";
    public static final String OP_QUERY_SCATTER = "QUERY-SCATTER";
    public static final String OP_QUERY_SEND = "QUERY-SEND";
    public static final String OP_QUERY_RECEIVE = "QUERY-RECEIVE";
    public static final String OP_RESULT_SEND = "RESULT-SEND";
    public static final String OP_RESULT_RECEIVE = "RESULT-RECEIVE";
    public static final String OP_RESULT_HOLDER = "RESULT-HOLDER";
    public static final String OP_SEQUENTIAL_ITERATOR = "SEQUENTIAL-ITERATION";
    public static final String OP_ROUNDROBIN_ITERATOR = "ROUNDROBIN-ITERATION";
    public static final String OP_ORDERED_ITERATOR = "ORDERED-ITERATION";
    public static final String OP_GROUPED_ITERATOR = "GROUPED-ITERATION";
    public static final String OP_OUTERJOIN_ITERATOR = "OUTER-JOIN-ITERATION";
    public static final String OP_ROWCOUNT_ITERATOR = "ROW-COUNT-ITERATION";
    public static final String OP_DISTRIBUTION_END = "DISTRIBUTION-END";
    public static final long oneMillisNanos = 1000000L;

    public static String getYesNoCharFromBoolean(boolean test) {
        if (test) {
            return YES_CODE;
        }
        return NO_CODE;
    }

    public static String getHashKeyColumnNumberString(int[] hashKeyColumns) {
        String hashKeyColumnString;
        if (hashKeyColumns == null) {
            return null;
        }
        if (hashKeyColumns.length == 1) {
            hashKeyColumnString = MessageService.getTextMessage("43X53.U") + " " + hashKeyColumns[0];
        } else {
            hashKeyColumnString = MessageService.getTextMessage("43X54.U") + " (" + hashKeyColumns[0];
            for (int index = 1; index < hashKeyColumns.length; ++index) {
                hashKeyColumnString = hashKeyColumnString + "," + hashKeyColumns[index];
            }
            hashKeyColumnString = hashKeyColumnString + ")";
        }
        return hashKeyColumnString;
    }

    public static String getLockModeCode(String lockString) {
        if ((lockString = lockString.toUpperCase()).startsWith("EXCLUSIVE")) {
            return "EX";
        }
        if (lockString.startsWith("SHARE")) {
            return LOCK_MODE_SHARE;
        }
        if (lockString.startsWith("INSTANTANEOUS")) {
            int length;
            int start = "INSTANTANEOUS".length();
            String sub = lockString.substring(start + 1, length = lockString.length());
            if (sub.startsWith("EXCLUSIVE")) {
                return LOCK_MODE_INSTANTENOUS_EXCLUSIVE;
            }
            if (sub.startsWith("SHARE")) {
                return LOCK_MODE_INSTANTENOUS_SHARE;
            }
            return null;
        }
        return null;
    }

    public static String getIsolationLevelCode(int isolationLevel) {
        switch (isolationLevel) {
            case 5: {
                return ISOLATION_SERIALIZABLE;
            }
            case 4: {
                return ISOLATION_REPEAT_READ;
            }
            case 2: 
            case 3: {
                return ISOLATION_READ_COMMIT;
            }
            case 1: {
                return ISOLATION_READ_UNCOMMITED;
            }
        }
        return null;
    }

    public static String getLockGranularityCode(String lockString) {
        if ((lockString = lockString.toUpperCase()).endsWith("TABLE")) {
            return LOCK_GRANULARITY_TABLE;
        }
        return LOCK_GRANULARITY_ROW;
    }

    public static String getStatementType(String SQLText) {
        if (SQLText == null) {
            return null;
        }
        String type = null;
        String text = SQLText.toUpperCase().trim();
        if (text.startsWith("CALL")) {
            type = CALL_STMT_TYPE;
        } else if (text.startsWith("SELECT")) {
            type = text.indexOf("~") > -1 ? SELECT_APPROXIMATE_STMT_TYPE : SELECT_STMT_TYPE;
        } else if (text.startsWith(OP_DELETE)) {
            type = DELETE_STMT_TYPE;
        } else if (text.startsWith(OP_INSERT)) {
            type = INSERT_STMT_TYPE;
        } else if (text.startsWith(OP_UPDATE)) {
            type = UPDATE_STMT_TYPE;
        } else if (text.startsWith("CREATE") || text.startsWith("ALTER") || text.startsWith("DROP")) {
            type = DDL_STMT_TYPE;
        }
        return type;
    }

    public static XPLAINScanPropsDescriptor extractScanProps(XPLAINScanPropsDescriptor descriptor, Properties scanProps) {
        String bs_property;
        String bth_property;
        String dvr_property;
        String fc_property;
        String qr_property;
        String vr_property;
        String scan_type = "";
        String scan_type_property = scanProps.getProperty(MessageService.getTextMessage("XSAJ0.U"));
        if (scan_type_property != null) {
            if (scan_type_property.equalsIgnoreCase(MessageService.getTextMessage("XSAJG.U"))) {
                scan_type = SCAN_HEAP;
            } else if (scan_type_property.equalsIgnoreCase(MessageService.getTextMessage("XSAJH.U"))) {
                scan_type = "SORT";
            } else if (scan_type_property.equalsIgnoreCase(MessageService.getTextMessage("XSAJF.U"))) {
                scan_type = SCAN_BTREE;
            }
        } else {
            scan_type = null;
        }
        descriptor.setScan_type(scan_type);
        String vp_property = scanProps.getProperty(MessageService.getTextMessage("XSAJ1.U"));
        if (vp_property != null) {
            descriptor.setNo_visited_pages(Integer.valueOf(vp_property));
        }
        if ((vr_property = scanProps.getProperty(MessageService.getTextMessage("XSAJ2.U"))) != null) {
            descriptor.setNo_visited_rows(Integer.valueOf(vr_property));
        }
        if ((qr_property = scanProps.getProperty(MessageService.getTextMessage("XSAJ4.U"))) != null) {
            descriptor.setNo_qualified_rows(Integer.valueOf(qr_property));
        }
        if ((fc_property = scanProps.getProperty(MessageService.getTextMessage("XSAJ5.U"))) != null) {
            descriptor.setNo_fetched_columns(Integer.valueOf(fc_property));
        }
        if ((dvr_property = scanProps.getProperty(MessageService.getTextMessage("XSAJ3.U"))) != null) {
            descriptor.setNo_visited_deleted_rows(Integer.valueOf(dvr_property));
        }
        if ((bth_property = scanProps.getProperty(MessageService.getTextMessage("XSAJ7.U"))) != null) {
            descriptor.setBtree_height(Integer.valueOf(bth_property));
        }
        if ((bs_property = scanProps.getProperty(MessageService.getTextMessage("XSAJ6.U"))) != null) {
            if (bs_property.equalsIgnoreCase(MessageService.getTextMessage("XSAJE.U"))) {
                descriptor.setBitset_of_fetched_columns(SCAN_BITSET_ALL);
            } else {
                descriptor.setBitset_of_fetched_columns(bs_property);
            }
        }
        return descriptor;
    }

    public static XPLAINSortPropsDescriptor extractSortProps(XPLAINSortPropsDescriptor descriptor, Properties sortProps) {
        String or_property;
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("Extracting Sort properties from " + sortProps));
        }
        String sort_type = null;
        String sort_type_property = sortProps.getProperty(MessageService.getTextMessage("XSAJ8.U"));
        if (sort_type_property != null) {
            sort_type = sort_type_property.equalsIgnoreCase(MessageService.getTextMessage("XSAJI.U")) ? "EX" : SORT_INTERNAL;
        }
        descriptor.setSort_type(sort_type);
        String ir_property = sortProps.getProperty(MessageService.getTextMessage("XSAJA.U"));
        if (ir_property != null) {
            descriptor.setNo_input_rows(Integer.valueOf(ir_property));
        }
        if ((or_property = sortProps.getProperty(MessageService.getTextMessage("XSAJB.U"))) != null) {
            descriptor.setNo_output_rows(Integer.valueOf(or_property));
        }
        if (sort_type == "EX") {
            String nomrd_property;
            String nomr_property = sortProps.getProperty(MessageService.getTextMessage("XSAJC.U"));
            if (nomr_property != null) {
                descriptor.setNo_merge_runs(Integer.valueOf(nomr_property));
            }
            if ((nomrd_property = sortProps.getProperty(MessageService.getTextMessage("XSAJD.U"))) != null) {
                descriptor.setMerge_run_details(nomrd_property);
            }
        }
        return descriptor;
    }

    public static long getAVGNextTime(long dividend, long divisor) {
        if (divisor == 0L) {
            return 0L;
        }
        if (dividend == 0L) {
            return 0L;
        }
        return dividend / divisor;
    }

    public static final long nanoTime() {
        return NanoTimer.nanoTime();
    }

    public static final long nanoTimeThread() {
        return NanoTimer.nativeNanoTime((int)3, (boolean)true);
    }

    public static final Timestamp currentTimeStamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static final long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static final long recordStdTiming(long startTime) {
        return DistributionStats.getStatTimeNoCheck() - startTime;
    }

    public static final long recordTiming(long startTime) {
        if (startTime == -1L) {
            return XPLAINUtil.nanoTime();
        }
        if (startTime == -2L) {
            return 0L;
        }
        long ts = XPLAINUtil.nanoTime();
        long delta = ts - startTime;
        if (GemFireXDUtils.TracePlanAssertion) {
            SanityManager.ASSERT((delta >= 0L ? 1 : 0) != 0, (String)(delta + " " + ts + " " + startTime));
        }
        return delta >= 0L ? delta : 0L;
    }

    public static final class ChildNodeTimeCollector
    extends AbstractPolymorphicStatisticsCollector {
        private ResultSet rootrs = null;
        private long totalTime = 0L;

        public ChildNodeTimeCollector(ResultSetStatisticsVisitor nextCollector) {
        }

        @Override
        public void visitVirtual(NoRowsResultSetImpl rs) {
            if (rs == this.rootrs) {
                return;
            }
            this.totalTime += rs.endExecutionTime - rs.beginExecutionTime;
        }

        @Override
        public void visitVirtual(BasicNoPutResultSetImpl rs) {
            if (rs == this.rootrs) {
                return;
            }
            this.totalTime += rs.constructorTime + rs.openTime + rs.nextTime + rs.closeTime;
        }

        @Override
        public void visitVirtual(AbstractGemFireResultSet rs) {
            if (rs == this.rootrs) {
                return;
            }
            this.totalTime += rs.openTime + rs.nextTime + rs.closeTime;
        }

        @Override
        public void visitVirtual(OutgoingResultSetImpl rs) {
        }

        @Override
        public void visitVirtual(TemporaryRowHolderResultSet rs) {
        }

        @Override
        public void clear() {
            this.totalTime = 0L;
            this.rootrs = null;
        }

        public void setRootRs(ResultSet rs) {
            this.rootrs = rs;
        }

        public long getNodeTime() {
            return this.totalTime;
        }
    }

    public static enum XMLForms {
        none,
        asXML,
        asXMLFragments;

    }

    public static enum DIRECTION {
        IN,
        OUT;

    }
}

