/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.AliasDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.RoutinePermsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GranteeIterator;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PrivilegeInfo;
import java.util.List;

public class RoutinePrivilegeInfo
extends PrivilegeInfo {
    private AliasDescriptor aliasDescriptor;

    public RoutinePrivilegeInfo(AliasDescriptor aliasDescriptor) {
        this.aliasDescriptor = aliasDescriptor;
    }

    @Override
    public void executeGrantRevoke(Activation activation, boolean grant, List grantees) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        String currentUser = lcc.getAuthorizationId();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        SchemaDescriptor sd = dd.getSchemaDescriptor(this.aliasDescriptor.getSchemaUUID(), tc);
        this.schemaName = sd.getSchemaName();
        this.objectName = this.aliasDescriptor.getObjectName();
        this.checkOwnership(currentUser, this.aliasDescriptor, sd, dd);
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        RoutinePermsDescriptor routinePermsDesc = ddg.newRoutinePermsDescriptor(this.aliasDescriptor, currentUser);
        GranteeIterator itr = new GranteeIterator(grantees, routinePermsDesc, grant, 18, 2, 6, dd, tc);
        while (itr.hasNext()) {
            boolean privileges_revoked = false;
            String grantee = itr.moveNext();
            if (dd.addRemovePermissionsDescriptor(grant, routinePermsDesc, grantee, tc)) {
                privileges_revoked = true;
                dd.getDependencyManager().invalidateFor(routinePermsDesc, 45, lcc);
                dd.getDependencyManager().invalidateFor(this.aliasDescriptor, 23, lcc);
            }
            this.addWarningIfPrivilegeNotRevoked(activation, grant, privileges_revoked, grantee);
        }
    }
}

