/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.RoleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;
import java.util.Iterator;
import java.util.List;

class RevokeRoleConstantAction
extends DDLConstantAction {
    private List roleNames;
    private List grantees;
    private final boolean withAdminOption = false;

    public RevokeRoleConstantAction(List roleNames, List grantees) {
        this.roleNames = roleNames;
        this.grantees = grantees;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        String grantor = lcc.getAuthorizationId();
        dd.startWriting(lcc);
        for (String role : this.roleNames) {
            for (String grantee : this.grantees) {
                RoleDescriptor rd = dd.getRoleDefinitionDescriptor(role);
                if (rd == null) {
                    throw StandardException.newException("0P000", role);
                }
                if (!grantor.equals(rd.getGrantee())) {
                    throw StandardException.newException("4251A", "REVOKE role");
                }
                SanityManager.ASSERT((boolean)lcc.getDataDictionary().getAuthorizationDatabaseOwner().equals(grantor), (String)"expected database owner in role descriptor");
                SanityManager.ASSERT((boolean)rd.isWithAdminOption(), (String)"expected role definition to have ADMIN OPTION");
                rd = dd.getRoleGrantDescriptor(role, grantee, grantor);
                if (rd != null) {
                    // empty if block
                }
                if (rd != null) {
                    rd.drop(lcc);
                    continue;
                }
                activation.addWarning(StandardException.newWarning("01007", role, grantee));
            }
        }
    }

    public String toString() {
        StringBuilder sb1 = new StringBuilder();
        Iterator it = this.roleNames.iterator();
        while (it.hasNext()) {
            if (sb1.length() > 0) {
                sb1.append(", ");
            }
            sb1.append(it.next().toString());
        }
        StringBuilder sb2 = new StringBuilder();
        Iterator it2 = this.grantees.iterator();
        while (it2.hasNext()) {
            if (sb2.length() > 0) {
                sb2.append(", ");
            }
            sb2.append(it2.next().toString());
        }
        return "REVOKE " + sb1.toString() + " FROM: " + sb2.toString() + "\n";
    }

    @Override
    public String getSchemaName() {
        return null;
    }

    @Override
    public boolean isCancellable() {
        return false;
    }
}

