/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecAggregator;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AggregatorInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.OrderableAggregator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class MaxMinAggregator
extends OrderableAggregator {
    private boolean isMax;

    @Override
    public void setup(String aggregateName, AggregatorInfo aggInfo) {
        this.isMax = aggregateName.equals("MAX");
        if (aggInfo != null) {
            super.setup(aggInfo);
        }
    }

    @Override
    protected void basicAccumulate(DataValueDescriptor addend) throws StandardException {
        if (this.value == null) {
            this.value = addend.getClone();
        } else if (this.value.isNull()) {
            if (!addend.isNull()) {
                this.value.setValue(addend);
            }
        } else if (this.isMax) {
            if (this.value.compare(addend) < 0) {
                this.value.setValue(addend);
            }
        } else if (this.value.compare(addend) > 0) {
            this.value.setValue(addend);
        }
    }

    @Override
    public ExecAggregator newAggregator() {
        MaxMinAggregator ma = new MaxMinAggregator();
        ma.isMax = this.isMax;
        return ma;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.isMax);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.isMax = in.readBoolean();
    }

    @Override
    public int getTypeFormatId() {
        return 152;
    }
}

