/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgument;
import com.gemstone.gemfire.internal.shared.ClientSharedData;
import com.pivotal.gemfirexd.callbacks.AsyncEventHelper;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.BulkDBSynchronizerMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.CacheLoadedDBSynchronizerMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.GfxdCBArgForSynchPrms;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.procedure.cohort.ProcedureSender;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ActivationStatisticsVisitor;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ConstantValueSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireInsertResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GfxdSubqueryResultSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.SQLWarningFactory;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.ConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedByteCode;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedClass;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorActivation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ResultSetFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TemporaryRowHolder;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameterValueSet;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.UnionResultSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public abstract class BaseActivation
implements CursorActivation,
GeneratedByteCode {
    protected LanguageConnectionContext lcc;
    protected ContextManager cm;
    protected ExecPreparedStatement preStmt;
    protected ResultSet resultSet;
    protected ResultDescription resultDescription;
    protected boolean closed;
    private String cursorName;
    protected int numSubqueries;
    private boolean singleExecution;
    private volatile boolean inUse;
    private java.sql.ResultSet targetVTI;
    private SQLWarning resultsetWarnings;
    private SQLWarning warnings;
    private GeneratedClass gc;
    private boolean checkRowCounts;
    private final HashSet rowCountsCheckedThisExecution = new HashSet(4, 0.9f);
    private static final long MAX_SQRT = (long)Math.sqrt(9.223372036854776E18);
    private static final int TEN_PERCENT_THRESHOLD = 400;
    private ConglomerateController updateHeapCC;
    private ScanController indexSC;
    private long indexConglomerateNumber = -1L;
    private TableDescriptor ddlTableDescriptor;
    private int maxRows = -1;
    private boolean forCreateTable;
    private boolean scrollable;
    private boolean resultSetHoldability;
    private CursorResultSet forUpdateIndexScan;
    private boolean autoGeneratedKeysResultSetMode;
    private int[] autoGeneratedKeysColumnIndexes;
    private String[] autoGeneratedKeysColumnNames;
    private Activation callActivation;
    private String nestedCurrentRole;
    protected int indexOfSessionTableNamesInSavedObjects = -1;
    private volatile short queryCancellationFlag = 0;
    public static final short CANCELLED_LOW_MEMORY = 1;
    public static final short CANCELLED_TIMED_OUT = 2;
    public static final short CANCELLED_USER_REQUESTED = 3;
    long timeoutMillis = 0L;
    protected long connectionID;
    protected long statementID;
    protected boolean isPrepStmntQuery;
    protected int executionID;
    protected long rootID;
    protected int statementLevel;
    private boolean isPutDML = false;
    protected ExecRow[] row;
    protected ParameterValueSet pvs;
    public boolean addToLCC;
    private DataValueDescriptor expressionDVD = null;
    private DataValueDescriptor[] expressionDVDs = null;
    private String objectName = null;
    private Object[] savedObjects = null;
    protected String currentColumnName;
    private String statementText = null;
    protected CursorResultSet[] raParentResultSets;
    protected Hashtable parentResultSets;
    private Calendar cal;
    private boolean[] updatedColumns = null;
    private int[] projectMapping = null;
    private FunctionContext fnContext;
    private ProcedureSender sender;
    private int flags;
    private boolean useOnlyPrimaryBuckets;
    private boolean queryHDFS = false;
    private boolean hasQueryHDFS = false;

    @Override
    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public void setObjectName(String name) {
        this.objectName = name;
    }

    @Override
    public void addNullEliminatedWarning() {
        if ((this.flags & 0x40) == 0) {
            this.addResultsetWarning(SQLWarningFactory.newSQLWarning("01003"));
            this.flags |= 0x40;
        }
    }

    @Override
    public String getCurrentColumnName() {
        return this.currentColumnName;
    }

    @Override
    public void setCurrentColumnName(String name) {
        this.currentColumnName = name;
    }

    public String getStatementText() {
        return this.statementText;
    }

    public void setExpressionDVDs(DataValueDescriptor dvd, DataValueDescriptor[] dvds) {
        this.expressionDVD = dvd;
        this.expressionDVDs = dvds;
    }

    protected BaseActivation(LanguageConnectionContext lcc) {
        this.lcc = lcc;
    }

    protected BaseActivation() {
    }

    @Override
    public final void initFromContext(LanguageConnectionContext context, boolean addToLCC, ExecPreparedStatement eps) throws StandardException {
        if (context == null) {
            SanityManager.THROWASSERT((String)"NULL context passed to BaseActivation.initFromContext");
            return;
        }
        this.cm = context.getContextManager();
        this.lcc = context;
        if (this.lcc == null) {
            SanityManager.THROWASSERT((String)("lcc is null in activation type " + this.getClass()));
        }
        this.inUse = true;
        this.preStmt = eps;
        if (eps instanceof GenericPreparedStatement) {
            this.savedObjects = ((GenericPreparedStatement)eps).getSavedObjects();
        }
        if (this.addToLCC = addToLCC) {
            this.lcc.addActivation(this);
        }
    }

    @Override
    public final ExecPreparedStatement getPreparedStatement() {
        return this.preStmt;
    }

    @Override
    public ConstantAction getConstantAction() {
        return this.preStmt.getConstantAction();
    }

    @Override
    public void checkStatementValidity() throws StandardException {
        if (this.preStmt == null) {
            return;
        }
        if (this.preStmt.upToDate() && this.gc == this.preStmt.getActivationClass()) {
            return;
        }
        StandardException se = StandardException.newException("XCL32.S");
        se.setReport(1);
        throw se;
    }

    public void setupActivation(ExecPreparedStatement ps, boolean scrollable, String stmt_text) throws StandardException {
        this.preStmt = ps;
        this.statementText = stmt_text;
        if (ps != null) {
            this.resultDescription = ps.getResultDescription();
            this.scrollable = scrollable;
            if (this.pvs != null && this.pvs.getParameterCount() != 0) {
                this.pvs.initialize(ps.getParameterTypes());
            } else {
                this.setConstantParameters(this.lcc.getConstantValueSet(this));
            }
            this.setInsertAsSubselect(ps.isInsertAsSubselect());
            this.setPutDML(ps.isPutDML());
        } else {
            this.resultDescription = null;
            this.scrollable = false;
        }
    }

    @Override
    public ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public RowLocation getRowLocationTemplate(int itemNumber) {
        RowLocation rl;
        SanityManager.ASSERT((itemNumber >= 0 ? 1 : 0) != 0, (String)"itemNumber expected to be >= 0");
        if (!(this.getSavedObject(itemNumber) instanceof RowLocation)) {
            SanityManager.THROWASSERT((String)("getPreparedStatement().getSavedObject(itemNumber) expected to be instance of RowLocation, not " + this.getSavedObject(itemNumber).getClass().getName() + ", query is " + this.getPreparedStatement().getUserQueryString(this.getLanguageConnectionContext())));
        }
        if (!((rl = (RowLocation)this.getSavedObject(itemNumber)).cloneObject() instanceof RowLocation)) {
            SanityManager.THROWASSERT((String)("rl.cloneObject() expected to be instance of RowLocation, not " + rl.getClass().getName() + ", query is " + this.getPreparedStatement().getSource()));
        }
        return (RowLocation)((RowLocation)this.getSavedObject(itemNumber)).cloneObject();
    }

    @Override
    public ResultDescription getResultDescription() {
        SanityManager.ASSERT((this.resultDescription != null ? 1 : 0) != 0, (String)"Must have a result description");
        return this.resultDescription;
    }

    @Override
    public void reset(boolean cleanupOnError) throws StandardException {
        ResultSet rs = this.resultSet;
        if (rs != null) {
            this.resultSet = null;
            rs.close(cleanupOnError);
            this.resultSet = rs;
        }
        this.updateHeapCC = null;
        this.queryCancellationFlag = 0;
        this.timeoutMillis = 0L;
        if (!this.isSingleExecution()) {
            this.clearWarnings();
        }
    }

    @Override
    public void close() throws StandardException {
        if (!this.closed) {
            ResultSet rs = this.resultSet;
            this.reset(false);
            if (rs != null) {
                this.resultSet = null;
                rs.finish();
            }
            if (this.pvs != null && this.pvs.canReleaseOnClose()) {
                if (GemFireXDUtils.TraceStatementMatching) {
                    SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)("nullifying " + GemFireXDUtils.addressOf(this.pvs) + " of " + GemFireXDUtils.addressOf(this)));
                }
                this.pvs = null;
            }
            this.closed = true;
            LanguageConnectionContext lcc = this.getLanguageConnectionContext();
            if (this.addToLCC) {
                lcc.removeActivation(this);
                if (this.preStmt != null) {
                    this.preStmt.finish(lcc);
                    this.preStmt = null;
                }
            } else if (this.preStmt != null) {
                this.preStmt = null;
            }
            this.fnContext = null;
            this.sender = null;
            try {
                this.closeActivationAction();
            }
            catch (Throwable e) {
                throw StandardException.plainWrapException(e);
            }
        }
    }

    protected void closeActivationAction() throws Exception {
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setSingleExecution() {
        this.singleExecution = true;
    }

    @Override
    public long getConnectionID() {
        return this.connectionID;
    }

    @Override
    public long getStatementID() {
        return this.statementID;
    }

    @Override
    public long getRootID() {
        return this.rootID;
    }

    @Override
    public int getStatementLevel() {
        return this.statementLevel;
    }

    @Override
    public boolean getIsPrepStmntQuery() {
        return this.isPrepStmntQuery;
    }

    @Override
    public void setConnectionID(long id) {
        this.connectionID = id;
    }

    @Override
    public void setStatementID(long id) {
        this.statementID = id;
    }

    @Override
    public void setRootID(long id) {
        this.rootID = id;
    }

    @Override
    public void setStatementLevel(int val) {
        this.statementLevel = val;
    }

    @Override
    public void setExecutionID(int id) {
        this.executionID = id;
    }

    @Override
    public int getExecutionID() {
        return this.executionID;
    }

    @Override
    public void setIsPrepStmntQuery(boolean flag) {
        this.isPrepStmntQuery = flag;
    }

    @Override
    public void distributeClose() {
    }

    @Override
    public boolean isSingleExecution() {
        return this.singleExecution;
    }

    @Override
    public int getNumSubqueries() {
        return this.numSubqueries;
    }

    @Override
    public boolean isCursorActivation() {
        return false;
    }

    @Override
    public final void setGC(GeneratedClass gc) {
        this.gc = gc;
    }

    @Override
    public final GeneratedClass getGC() {
        if (this.gc == null) {
            SanityManager.THROWASSERT((String)"move code requiring GC to postConstructor() method!!");
        }
        return this.gc;
    }

    @Override
    public final GeneratedMethod getMethod(String methodName) throws StandardException {
        return this.getGC().getMethod(methodName);
    }

    @Override
    public Object e0() throws StandardException {
        return null;
    }

    @Override
    public Object e1() throws StandardException {
        return null;
    }

    @Override
    public Object e2() throws StandardException {
        return null;
    }

    @Override
    public Object e3() throws StandardException {
        return null;
    }

    @Override
    public Object e4() throws StandardException {
        return null;
    }

    @Override
    public Object e5() throws StandardException {
        return null;
    }

    @Override
    public Object e6() throws StandardException {
        return null;
    }

    @Override
    public Object e7() throws StandardException {
        return null;
    }

    @Override
    public Object e8() throws StandardException {
        return null;
    }

    @Override
    public Object e9() throws StandardException {
        return null;
    }

    @Override
    public boolean checkIfThisActivationHasHoldCursor(String tableName) {
        if (!this.inUse) {
            return false;
        }
        if (!this.resultSetHoldability) {
            return false;
        }
        if (this.indexOfSessionTableNamesInSavedObjects == -1) {
            return false;
        }
        if (this.resultSet != null && !this.resultSet.isClosed() && this.resultSet.returnsRows()) {
            return ((ArrayList)this.getSavedObject(this.indexOfSessionTableNamesInSavedObjects)).contains(tableName);
        }
        return false;
    }

    @Override
    public void setCursorName(String cursorName) {
        if (this.isCursorActivation()) {
            this.cursorName = cursorName;
        }
    }

    @Override
    public String getCursorName() {
        return this.isCursorActivation() ? this.cursorName : null;
    }

    @Override
    public void setResultSetHoldability(boolean resultSetHoldability) {
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public boolean getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    @Override
    public void setAutoGeneratedKeysResultsetInfo(int[] columnIndexes, String[] columnNames) {
        this.autoGeneratedKeysResultSetMode = true;
        this.autoGeneratedKeysColumnIndexes = columnIndexes;
        this.autoGeneratedKeysColumnNames = columnNames;
    }

    @Override
    public boolean getAutoGeneratedKeysResultsetMode() {
        return this.autoGeneratedKeysResultSetMode;
    }

    @Override
    public int[] getAutoGeneratedKeysColumnIndexes() {
        return this.autoGeneratedKeysColumnIndexes;
    }

    @Override
    public String[] getAutoGeneratedKeysColumnNames() {
        return this.autoGeneratedKeysColumnNames;
    }

    public final ResultSetFactory getResultSetFactory() {
        return this.getExecutionFactory().getResultSetFactory();
    }

    @Override
    public final ExecutionFactory getExecutionFactory() {
        return this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
    }

    @Override
    public CursorResultSet getTargetResultSet() {
        SanityManager.THROWASSERT((String)"Must be overridden to be used.");
        return null;
    }

    protected DataValueDescriptor getSetAutoincrementValue(int columnPosition, long increment, boolean isGeneratedByDefault) throws StandardException {
        DataValueDescriptor l = null;
        l = isGeneratedByDefault ? ((GemFireInsertResultSet)this.resultSet).getMaxIdentityValue(columnPosition) : ((GemFireInsertResultSet)this.resultSet).getNextUUIDValue(columnPosition);
        return l;
    }

    @Override
    public CursorResultSet getCursorResultSet() {
        SanityManager.THROWASSERT((String)"Must be overridden to be used.");
        return null;
    }

    public void throwIfClosed(String op) throws StandardException {
        if (this.closed) {
            throw StandardException.newException("XCL05.S", op);
        }
    }

    public static void setColumnPosition(int[] columnPositions, int positionToSet, int column) {
        columnPositions[positionToSet] = column;
    }

    public static void allocateQualArray(Qualifier[][] qualifiers, int position, int length) {
        qualifiers[position] = new Qualifier[length];
    }

    public static void setQualifier(Qualifier[][] qualifiers, Qualifier qualifier, int position_1, int position_2) {
        qualifiers[position_1][position_2] = qualifier;
    }

    public static void reinitializeQualifiers(Qualifier[][] qualifiers) {
        if (qualifiers != null) {
            for (int term = 0; term < qualifiers.length; ++term) {
                for (int i = 0; i < qualifiers[term].length; ++i) {
                    qualifiers[term][i].reinitialize();
                }
            }
        }
    }

    @Override
    public final void markUnused() {
        if (this.isInUse()) {
            this.fnContext = null;
            this.sender = null;
            this.inUse = false;
            this.lcc.notifyUnusedActivation();
        }
    }

    @Override
    public final boolean isInUse() {
        return this.inUse;
    }

    @Override
    public void addResultsetWarning(SQLWarning w) {
        if (this.resultsetWarnings == null) {
            this.resultsetWarnings = w;
        } else {
            this.resultsetWarnings.setNextWarning(w);
        }
    }

    @Override
    public void addWarning(SQLWarning w) {
        if (this.warnings == null) {
            this.warnings = w;
        } else {
            this.warnings.setNextWarning(w);
        }
    }

    @Override
    public SQLWarning getResultsetWarnings() {
        return this.resultsetWarnings;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warnings;
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public void clearResultsetWarnings() {
        this.resultsetWarnings = null;
    }

    protected static void nullToPrimitiveTest(DataValueDescriptor dvd, String primitiveType) throws StandardException {
        if (dvd.isNull()) {
            throw StandardException.newException("39004", primitiveType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void informOfRowCount(NoPutResultSet resultSet, long currentRowCount) throws StandardException {
        if (this.checkRowCounts) {
            boolean significantChange = false;
            int resultSetNumber = resultSet.resultSetNumber();
            Integer rsn = ReuseFactory.getInteger(resultSetNumber);
            if (this.rowCountsCheckedThisExecution.add(rsn)) {
                ExecPreparedStatement execPreparedStatement = this.getPreparedStatement();
                synchronized (execPreparedStatement) {
                    Vector<Long> rowCountCheckVector = this.getRowCountCheckVector();
                    if (rowCountCheckVector == null) {
                        rowCountCheckVector = new Vector<Long>();
                        this.setRowCountCheckVector(rowCountCheckVector);
                    }
                    Long firstRowCount = null;
                    if (resultSetNumber < rowCountCheckVector.size()) {
                        firstRowCount = (Long)rowCountCheckVector.elementAt(resultSetNumber);
                    } else {
                        rowCountCheckVector.setSize(resultSetNumber + 1);
                    }
                    if (firstRowCount != null) {
                        long n1 = firstRowCount;
                        if (currentRowCount != n1) {
                            if (n1 >= 400L) {
                                long changeFactor = n1 / (currentRowCount - n1);
                                if (Math.abs(changeFactor) <= 10L) {
                                    significantChange = true;
                                }
                            } else {
                                long changediff = currentRowCount - n1;
                                if (Math.abs(changediff) <= MAX_SQRT && changediff * changediff > Math.abs(4L * n1)) {
                                    significantChange = true;
                                }
                            }
                        }
                    } else {
                        firstRowCount = currentRowCount;
                        rowCountCheckVector.setElementAt(firstRowCount, resultSetNumber);
                    }
                }
            }
            if (significantChange) {
                this.preStmt.makeInvalid(23, this.lcc);
            }
        }
    }

    public void startExecution() throws StandardException {
        this.shouldWeCheckRowCounts();
        if (this.checkRowCounts) {
            this.rowCountsCheckedThisExecution.clear();
        }
    }

    @Override
    public ConglomerateController getHeapConglomerateController() {
        return this.updateHeapCC;
    }

    @Override
    public void setHeapConglomerateController(ConglomerateController updateHeapCC) {
        this.updateHeapCC = updateHeapCC;
    }

    @Override
    public void clearHeapConglomerateController() {
        this.updateHeapCC = null;
    }

    @Override
    public ScanController getIndexScanController() {
        return this.indexSC;
    }

    @Override
    public void setIndexScanController(ScanController indexSC) {
        this.indexSC = indexSC;
    }

    @Override
    public long getIndexConglomerateNumber() {
        return this.indexConglomerateNumber;
    }

    @Override
    public void setIndexConglomerateNumber(long indexConglomerateNumber) {
        this.indexConglomerateNumber = indexConglomerateNumber;
    }

    @Override
    public void clearIndexScanInfo() {
        this.indexSC = null;
        this.indexConglomerateNumber = -1L;
    }

    @Override
    public void setForCreateTable() {
        this.forCreateTable = true;
    }

    @Override
    public boolean getForCreateTable() {
        return this.forCreateTable;
    }

    @Override
    public void setDDLTableDescriptor(TableDescriptor td) {
        this.ddlTableDescriptor = td;
    }

    @Override
    public TableDescriptor getDDLTableDescriptor() {
        return this.ddlTableDescriptor;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setTargetVTI(java.sql.ResultSet targetVTI) {
        this.targetVTI = targetVTI;
    }

    @Override
    public java.sql.ResultSet getTargetVTI() {
        return this.targetVTI;
    }

    private void shouldWeCheckRowCounts() throws StandardException {
        int executionCount = this.getExecutionCount() + 1;
        if (executionCount == 1) {
            this.checkRowCounts = true;
        } else if (executionCount < 5) {
            this.checkRowCounts = false;
        } else {
            int stalePlanCheckInterval = this.getStalePlanCheckInterval();
            if (stalePlanCheckInterval == 0) {
                TransactionController tc = this.getTransactionController();
                stalePlanCheckInterval = PropertyUtil.getServiceInt(tc, "gemfirexd.language.stalePlanCheckInterval", 5, Integer.MAX_VALUE, 100);
                this.setStalePlanCheckInterval(stalePlanCheckInterval);
            }
            this.checkRowCounts = executionCount % stalePlanCheckInterval == 1;
        }
        this.setExecutionCount(executionCount);
    }

    protected abstract int getExecutionCount();

    protected abstract void setExecutionCount(int var1);

    protected abstract Vector getRowCountCheckVector();

    protected abstract void setRowCountCheckVector(Vector var1);

    protected abstract int getStalePlanCheckInterval();

    protected abstract void setStalePlanCheckInterval(int var1);

    public final boolean getScrollable() {
        return this.scrollable;
    }

    protected final void setParameterValueSet(int paramCount, boolean hasReturnParam) {
        if (this.preStmt == null || !this.preStmt.isSubqueryPrepStatement()) {
            this.pvs = this.lcc.getLanguageFactory().newParameterValueSet(this.lcc.getLanguageConnectionFactory().getClassFactory().getClassInspector(), paramCount, hasReturnParam);
        }
    }

    public final DataValueDescriptor getParameter(int position) throws StandardException {
        return this.pvs.getParameter(position);
    }

    @Override
    public final ParameterValueSet getParameterValueSet() {
        if (this.pvs == null) {
            this.setParameterValueSet(0, false);
        }
        return this.pvs;
    }

    @Override
    public void setParameters(ParameterValueSet parameterValues, DataTypeDescriptor[] parameterTypes) throws StandardException {
        if (!this.isClosed()) {
            if (this.pvs == null || parameterTypes == null || this.pvs.isListOfConstants()) {
                this.pvs = parameterValues;
                return;
            }
            DataTypeDescriptor[] newParamTypes = this.preStmt.getParameterTypes();
            boolean match = false;
            if (newParamTypes != null && newParamTypes.length == parameterTypes.length) {
                match = true;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    DataTypeDescriptor oldType = parameterTypes[i];
                    DataTypeDescriptor newType = newParamTypes[i];
                    if (!oldType.isExactTypeAndLengthMatch(newType)) {
                        match = false;
                        break;
                    }
                    if (oldType.isNullable() == newType.isNullable()) continue;
                    match = false;
                    break;
                }
            }
            if (!match) {
                throw StandardException.newException("XCL10.S");
            }
            parameterValues.transferDataValues(this.pvs);
        } else {
            SanityManager.THROWASSERT((String)"isClosed() is expected to return false");
        }
    }

    public void throwIfMissingParms() throws StandardException {
        int notSetPos;
        if (this.pvs != null && (notSetPos = this.pvs.allAreSet()) > 0) {
            throw StandardException.newException("07000", (Object)notSetPos, (Object)(this.statementText != null ? this.statementText : (this.preStmt != null ? this.preStmt.getSource() : "(null)")));
        }
    }

    @Override
    public void setCurrentRow(ExecRow currentRow, int resultSetNumber) {
        if (this.row != null) {
            this.row[resultSetNumber] = currentRow;
        }
    }

    @Override
    public void clearCurrentRow(int resultSetNumber) {
        if (this.row != null) {
            this.row[resultSetNumber] = null;
        }
    }

    @Override
    public void setNestedCurrentRole(String role) {
        this.nestedCurrentRole = role;
    }

    @Override
    public String getNestedCurrentRole() {
        return this.nestedCurrentRole;
    }

    @Override
    public void setCallActivation(Activation a) {
        this.callActivation = a;
    }

    @Override
    public Activation getCallActivation() {
        return this.callActivation;
    }

    protected final DataValueDescriptor getColumnFromRow(int rsNumber, int colId) throws StandardException {
        if (this.expressionDVD != null) {
            DataValueDescriptor dvd = this.expressionDVD;
            if (colId != 1) {
                GemFireXDUtils.throwAssert("unexpected colId=" + colId);
            }
            if (GemFireXDUtils.TraceConglomRead) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomRead", (String)(this.toString() + ": returning single column for colId=" + colId + ": " + dvd + "(type: " + dvd.getTypeName() + ", id=" + dvd.getTypeFormatId() + ')'));
            }
            return dvd;
        }
        if (this.expressionDVDs != null) {
            DataValueDescriptor dvd = this.expressionDVDs[colId - 1];
            if (GemFireXDUtils.TraceConglomRead) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomRead", (String)(this.toString() + ": returning column for colId=" + colId + ": " + dvd + "(type: " + dvd.getTypeName() + ", id=" + dvd.getTypeFormatId() + ')'));
            }
            return dvd;
        }
        ExecRow row = this.row[rsNumber];
        if (row != null) {
            return row.getColumn(colId);
        }
        return null;
    }

    protected void checkPositionedStatement(String cursorName, String psName) throws StandardException {
        ExecPreparedStatement ps = this.getPreparedStatement();
        if (ps == null) {
            return;
        }
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        CursorActivation cursorActivation = lcc.lookupCursorActivation(cursorName);
        if (cursorActivation != null && !psName.equals(cursorActivation.getPreparedStatement().getObjectName())) {
            ps.makeInvalid(5, lcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NoPutResultSet materializeResultSetIfPossible(NoPutResultSet rs) throws StandardException {
        boolean isGfxdSubquery = rs instanceof GfxdSubqueryResultSet;
        if (isGfxdSubquery) {
            rs.openCore();
            return rs;
        }
        rs.openCore();
        Vector<ExecRow> rowCache = new Vector<ExecRow>();
        int cacheSize = 0;
        FormatableBitSet toClone = null;
        int maxMemoryPerTable = this.getLanguageConnectionContext().getOptimizerFactory().getMaxMemoryPerTable();
        boolean isOffHeapEnabled = GemFireXDUtils.isOffHeapEnabled();
        ExecRow aRow = rs.getNextRowCore();
        if (aRow != null) {
            toClone = new FormatableBitSet(aRow.nColumns() + 1);
            toClone.set(1);
        }
        boolean anyByteSourceRetained = false;
        while (aRow != null && (cacheSize += aRow.getColumn(1).getLength()) <= maxMemoryPerTable && rowCache.size() <= 512) {
            ExecRow clonedRow = aRow.getClone(toClone);
            rowCache.addElement(clonedRow);
            if (isOffHeapEnabled) {
                Class<?> byteSourceClass;
                Object byteSource = clonedRow.getByteSource();
                if (byteSource != null && (byteSourceClass = byteSource.getClass()) != byte[].class && byteSourceClass != byte[][].class) {
                    ((OffHeapByteSource)((Object)byteSource)).retain();
                    anyByteSourceRetained = true;
                }
                rs.releasePreviousByteSource();
            }
            aRow = rs.getNextRowCore();
        }
        boolean releaseCachedByteSource = anyByteSourceRetained;
        try {
            rs.close(false);
            if (aRow == null) {
                releaseCachedByteSource = false;
                int rsNum = rs.resultSetNumber();
                int numRows = rowCache.size();
                if (numRows == 0) {
                    RowResultSet rowResultSet = new RowResultSet((Activation)this, (ExecRow)null, true, rsNum, 0.0, 0.0);
                    return rowResultSet;
                }
                RowResultSet[] rrs = new RowResultSet[numRows];
                UnionResultSet[] urs = new UnionResultSet[numRows - 1];
                for (int i = 0; i < numRows; ++i) {
                    rrs[i] = new RowResultSet((Activation)this, (ExecRow)rowCache.elementAt(i), true, rsNum, 1.0, 0.0);
                    if (i <= 0) continue;
                    urs[i - 1] = new UnionResultSet(i > 1 ? urs[i - 2] : rrs[0], rrs[i], this, rsNum, i + 1, 0.0);
                }
                rs.finish();
                if (numRows == 1) {
                    RowResultSet rowResultSet = rrs[0];
                    return rowResultSet;
                }
                UnionResultSet unionResultSet = urs[urs.length - 1];
                return unionResultSet;
            }
            NoPutResultSet noPutResultSet = rs;
            return noPutResultSet;
        }
        finally {
            if (releaseCachedByteSource) {
                int size = rowCache.size();
                for (int i = 0; i < size; ++i) {
                    ExecRow row = (ExecRow)rowCache.get(i);
                    row.releaseByteSource();
                }
            }
        }
    }

    @Override
    public void setParentResultSet(TemporaryRowHolder rs, String resultSetId) {
        Vector<TemporaryRowHolder> rsVector;
        if (this.parentResultSets == null) {
            this.parentResultSets = new Hashtable();
        }
        if ((rsVector = (Vector<TemporaryRowHolder>)this.parentResultSets.get(resultSetId)) == null) {
            rsVector = new Vector<TemporaryRowHolder>();
            rsVector.addElement(rs);
        } else {
            rsVector.addElement(rs);
        }
        this.parentResultSets.put(resultSetId, rsVector);
    }

    @Override
    public Vector getParentResultSet(String resultSetId) {
        return (Vector)this.parentResultSets.get(resultSetId);
    }

    @Override
    public Hashtable getParentResultSets() {
        return this.parentResultSets;
    }

    @Override
    public void clearParentResultSets() {
        if (this.parentResultSets != null) {
            this.parentResultSets.clear();
        }
    }

    @Override
    public void setForUpdateIndexScan(CursorResultSet forUpdateIndexScan) {
        this.forUpdateIndexScan = forUpdateIndexScan;
    }

    @Override
    public CursorResultSet getForUpdateIndexScan() {
        return this.forUpdateIndexScan;
    }

    protected Calendar getCalendar() {
        if (this.cal == null) {
            this.cal = ClientSharedData.getDefaultCalendar();
        }
        this.cal.clear();
        return this.cal;
    }

    @Override
    public final LanguageConnectionContext getLanguageConnectionContext() {
        return this.lcc;
    }

    @Override
    public final TransactionController getTransactionController() {
        return this.lcc.getTransactionExecute();
    }

    @Override
    public ContextManager getContextManager() {
        return this.cm;
    }

    @Override
    public DataValueFactory getDataValueFactory() {
        return this.getLanguageConnectionContext().getDataValueFactory();
    }

    public Connection getCurrentConnection() throws SQLException {
        ConnectionContext cc = (ConnectionContext)((Object)this.getContextManager().getContext("JDBC_ConnectionContext"));
        return cc.getNestedConnection(true);
    }

    @Override
    public java.sql.ResultSet[][] getDynamicResults() {
        return null;
    }

    @Override
    public int getMaxDynamicResults() {
        return 0;
    }

    public NumberDataValue getDB2Length(DataValueDescriptor value, int constantLength, NumberDataValue reUse) throws StandardException {
        if (reUse == null) {
            reUse = this.getDataValueFactory().getNullInteger(null);
        }
        if (value.isNull()) {
            reUse.setToNull();
        } else if (constantLength >= 0) {
            reUse.setValue(constantLength);
        } else {
            reUse.setValue(value.getLength());
        }
        return reUse;
    }

    public ResultDescription switchResultDescription(ResultDescription rd) {
        ResultDescription old = this.resultDescription;
        this.resultDescription = rd;
        return old;
    }

    public void setProxyParameterValueSet(ParameterValueSet pvs) {
        this.pvs = pvs;
    }

    @Override
    public final FunctionContext getFunctionContext() {
        return this.fnContext;
    }

    @Override
    public final void setFunctionContext(FunctionContext fc) {
        this.fnContext = fc;
    }

    @Override
    public final void setFlags(int flags) {
        int immutableFlags = this.flags & 0x18;
        this.flags = flags & 0xFFFFFFE7;
        this.flags |= immutableFlags;
    }

    public final void copyFlags(BaseActivation target) {
        target.flags = this.flags;
    }

    @Override
    public final boolean isSpecialCaseOuterJoin() {
        return (this.flags & 1) != 0;
    }

    @Override
    public final void setSpecialCaseOuterJoin(boolean flag) {
        this.flags = GemFireXDUtils.set(this.flags, 1, flag);
    }

    @Override
    public final boolean needKeysForSelectForUpdate() {
        return (this.flags & 2) != 0;
    }

    @Override
    public final void setNeedKeysForSelectForUpdate(boolean flag) {
        this.flags = GemFireXDUtils.set(this.flags, 2, flag);
    }

    @Override
    public final boolean isPreparedBatch() {
        return (this.flags & 8) != 0;
    }

    @Override
    public final void setPreparedBatch(boolean flag) {
        this.flags = GemFireXDUtils.set(this.flags, 8, flag);
    }

    @Override
    public final boolean getInsertAsSubselect() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public final boolean isPutDML() {
        return this.isPutDML;
    }

    @Override
    public final void setInsertAsSubselect(boolean flag) {
        this.flags = GemFireXDUtils.set(this.flags, 16, flag);
    }

    public final void setPutDML(boolean val) {
        this.isPutDML = val;
    }

    @Override
    public ProcedureSender getProcedureSender() {
        return this.sender;
    }

    @Override
    public void setProcedureSender(ProcedureSender sender) {
        this.sender = sender;
    }

    @Override
    public boolean isPossibleDuplicate() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public void setPossibleDuplicate(boolean flag) {
        this.flags = GemFireXDUtils.set(this.flags, 32, flag);
    }

    public void setUpdatedColumns(boolean[] updatedColumns) {
        this.updatedColumns = updatedColumns;
    }

    public boolean[] getUpdatedColumns() {
        return this.updatedColumns;
    }

    public void setProjectMapping(int[] projectMapping) {
        if (this.projectMapping != null) {
            int[] newMapping = (int[])projectMapping.clone();
            for (int index = 0; index < this.projectMapping.length; ++index) {
                newMapping[index] = projectMapping[this.projectMapping[index] - 1];
            }
            this.projectMapping = newMapping;
        } else {
            this.projectMapping = projectMapping;
        }
    }

    public int[] getProjectMapping() {
        return this.projectMapping;
    }

    @Override
    public final void checkCancellationFlag() throws StandardException {
        if (this.isQueryCancelled()) {
            switch (this.queryCancellationFlag) {
                case 1: {
                    if (GemFireXDUtils.TraceHeapThresh || GemFireXDUtils.TraceExecution) {
                        SanityManager.DEBUG_PRINT((String)"TraceHeapThreshold", (String)("BaseActivation: statement " + (this.preStmt != null ? this.preStmt.getUserQueryString(this.lcc) : "null statement") + " is cancelled due to low memory"));
                    }
                    throw Misc.generateLowMemoryException(this.getPreparedStatement().getUserQueryString(this.lcc));
                }
                case 2: {
                    if (GemFireXDUtils.TraceExecution) {
                        SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("BaseActivation: statement " + (this.preStmt != null ? this.preStmt.getUserQueryString(this.lcc) : "null statement") + " is cancelled due to timeout"));
                    }
                    Misc.getMemStoreBooting().getStoreStatistics().collectQueryTimeOutStats();
                    throw StandardException.newException("XCL52.S");
                }
                case 3: {
                    if (GemFireXDUtils.TraceExecution) {
                        SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("BaseActivation: statement " + (this.preStmt != null ? this.preStmt.getUserQueryString(this.lcc) : "null statement") + " is cancelled due to a user request"));
                    }
                    throw StandardException.newException("XCL56.T");
                }
            }
        }
    }

    @Override
    public final boolean isQueryCancelled() {
        return this.queryCancellationFlag != 0;
    }

    @Override
    public final void cancelOnLowMemory() {
        this.queryCancellationFlag = 1;
        LogWriter logger = Misc.getCacheLogWriterNoThrow();
        if (logger != null && logger.warningEnabled()) {
            logger.warning("BaseActivation: cancelling statement due to low memory " + (this.preStmt != null ? this.preStmt.getUserQueryString(this.getLanguageConnectionContext()) : " NULL "));
        }
    }

    @Override
    public final void cancelOnTimeOut() {
        this.queryCancellationFlag = (short)2;
        LogWriter logger = Misc.getCacheLogWriterNoThrow();
        if (logger != null && logger.warningEnabled()) {
            logger.warning("BaseActivation: cancelling statement due to query timeout " + (this.preStmt != null ? this.preStmt.getUserQueryString(this.getLanguageConnectionContext()) : " NULL "));
        }
    }

    @Override
    public final void cancelOnUserRequest() {
        this.queryCancellationFlag = (short)3;
        LogWriter logger = Misc.getCacheLogWriterNoThrow();
        if (logger != null && logger.warningEnabled()) {
            logger.warning("BaseActivation: cancelling statement due to a user request " + (this.preStmt != null ? this.preStmt.getUserQueryString(this.getLanguageConnectionContext()) : " NULL "));
        }
    }

    @Override
    public void setTimeOutMillis(long timeOutMillis) {
        this.timeoutMillis = timeOutMillis;
    }

    @Override
    public long getTimeOutMillis() {
        return this.timeoutMillis;
    }

    @Override
    public long estimateMemoryUsage() throws StandardException {
        return Misc.estimateMemoryUsage(this.lcc, this.resultSet, this.preStmt != null ? this.preStmt.getUserQueryString(this.getLanguageConnectionContext()) : null);
    }

    public void distributeTxCacheLoaded(LocalRegion rgn, GemFireTransaction gft, Object key, Object value) throws StandardException {
        if (rgn.isGatewaySenderEnabled()) {
            assert (gft != null && gft.isTransactional());
            CacheLoadedDBSynchronizerMessage dbm = new CacheLoadedDBSynchronizerMessage(rgn, key, value, gft.isTransactional());
            if (GemFireXDUtils.TraceDBSynchronizer) {
                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("BaseActivation: distributeTxCacheLoaded Key =" + key + ";value = " + value + ";Transaction = " + gft));
            }
            gft.addDBSynchronizerOperation(dbm);
        }
    }

    public final void distributeBulkOpToDBSynchronizer(LocalRegion rgn, boolean isDynamic, GemFireTransaction tran, boolean skipListeners) throws StandardException {
        this.distributeBulkOpToDBSynchronizer(rgn, isDynamic, tran, skipListeners, null);
    }

    @Override
    public final void distributeBulkOpToDBSynchronizer(LocalRegion rgn, boolean isDynamic, GemFireTransaction tran, boolean skipListeners, ArrayList<Object> bulkInsertRows) throws StandardException {
        if (rgn.isGatewaySenderEnabled() && (!skipListeners || rgn.getGatewaySenderIds().size() > 0)) {
            GfxdCBArgForSynchPrms cbArg;
            LanguageConnectionContext lcc = this.getLanguageConnectionContext();
            String source = this.preStmt.getUserQueryString(lcc);
            if (GemFireXDUtils.TraceDBSynchronizer) {
                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("BaseActivation: distributing bulk " + (isDynamic ? " dynamic " : " static ") + "DML operation" + " with dml string =" + source + ". " + "Transaction = " + tran));
            }
            boolean isTransactional = tran != null && tran.isTransactional();
            GatewaySenderEventCallbackArgument senderArg = this.getLanguageConnectionContext().getGatewaySenderEventCallbackArg();
            GemFireContainer gfc = (GemFireContainer)rgn.getUserAttribute();
            ParameterValueSet params = this.getParameterValueSet();
            if (params instanceof ConstantValueSet) {
                if (!this.isSingleExecution()) {
                    SanityManager.THROWASSERT((String)"This activation must be for single use i.e. statement query activation & shouldn't be cached.");
                }
                source = this.statementText;
                assert (source != null);
                isDynamic = false;
            }
            if (bulkInsertRows != null) {
                ExtraTableInfo tableInfo = gfc.getExtraTableInfo();
                try {
                    source = AsyncEventHelper.getInsertString(gfc.getQualifiedTableName(), tableInfo.getRowFormatter().getMetaData(), tableInfo.hasAutoGeneratedColumns());
                }
                catch (SQLException sqle) {
                    throw Misc.wrapSQLException(sqle, sqle);
                }
                cbArg = new GfxdCBArgForSynchPrms(source, bulkInsertRows, gfc, isTransactional, senderArg, this.isPutDML);
            } else if (isDynamic) {
                GenericParameterValueSet pvs = (GenericParameterValueSet)params;
                if (isTransactional) {
                    pvs = (GenericParameterValueSet)pvs.getClone();
                }
                cbArg = new GfxdCBArgForSynchPrms(source, pvs, this.preStmt.getParameterTypes(), gfc.getSchemaName(), gfc.getTableName(), isTransactional, senderArg, this.isPutDML);
            } else {
                cbArg = new GfxdCBArgForSynchPrms(source, gfc.getSchemaName(), gfc.getTableName(), isTransactional, senderArg, this.isPutDML);
            }
            BulkDBSynchronizerMessage dbm = new BulkDBSynchronizerMessage(rgn, source, skipListeners, cbArg);
            if (isTransactional) {
                tran.addDBSynchronizerOperation(dbm);
            } else {
                dbm.applyOperation();
            }
        }
    }

    private final void setConstantParameters(ParameterValueSet parameterValueSet) throws StandardException {
        if (GemFireXDUtils.TraceStatementMatching) {
            ExecPreparedStatement ps = this.getPreparedStatement();
            SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)(GemFireXDUtils.addressOf(this) + ":setConstantParameters: (" + (ps != null ? ps.getStatement() : " NULL ") + (parameterValueSet != null ? ") setting with constantValues " + parameterValueSet : ") setting  with constantValues [ NULL ] ") + " of parameter types " + (ps != null ? ps.getParameterTypes() : " NULL ")));
        }
        if (parameterValueSet != null && (this.preStmt == null || this.preStmt.getParameterTypes() != null)) {
            this.pvs = parameterValueSet;
        }
    }

    @Override
    public void accept(ActivationStatisticsVisitor visitor) {
    }

    @Override
    public ExecRow getCurrentRow(int resultSetNumber) {
        if (this.row != null) {
            return this.row[resultSetNumber];
        }
        return null;
    }

    @Override
    public void setUseOnlyPrimaryBuckets(boolean b) {
        this.useOnlyPrimaryBuckets = b;
    }

    @Override
    public boolean getUseOnlyPrimaryBuckets() {
        return this.useOnlyPrimaryBuckets;
    }

    @Override
    public void setQueryHDFS(boolean val) {
        this.queryHDFS = val;
    }

    @Override
    public boolean getQueryHDFS() {
        return this.queryHDFS;
    }

    @Override
    public boolean getHasQueryHDFS() {
        return this.hasQueryHDFS;
    }

    @Override
    public void setHasQueryHDFS(boolean hasQueryHDFS) {
        this.hasQueryHDFS = hasQueryHDFS;
    }

    @Override
    public final Object getSavedObject(int objectNum) {
        if (objectNum < 0 || objectNum >= this.savedObjects.length) {
            SanityManager.THROWASSERT((String)("request for savedObject entry " + objectNum + " invalid; " + "savedObjects has " + this.savedObjects.length + " entries"));
        }
        return this.savedObjects[objectNum];
    }

    @Override
    public final Object[] getSavedObjects() {
        return this.savedObjects;
    }
}

